/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.collect.Sets;
import eu.europa.ec.inspire.schemas.base2.x20.DocumentCitationType;
import java.util.Calendar;
import java.util.Collections;
import java.util.Set;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.joda.time.DateTime;
import org.n52.shetland.inspire.base2.DocumentCitation;
import org.n52.shetland.w3c.Nillable;
import org.n52.svalbard.encode.AbstractXmlEncoder;
import org.n52.svalbard.encode.ClassToClassEncoderKey;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.XmlEncoderKey;
import org.n52.svalbard.encode.exception.EncodingException;

public class DocumentCitationTypeEncoder
extends AbstractXmlEncoder<XmlObject, DocumentCitation> {
    private static final Set<EncoderKey> ENCODER_KEYS = Sets.newHashSet((Object[])new EncoderKey[]{new ClassToClassEncoderKey(DocumentCitationType.class, DocumentCitation.class), new XmlEncoderKey("http://inspire.ec.europa.eu/schemas/base2/2.0", DocumentCitation.class)});

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEYS);
    }

    public XmlObject encode(DocumentCitation documentCitation, EncodingContext context) throws EncodingException {
        DocumentCitationType dct = DocumentCitationType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        if (documentCitation.isSetDate()) {
            dct.addNewDate().addNewCIDate().addNewDate().setDateTime((Calendar)((DateTime)documentCitation.getDate().get()).toGregorianCalendar());
        }
        if (documentCitation.isSetName()) {
            dct.setName2(documentCitation.getFirstName().getValue());
        }
        if (documentCitation.isSetLinks()) {
            for (Nillable link : documentCitation.getLinks()) {
                if (link.isPresent()) {
                    dct.addNewLink().setStringValue((String)link.get());
                    continue;
                }
                DocumentCitationType.Link l = dct.addNewLink();
                l.setNil();
                if (!link.getNilReason().isPresent()) continue;
                l.setNilReason(link.getNilReason().get());
            }
        }
        return dct;
    }
}

