/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.collect.Sets;
import java.util.Set;
import net.opengis.sos.x20.GetResultTemplateResponseDocument;
import net.opengis.sos.x20.GetResultTemplateResponseType;
import net.opengis.swe.x20.DataRecordDocument;
import net.opengis.swe.x20.TextEncodingDocument;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.shetland.ogc.sos.Sos2Constants;
import org.n52.shetland.ogc.sos.SosResultEncoding;
import org.n52.shetland.ogc.sos.SosResultStructure;
import org.n52.shetland.ogc.sos.response.GetResultTemplateResponse;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.AbstractSosResponseEncoder;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.util.XmlHelper;

public class GetResultTemplateResponseEncoder
extends AbstractSosResponseEncoder<GetResultTemplateResponse> {
    public GetResultTemplateResponseEncoder() {
        super(Sos2Constants.Operations.GetResultTemplate.name(), GetResultTemplateResponse.class);
    }

    @Override
    protected XmlObject create(GetResultTemplateResponse response) throws EncodingException {
        GetResultTemplateResponseDocument doc = GetResultTemplateResponseDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        GetResultTemplateResponseType xbResponse = doc.addNewGetResultTemplateResponse();
        xbResponse.setResultEncoding(this.createResultEncoding(response.getResultEncoding()));
        xbResponse.setResultStructure(this.createResultStructure(response.getResultStructure()));
        return doc;
    }

    private GetResultTemplateResponseType.ResultEncoding createResultEncoding(SosResultEncoding resultEncoding) throws EncodingException {
        TextEncodingDocument xbEncoding;
        if (resultEncoding.isEncoded()) {
            try {
                xbEncoding = TextEncodingDocument.Factory.parse((String)((String)resultEncoding.getXml().get()));
            }
            catch (XmlException ex) {
                throw GetResultTemplateResponseEncoder.unsupportedResultEncoding(ex);
            }
        } else {
            XmlObject xml = this.encodeSwe(EncodingContext.of((Enum)XmlBeansEncodingFlags.DOCUMENT), resultEncoding.get().get());
            if (xml instanceof TextEncodingDocument) {
                xbEncoding = (TextEncodingDocument)xml;
            } else {
                throw GetResultTemplateResponseEncoder.unsupportedResultEncoding();
            }
        }
        GetResultTemplateResponseType.ResultEncoding xbResultEncoding = GetResultTemplateResponseType.ResultEncoding.Factory.newInstance((XmlOptions)this.getXmlOptions());
        xbResultEncoding.addNewAbstractEncoding().set((XmlObject)xbEncoding.getTextEncoding());
        XmlHelper.substituteElement((XmlObject)xbResultEncoding.getAbstractEncoding(), (XmlObject)xbEncoding.getTextEncoding());
        return xbResultEncoding;
    }

    private GetResultTemplateResponseType.ResultStructure createResultStructure(SosResultStructure resultStructure) throws EncodingException {
        DataRecordDocument dataRecordDoc;
        if (resultStructure.isEncoded()) {
            try {
                dataRecordDoc = DataRecordDocument.Factory.parse((String)((String)resultStructure.getXml().get()));
            }
            catch (XmlException ex) {
                throw GetResultTemplateResponseEncoder.unsupportedResultStructure(ex);
            }
        } else {
            XmlObject xml = this.encodeSwe(EncodingContext.of((Enum)XmlBeansEncodingFlags.DOCUMENT), resultStructure.get().get());
            if (xml instanceof DataRecordDocument) {
                dataRecordDoc = (DataRecordDocument)xml;
            } else {
                throw GetResultTemplateResponseEncoder.unsupportedResultStructure();
            }
        }
        GetResultTemplateResponseType.ResultStructure xbResultStructure = GetResultTemplateResponseType.ResultStructure.Factory.newInstance((XmlOptions)this.getXmlOptions());
        xbResultStructure.addNewAbstractDataComponent().set((XmlObject)dataRecordDoc.getDataRecord());
        XmlHelper.substituteElement((XmlObject)xbResultStructure.getAbstractDataComponent(), (XmlObject)dataRecordDoc.getDataRecord());
        return xbResultStructure;
    }

    @Override
    public Set<SchemaLocation> getConcreteSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{Sos2Constants.SOS_GET_RESULT_TEMPLATE_SCHEMA_LOCATION});
    }

    private static EncodingException unsupportedResultEncoding(Throwable cause) {
        return new EncodingException("ResultEncoding element encoding is not supported!", cause);
    }

    private static EncodingException unsupportedResultEncoding() {
        return GetResultTemplateResponseEncoder.unsupportedResultEncoding(null);
    }

    private static EncodingException unsupportedResultStructure(Throwable cause) {
        return new EncodingException("ResultStructure element encoding is not supported!", cause);
    }

    private static EncodingException unsupportedResultStructure() {
        return GetResultTemplateResponseEncoder.unsupportedResultStructure(null);
    }
}

