/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.opengis.sensorml.x20.AbstractPhysicalProcessType;
import net.opengis.sensorml.x20.AbstractProcessType;
import net.opengis.sensorml.x20.AggregateProcessDocument;
import net.opengis.sensorml.x20.AggregateProcessPropertyType;
import net.opengis.sensorml.x20.AggregateProcessType;
import net.opengis.sensorml.x20.CapabilityListType;
import net.opengis.sensorml.x20.CharacteristicListType;
import net.opengis.sensorml.x20.ClassifierListPropertyType;
import net.opengis.sensorml.x20.ClassifierListType;
import net.opengis.sensorml.x20.ComponentListPropertyType;
import net.opengis.sensorml.x20.ComponentListType;
import net.opengis.sensorml.x20.ConnectionListPropertyType;
import net.opengis.sensorml.x20.ConnectionListType;
import net.opengis.sensorml.x20.ContactListType;
import net.opengis.sensorml.x20.DataComponentOrObservablePropertyType;
import net.opengis.sensorml.x20.DescribedObjectType;
import net.opengis.sensorml.x20.DocumentListPropertyType;
import net.opengis.sensorml.x20.DocumentListType;
import net.opengis.sensorml.x20.FeatureListType;
import net.opengis.sensorml.x20.IdentifierListPropertyType;
import net.opengis.sensorml.x20.IdentifierListType;
import net.opengis.sensorml.x20.InputListType;
import net.opengis.sensorml.x20.LinkType;
import net.opengis.sensorml.x20.ObservablePropertyType;
import net.opengis.sensorml.x20.OutputListType;
import net.opengis.sensorml.x20.PhysicalComponentDocument;
import net.opengis.sensorml.x20.PhysicalComponentPropertyType;
import net.opengis.sensorml.x20.PhysicalComponentType;
import net.opengis.sensorml.x20.PhysicalSystemDocument;
import net.opengis.sensorml.x20.PhysicalSystemPropertyType;
import net.opengis.sensorml.x20.PhysicalSystemType;
import net.opengis.sensorml.x20.PositionUnionPropertyType;
import net.opengis.sensorml.x20.ProcessMethodType;
import net.opengis.sensorml.x20.SimpleProcessDocument;
import net.opengis.sensorml.x20.SimpleProcessPropertyType;
import net.opengis.sensorml.x20.SimpleProcessType;
import net.opengis.sensorml.x20.TermType;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.janmayen.NcName;
import org.n52.janmayen.http.MediaType;
import org.n52.shetland.ogc.SupportedType;
import org.n52.shetland.ogc.gml.CodeType;
import org.n52.shetland.ogc.gml.time.Time;
import org.n52.shetland.ogc.gml.time.TimeInstant;
import org.n52.shetland.ogc.gml.time.TimePeriod;
import org.n52.shetland.ogc.sensorML.AbstractProcess;
import org.n52.shetland.ogc.sensorML.AbstractSensorML;
import org.n52.shetland.ogc.sensorML.HasComponents;
import org.n52.shetland.ogc.sensorML.HasProcessMethod;
import org.n52.shetland.ogc.sensorML.SensorML20Constants;
import org.n52.shetland.ogc.sensorML.SmlContact;
import org.n52.shetland.ogc.sensorML.SmlResponsibleParty;
import org.n52.shetland.ogc.sensorML.Term;
import org.n52.shetland.ogc.sensorML.elements.AbstractSmlDocumentation;
import org.n52.shetland.ogc.sensorML.elements.SmlCapabilities;
import org.n52.shetland.ogc.sensorML.elements.SmlCapability;
import org.n52.shetland.ogc.sensorML.elements.SmlCharacteristic;
import org.n52.shetland.ogc.sensorML.elements.SmlCharacteristics;
import org.n52.shetland.ogc.sensorML.elements.SmlClassifier;
import org.n52.shetland.ogc.sensorML.elements.SmlComponent;
import org.n52.shetland.ogc.sensorML.elements.SmlConnection;
import org.n52.shetland.ogc.sensorML.elements.SmlDocumentation;
import org.n52.shetland.ogc.sensorML.elements.SmlDocumentationList;
import org.n52.shetland.ogc.sensorML.elements.SmlIdentifier;
import org.n52.shetland.ogc.sensorML.elements.SmlIo;
import org.n52.shetland.ogc.sensorML.elements.SmlLink;
import org.n52.shetland.ogc.sensorML.elements.SmlPosition;
import org.n52.shetland.ogc.sensorML.v20.AbstractPhysicalProcess;
import org.n52.shetland.ogc.sensorML.v20.AbstractProcessV20;
import org.n52.shetland.ogc.sensorML.v20.AggregateProcess;
import org.n52.shetland.ogc.sensorML.v20.DescribedObject;
import org.n52.shetland.ogc.sensorML.v20.PhysicalComponent;
import org.n52.shetland.ogc.sensorML.v20.PhysicalSystem;
import org.n52.shetland.ogc.sensorML.v20.SimpleProcess;
import org.n52.shetland.ogc.sensorML.v20.SmlFeatureOfInterest;
import org.n52.shetland.ogc.sos.ProcedureDescriptionFormat;
import org.n52.shetland.ogc.swe.SweAbstractDataComponent;
import org.n52.shetland.ogc.swe.SweDataArray;
import org.n52.shetland.ogc.swe.SweDataRecord;
import org.n52.shetland.ogc.swe.simpleType.SweObservableProperty;
import org.n52.shetland.util.CollectionHelper;
import org.n52.shetland.util.JavaHelper;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.AbstractSensorMLEncoder;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class SensorMLEncoderv20
extends AbstractSensorMLEncoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SensorMLEncoderv20.class);
    private static final ImmutableSet<SupportedType> SUPPORTED_TYPES = ImmutableSet.builder().add((Object)new ProcedureDescriptionFormat("http://www.opengis.net/sensorml/2.0")).add((Object)new ProcedureDescriptionFormat(SensorML20Constants.SENSORML_20_CONTENT_TYPE.toString())).build();
    private static final Map<String, Map<String, Set<String>>> SUPPORTED_PROCEDURE_DESCRIPTION_FORMATS = ImmutableMap.of((Object)"SOS", (Object)ImmutableMap.builder().put((Object)"2.0.0", (Object)ImmutableSet.of((Object)"http://www.opengis.net/sensorml/2.0")).put((Object)"1.0.0", (Object)ImmutableSet.of((Object)SensorML20Constants.SENSORML_20_OUTPUT_FORMAT_MIME_TYPE)).build());
    private static final Set<EncoderKey> ENCODER_KEYS = CollectionHelper.union((Set[])new Set[]{CodingHelper.encoderKeysForElements((String)"http://www.opengis.net/sensorml/2.0", (Class[])new Class[]{AbstractSensorML.class, DescribedObject.class}), CodingHelper.encoderKeysForElements((String)SensorML20Constants.SENSORML_20_CONTENT_TYPE.toString(), (Class[])new Class[]{AbstractSensorML.class, DescribedObject.class})});

    public SensorMLEncoderv20() {
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(ENCODER_KEYS));
    }

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEYS);
    }

    public Set<SupportedType> getSupportedTypes() {
        return Collections.unmodifiableSet(SUPPORTED_TYPES);
    }

    public void addNamespacePrefixToMap(Map<String, String> nameSpacePrefixMap) {
        nameSpacePrefixMap.put("http://www.opengis.net/sensorml/2.0", "sml");
    }

    @Override
    public MediaType getContentType() {
        return SensorML20Constants.SENSORML_20_CONTENT_TYPE;
    }

    public Set<SchemaLocation> getSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{SensorML20Constants.SML_20_SCHEMA_LOCATION});
    }

    public Set<String> getSupportedProcedureDescriptionFormats(String service, String version) {
        return SUPPORTED_PROCEDURE_DESCRIPTION_FORMATS.getOrDefault(service, Collections.emptyMap()).getOrDefault(version, Collections.emptySet());
    }

    public XmlObject encode(Object objectToEncode, EncodingContext additionalValues) throws EncodingException {
        XmlObject encodedObject;
        block5: {
            encodedObject = null;
            try {
                if (objectToEncode instanceof AbstractSensorML) {
                    AbstractSensorML description = (AbstractSensorML)objectToEncode;
                    if (description.isSetXml()) {
                        encodedObject = XmlObject.Factory.parse((String)((AbstractSensorML)objectToEncode).getXml());
                        this.addValuesToXmlObject(encodedObject, (AbstractSensorML)objectToEncode);
                        encodedObject = this.checkForAdditionalValues(encodedObject, additionalValues);
                    } else {
                        encodedObject = this.encodeDescription(description, additionalValues);
                    }
                    break block5;
                }
                throw new UnsupportedEncoderInputException((Encoder)this, objectToEncode);
            }
            catch (XmlException xmle) {
                throw new EncodingException((Throwable)xmle);
            }
        }
        XmlHelper.makeGmlIdsUnique((Node)encodedObject.getDomNode());
        XmlHelper.validateDocument((XmlObject)encodedObject, EncodingException::new);
        return encodedObject;
    }

    private XmlObject checkForAdditionalValues(XmlObject element, EncodingContext additionalValues) {
        boolean doc = additionalValues.has((Enum)XmlBeansEncodingFlags.DOCUMENT);
        boolean propertyType = additionalValues.has((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE);
        boolean type = additionalValues.has((Enum)XmlBeansEncodingFlags.TYPE);
        if (element instanceof PhysicalSystemDocument) {
            if (propertyType) {
                PhysicalSystemPropertyType pspt = PhysicalSystemPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
                pspt.setPhysicalSystem(((PhysicalSystemDocument)element).getPhysicalSystem());
                return pspt;
            }
            if (type) {
                return ((PhysicalSystemDocument)element).getPhysicalSystem();
            }
        } else if (element instanceof PhysicalSystemPropertyType) {
            if (doc) {
                PhysicalSystemDocument psd = PhysicalSystemDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
                psd.setPhysicalSystem(((PhysicalSystemPropertyType)element).getPhysicalSystem());
                return psd;
            }
            if (type) {
                return ((PhysicalSystemPropertyType)element).getPhysicalSystem();
            }
        } else if (element instanceof PhysicalSystemType) {
            if (doc) {
                PhysicalSystemDocument psd = PhysicalSystemDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
                psd.setPhysicalSystem((PhysicalSystemType)element);
                return psd;
            }
            if (propertyType) {
                PhysicalSystemPropertyType pspt = PhysicalSystemPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
                pspt.setPhysicalSystem((PhysicalSystemType)element);
                return pspt;
            }
        } else if (element instanceof PhysicalComponentDocument) {
            if (propertyType) {
                PhysicalComponentPropertyType pcpt = PhysicalComponentPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
                pcpt.setPhysicalComponent(((PhysicalComponentDocument)element).getPhysicalComponent());
            } else if (type) {
                return ((PhysicalComponentDocument)element).getPhysicalComponent();
            }
        } else if (element instanceof PhysicalComponentPropertyType) {
            if (doc) {
                PhysicalComponentDocument pcd = PhysicalComponentDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
                pcd.setPhysicalComponent(((PhysicalComponentPropertyType)element).getPhysicalComponent());
                return pcd;
            }
            if (type) {
                return ((PhysicalComponentPropertyType)element).getPhysicalComponent();
            }
        } else if (element instanceof PhysicalComponentType) {
            if (doc) {
                PhysicalComponentDocument pcd = PhysicalComponentDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
                pcd.setPhysicalComponent((PhysicalComponentType)element);
                return pcd;
            }
            if (propertyType) {
                PhysicalComponentPropertyType pcpt = PhysicalComponentPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
                pcpt.setPhysicalComponent((PhysicalComponentType)element);
                return pcpt;
            }
        } else if (element instanceof SimpleProcessDocument) {
            if (propertyType) {
                SimpleProcessPropertyType sppt = SimpleProcessPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
                sppt.setSimpleProcess(((SimpleProcessDocument)element).getSimpleProcess());
            } else if (type) {
                return ((SimpleProcessDocument)element).getSimpleProcess();
            }
        } else if (element instanceof SimpleProcessPropertyType) {
            if (doc) {
                SimpleProcessDocument spd = SimpleProcessDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
                spd.setSimpleProcess(((SimpleProcessPropertyType)element).getSimpleProcess());
                return spd;
            }
            if (type) {
                return ((SimpleProcessPropertyType)element).getSimpleProcess();
            }
        } else if (element instanceof SimpleProcessType) {
            if (doc) {
                SimpleProcessDocument spd = SimpleProcessDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
                spd.setSimpleProcess((SimpleProcessType)element);
                return spd;
            }
            if (propertyType) {
                SimpleProcessPropertyType sppt = SimpleProcessPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
                sppt.setSimpleProcess((SimpleProcessType)element);
                return sppt;
            }
        } else if (element instanceof AggregateProcessDocument) {
            if (propertyType) {
                AggregateProcessPropertyType appt = AggregateProcessPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
                appt.setAggregateProcess(((AggregateProcessDocument)element).getAggregateProcess());
            } else if (type) {
                return ((AggregateProcessDocument)element).getAggregateProcess();
            }
        } else if (element instanceof AggregateProcessPropertyType) {
            if (doc) {
                AggregateProcessDocument apd = AggregateProcessDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
                apd.setAggregateProcess(((AggregateProcessPropertyType)element).getAggregateProcess());
                return apd;
            }
            if (type) {
                return ((AggregateProcessPropertyType)element).getAggregateProcess();
            }
        } else if (element instanceof AggregateProcessType) {
            if (doc) {
                AggregateProcessDocument apd = AggregateProcessDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
                apd.setAggregateProcess((AggregateProcessType)element);
                return apd;
            }
            if (propertyType) {
                AggregateProcessPropertyType appt = AggregateProcessPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
                appt.setAggregateProcess((AggregateProcessType)element);
                return appt;
            }
        }
        return element;
    }

    private void addValuesToXmlObject(XmlObject element, AbstractSensorML description) throws EncodingException {
        if (element instanceof PhysicalSystemDocument) {
            this.addPhysicalSystemValues(((PhysicalSystemDocument)element).getPhysicalSystem(), (PhysicalSystem)description);
        } else if (element instanceof PhysicalSystemPropertyType) {
            this.addPhysicalSystemValues(((PhysicalSystemPropertyType)element).getPhysicalSystem(), (PhysicalSystem)description);
        } else if (element instanceof PhysicalComponentDocument && description instanceof PhysicalComponent) {
            this.addPhysicalComponentValues(((PhysicalComponentDocument)element).getPhysicalComponent(), (PhysicalComponent)description);
        } else if (element instanceof PhysicalComponentPropertyType && description instanceof PhysicalComponent) {
            this.addPhysicalComponentValues(((PhysicalComponentPropertyType)element).getPhysicalComponent(), (PhysicalComponent)description);
        } else if (element instanceof SimpleProcessDocument && description instanceof SimpleProcess) {
            this.addSimpleProcessValues(((SimpleProcessDocument)element).getSimpleProcess(), (SimpleProcess)description);
        } else if (element instanceof SimpleProcessPropertyType && description instanceof SimpleProcess) {
            this.addSimpleProcessValues(((SimpleProcessPropertyType)element).getSimpleProcess(), (SimpleProcess)description);
        } else if (element instanceof AggregateProcessDocument && description instanceof AggregateProcess) {
            this.addAggregateProcessValues(((AggregateProcessDocument)element).getAggregateProcess(), (AggregateProcess)description);
        } else if (element instanceof AggregateProcessPropertyType && description instanceof AggregateProcess) {
            this.addAggregateProcessValues(((AggregateProcessPropertyType)element).getAggregateProcess(), (AggregateProcess)description);
        }
    }

    private XmlObject encodeDescription(AbstractSensorML description, EncodingContext additionalValues) throws EncodingException {
        XmlObject absProc = null;
        if (description instanceof AbstractPhysicalProcess) {
            absProc = this.encodeAbstractPhysicalProcess((AbstractPhysicalProcess)description, additionalValues);
        } else if (description instanceof SimpleProcess) {
            absProc = this.encodeSimpleProcess((SimpleProcess)description, additionalValues);
        } else if (description instanceof AggregateProcess) {
            absProc = this.encodeAggregateProcess((AggregateProcess)description, additionalValues);
        } else {
            throw new UnsupportedEncoderInputException((Encoder)this, (Object)description);
        }
        return absProc;
    }

    private XmlObject encodeSimpleProcess(SimpleProcess abstractProcess, EncodingContext additionalValues) throws EncodingException {
        SimpleProcessPropertyType sppt = SimpleProcessPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        this.addSimpleProcessValues(sppt.addNewSimpleProcess(), abstractProcess);
        if (additionalValues.has((Enum)XmlBeansEncodingFlags.DOCUMENT)) {
            SimpleProcessDocument spd = SimpleProcessDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
            spd.setSimpleProcess(sppt.getSimpleProcess());
        } else if (additionalValues.has((Enum)XmlBeansEncodingFlags.TYPE)) {
            return sppt.getSimpleProcess();
        }
        return sppt;
    }

    private void addSimpleProcessValues(SimpleProcessType spt, SimpleProcess abstractProcess) throws EncodingException {
        this.addAbstractProcessValues((AbstractProcessType)spt, (AbstractProcessV20)abstractProcess);
        this.addDescribedObjectValues((DescribedObjectType)spt, (DescribedObject)abstractProcess);
        if (abstractProcess.isSetMethod()) {
            spt.addNewMethod().setProcessMethod(this.createProcessMethod((HasProcessMethod)abstractProcess));
        }
    }

    private XmlObject encodeAggregateProcess(AggregateProcess abstractProcess, EncodingContext additionalValues) throws EncodingException {
        AggregateProcessPropertyType appt = AggregateProcessPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        this.addAggregateProcessValues(appt.addNewAggregateProcess(), abstractProcess);
        if (additionalValues.has((Enum)XmlBeansEncodingFlags.DOCUMENT)) {
            AggregateProcessDocument apd = AggregateProcessDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
            apd.setAbstractProcess((AbstractProcessType)appt.getAggregateProcess());
        } else if (additionalValues.has((Enum)XmlBeansEncodingFlags.TYPE)) {
            return appt.getAggregateProcess();
        }
        return appt;
    }

    private void addAggregateProcessValues(AggregateProcessType apt, AggregateProcess abstractProcess) throws EncodingException {
        ComponentListPropertyType clpt;
        List<SmlComponent> smlComponents;
        this.addAbstractProcessValues((AbstractProcessType)apt, (AbstractProcessV20)abstractProcess);
        this.addDescribedObjectValues((DescribedObjectType)apt, (DescribedObject)abstractProcess);
        if (abstractProcess.isSetComponents() && !(smlComponents = this.checkForComponents((AbstractProcess)abstractProcess)).isEmpty() && (clpt = this.createComponents(smlComponents)) != null && clpt.getComponentList() != null && clpt.getComponentList().sizeOfComponentArray() > 0) {
            apt.setComponents(clpt);
        }
    }

    private XmlObject encodeAbstractPhysicalProcess(AbstractPhysicalProcess abstractPhysicalProcess, EncodingContext additionalValues) throws EncodingException {
        XmlObject absPhysObj = null;
        if (abstractPhysicalProcess instanceof PhysicalSystem) {
            absPhysObj = this.encodePhysicalSystem((PhysicalSystem)abstractPhysicalProcess, additionalValues);
        } else if (abstractPhysicalProcess instanceof PhysicalComponent) {
            absPhysObj = this.encodePhysicalComponent((PhysicalComponent)abstractPhysicalProcess, additionalValues);
        } else {
            throw new UnsupportedEncoderInputException((Encoder)this, (Object)abstractPhysicalProcess);
        }
        return absPhysObj;
    }

    private XmlObject encodePhysicalComponent(PhysicalComponent abstractPhysicalProcess, EncodingContext additionalValues) throws EncodingException {
        PhysicalComponentPropertyType pcpt = PhysicalComponentPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        this.addPhysicalComponentValues(pcpt.addNewPhysicalComponent(), abstractPhysicalProcess);
        if (additionalValues.has((Enum)XmlBeansEncodingFlags.DOCUMENT)) {
            PhysicalComponentDocument pcd = PhysicalComponentDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
            pcd.setPhysicalComponent(pcpt.getPhysicalComponent());
        } else if (additionalValues.has((Enum)XmlBeansEncodingFlags.TYPE)) {
            return pcpt.getPhysicalComponent();
        }
        return pcpt;
    }

    private void addPhysicalComponentValues(PhysicalComponentType pct, PhysicalComponent abstractPhysicalProcess) throws EncodingException {
        this.addAbstractProcessValues((AbstractProcessType)pct, (AbstractProcessV20)abstractPhysicalProcess);
        this.addDescribedObjectValues((DescribedObjectType)pct, (DescribedObject)abstractPhysicalProcess);
        this.addAbstractPhysicalProcessValues((AbstractPhysicalProcessType)pct, (AbstractPhysicalProcess)abstractPhysicalProcess);
        if (abstractPhysicalProcess.isSetMethod()) {
            pct.addNewMethod().setProcessMethod(this.createProcessMethod((HasProcessMethod)abstractPhysicalProcess));
        }
    }

    private XmlObject encodePhysicalSystem(PhysicalSystem abstractPhysicalProcess, EncodingContext additionalValues) throws EncodingException {
        PhysicalSystemPropertyType pspt = PhysicalSystemPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        this.addPhysicalSystemValues(pspt.addNewPhysicalSystem(), abstractPhysicalProcess);
        if (additionalValues.has((Enum)XmlBeansEncodingFlags.DOCUMENT)) {
            PhysicalSystemDocument psd = PhysicalSystemDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
            psd.setPhysicalSystem(pspt.getPhysicalSystem());
        } else if (additionalValues.has((Enum)XmlBeansEncodingFlags.TYPE)) {
            return pspt.getPhysicalSystem();
        }
        return pspt;
    }

    private void addPhysicalSystemValues(PhysicalSystemType pst, PhysicalSystem abstractPhysicalProcess) throws EncodingException {
        ComponentListPropertyType clpt;
        List<SmlComponent> smlComponents;
        this.addAbstractProcessValues((AbstractProcessType)pst, (AbstractProcessV20)abstractPhysicalProcess);
        this.addDescribedObjectValues((DescribedObjectType)pst, (DescribedObject)abstractPhysicalProcess);
        this.addAbstractPhysicalProcessValues((AbstractPhysicalProcessType)pst, (AbstractPhysicalProcess)abstractPhysicalProcess);
        if (abstractPhysicalProcess.isSetComponents() && !(smlComponents = this.checkForComponents((AbstractProcess)abstractPhysicalProcess)).isEmpty() && (clpt = this.createComponents(smlComponents)) != null && clpt.getComponentList() != null && clpt.getComponentList().sizeOfComponentArray() > 0) {
            pst.setComponents(clpt);
        }
        if (abstractPhysicalProcess.isSetConnections() && !pst.isSetConnections()) {
            pst.setConnections(this.createConnections(abstractPhysicalProcess.getConnections()));
        }
    }

    private void addDescribedObjectValues(DescribedObjectType dot, DescribedObject describedObject) throws EncodingException {
        if (!describedObject.isSetGmlID()) {
            describedObject.setGmlId("do_" + JavaHelper.generateID((String)describedObject.toString()));
        }
        dot.setId(describedObject.getGmlId());
        if (describedObject.isSetIdentifier()) {
            describedObject.getIdentifierCodeWithAuthority().setCodeSpace("uniqueID");
            XmlObject encodeObjectToXml = this.encodeObjectToXmlGml32(describedObject.getIdentifierCodeWithAuthority());
            if (encodeObjectToXml != null) {
                if (dot.isSetIdentifier()) {
                    dot.getIdentifier().set(encodeObjectToXml);
                } else {
                    dot.addNewIdentifier().set(encodeObjectToXml);
                }
            }
        }
        if (describedObject.isSetCapabilities()) {
            DescribedObjectType.Capabilities[] existing = dot.getCapabilitiesArray();
            HashSet names = Sets.newHashSetWithExpectedSize((int)existing.length);
            for (DescribedObjectType.Capabilities element : existing) {
                if (element.getName() == null) continue;
                names.add(element.getName());
            }
            for (SmlCapabilities sosCapability : describedObject.getCapabilities()) {
                DescribedObjectType.Capabilities c;
                if ("observedBBOX".equals(sosCapability.getName()) || (c = this.createCapability(sosCapability)) == null) continue;
                if (names.contains(c.getName())) {
                    this.removeCapability(dot, c);
                }
                dot.addNewCapabilities().set((XmlObject)c);
            }
        }
        if (describedObject.isSetDescription() && !dot.isSetDescription()) {
            dot.addNewDescription().setStringValue(describedObject.getDescription());
        }
        if (describedObject.isSetName() && CollectionHelper.isNullOrEmpty((Object[])dot.getNameArray())) {
            this.addNamesToAbstractProcess(dot, describedObject.getNames());
        }
        if (describedObject.isSetKeywords() && CollectionHelper.isNullOrEmpty((Object[])dot.getKeywordsArray())) {
            List keywords = describedObject.getKeywords();
            dot.addNewKeywords().addNewKeywordList().setKeywordArray(keywords.toArray(new String[keywords.size()]));
        }
        if (describedObject.isSetIdentifications()) {
            dot.setIdentificationArray(this.createIdentification(describedObject.getIdentifications()));
        }
        if (describedObject.isSetClassifications()) {
            dot.setClassificationArray(this.createClassification(describedObject.getClassifications()));
        }
        if (describedObject.isSetValidTime() && CollectionHelper.isNullOrEmpty((Object[])dot.getValidTimeArray())) {
            for (Time time : describedObject.getValidTime()) {
                XmlObject xbtime = this.encodeObjectToXmlGml32(time);
                if (time instanceof TimeInstant) {
                    dot.addNewValidTime().addNewTimeInstant().set(xbtime);
                    continue;
                }
                if (!(time instanceof TimePeriod)) continue;
                dot.addNewValidTime().addNewTimePeriod().set(xbtime);
            }
        }
        if (describedObject.isSetCharacteristics()) {
            dot.setCharacteristicsArray(this.createCharacteristics(describedObject.getCharacteristics()));
        }
        if (describedObject.isSetContact() && CollectionHelper.isNullOrEmpty((Object[])dot.getContactsArray())) {
            ContactListType cl = ContactListType.Factory.newInstance();
            for (SmlContact contact : describedObject.getContact()) {
                if (!(contact instanceof SmlResponsibleParty)) continue;
                if (contact.isSetHref()) {
                    XmlObject xml = this.encodeObjectToXml("http://www.isotc211.org/2005/gmd", (SmlResponsibleParty)contact, EncodingContext.of((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE));
                    cl.addNewContact().set(xml);
                    continue;
                }
                XmlObject encodeObjectToXml = this.encodeObjectToXml("http://www.isotc211.org/2005/gmd", contact);
                if (encodeObjectToXml == null) continue;
                cl.addNewContact().addNewCIResponsibleParty().set(encodeObjectToXml);
            }
            if (CollectionHelper.isNotNullOrEmpty((Object[])cl.getContactArray())) {
                dot.addNewContacts().setContactList(cl);
            }
        }
        if (describedObject.isSetDocumentation() && CollectionHelper.isNullOrEmpty((Object[])dot.getDocumentationArray())) {
            dot.setDocumentationArray(this.createDocumentationArray(describedObject.getDocumentation()));
        }
    }

    private void addAbstractProcessValues(AbstractProcessType apt, AbstractProcessV20 abstractProcess) throws EncodingException {
        if (abstractProcess.isSetTypeOf()) {
            if (apt.isSetTypeOf()) {
                this.substitute((XmlObject)apt.getTypeOf(), this.encodeObjectToXmlGml32(abstractProcess.getTypeOf()));
            } else {
                this.substitute((XmlObject)apt.addNewTypeOf(), this.encodeObjectToXmlGml32(abstractProcess.getTypeOf()));
            }
        }
        if (abstractProcess.isSetSmlFeatureOfInterest() && abstractProcess.getSmlFeatureOfInterest().isSetFeatures()) {
            if (!apt.isSetFeaturesOfInterest()) {
                apt.setFeaturesOfInterest(this.createFeatureOfInterest(abstractProcess.getSmlFeatureOfInterest()));
            }
            this.addFeatures(apt.getFeaturesOfInterest().getFeatureList(), abstractProcess.getSmlFeatureOfInterest());
        }
        if (abstractProcess.isSetInputs() && !apt.isSetInputs()) {
            apt.setInputs(this.createInputs(abstractProcess.getInputs()));
        }
        if (abstractProcess.isSetOutputs() && !apt.isSetOutputs()) {
            apt.setOutputs(this.createOutputs(abstractProcess.getOutputs()));
        }
    }

    private void addAbstractPhysicalProcessValues(AbstractPhysicalProcessType appt, AbstractPhysicalProcess absPhysicalProcess) throws EncodingException {
        if (absPhysicalProcess.isSetAttachedTo()) {
            if (appt.isSetAttachedTo()) {
                this.substitute((XmlObject)appt.getAttachedTo(), this.encodeObjectToXmlGml32(absPhysicalProcess.getAttachedTo()));
            } else {
                this.substitute((XmlObject)appt.addNewAttachedTo(), this.encodeObjectToXmlGml32(absPhysicalProcess.getAttachedTo()));
            }
        }
        if (CollectionHelper.isNullOrEmpty((Object[])appt.getPositionArray()) && absPhysicalProcess.isSetPosition()) {
            this.createPosition(appt.addNewPosition(), absPhysicalProcess.getPosition());
        }
    }

    private List<SmlComponent> checkForComponents(AbstractProcess abstractProcess) throws EncodingException {
        ArrayList smlComponents = Lists.newArrayList();
        if (abstractProcess instanceof HasComponents && ((HasComponents)abstractProcess).isSetComponents()) {
            smlComponents.addAll(((HasComponents)abstractProcess).getComponents());
        }
        return smlComponents;
    }

    private void addNamesToAbstractProcess(DescribedObjectType dot, List<CodeType> names) throws EncodingException {
        for (CodeType codeType : names) {
            dot.addNewName().set(this.encodeObjectToXmlGml32(codeType));
        }
    }

    private void removeCapability(DescribedObjectType dot, DescribedObjectType.Capabilities c) {
        for (int i = 0; i < dot.getCapabilitiesArray().length; ++i) {
            if (!dot.getCapabilitiesArray(i).getName().equals(c.getName())) continue;
            dot.removeCapabilities(i);
            return;
        }
    }

    private DescribedObjectType.Capabilities createCapability(SmlCapabilities capabilities) throws EncodingException {
        DescribedObjectType.Capabilities xbCapabilities;
        block9: {
            CapabilityListType capabilityList;
            block10: {
                xbCapabilities = null;
                if (!capabilities.isSetAbstractDataComponents()) break block9;
                xbCapabilities = DescribedObjectType.Capabilities.Factory.newInstance((XmlOptions)this.getXmlOptions());
                if (capabilities.isSetName()) {
                    xbCapabilities.setName(capabilities.getName());
                }
                capabilityList = xbCapabilities.addNewCapabilityList();
                if (!capabilities.isSetCapabilities()) break block10;
                for (SmlCapability capability : capabilities.getCapabilities()) {
                    XmlObject encodeObjectToXml = this.encodeObjectToXmlSwe20(capability.getAbstractDataComponent());
                    CapabilityListType.Capability c = capabilityList.addNewCapability();
                    if (capability.isSetName()) {
                        c.setName(NcName.makeValid((String)capability.getName()));
                    } else if (capability.getAbstractDataComponent().isSetName()) {
                        capability.setName(NcName.makeValid((String)capability.getAbstractDataComponent().getName().getValue()));
                    } else {
                        capability.setName(NcName.makeValid((String)capability.getAbstractDataComponent().getDefinition()));
                    }
                    XmlObject substituteElement = XmlHelper.substituteElement((XmlObject)c.addNewAbstractDataComponent(), (XmlObject)encodeObjectToXml);
                    substituteElement.set(encodeObjectToXml);
                }
                break block9;
            }
            if (!capabilities.isSetAbstractDataComponents()) break block9;
            for (SweAbstractDataComponent component : capabilities.getAbstractDataComponents()) {
                XmlObject encodeObjectToXml = this.encodeObjectToXmlSwe20(component);
                CapabilityListType.Capability capability = capabilityList.addNewCapability();
                if (component.isSetName()) {
                    capability.setName(NcName.makeValid((String)component.getName().getValue()));
                } else {
                    capability.setName(NcName.makeValid((String)component.getDefinition()));
                }
                XmlObject substituteElement = XmlHelper.substituteElement((XmlObject)capability.addNewAbstractDataComponent(), (XmlObject)encodeObjectToXml);
                substituteElement.set(encodeObjectToXml);
            }
        }
        return xbCapabilities;
    }

    private ProcessMethodType createProcessMethod(HasProcessMethod processMethod) {
        return null;
    }

    protected IdentifierListPropertyType[] createIdentification(List<SmlIdentifier> identifications) {
        IdentifierListPropertyType xbIdentification = IdentifierListPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        IdentifierListType xbIdentifierList = xbIdentification.addNewIdentifierList();
        identifications.forEach(sosSMLIdentifier -> this.createTerm(xbIdentifierList.addNewIdentifier2().addNewTerm(), (Term)sosSMLIdentifier));
        return new IdentifierListPropertyType[]{xbIdentification};
    }

    private ClassifierListPropertyType[] createClassification(List<SmlClassifier> classifications) {
        ClassifierListPropertyType xbClassification = ClassifierListPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        ClassifierListType xbClassifierList = xbClassification.addNewClassifierList();
        classifications.forEach(classifier -> this.createTerm(xbClassifierList.addNewClassifier().addNewTerm(), (Term)classifier));
        return new ClassifierListPropertyType[]{xbClassification};
    }

    private void createTerm(TermType t, Term term) {
        t.setLabel(term.getLabel());
        if (term.isSetDefinition()) {
            t.setDefinition(term.getDefinition());
        }
        if (term.isSetCodeSpace()) {
            t.addNewCodeSpace().setHref(term.getCodeSpace());
        }
        t.setValue(term.getValue());
    }

    private DescribedObjectType.Characteristics[] createCharacteristics(List<SmlCharacteristics> smlCharacteristics) throws EncodingException {
        ArrayList<DescribedObjectType.Characteristics> characteristicsList = new ArrayList<DescribedObjectType.Characteristics>(smlCharacteristics.size());
        for (SmlCharacteristics sosSMLCharacteristics : smlCharacteristics) {
            XmlObject substituteElement;
            DescribedObjectType.Characteristics xbCharacteristics = DescribedObjectType.Characteristics.Factory.newInstance((XmlOptions)this.getXmlOptions());
            if (sosSMLCharacteristics.isSetName()) {
                xbCharacteristics.setName(sosSMLCharacteristics.getName());
            } else {
                xbCharacteristics.setName("characteristics_" + smlCharacteristics.lastIndexOf(sosSMLCharacteristics));
            }
            CharacteristicListType characteristicList = xbCharacteristics.addNewCharacteristicList();
            if (sosSMLCharacteristics.isSetCharacteristics()) {
                for (SmlCharacteristic characteristic : sosSMLCharacteristics.getCharacteristic()) {
                    CharacteristicListType.Characteristic c = characteristicList.addNewCharacteristic();
                    c.setName(NcName.makeValid((String)characteristic.getName()));
                    if (characteristic.isSetAbstractDataComponent()) {
                        XmlObject encodeObjectToXml = this.encodeObjectToXml("http://www.opengis.net/swe/2.0", characteristic.getAbstractDataComponent());
                        substituteElement = XmlHelper.substituteElement((XmlObject)c.addNewAbstractDataComponent(), (XmlObject)encodeObjectToXml);
                        substituteElement.set(encodeObjectToXml);
                        continue;
                    }
                    if (!characteristic.isSetHref()) continue;
                    c.setHref(characteristic.getHref());
                    if (!characteristic.isSetTitle()) continue;
                    c.setTitle(characteristic.getTitle());
                }
            }
            if (sosSMLCharacteristics.isSetAbstractDataComponents() && sosSMLCharacteristics.isSetAbstractDataComponents()) {
                for (SweAbstractDataComponent component : sosSMLCharacteristics.getAbstractDataComponents()) {
                    XmlObject encodeObjectToXml = this.encodeObjectToXml("http://www.opengis.net/swe/2.0", component);
                    CharacteristicListType.Characteristic c = characteristicList.addNewCharacteristic();
                    c.setName(NcName.makeValid((String)component.getName().getValue()));
                    substituteElement = XmlHelper.substituteElement((XmlObject)c.addNewAbstractDataComponent(), (XmlObject)encodeObjectToXml);
                    substituteElement.set(encodeObjectToXml);
                }
            }
            characteristicsList.add(xbCharacteristics);
        }
        return characteristicsList.toArray(new DescribedObjectType.Characteristics[characteristicsList.size()]);
    }

    protected DocumentListPropertyType[] createDocumentationArray(List<AbstractSmlDocumentation> sosDocumentation) {
        return (DocumentListPropertyType[])sosDocumentation.stream().map(doc -> {
            DocumentListPropertyType documentation = DocumentListPropertyType.Factory.newInstance();
            if (doc instanceof SmlDocumentation) {
                documentation.setDocumentList(this.createDocument((SmlDocumentation)doc));
            } else if (doc instanceof SmlDocumentationList) {
                documentation.setDocumentList(this.createDocumentationList((SmlDocumentationList)doc));
            }
            return documentation;
        }).toArray(DocumentListPropertyType[]::new);
    }

    private DocumentListType createDocument(SmlDocumentation sosDocumentation) {
        DocumentListType documentList = DocumentListType.Factory.newInstance();
        if (sosDocumentation.isSetDescription()) {
            documentList.setDescription(sosDocumentation.getDescription());
        }
        return documentList;
    }

    private DocumentListType createDocumentationList(SmlDocumentationList sosDocumentationList) {
        DocumentListType documentList = DocumentListType.Factory.newInstance();
        if (sosDocumentationList.isSetDescription()) {
            documentList.setDescription(sosDocumentationList.getDescription());
        }
        return documentList;
    }

    private void createPosition(PositionUnionPropertyType pupt, SmlPosition position) throws EncodingException {
        if (position.isSetVector()) {
            pupt.addNewVector().set(this.encodeObjectToXmlSwe20(position.getVector()));
        } else if (position.isSetAbstractDataComponent()) {
            SweAbstractDataComponent abstractDataComponent = position.getAbstractDataComponent();
            if (abstractDataComponent instanceof SweDataRecord) {
                pupt.addNewDataRecord().set(this.encodeObjectToXmlSwe20(abstractDataComponent));
            } else if (abstractDataComponent instanceof SweDataArray) {
                pupt.addNewDataArray1().set(this.encodeObjectToXmlSwe20(abstractDataComponent));
            }
        }
    }

    private AbstractProcessType.Inputs createInputs(List<SmlIo> inputs) throws EncodingException {
        AbstractProcessType.Inputs xbInputs = AbstractProcessType.Inputs.Factory.newInstance((XmlOptions)this.getXmlOptions());
        InputListType xbInputList = xbInputs.addNewInputList();
        int counter = 1;
        for (SmlIo sosSMLIo : inputs) {
            if (!sosSMLIo.isSetName()) {
                sosSMLIo.setIoName("input_" + counter++);
            } else {
                sosSMLIo.setIoName(NcName.makeValid((String)sosSMLIo.getIoName()));
            }
            this.addInput(xbInputList.addNewInput(), sosSMLIo);
        }
        return xbInputs;
    }

    private AbstractProcessType.Outputs createOutputs(List<SmlIo> sosOutputs) throws EncodingException {
        AbstractProcessType.Outputs outputs = AbstractProcessType.Outputs.Factory.newInstance((XmlOptions)this.getXmlOptions());
        OutputListType outputList = outputs.addNewOutputList();
        HashSet definitions = Sets.newHashSet();
        int counter = 1;
        HashSet outputNames = Sets.newHashSet();
        for (SmlIo sosSMLIo : sosOutputs) {
            if (!sosSMLIo.isSetValue().booleanValue() || definitions.contains(sosSMLIo.getIoValue().getDefinition())) continue;
            if (!sosSMLIo.isSetName() || outputNames.contains(sosSMLIo.getIoName())) {
                sosSMLIo.setIoName(this.getValidOutputName(counter++, outputNames));
            } else {
                sosSMLIo.setIoName(NcName.makeValid((String)sosSMLIo.getIoName()));
            }
            outputNames.add(sosSMLIo.getIoName());
            this.addOutput(outputList.addNewOutput(), sosSMLIo);
            definitions.add(sosSMLIo.getIoValue().getDefinition());
        }
        return outputs;
    }

    private AbstractProcessType.FeaturesOfInterest createFeatureOfInterest(SmlFeatureOfInterest feature) {
        if (feature.isSetFeaturesOfInterest()) {
            AbstractProcessType.FeaturesOfInterest foi = AbstractProcessType.FeaturesOfInterest.Factory.newInstance((XmlOptions)this.getXmlOptions());
            FeatureListType featureList = foi.addNewFeatureList();
            if (feature.isSetDefinition()) {
                featureList.setDefinition(feature.getDefinition());
            }
            if (feature.isSetDescription()) {
                featureList.setDescription(feature.getDescription());
            }
            if (feature.isSetIdentifier()) {
                featureList.setIdentifier(feature.getIdentifier());
            }
            if (feature.isSetLabel()) {
                featureList.setLabel(feature.getLabel());
            }
            return foi;
        }
        return null;
    }

    private void addFeatures(FeatureListType featureList, SmlFeatureOfInterest feature) {
        HashSet featuresToAdd = Sets.newHashSet();
        if (feature.isSetFeaturesOfInterest()) {
            featuresToAdd.addAll(feature.getFeaturesOfInterest());
        }
        if (feature.isSetFeaturesOfInterestMap()) {
            featuresToAdd.addAll(feature.getFeaturesOfInterestMap().keySet());
        }
        for (int i = 0; i < featureList.sizeOfFeatureArray(); ++i) {
            featureList.removeFeature(i);
        }
        featuresToAdd.forEach(featureIdentifier -> featureList.addNewFeature().setHref(featureIdentifier));
    }

    private ComponentListPropertyType createComponents(List<SmlComponent> sosComponents) throws EncodingException {
        ComponentListPropertyType clpt = ComponentListPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        ComponentListType clt = clpt.addNewComponentList();
        for (SmlComponent sosSMLComponent : sosComponents) {
            XmlObject xmlObject;
            ComponentListType.Component component = clt.addNewComponent();
            if (sosSMLComponent.isSetName()) {
                component.setName(sosSMLComponent.getName());
            }
            if (sosSMLComponent.isSetHref()) {
                component.setHref(sosSMLComponent.getHref());
                if (!sosSMLComponent.isSetTitle()) continue;
                component.setTitle(sosSMLComponent.getTitle());
                continue;
            }
            if (!sosSMLComponent.isSetProcess() || (xmlObject = this.encode(sosSMLComponent.getProcess(), EncodingContext.of((Enum)XmlBeansEncodingFlags.TYPE))) == null) continue;
            this.substitute((XmlObject)component.addNewAbstractProcess(), xmlObject);
        }
        return clpt;
    }

    private ConnectionListPropertyType createConnections(SmlConnection connections) {
        ConnectionListPropertyType clpt = ConnectionListPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        if (!Strings.isNullOrEmpty((String)connections.getHref())) {
            clpt.setHref(connections.getHref());
            if (!Strings.isNullOrEmpty((String)connections.getTitle())) {
                clpt.setTitle(connections.getTitle());
            }
            if (!Strings.isNullOrEmpty((String)connections.getRole())) {
                clpt.setRole(connections.getRole());
            }
        } else {
            ConnectionListType clt = clpt.addNewConnectionList();
            for (SmlLink link : connections.getConnections()) {
                LinkType lt = clt.addNewConnection().addNewLink();
                lt.addNewDestination().setRef(link.getDestination());
                lt.addNewSource().setRef(link.getSource());
                if (Strings.isNullOrEmpty((String)link.getId())) continue;
                lt.setId(link.getId());
            }
        }
        return clpt;
    }

    private void addInput(InputListType.Input input, SmlIo sosSMLIO) throws EncodingException {
        input.setName(sosSMLIO.getIoName());
        this.addDataComponentOrObservablePropertyType((DataComponentOrObservablePropertyType)input, sosSMLIO);
    }

    private void addDataComponentOrObservablePropertyType(DataComponentOrObservablePropertyType type, SmlIo sosSMLIO) throws EncodingException {
        if (sosSMLIO.isSetHref()) {
            type.setHref(sosSMLIO.getHref());
            if (sosSMLIO.isSetTitle()) {
                type.setTitle(sosSMLIO.getTitle());
            }
        } else if (sosSMLIO.getIoValue() instanceof SweObservableProperty) {
            this.addValueToObservableProperty(type.addNewObservableProperty(), sosSMLIO.getIoValue());
        } else {
            XmlObject encodeObjectToXml = this.encodeObjectToXmlSwe20(sosSMLIO.getIoValue());
            XmlObject substituteElement = XmlHelper.substituteElement((XmlObject)type.addNewAbstractDataComponent(), (XmlObject)encodeObjectToXml);
            substituteElement.set(encodeObjectToXml);
        }
    }

    private void addValueToObservableProperty(ObservablePropertyType opt, SweAbstractDataComponent observableProperty) {
        if (observableProperty.isSetDefinition()) {
            opt.setDefinition(observableProperty.getDefinition());
        }
        if (observableProperty.isSetDescription()) {
            opt.setDescription(observableProperty.getDescription());
        }
        if (observableProperty.isSetIdentifier()) {
            opt.setIdentifier(observableProperty.getIdentifier());
        }
        if (observableProperty.isSetLabel()) {
            opt.setLabel(observableProperty.getLabel());
        }
    }

    private void addOutput(OutputListType.Output output, SmlIo sosSMLIO) throws EncodingException {
        output.setName(sosSMLIO.getIoName());
        this.addDataComponentOrObservablePropertyType((DataComponentOrObservablePropertyType)output, sosSMLIO);
    }

    private XmlObject encodeObjectToXmlGml32(Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/gml/3.2", o);
    }

    private XmlObject encodeObjectToXmlSwe20(Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/swe/2.0", o);
    }
}

