/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Joiner;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.n52.shetland.w3c.soap.SoapHeader;
import org.n52.shetland.w3c.soap.SoapHelper;
import org.n52.shetland.w3c.soap.SoapResponse;
import org.n52.shetland.w3c.wsa.WsaActionHeader;
import org.n52.shetland.w3c.wsa.WsaHeader;
import org.n52.svalbard.encode.AbstractSoapEncoder;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.N52XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Soap11Encoder
extends AbstractSoapEncoder<SOAPMessage, SoapResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Soap11Encoder.class);

    public Soap11Encoder() {
        super("http://schemas.xmlsoap.org/soap/envelope/");
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(this.getKeys()));
    }

    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
    public SOAPMessage encode(SoapResponse soapResponse, EncodingContext additionalValues) throws EncodingException {
        if (soapResponse == null) {
            throw new UnsupportedEncoderInputException((Encoder)this, (Object)soapResponse);
        }
        String soapVersion = soapResponse.getSoapVersion();
        String action = null;
        try {
            SOAPMessage soapResponseMessage = SoapHelper.getSoapMessageForProtocol((String)soapVersion);
            if (soapResponse.getSoapFault() != null) {
                this.createSOAPFault(soapResponseMessage.getSOAPBody().addFault(), soapResponse.getSoapFault());
            } else if (soapResponse.getException() != null) {
                action = this.createSOAPFaultFromExceptionResponse(soapResponseMessage.getSOAPBody().addFault(), soapResponse.getException());
                this.addSchemaLocationForExceptionToSOAPMessage(soapResponseMessage);
            } else {
                action = this.createSOAPBody(soapResponseMessage, soapResponse, soapResponse.getSoapAction());
            }
            if (soapResponse.getHeader() != null) {
                List headers = soapResponse.getHeader();
                for (SoapHeader header : headers) {
                    Encoder encoder;
                    if ("http://www.w3.org/2005/08/addressing".equals(header.getNamespace()) && header instanceof WsaActionHeader) {
                        ((WsaHeader)header).setValue(action);
                    }
                    if ((encoder = this.getEncoder(CodingHelper.getEncoderKey((String)header.getNamespace(), (Object)header), new EncoderKey[0])) == null) continue;
                    Map headerElements = (Map)encoder.encode((Object)header);
                    for (Map.Entry entry : headerElements.entrySet()) {
                        QName qName = (QName)entry.getKey();
                        soapResponseMessage.getSOAPHeader().addChildElement(qName).setTextContent((String)headerElements.get(qName));
                    }
                }
            } else {
                soapResponseMessage.getSOAPHeader().detachNode();
            }
            soapResponseMessage.setProperty("javax.xml.soap.write-xml-declaration", (Object)String.valueOf(true));
            return soapResponseMessage;
        }
        catch (SOAPException soape) {
            throw new EncodingException("Error while encoding SOAPMessage!", (Throwable)soape);
        }
    }

    private void addSchemaLocationForExceptionToSOAPMessage(SOAPMessage soapResponseMessage) throws SOAPException {
        SOAPEnvelope envelope = soapResponseMessage.getSOAPPart().getEnvelope();
        envelope.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        StringBuilder schemaLocation = new StringBuilder();
        schemaLocation.append(envelope.getNamespaceURI());
        schemaLocation.append(" ");
        schemaLocation.append(envelope.getNamespaceURI());
        schemaLocation.append(" ");
        schemaLocation.append(N52XmlHelper.getSchemaLocationForOWS110Exception());
        envelope.addAttribute(N52XmlHelper.getSchemaLocationQNameWithPrefix(), schemaLocation.toString());
    }
}

