/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Joiner;
import eu.europa.ec.inspire.schemas.omso.x30.TrajectoryObservationType;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.opengis.om.x20.OMObservationType;
import net.opengis.waterml.x20.CategoricalTimeseriesDocument;
import net.opengis.waterml.x20.CategoricalTimeseriesType;
import net.opengis.waterml.x20.DefaultCategoricalTVPMetadataType;
import net.opengis.waterml.x20.DefaultTVPCategoricalMetadataDocument;
import net.opengis.waterml.x20.DefaultTVPMeasurementMetadataDocument;
import net.opengis.waterml.x20.MeasurementTimeseriesDocument;
import net.opengis.waterml.x20.MeasurementTimeseriesType;
import net.opengis.waterml.x20.TVPDefaultMetadataPropertyType;
import net.opengis.waterml.x20.TVPMeasurementMetadataType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.shetland.inspire.omso.TrajectoryObservation;
import org.n52.shetland.ogc.om.AbstractObservationValue;
import org.n52.shetland.ogc.om.MultiObservationValues;
import org.n52.shetland.ogc.om.ObservationValue;
import org.n52.shetland.ogc.om.OmObservation;
import org.n52.shetland.ogc.om.SingleObservationValue;
import org.n52.shetland.ogc.om.TimeLocationValueTriple;
import org.n52.shetland.ogc.om.values.CategoryValue;
import org.n52.shetland.ogc.om.values.CountValue;
import org.n52.shetland.ogc.om.values.QuantityValue;
import org.n52.shetland.ogc.om.values.TLVTValue;
import org.n52.shetland.util.JavaHelper;
import org.n52.svalbard.encode.AbstractOmInspireEncoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.util.CodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrajectoryObservationTypeEncoder
extends AbstractOmInspireEncoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrajectoryObservationTypeEncoder.class);
    private static final String TIMESERIES_PREFIX = "timeseries.";
    private static final Set<EncoderKey> ENCODER_KEYS = CodingHelper.encoderKeysForElements((String)"http://inspire.ec.europa.eu/schemas/omso/3.0", (Class[])new Class[]{TrajectoryObservation.class});

    public TrajectoryObservationTypeEncoder() {
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(ENCODER_KEYS));
    }

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEYS);
    }

    @Override
    public XmlObject encode(Object element, EncodingContext ec) throws EncodingException {
        return super.encode(element, ec);
    }

    @Override
    public void encode(Object objectToEncode, OutputStream outputStream, EncodingContext context) throws EncodingException {
        super.encode(objectToEncode, outputStream, context);
    }

    @Override
    protected XmlObject createResult(OmObservation sosObservation) throws EncodingException {
        return this.encodeResult(sosObservation.getValue());
    }

    @Override
    protected XmlObject encodeResult(ObservationValue<?> observationValue) throws EncodingException {
        if (observationValue instanceof SingleObservationValue && observationValue.getValue() instanceof TimeLocationValueTriple) {
            if (observationValue.getValue().getValue() instanceof QuantityValue || observationValue.getValue().getValue() instanceof CountValue) {
                return this.createMeasurementTimeseries((AbstractObservationValue)observationValue);
            }
            if (observationValue.getValue().getValue() instanceof CategoryValue) {
                return this.createCategoricalTimeseries((AbstractObservationValue)observationValue);
            }
        } else if (observationValue instanceof MultiObservationValues && observationValue.getValue() instanceof TLVTValue) {
            TimeLocationValueTriple value = (TimeLocationValueTriple)((TLVTValue)observationValue.getValue()).getValue().iterator().next();
            if (value.getValue() instanceof QuantityValue || value.getValue() instanceof CountValue) {
                return this.createMeasurementTimeseries((AbstractObservationValue)observationValue);
            }
            if (value.getValue() instanceof CategoryValue) {
                return this.createCategoricalTimeseries((AbstractObservationValue)observationValue);
            }
        }
        return null;
    }

    @Override
    protected String getObservationType() {
        return "http://inspire.ec.europa.eu/featureconcept/TrajectoryObservation";
    }

    @Override
    protected OMObservationType createOmObservationType() {
        return TrajectoryObservationType.Factory.newInstance((XmlOptions)this.getXmlOptions());
    }

    private XmlObject createMeasurementTimeseries(AbstractObservationValue<?> observationValue) throws EncodingException {
        MultiObservationValues multiObservationValue;
        MeasurementTimeseriesDocument measurementTimeseriesDoc = MeasurementTimeseriesDocument.Factory.newInstance();
        MeasurementTimeseriesType measurementTimeseries = measurementTimeseriesDoc.addNewMeasurementTimeseries();
        if (!observationValue.isSetObservationID()) {
            observationValue.setObservationID(JavaHelper.generateID((String)observationValue.toString()));
        }
        measurementTimeseries.setId(TIMESERIES_PREFIX + observationValue.getObservationID());
        measurementTimeseries.addNewMetadata().addNewTimeseriesMetadata().addNewTemporalExtent().setHref("#" + observationValue.getPhenomenonTime().getGmlId());
        TVPDefaultMetadataPropertyType xbMetaComponent = measurementTimeseries.addNewDefaultPointMetadata();
        DefaultTVPMeasurementMetadataDocument xbDefMeasureMetaComponent = DefaultTVPMeasurementMetadataDocument.Factory.newInstance();
        TVPMeasurementMetadataType defaultTVPMeasurementMetadata = xbDefMeasureMetaComponent.addNewDefaultTVPMeasurementMetadata();
        defaultTVPMeasurementMetadata.addNewInterpolationType().setHref("http://www.opengis.net/def/timeseriesType/WaterML/2.0/continuous");
        xbDefMeasureMetaComponent.getDefaultTVPMeasurementMetadata().getInterpolationType().setTitle("Instantaneous");
        String unit = null;
        if (observationValue instanceof SingleObservationValue) {
            SingleObservationValue singleObservationValue = (SingleObservationValue)observationValue;
            unit = singleObservationValue.getValue().getUnit();
            if (observationValue.getValue() instanceof TimeLocationValueTriple) {
                measurementTimeseries.addNewPoint().addNewMeasurementTVP().set(this.encodeTLVT((TimeLocationValueTriple)observationValue.getValue()));
            }
        } else if (observationValue instanceof MultiObservationValues && (multiObservationValue = (MultiObservationValues)observationValue).getValue() instanceof TLVTValue) {
            TLVTValue tlvtValue = (TLVTValue)multiObservationValue.getValue();
            List timeLocationValueTriples = tlvtValue.getValue();
            unit = tlvtValue.getUnit();
            int counter = 0;
            for (TimeLocationValueTriple timeLocationValueTriple : timeLocationValueTriples) {
                timeLocationValueTriple.getLocation().setUserData((Object)this.getUserObject(observationValue.getObservationID(), counter));
                measurementTimeseries.addNewPoint().addNewMeasurementTVP().set(this.encodeTLVT(timeLocationValueTriple));
                ++counter;
            }
        }
        if (unit != null && !unit.isEmpty()) {
            defaultTVPMeasurementMetadata.addNewUom().setCode(unit);
        }
        xbMetaComponent.set((XmlObject)xbDefMeasureMetaComponent);
        return measurementTimeseriesDoc;
    }

    private XmlObject encodeTLVT(TimeLocationValueTriple value) throws EncodingException {
        return this.encodeInspireOMSO(value);
    }

    private XmlObject createCategoricalTimeseries(AbstractObservationValue<?> observationValue) throws EncodingException {
        MultiObservationValues multiObservationValue;
        CategoricalTimeseriesDocument categoricalTimeseriesDoc = CategoricalTimeseriesDocument.Factory.newInstance();
        CategoricalTimeseriesType categoricalTimeseries = categoricalTimeseriesDoc.addNewCategoricalTimeseries();
        categoricalTimeseries.setId(TIMESERIES_PREFIX + observationValue.getObservationID());
        categoricalTimeseries.addNewMetadata().addNewTimeseriesMetadata().addNewTemporalExtent().setHref("#" + observationValue.getPhenomenonTime().getGmlId());
        TVPDefaultMetadataPropertyType xbMetaComponent = categoricalTimeseries.addNewDefaultPointMetadata();
        DefaultTVPCategoricalMetadataDocument xbDefCateMetaComponent = DefaultTVPCategoricalMetadataDocument.Factory.newInstance();
        DefaultCategoricalTVPMetadataType defaultTVPCateMetadata = xbDefCateMetaComponent.addNewDefaultTVPCategoricalMetadata();
        String unit = null;
        if (observationValue instanceof SingleObservationValue) {
            SingleObservationValue singleObservationValue = (SingleObservationValue)observationValue;
            unit = singleObservationValue.getValue().getUnit();
            if (observationValue.getValue() instanceof TimeLocationValueTriple) {
                categoricalTimeseries.addNewPoint().addNewCategoricalTVP().set(this.encodeTLVT((TimeLocationValueTriple)observationValue.getValue()));
            }
        } else if (observationValue instanceof MultiObservationValues && (multiObservationValue = (MultiObservationValues)observationValue).getValue() instanceof TLVTValue) {
            TLVTValue tlvtValue = (TLVTValue)multiObservationValue.getValue();
            List timeLocationValueTriples = tlvtValue.getValue();
            unit = tlvtValue.getUnit();
            int counter = 0;
            for (TimeLocationValueTriple timeLocationValueTriple : timeLocationValueTriples) {
                timeLocationValueTriple.getLocation().setUserData((Object)this.getUserObject(observationValue.getObservationID(), counter));
                categoricalTimeseries.addNewPoint().addNewCategoricalTVP().set(this.encodeTLVT(timeLocationValueTriple));
                ++counter;
            }
        }
        if (unit != null && !unit.isEmpty()) {
            defaultTVPCateMetadata.setCodeSpace(unit);
        }
        xbMetaComponent.set((XmlObject)xbDefCateMetaComponent);
        return categoricalTimeseriesDoc;
    }

    private EncodingContext getUserObject(String observationID, int counter) {
        return EncodingContext.of((Enum)XmlBeansEncodingFlags.GMLID, (Object)(observationID + "_" + counter));
    }

    protected XmlObject encodeInspireOMSO(Object o) throws EncodingException {
        return this.encodeObjectToXml("http://inspire.ec.europa.eu/schemas/omso/3.0", o);
    }

    protected XmlObject encodeInspireOMSO(Object o, EncodingContext ec) throws EncodingException {
        return this.encodeObjectToXml("http://inspire.ec.europa.eu/schemas/omso/3.0", o, ec);
    }
}

