/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.Set;
import net.opengis.gml.x32.FeaturePropertyType;
import net.opengis.sos.x20.GetFeatureOfInterestResponseDocument;
import net.opengis.sos.x20.GetFeatureOfInterestResponseType;
import net.opengis.swes.x20.ExtensibleResponseType;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.om.features.FeatureCollection;
import org.n52.shetland.ogc.ows.extension.Extensions;
import org.n52.shetland.ogc.ows.service.OwsServiceResponse;
import org.n52.shetland.ogc.sos.response.GetFeatureOfInterestResponse;
import org.n52.shetland.util.CollectionHelper;
import org.n52.svalbard.decode.AbstractXmlDecoder;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.SosResponseDecoder;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetFeatureOfInterestResponseDocumentDecoder
extends AbstractXmlDecoder<GetFeatureOfInterestResponseDocument, GetFeatureOfInterestResponse>
implements SosResponseDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetFeatureOfInterestResponseDocumentDecoder.class);
    private static final Set<DecoderKey> DECODER_KEYS = CodingHelper.decoderKeysForElements((String)"http://www.opengis.net/sos/2.0", (Class[])new Class[]{GetFeatureOfInterestResponseDocument.class});

    public GetFeatureOfInterestResponseDocumentDecoder() {
        LOGGER.debug("Decoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(DECODER_KEYS));
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
    public GetFeatureOfInterestResponse decode(GetFeatureOfInterestResponseDocument gfoird) throws DecodingException {
        if (gfoird != null) {
            GetFeatureOfInterestResponse response = new GetFeatureOfInterestResponse();
            this.setService((OwsServiceResponse)response);
            this.setVersions((OwsServiceResponse)response);
            GetFeatureOfInterestResponseType gfoirt = gfoird.getGetFeatureOfInterestResponse();
            response.setExtensions((Extensions)this.parseExtensibleResponse((ExtensibleResponseType)gfoirt));
            response.setAbstractFeature(this.parseFeatures(gfoirt));
            return response;
        }
        throw new UnsupportedDecoderInputException((Decoder)this, (Object)gfoird);
    }

    private AbstractFeature parseFeatures(GetFeatureOfInterestResponseType gfoirt) throws DecodingException {
        if (CollectionHelper.isNotNullOrEmpty((Object[])gfoirt.getFeatureMemberArray())) {
            if (gfoirt.getFeatureMemberArray().length == 1) {
                return (AbstractFeature)this.decodeXmlObject((XmlObject)gfoirt.getFeatureMemberArray()[0]);
            }
            FeatureCollection featureCollection = new FeatureCollection();
            for (FeaturePropertyType fpt : gfoirt.getFeatureMemberArray()) {
                featureCollection.addMember((AbstractFeature)this.decodeXmlObject((XmlObject)fpt));
            }
            return featureCollection;
        }
        return null;
    }
}

