/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.Set;
import net.opengis.ogc.BBOXType;
import net.opengis.ogc.BinarySpatialOpType;
import net.opengis.ogc.BinaryTemporalOpType;
import net.opengis.ogc.PropertyNameDocument;
import net.opengis.ogc.PropertyNameType;
import net.opengis.ogc.SpatialOperatorType;
import net.opengis.ogc.TemporalOperatorType;
import net.opengis.ogc.impl.BBOXTypeImpl;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.locationtech.jts.geom.Geometry;
import org.n52.shetland.ogc.filter.FilterConstants;
import org.n52.shetland.ogc.filter.SpatialFilter;
import org.n52.shetland.ogc.filter.TemporalFilter;
import org.n52.shetland.ogc.gml.GmlConstants;
import org.n52.shetland.ogc.gml.time.Time;
import org.n52.shetland.ogc.gml.time.TimeInstant;
import org.n52.shetland.ogc.gml.time.TimePeriod;
import org.n52.shetland.ogc.sos.Sos1Constants;
import org.n52.svalbard.decode.AbstractXmlDecoder;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderXmlInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OgcDecoderv100
extends AbstractXmlDecoder<XmlObject, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OgcDecoderv100.class);
    private static final Set<DecoderKey> DECODER_KEYS = CodingHelper.decoderKeysForElements((String)"http://www.opengis.net/ogc", (Class[])new Class[]{SpatialOperatorType.class, TemporalOperatorType.class, BinarySpatialOpType.class, BinaryTemporalOpType.class, BBOXType.class, PropertyNameDocument.class});

    public OgcDecoderv100() {
        LOGGER.debug("Decoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(DECODER_KEYS));
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    public Object decode(XmlObject xmlObject) throws DecodingException {
        if (xmlObject instanceof BinaryTemporalOpType) {
            return this.parseTemporalOperatorType((BinaryTemporalOpType)xmlObject);
        }
        if (xmlObject instanceof TemporalOperatorType) {
            throw OgcDecoderv100.unsupportedTemporalFilterOperand();
        }
        if (xmlObject instanceof PropertyNameDocument) {
            PropertyNameDocument xbPropertyNameDoc = (PropertyNameDocument)xmlObject;
            return xbPropertyNameDoc.getPropertyName();
        }
        if (xmlObject instanceof BinarySpatialOpType) {
            return this.parseSpatialOperatorType((BinarySpatialOpType)xmlObject);
        }
        if (xmlObject instanceof BBOXType) {
            return this.parseBBOXFilterType((BBOXTypeImpl)xmlObject);
        }
        if (xmlObject instanceof BBOXTypeImpl) {
            return this.parseBBOXFilterType((BBOXTypeImpl)xmlObject);
        }
        throw new UnsupportedDecoderXmlInputException((Decoder<?, ?>)this, xmlObject);
    }

    private Object parseTemporalOperatorType(BinaryTemporalOpType xbBinaryTemporalOp) throws DecodingException {
        TemporalFilter temporalFilter = new TemporalFilter();
        String valueRef = "phenomenonTime";
        try {
            NodeList nodes = xbBinaryTemporalOp.getDomNode().getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                FilterConstants.TimeOperator operator;
                if (nodes.item(i).getNamespaceURI() == null || nodes.item(i).getLocalName().equals("ValueReference")) continue;
                Object timeObject = this.decodeXmlElement(XmlObject.Factory.parse((Node)nodes.item(i)));
                if (timeObject instanceof PropertyNameType) {
                    PropertyNameType propertyNameType = (PropertyNameType)timeObject;
                }
                if (!(timeObject instanceof Time)) continue;
                Time time = (Time)timeObject;
                String localName = XmlHelper.getLocalName((XmlObject)xbBinaryTemporalOp);
                if (localName.equals(FilterConstants.TimeOperator.TM_During.name()) && time instanceof TimePeriod) {
                    operator = FilterConstants.TimeOperator.TM_During;
                } else if (localName.equals(FilterConstants.TimeOperator.TM_Equals.name()) && time instanceof TimeInstant) {
                    operator = FilterConstants.TimeOperator.TM_Equals;
                } else if (localName.equals(FilterConstants.TimeOperator.TM_After.name()) && time instanceof TimeInstant) {
                    operator = FilterConstants.TimeOperator.TM_After;
                } else if (localName.equals(FilterConstants.TimeOperator.TM_Before.name()) && time instanceof TimeInstant) {
                    operator = FilterConstants.TimeOperator.TM_Before;
                } else {
                    throw OgcDecoderv100.unsupportedTemporalFilterOperand();
                }
                temporalFilter.setOperator(operator);
                temporalFilter.setTime(time);
                temporalFilter.setValueReference(valueRef);
                break;
            }
        }
        catch (XmlException xmle) {
            throw new DecodingException("Error while parsing temporal filter!", (Throwable)xmle);
        }
        return temporalFilter;
    }

    private SpatialFilter parseBBOXFilterType(BBOXTypeImpl xbBBOX) throws DecodingException {
        SpatialFilter spatialFilter = new SpatialFilter();
        String valueRef = "om:featureOfInterest/sams:SF_SpatialSamplingFeature/sams:shape";
        try {
            spatialFilter.setOperator(FilterConstants.SpatialOperator.BBOX);
            XmlCursor geometryCursor = xbBBOX.newCursor();
            if (geometryCursor.toChild(GmlConstants.QN_ENVELOPE)) {
                Object sosGeometry = this.decodeXmlElement(XmlObject.Factory.parse((Node)geometryCursor.getDomNode()));
                if (sosGeometry instanceof Geometry) {
                    spatialFilter.setGeometry((Geometry)sosGeometry);
                    spatialFilter.setValueReference(valueRef);
                }
            } else {
                throw OgcDecoderv100.unsupportedSpatialFilterOperand();
            }
            geometryCursor.dispose();
        }
        catch (XmlException xmle) {
            throw OgcDecoderv100.errorParsingSpatialFilter(xmle);
        }
        return spatialFilter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object parseSpatialOperatorType(BinarySpatialOpType xbSpatialOpsType) throws DecodingException {
        SpatialFilter spatialFilter = new SpatialFilter();
        try {
            if (!(xbSpatialOpsType instanceof BBOXTypeImpl)) throw OgcDecoderv100.unsupportedSpatialFilter();
            spatialFilter.setOperator(FilterConstants.SpatialOperator.BBOX);
            BBOXTypeImpl xbBBOX = (BBOXTypeImpl)xbSpatialOpsType;
            spatialFilter.setOperator(FilterConstants.SpatialOperator.BBOX);
            XmlCursor geometryCursor = xbBBOX.newCursor();
            if (!geometryCursor.toChild(GmlConstants.QN_ENVELOPE)) throw OgcDecoderv100.unsupportedSpatialFilter();
            Object sosGeometry = this.decodeXmlElement(XmlObject.Factory.parse((Node)geometryCursor.getDomNode()));
            if (sosGeometry instanceof Geometry) {
                spatialFilter.setGeometry((Geometry)sosGeometry);
            }
            geometryCursor.dispose();
            return spatialFilter;
        }
        catch (XmlException xmle) {
            throw OgcDecoderv100.errorParsingSpatialFilter(xmle);
        }
    }

    private static DecodingException unsupportedSpatialFilterOperand() {
        return new DecodingException("The requested spatial filter operand is not supported by this SOS!", new Object[0]);
    }

    private static DecodingException unsupportedSpatialFilter() {
        return new DecodingException("The requested spatial filter is not supported by this SOS!", new Object[0]);
    }

    private static DecodingException errorParsingSpatialFilter(XmlException xmle) {
        return new DecodingException("Error while parsing spatial filter!", (Throwable)xmle);
    }

    private static DecodingException unsupportedTemporalFilterOperand() {
        return new DecodingException((Enum)Sos1Constants.GetObservationParams.eventTime, "The requested temporal filter operand is not supported by this SOS!", new Object[0]);
    }
}

