/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import net.opengis.gml.x32.AbstractGMLType;
import net.opengis.gml.x32.FeaturePropertyType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gml.AbstractGML;
import org.n52.shetland.ogc.gml.CodeType;
import org.n52.shetland.ogc.gml.FeatureWith;
import org.n52.shetland.util.CollectionHelper;
import org.n52.svalbard.encode.AbstractXmlEncoder;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.exception.EncodingException;

public abstract class AbstractGmlEncoderv321<T, S>
extends AbstractXmlEncoder<T, S> {
    protected XmlObject createFeaturePropertyTypeFrom(AbstractFeature abstractFeature, EncodingContext context) throws EncodingException {
        FeaturePropertyType featurePropertyType = this.createFeaturePropertyType();
        if (context.has((Enum)XmlBeansEncodingFlags.REFERENCED) && context.getBoolean((Enum)XmlBeansEncodingFlags.REFERENCED)) {
            featurePropertyType.setHref(abstractFeature.getIdentifierCodeWithAuthority().getValue());
            return featurePropertyType;
        }
        if (abstractFeature.isSetGmlID()) {
            featurePropertyType.setHref("#" + abstractFeature.getGmlId());
            return featurePropertyType;
        }
        if (context.has((Enum)XmlBeansEncodingFlags.ENCODE) && !context.getBoolean((Enum)XmlBeansEncodingFlags.ENCODE) || abstractFeature instanceof FeatureWith.FeatureWithEncode && !((FeatureWith.FeatureWithEncode)abstractFeature).isEncode()) {
            featurePropertyType.setHref(abstractFeature.getIdentifierCodeWithAuthority().getValue());
            if (abstractFeature.isSetName()) {
                featurePropertyType.setTitle(abstractFeature.getFirstName().getValue());
            }
            return featurePropertyType;
        }
        if (abstractFeature instanceof FeatureWith.FeatureWithGeometry && !((FeatureWith.FeatureWithGeometry)abstractFeature).isSetGeometry()) {
            featurePropertyType.setHref(abstractFeature.getIdentifierCodeWithAuthority().getValue());
            if (abstractFeature.isSetName()) {
                featurePropertyType.setTitle(abstractFeature.getFirstName().getValue());
            }
            return featurePropertyType;
        }
        if (abstractFeature instanceof FeatureWith.FeatureWithUrl && ((FeatureWith.FeatureWithUrl)abstractFeature).isSetUrl()) {
            featurePropertyType.setHref(((FeatureWith.FeatureWithUrl)abstractFeature).getUrl());
            if (abstractFeature.isSetIdentifier()) {
                featurePropertyType.setTitle(abstractFeature.getIdentifierCodeWithAuthority().getValue());
            } else if (abstractFeature.isSetName()) {
                featurePropertyType.setTitle(abstractFeature.getFirstName().getValue());
            }
            return featurePropertyType;
        }
        return this.createFeature(featurePropertyType, abstractFeature, context);
    }

    protected void addId(AbstractGMLType aft, AbstractFeature abstractFeature) {
        aft.setId(abstractFeature.getGmlId());
    }

    protected boolean addIdentifier(AbstractGMLType aft, AbstractGML abstractFeature) throws EncodingException {
        if (aft != null && abstractFeature != null && abstractFeature.isSetIdentifier()) {
            aft.addNewIdentifier().set(this.encodeObjectToXml("http://www.opengis.net/gml/3.2", abstractFeature.getIdentifierCodeWithAuthority()));
            return true;
        }
        return false;
    }

    protected void addName(AbstractGMLType aft, AbstractGML abstractFeature) throws EncodingException {
        if (aft != null && abstractFeature != null && abstractFeature.isSetName()) {
            this.removeExitingNames(aft);
            for (CodeType codeType : abstractFeature.getName()) {
                aft.addNewName().set(this.encodeObjectToXml("http://www.opengis.net/gml/3.2", codeType));
            }
        }
    }

    protected void addDescription(AbstractGMLType aft, AbstractGML abstractFeature) {
        if (aft != null && abstractFeature != null && abstractFeature.isSetDescription()) {
            if (!aft.isSetDescription()) {
                aft.addNewDescription();
            }
            aft.getDescription().setStringValue(abstractFeature.getDescription());
        }
    }

    protected void removeExitingNames(AbstractGMLType aft) {
        if (CollectionHelper.isNotNullOrEmpty((Object[])aft.getNameArray())) {
            for (int i = 0; i < aft.getNameArray().length; ++i) {
                aft.removeName(i);
            }
        }
    }

    protected FeaturePropertyType createFeaturePropertyType() {
        return FeaturePropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
    }

    protected abstract XmlObject createFeature(FeaturePropertyType var1, AbstractFeature var2, EncodingContext var3) throws EncodingException;
}

