/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.opengis.om.x20.NamedValueDocument;
import net.opengis.om.x20.NamedValuePropertyType;
import net.opengis.om.x20.NamedValueType;
import net.opengis.om.x20.OMObservationDocument;
import net.opengis.om.x20.OMObservationPropertyType;
import net.opengis.om.x20.OMObservationType;
import net.opengis.om.x20.OMProcessPropertyType;
import net.opengis.om.x20.ObservationContextPropertyType;
import net.opengis.om.x20.ObservationContextType;
import net.opengis.om.x20.TimeObjectPropertyType;
import org.apache.xmlbeans.XmlBoolean;
import org.apache.xmlbeans.XmlInteger;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlString;
import org.isotc211.x2005.gmd.AbstractDQElementDocument;
import org.isotc211.x2005.gmd.DQElementPropertyType;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gml.AbstractMetaData;
import org.n52.shetland.ogc.gml.CodeType;
import org.n52.shetland.ogc.gml.time.Time;
import org.n52.shetland.ogc.gml.time.TimeInstant;
import org.n52.shetland.ogc.gml.time.TimePeriod;
import org.n52.shetland.ogc.om.AbstractPhenomenon;
import org.n52.shetland.ogc.om.NamedValue;
import org.n52.shetland.ogc.om.ObservationValue;
import org.n52.shetland.ogc.om.OmObservation;
import org.n52.shetland.ogc.om.OmObservationContext;
import org.n52.shetland.ogc.om.SingleObservationValue;
import org.n52.shetland.ogc.om.quality.OmResultQuality;
import org.n52.shetland.ogc.om.values.BooleanValue;
import org.n52.shetland.ogc.om.values.CategoryValue;
import org.n52.shetland.ogc.om.values.ComplexValue;
import org.n52.shetland.ogc.om.values.CountValue;
import org.n52.shetland.ogc.om.values.CvDiscretePointCoverage;
import org.n52.shetland.ogc.om.values.GeometryValue;
import org.n52.shetland.ogc.om.values.HrefAttributeValue;
import org.n52.shetland.ogc.om.values.MultiPointCoverage;
import org.n52.shetland.ogc.om.values.NilTemplateValue;
import org.n52.shetland.ogc.om.values.ProfileValue;
import org.n52.shetland.ogc.om.values.QuantityRangeValue;
import org.n52.shetland.ogc.om.values.QuantityValue;
import org.n52.shetland.ogc.om.values.RectifiedGridCoverage;
import org.n52.shetland.ogc.om.values.ReferenceValue;
import org.n52.shetland.ogc.om.values.SweDataArrayValue;
import org.n52.shetland.ogc.om.values.TLVTValue;
import org.n52.shetland.ogc.om.values.TVPValue;
import org.n52.shetland.ogc.om.values.TextValue;
import org.n52.shetland.ogc.om.values.TimeRangeValue;
import org.n52.shetland.ogc.om.values.UnknownValue;
import org.n52.shetland.ogc.om.values.Value;
import org.n52.shetland.ogc.om.values.XmlValue;
import org.n52.shetland.ogc.om.values.visitor.ValueVisitor;
import org.n52.shetland.ogc.sos.SosProcedureDescription;
import org.n52.shetland.ogc.sos.SosProcedureDescriptionUnknownType;
import org.n52.shetland.util.JavaHelper;
import org.n52.svalbard.encode.AbstractXmlEncoder;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.ObservationEncoder;
import org.n52.svalbard.encode.StreamingEncoder;
import org.n52.svalbard.encode.StreamingEncoderFlags;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.XmlEncoderFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.n52.svalbard.util.GmlHelper;
import org.n52.svalbard.util.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOmEncoderv20
extends AbstractXmlEncoder<XmlObject, Object>
implements ObservationEncoder<XmlObject, Object>,
StreamingEncoder<XmlObject, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractOmEncoderv20.class);
    private static final String OBSERVATION_ID_PREFIX = "o_";

    protected abstract XmlObject createResult(OmObservation var1) throws EncodingException;

    protected abstract XmlObject encodeResult(ObservationValue<?> var1) throws EncodingException;

    protected abstract void addObservationType(OMObservationType var1, String var2);

    public abstract String getDefaultFeatureEncodingNamespace();

    protected abstract String getDefaultProcedureEncodingNamspace();

    protected abstract boolean convertEncodedProcedure();

    protected abstract OMObservationType createOmObservationType();

    protected abstract void addAddtitionalInformation(OMObservationType var1, OmObservation var2) throws EncodingException;

    public XmlObject encode(Object element, EncodingContext additionalValues) throws EncodingException {
        XmlObject encodedObject = null;
        if (element instanceof OmObservation) {
            encodedObject = this.encodeOmObservation((OmObservation)element, additionalValues);
        } else if (element instanceof NamedValue) {
            NamedValueType nvt = this.createNamedValue((NamedValue)element);
            if (additionalValues.has((Enum)XmlBeansEncodingFlags.DOCUMENT)) {
                NamedValueDocument nvd = NamedValueDocument.Factory.newInstance();
                nvd.setNamedValue(nvt);
                encodedObject = nvd;
            } else if (additionalValues.has((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE)) {
                NamedValuePropertyType nvpt = NamedValuePropertyType.Factory.newInstance();
                nvpt.setNamedValue(nvt);
                encodedObject = nvpt;
            } else {
                encodedObject = nvt;
            }
        } else if (element instanceof AbstractFeature) {
            encodedObject = this.encodeFeatureOfInterest((AbstractFeature)element);
        } else if (element instanceof SosProcedureDescription) {
            encodedObject = this.encodeProcedureDescription((SosProcedureDescription)element);
        } else {
            throw new UnsupportedEncoderInputException((Encoder)this, element);
        }
        return encodedObject;
    }

    public void encode(Object objectToEncode, OutputStream outputStream, EncodingContext ctx) throws EncodingException {
        try {
            XmlOptions xmlOptions = this.getXmlOptions();
            if (ctx.has((Enum)StreamingEncoderFlags.EMBEDDED)) {
                xmlOptions.setSaveNoXmlDecl();
            }
            this.encode(objectToEncode, ctx.with((Enum)StreamingEncoderFlags.ENCODER, (Object)this)).save(outputStream, xmlOptions);
        }
        catch (IOException ioe) {
            throw new EncodingException("Error while writing element to stream!", (Throwable)ioe);
        }
        finally {
            if (ctx.has((Enum)StreamingEncoderFlags.EMBEDDED)) {
                this.getXmlOptions().remove((Object)"SAVE_NO_XML_DECL");
            }
        }
    }

    public void addNamespacePrefixToMap(Map<String, String> nameSpacePrefixMap) {
        nameSpacePrefixMap.put("http://www.opengis.net/om/2.0", "om");
    }

    protected XmlObject encodeOmObservation(OmObservation sosObservation, EncodingContext context) throws EncodingException {
        OMObservationType xbObservation = this.createOmObservationType();
        if (!sosObservation.isSetObservationID()) {
            sosObservation.setObservationID(JavaHelper.generateID((String)Double.toString((double)System.currentTimeMillis() * Math.random())));
        }
        String observationID = sosObservation.getObservationID();
        if (!sosObservation.isSetGmlID()) {
            sosObservation.setGmlId(OBSERVATION_ID_PREFIX + observationID);
        }
        xbObservation.setId(AbstractOmEncoderv20.generateObservationGMLId());
        if (!sosObservation.isSetObservationID()) {
            sosObservation.setObservationID(xbObservation.getId().replace(OBSERVATION_ID_PREFIX, ""));
        }
        this.setObservationIdentifier(sosObservation, xbObservation);
        this.setObservationName(sosObservation, xbObservation);
        this.setDescription(sosObservation, xbObservation);
        this.setMetaDataProperty(sosObservation, xbObservation);
        this.setObservationType(sosObservation, xbObservation);
        this.setRelatedObservations(sosObservation, xbObservation);
        this.setPhenomenonTime(sosObservation, xbObservation);
        this.setResultTime(sosObservation, xbObservation);
        this.setValidTime(sosObservation, xbObservation);
        this.setProcedure(sosObservation, xbObservation);
        this.setParameter(sosObservation, xbObservation);
        this.setObservableProperty(sosObservation, xbObservation);
        this.setFeatureOfInterest(sosObservation, xbObservation);
        this.setResultQualities(xbObservation, sosObservation);
        this.setResult(sosObservation, xbObservation);
        this.addAddtitionalInformation(xbObservation, sosObservation);
        if (context.has((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE)) {
            return this.createObservationPropertyType(xbObservation);
        }
        if (context.has((Enum)XmlBeansEncodingFlags.DOCUMENT)) {
            return this.createObservationDocument(xbObservation);
        }
        return xbObservation;
    }

    private XmlObject createObservationDocument(OMObservationType xbObservation) {
        OMObservationDocument doc = this.createObservationDocument();
        doc.setOMObservation(xbObservation);
        return doc;
    }

    private OMObservationDocument createObservationDocument() {
        return OMObservationDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
    }

    private XmlObject createObservationPropertyType(OMObservationType obs) {
        OMObservationPropertyType opt = this.createObservationPropertyType();
        opt.setOMObservation(obs);
        return opt;
    }

    private OMObservationPropertyType createObservationPropertyType() {
        return OMObservationPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
    }

    private void setDescription(OmObservation observation, OMObservationType xb) {
        if (observation.isSetDescription()) {
            xb.addNewDescription().setStringValue(observation.getDescription());
        }
    }

    private void setResult(OmObservation observation, OMObservationType xb) throws EncodingException {
        XmlObject result = this.createResult(observation);
        if (result != null) {
            xb.addNewResult().set(result);
        } else {
            xb.addNewResult();
        }
    }

    private void setFeatureOfInterest(OmObservation observation, OMObservationType xb) throws EncodingException {
        AbstractFeature foi = observation.getObservationConstellation().getFeatureOfInterest();
        XmlObject xbFoi = this.encodeFeatureOfInterest(foi);
        xb.addNewFeatureOfInterest().set(xbFoi);
    }

    private void setObservationIdentifier(OmObservation observation, OMObservationType xb) throws EncodingException {
        if (observation.isSetIdentifier()) {
            XmlObject xbId = this.encodeGML(observation.getIdentifierCodeWithAuthority());
            xb.addNewIdentifier().set(xbId);
        }
    }

    private void setObservationName(OmObservation observation, OMObservationType xb) throws EncodingException {
        if (observation.isSetIdentifier()) {
            for (CodeType name : observation.getName()) {
                XmlObject xbId = this.encodeGML(name);
                xb.addNewName().set(xbId);
            }
        }
    }

    private void setMetaDataProperty(OmObservation sosObservation, OMObservationType xbObservation) throws EncodingException {
        if (sosObservation.isSetMetaDataProperty()) {
            for (AbstractMetaData abstractMetaData : sosObservation.getMetaDataProperty()) {
                XmlObject encodeObject = this.encodeGML(abstractMetaData);
                XmlObject substituteElement = XmlHelper.substituteElement((XmlObject)xbObservation.addNewMetaDataProperty().addNewAbstractMetaData(), (XmlObject)encodeObject);
                substituteElement.set(encodeObject);
            }
        }
    }

    protected void setObservationType(OmObservation observation, OMObservationType xb) {
        this.addObservationType(xb, observation.getObservationConstellation().getObservationType());
    }

    private void setRelatedObservations(OmObservation sosObservation, OMObservationType omot) throws EncodingException {
        if (sosObservation.isSetRelatedObservations()) {
            for (OmObservationContext observationContext : sosObservation.getRelatedObservations()) {
                this.addRelatedObservation(omot.addNewRelatedObservation(), observationContext);
            }
        }
    }

    private void addRelatedObservation(ObservationContextPropertyType ocpt, OmObservationContext observationContext) throws EncodingException {
        ObservationContextType oct = ocpt.addNewObservationContext();
        oct.addNewRole().set(this.encodeGML(observationContext.getRole()));
        oct.addNewRelatedObservation().set(this.encodeGML(observationContext.getRelatedObservation()));
    }

    private void setPhenomenonTime(OmObservation observation, OMObservationType xb) throws EncodingException {
        Time phenomenonTime = observation.getPhenomenonTime();
        if (phenomenonTime.getGmlId() == null) {
            phenomenonTime.setGmlId("phenomenonTime_" + observation.getObservationID());
        }
        this.addPhenomenonTime(xb.addNewPhenomenonTime(), phenomenonTime);
    }

    private void setResultTime(OmObservation observation, OMObservationType xb) throws EncodingException {
        this.addResultTime(xb, observation);
    }

    private void setProcedure(OmObservation observation, OMObservationType xb) throws EncodingException {
        this.addProcedure(xb.addNewProcedure(), observation.getObservationConstellation().getProcedure());
    }

    private void setParameter(OmObservation observation, OMObservationType xb) throws EncodingException {
        if (observation.isSetParameter()) {
            this.addParameter(xb, observation.getParameter());
        }
    }

    private void setObservableProperty(OmObservation observation, OMObservationType xb) {
        AbstractPhenomenon observableProperty = observation.getObservationConstellation().getObservableProperty();
        xb.addNewObservedProperty().setHref(observableProperty.getIdentifier());
        if (observableProperty.isSetName()) {
            xb.getObservedProperty().setTitle(observableProperty.getFirstName().getValue());
        }
        if (observableProperty.isSetName() && observableProperty.getFirstName().isSetValue()) {
            xb.getObservedProperty().setTitle(observableProperty.getFirstName().getValue());
        }
    }

    private XmlObject encodeProcedureDescription(SosProcedureDescription<?> procedureDescription) throws EncodingException {
        OMProcessPropertyType procedure = OMProcessPropertyType.Factory.newInstance();
        this.addProcedure(procedure, (AbstractFeature)procedureDescription);
        return procedure;
    }

    private void addProcedure(OMProcessPropertyType procedure, AbstractFeature procedureDescription) throws EncodingException {
        if (!(procedureDescription instanceof SosProcedureDescriptionUnknownType)) {
            XmlObject encodedProcedure = procedureDescription instanceof SosProcedureDescription ? this.encodeObjectToXml(procedureDescription.getDefaultElementEncoding(), ((SosProcedureDescription)procedureDescription).getProcedureDescription()) : this.encodeObjectToXmlPropertyType(procedureDescription.getDefaultElementEncoding(), procedureDescription);
            if (encodedProcedure != null) {
                procedure.set(encodedProcedure);
            } else {
                procedure.setHref(procedureDescription.getIdentifier());
            }
        } else {
            procedure.setHref(procedureDescription.getIdentifier());
        }
        if (procedure.isSetHref() && procedureDescription.isSetName() && procedureDescription.getFirstName().isSetValue()) {
            procedure.setTitle(procedureDescription.getFirstName().getValue());
        }
    }

    private void addPhenomenonTime(TimeObjectPropertyType timeObjectPropertyType, Time time) throws EncodingException {
        XmlObject xmlObject = this.encodeGML(time);
        XmlObject substitution = timeObjectPropertyType.addNewAbstractTimeObject().substitute(GmlHelper.getGml321QnameForITime((Time)time), xmlObject.schemaType());
        substitution.set(xmlObject);
    }

    private void addResultTime(OMObservationType xbObs, OmObservation sosObservation) throws EncodingException {
        TimeInstant resultTime = sosObservation.getResultTime();
        Time phenomenonTime = sosObservation.getPhenomenonTime();
        if (sosObservation.getResultTime() != null) {
            if (resultTime.equals((Object)phenomenonTime)) {
                xbObs.addNewResultTime().setHref("#" + phenomenonTime.getGmlId());
            } else {
                this.addResultTime(xbObs, resultTime);
            }
        } else if (phenomenonTime instanceof TimeInstant) {
            xbObs.addNewResultTime().setHref("#" + phenomenonTime.getGmlId());
        } else if (phenomenonTime instanceof TimePeriod) {
            TimeInstant rsTime = new TimeInstant(((TimePeriod)sosObservation.getPhenomenonTime()).getEnd());
            this.addResultTime(xbObs, rsTime);
        }
    }

    private void addResultTime(OMObservationType xbObs, TimeInstant time) throws EncodingException {
        XmlObject xmlObject = this.encodeGML(time);
        xbObs.addNewResultTime().addNewTimeInstant().set(xmlObject);
        XmlObject substitution = xbObs.getResultTime().getTimeInstant().substitute(GmlHelper.getGml321QnameForITime((Time)time), xmlObject.schemaType());
        substitution.set(xmlObject);
    }

    private void setValidTime(OmObservation observation, OMObservationType xb) throws EncodingException {
        TimePeriod validTime = observation.getValidTime();
        if (validTime == null) {
            return;
        }
        if (validTime.getGmlId() == null) {
            validTime.setGmlId("validTime_" + observation.getObservationID());
        }
        xb.addNewValidTime().addNewTimePeriod().set(this.encodeGML(validTime));
    }

    private void addParameter(OMObservationType xbObservation, Collection<NamedValue<?>> parameter) throws EncodingException {
        for (NamedValue<?> namedValue : parameter) {
            xbObservation.addNewParameter().setNamedValue(this.createNamedValue(namedValue));
        }
    }

    private XmlObject encodeFeatureOfInterest(AbstractFeature feature) throws EncodingException {
        String namespace = null;
        namespace = !Strings.isNullOrEmpty((String)this.getDefaultFeatureEncodingNamespace()) ? this.getDefaultFeatureEncodingNamespace() : feature.getDefaultElementEncoding();
        return this.encodeGML(feature, EncodingContext.empty().with((Enum)XmlEncoderFlags.ENCODE_NAMESPACE, (Object)namespace));
    }

    protected NamedValueType createNamedValue(NamedValue<?> sosNamedValue) throws EncodingException {
        XmlObject namedValuePropertyValue = this.getNamedValueValue(sosNamedValue.getValue());
        if (namedValuePropertyValue != null) {
            NamedValueType xbNamedValue = NamedValueType.Factory.newInstance((XmlOptions)this.getXmlOptions());
            XmlObject encodeObjectToXml = this.encodeGML(sosNamedValue.getName());
            xbNamedValue.addNewName().set(encodeObjectToXml);
            xbNamedValue.setValue(namedValuePropertyValue);
            return xbNamedValue;
        }
        return null;
    }

    private XmlObject getNamedValueValue(Value<?> value) throws EncodingException {
        if (value.isSetValue()) {
            return (XmlObject)value.accept((ValueVisitor)new NamedValueValueEncoder());
        }
        return null;
    }

    private void setResultQualities(OMObservationType xbObservation, OmObservation sosObservation) throws EncodingException {
        if (sosObservation.isSetResultQuality()) {
            this.encodeResultQualities(xbObservation, sosObservation.getResultQuality());
        } else if (sosObservation.getValue() instanceof SingleObservationValue) {
            this.encodeResultQualities(xbObservation, ((SingleObservationValue)sosObservation.getValue()).getQualityList());
        }
    }

    private void encodeResultQualities(OMObservationType xbObservation, Set<OmResultQuality> resultQuality) throws EncodingException {
        for (OmResultQuality quality : resultQuality) {
            AbstractDQElementDocument encodedQuality = (AbstractDQElementDocument)this.encodeObjectToXml(null, quality, EncodingContext.of((Enum)XmlBeansEncodingFlags.DOCUMENT));
            DQElementPropertyType addNewResultQuality = xbObservation.addNewResultQuality();
            addNewResultQuality.setAbstractDQElement(encodedQuality.getAbstractDQElement());
            XmlHelper.substituteElement((XmlObject)addNewResultQuality.getAbstractDQElement(), (XmlObject)encodedQuality.getAbstractDQElement());
        }
    }

    protected XmlObject encodeXLINK(Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.w3.org/1999/xlink", o);
    }

    protected XmlObject encodeXLINK(Object o, EncodingContext context) throws EncodingException {
        return this.encodeObjectToXml("http://www.w3.org/1999/xlink", o, context);
    }

    protected XmlObject encodeGML(Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/gml/3.2", o);
    }

    protected XmlObject encodeGML(Object o, EncodingContext context) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/gml/3.2", o, context);
    }

    protected XmlObject encodeSweCommon(Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/swe/2.0", o);
    }

    protected XmlObject encodeSweCommon(Object o, EncodingContext context) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/swe/2.0", o, context);
    }

    protected XmlObject encodeGWML(Object o) throws EncodingException {
        return this.encodeGWML(o, EncodingContext.empty());
    }

    protected XmlObject encodeGWML(Object o, EncodingContext context) throws EncodingException {
        return this.encodeObjectToXmlPropertyType("http://www.opengis.net/gwml/2.2", o, context);
    }

    private static String generateObservationGMLId() {
        return OBSERVATION_ID_PREFIX + JavaHelper.generateID((String)Double.toString((double)System.currentTimeMillis() * Math.random()));
    }

    private class NamedValueValueEncoder
    implements ValueVisitor<XmlObject, EncodingException> {
        private NamedValueValueEncoder() {
        }

        public XmlObject visit(BooleanValue value) {
            XmlBoolean xbBoolean = XmlBoolean.Factory.newInstance();
            xbBoolean.setBooleanValue(value.getValue().booleanValue());
            return xbBoolean;
        }

        public XmlObject visit(CategoryValue value) throws EncodingException {
            return AbstractOmEncoderv20.this.encodeGML(value, this.createHelperValues((Value<?>)value));
        }

        public XmlObject visit(ComplexValue value) {
            return this.defaultValue((Value<?>)value);
        }

        public XmlObject visit(CountValue value) {
            XmlInteger xmlInteger = XmlInteger.Factory.newInstance();
            xmlInteger.setStringValue(value.getValue().toString());
            return xmlInteger;
        }

        public XmlObject visit(GeometryValue value) throws EncodingException {
            return AbstractOmEncoderv20.this.encodeGML(value, this.createHelperValues((Value<?>)value));
        }

        public XmlObject visit(HrefAttributeValue value) throws EncodingException {
            return AbstractOmEncoderv20.this.encodeXLINK(value.getValue(), this.createHelperValues((Value<?>)value));
        }

        public XmlObject visit(NilTemplateValue value) {
            return this.defaultValue((Value<?>)value);
        }

        public XmlObject visit(QuantityValue value) throws EncodingException {
            return AbstractOmEncoderv20.this.encodeGML(value, this.createHelperValues((Value<?>)value));
        }

        public XmlObject visit(QuantityRangeValue value) throws EncodingException {
            return this.defaultValue((Value<?>)value);
        }

        public XmlObject visit(ReferenceValue value) throws EncodingException {
            return AbstractOmEncoderv20.this.encodeGML(value.getValue(), this.createHelperValues((Value<?>)value));
        }

        public XmlObject visit(SweDataArrayValue value) {
            return this.defaultValue((Value<?>)value);
        }

        public XmlObject visit(TVPValue value) {
            return this.defaultValue((Value<?>)value);
        }

        public XmlObject visit(TextValue value) {
            XmlString xmlString = XmlString.Factory.newInstance();
            xmlString.setStringValue(value.getValue());
            return xmlString;
        }

        public XmlObject visit(UnknownValue value) {
            return this.defaultValue((Value<?>)value);
        }

        public XmlObject visit(TLVTValue value) throws EncodingException {
            return this.defaultValue((Value<?>)value);
        }

        public XmlObject visit(CvDiscretePointCoverage value) throws EncodingException {
            return this.defaultValue((Value<?>)value);
        }

        public XmlObject visit(MultiPointCoverage value) throws EncodingException {
            return this.defaultValue((Value<?>)value);
        }

        public XmlObject visit(RectifiedGridCoverage value) throws EncodingException {
            return this.defaultValue((Value<?>)value);
        }

        public XmlObject visit(ProfileValue value) throws EncodingException {
            return this.defaultValue((Value<?>)value);
        }

        public XmlObject visit(TimeRangeValue value) throws EncodingException {
            return AbstractOmEncoderv20.this.encodeObjectToXml("http://www.opengis.net/swe/2.0", value, EncodingContext.of((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE));
        }

        public XmlObject visit(XmlValue<?> value) throws EncodingException {
            if (value.getValue() instanceof XmlObject) {
                return (XmlObject)value.getValue();
            }
            return this.defaultValue((Value<?>)value);
        }

        private EncodingContext createHelperValues(Value<?> value) {
            return EncodingContext.of((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE).with((Enum)XmlBeansEncodingFlags.GMLID, (Object)JavaHelper.generateID((String)value.toString()));
        }

        private XmlObject defaultValue(Value<?> value) {
            LOG.warn("Can not encode named value value {}", value);
            return null;
        }
    }
}

