/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import net.opengis.om.x20.OMObservationType;
import net.opengis.waterml.x20.DefaultTVPMeasurementMetadataDocument;
import net.opengis.waterml.x20.MeasureTVPType;
import net.opengis.waterml.x20.MeasurementTimeseriesDocument;
import net.opengis.waterml.x20.MeasurementTimeseriesMetadataType;
import net.opengis.waterml.x20.MeasurementTimeseriesType;
import net.opengis.waterml.x20.TVPDefaultMetadataPropertyType;
import net.opengis.waterml.x20.TVPMeasurementMetadataType;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.ogc.SupportedType;
import org.n52.shetland.ogc.om.AbstractObservationValue;
import org.n52.shetland.ogc.om.MultiObservationValues;
import org.n52.shetland.ogc.om.ObservationType;
import org.n52.shetland.ogc.om.ObservationValue;
import org.n52.shetland.ogc.om.OmObservableProperty;
import org.n52.shetland.ogc.om.OmObservation;
import org.n52.shetland.ogc.om.SingleObservationValue;
import org.n52.shetland.ogc.om.TimeValuePair;
import org.n52.shetland.ogc.om.series.MeasurementTimeseriesMetadata;
import org.n52.shetland.ogc.om.series.TimeseriesMetadata;
import org.n52.shetland.ogc.om.series.wml.WaterMLConstants;
import org.n52.shetland.ogc.om.values.CountValue;
import org.n52.shetland.ogc.om.values.ProfileLevel;
import org.n52.shetland.ogc.om.values.ProfileValue;
import org.n52.shetland.ogc.om.values.QuantityValue;
import org.n52.shetland.ogc.om.values.TVPValue;
import org.n52.shetland.ogc.ows.exception.CodedException;
import org.n52.shetland.ogc.ows.exception.NoApplicableCodeException;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.sos.response.GetObservationResponse;
import org.n52.shetland.util.CollectionHelper;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.AbstractWmlEncoderv20;
import org.n52.svalbard.encode.EncoderFlags;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.XmlEncoderFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.write.WmlTVPEncoderv20XmlStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WmlTVPEncoderv20
extends AbstractWmlEncoderv20 {
    private static final Logger LOGGER = LoggerFactory.getLogger(WmlTVPEncoderv20.class);
    private static final Set<String> CONFORMANCE_CLASSES = Sets.newHashSet((Object[])new String[]{"http://www.opengis.net/spec/waterml/2.0/conf/uml-measurement-timeries-tvp-observation", "http://www.opengis.net/spec/waterml/2.0/conf/uml-timeseries-tvp-observation", "http://www.opengis.net/spec/waterml/2.0/conf/uml-measurement-timeries-tvp-observation", "http://www.opengis.net/spec/waterml/2.0/conf/xsd-xml-rules", "http://www.opengis.net/spec/waterml/2.0/conf/xsd-timeseries-observation", "http://www.opengis.net/spec/waterml/2.0/conf/xsd-timeseries-tvp-observation", "http://www.opengis.net/spec/waterml/2.0/conf/xsd-measurement-timeseries-tvp"});
    private static final ImmutableSet<SupportedType> SUPPORTED_TYPES = ImmutableSet.builder().add((Object)new ObservationType("http://www.opengis.net/def/observationType/waterml/2.0/MeasurementTimeseriesTVPObservation")).build();
    private static final Set<EncoderKey> ENCODER_KEYS = CollectionHelper.union((Set[])new Set[]{WmlTVPEncoderv20.getDefaultEncoderKeys(), CodingHelper.encoderKeysForElements((String)"http://www.opengis.net/waterml/2.0", (Class[])new Class[]{GetObservationResponse.class, OmObservation.class, SingleObservationValue.class, MultiObservationValues.class})});
    private static final Map<String, Map<String, Set<String>>> SUPPORTED_RESPONSE_FORMATS = Collections.singletonMap("SOS", Collections.singletonMap("2.0.0", Collections.singleton("http://www.opengis.net/waterml/2.0")));
    private static final String TIMESERIES_ID_PREFIX = "timeseries.";

    public WmlTVPEncoderv20() {
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(ENCODER_KEYS));
    }

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEYS);
    }

    public Set<SupportedType> getSupportedTypes() {
        return Collections.unmodifiableSet(SUPPORTED_TYPES);
    }

    public Map<String, Set<SupportedType>> getSupportedResponseFormatObservationTypes() {
        return Collections.singletonMap("http://www.opengis.net/waterml/2.0", this.getSupportedTypes());
    }

    public Set<String> getConformanceClasses(String service, String version) {
        if ("SOS".equals(service) && "2.0.0".equals(version)) {
            return Collections.unmodifiableSet(CONFORMANCE_CLASSES);
        }
        return Collections.emptySet();
    }

    public Set<String> getSupportedResponseFormats(String service, String version) {
        return SUPPORTED_RESPONSE_FORMATS.getOrDefault(service, Collections.emptyMap()).getOrDefault(version, Collections.emptySet());
    }

    public Set<SchemaLocation> getSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{WaterMLConstants.WML_20_SCHEMA_LOCATION, WaterMLConstants.WML_20_TS_SCHEMA_LOCATION});
    }

    public boolean supportsResultStreamingForMergedValues() {
        return true;
    }

    @Override
    public XmlObject encode(Object element, EncodingContext additionalValues) throws EncodingException, UnsupportedEncoderInputException {
        if (element instanceof ObservationValue) {
            return this.encodeResult((ObservationValue)element);
        }
        return super.encode(element, additionalValues);
    }

    @Override
    public void encode(Object objectToEncode, OutputStream outputStream, EncodingContext ctx) throws EncodingException {
        if (objectToEncode instanceof OmObservation) {
            try {
                new WmlTVPEncoderv20XmlStreamWriter(ctx.with((Enum)EncoderFlags.ENCODER_REPOSITORY, (Object)this.getEncoderRepository()).with((Enum)XmlEncoderFlags.XML_OPTIONS, this::getXmlOptions), outputStream, (OmObservation)objectToEncode).write();
            }
            catch (XMLStreamException xmlse) {
                throw new EncodingException("Error while writing element to stream!", (Throwable)xmlse);
            }
        } else {
            super.encode(objectToEncode, ctx);
        }
    }

    @Override
    protected XmlObject createResult(OmObservation sosObservation) throws EncodingException {
        try {
            return this.createMeasurementTimeseries(sosObservation);
        }
        catch (OwsExceptionReport ce) {
            throw new EncodingException((Throwable)ce);
        }
    }

    @Override
    protected XmlObject encodeResult(ObservationValue<?> observationValue) throws EncodingException {
        try {
            return this.createMeasurementTimeseries((AbstractObservationValue)observationValue);
        }
        catch (OwsExceptionReport ce) {
            throw new EncodingException((Throwable)ce);
        }
    }

    @Override
    protected void addObservationType(OMObservationType xbObservation, String observationType) {
        if (!Strings.isNullOrEmpty((String)observationType)) {
            if (observationType.equals("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement") || observationType.equals("http://www.opengis.net/def/observationType/waterml/2.0/MeasurementTimeseriesTVPObservation")) {
                xbObservation.addNewType().setHref("http://www.opengis.net/def/observationType/waterml/2.0/MeasurementTimeseriesTVPObservation");
            } else if (observationType.equals("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_CategoryObservation") || observationType.equals("http://www.opengis.net/def/observationType/waterml/2.0/CategoricalTVPTimeseriesObservation")) {
                xbObservation.addNewType().setHref("http://www.opengis.net/def/observationType/waterml/2.0/CategoricalTVPTimeseriesObservation");
            }
        }
    }

    @Override
    protected OMObservationType createOmObservationType() {
        return null;
    }

    private XmlObject createMeasurementTimeseries(OmObservation sosObservation) throws OwsExceptionReport {
        MeasurementTimeseriesDocument measurementTimeseriesDoc = MeasurementTimeseriesDocument.Factory.newInstance();
        MeasurementTimeseriesType measurementTimeseries = measurementTimeseriesDoc.addNewMeasurementTimeseries();
        measurementTimeseries.setId(TIMESERIES_ID_PREFIX + sosObservation.getObservationID());
        MeasurementTimeseriesMetadata timeseriesMetadata = new MeasurementTimeseriesMetadata().setCumulative(false);
        if (sosObservation.isSetValue() && sosObservation.getValue().isSetValue() && sosObservation.getValue().getValue().getClass().isAssignableFrom(TVPValue.class) && sosObservation.getObservationConstellation().isSetMetadata() && sosObservation.getObservationConstellation().getMetadata().isSetTimeseriesMetadata()) {
            timeseriesMetadata = sosObservation.getObservationConstellation().getMetadata().getTimeseriesmetadata();
        }
        this.addTimeseriesMetadata(measurementTimeseries, sosObservation.getPhenomenonTime().getGmlId(), (TimeseriesMetadata)timeseriesMetadata);
        TVPDefaultMetadataPropertyType xbMetaComponent = measurementTimeseries.addNewDefaultPointMetadata();
        DefaultTVPMeasurementMetadataDocument xbDefMeasureMetaComponent = DefaultTVPMeasurementMetadataDocument.Factory.newInstance();
        TVPMeasurementMetadataType defaultTVPMeasurementMetadata = xbDefMeasureMetaComponent.addNewDefaultTVPMeasurementMetadata();
        WaterMLConstants.InterpolationType interpolationType = WaterMLConstants.InterpolationType.Continuous;
        if (sosObservation.isSetValue() && sosObservation.getValue().isSetValue() && sosObservation.getObservationConstellation().isSetDefaultPointMetadata() && sosObservation.getObservationConstellation().getDefaultPointMetadata().isSetDefaultTVPMeasurementMetadata() && sosObservation.getObservationConstellation().getDefaultPointMetadata().getDefaultTVPMeasurementMetadata().isSetInterpolationType()) {
            interpolationType = (WaterMLConstants.InterpolationType)sosObservation.getObservationConstellation().getDefaultPointMetadata().getDefaultTVPMeasurementMetadata().getInterpolationtype();
        }
        defaultTVPMeasurementMetadata.addNewInterpolationType().setHref(interpolationType.getIdentifier());
        xbDefMeasureMetaComponent.getDefaultTVPMeasurementMetadata().getInterpolationType().setTitle(interpolationType.getTitle());
        String unit = this.addValues(measurementTimeseries, sosObservation.getValue());
        if (unit != null && !unit.isEmpty()) {
            defaultTVPMeasurementMetadata.addNewUom().setCode(unit);
        } else {
            OmObservableProperty observableProperty = (OmObservableProperty)sosObservation.getObservationConstellation().getObservableProperty();
            if (observableProperty.isSetUnit()) {
                defaultTVPMeasurementMetadata.addNewUom().setCode(observableProperty.getUnit());
            }
        }
        xbMetaComponent.set((XmlObject)xbDefMeasureMetaComponent);
        return measurementTimeseriesDoc;
    }

    private XmlObject createMeasurementTimeseries(AbstractObservationValue<?> observationValue) throws CodedException {
        MeasurementTimeseriesDocument measurementTimeseriesDoc = MeasurementTimeseriesDocument.Factory.newInstance();
        MeasurementTimeseriesType measurementTimeseries = measurementTimeseriesDoc.addNewMeasurementTimeseries();
        measurementTimeseries.setId(TIMESERIES_ID_PREFIX + observationValue.getObservationID());
        MeasurementTimeseriesMetadata timeseriesMetadata = new MeasurementTimeseriesMetadata().setCumulative(false);
        if (observationValue.isSetValue() && observationValue.isSetMetadata() && observationValue.getMetadata().isSetTimeseriesMetadata()) {
            timeseriesMetadata = observationValue.getMetadata().getTimeseriesmetadata();
        }
        this.addTimeseriesMetadata(measurementTimeseries, observationValue.getPhenomenonTime().getGmlId(), (TimeseriesMetadata)timeseriesMetadata);
        TVPDefaultMetadataPropertyType xbMetaComponent = measurementTimeseries.addNewDefaultPointMetadata();
        DefaultTVPMeasurementMetadataDocument xbDefMeasureMetaComponent = DefaultTVPMeasurementMetadataDocument.Factory.newInstance();
        TVPMeasurementMetadataType defaultTVPMeasurementMetadata = xbDefMeasureMetaComponent.addNewDefaultTVPMeasurementMetadata();
        WaterMLConstants.InterpolationType interpolationType = WaterMLConstants.InterpolationType.Continuous;
        if (observationValue.isSetValue() && observationValue.isSetDefaultPointMetadata() && observationValue.getDefaultPointMetadata().isSetDefaultTVPMeasurementMetadata() && observationValue.getDefaultPointMetadata().getDefaultTVPMeasurementMetadata().isSetInterpolationType()) {
            interpolationType = (WaterMLConstants.InterpolationType)observationValue.getDefaultPointMetadata().getDefaultTVPMeasurementMetadata().getInterpolationtype();
        }
        defaultTVPMeasurementMetadata.addNewInterpolationType().setHref(interpolationType.getIdentifier());
        xbDefMeasureMetaComponent.getDefaultTVPMeasurementMetadata().getInterpolationType().setTitle(interpolationType.getTitle());
        String unit = this.addValues(measurementTimeseries, (ObservationValue<?>)observationValue);
        if (unit != null && !unit.isEmpty()) {
            defaultTVPMeasurementMetadata.addNewUom().setCode(unit);
        }
        xbMetaComponent.set((XmlObject)xbDefMeasureMetaComponent);
        return measurementTimeseriesDoc;
    }

    private String addValues(MeasurementTimeseriesType measurementTimeseries, ObservationValue<?> observationValue) throws CodedException {
        String unit = null;
        if (observationValue instanceof SingleObservationValue) {
            QuantityValue quantityValue;
            ProfileValue profileValue;
            SingleObservationValue singleObservationValue = (SingleObservationValue)observationValue;
            String time = this.getTimeString(singleObservationValue.getPhenomenonTime());
            unit = singleObservationValue.getValue().getUnit();
            String value = null;
            if (singleObservationValue.getValue() instanceof QuantityValue) {
                QuantityValue quantityValue2 = (QuantityValue)singleObservationValue.getValue();
                if (quantityValue2.isSetValue()) {
                    value = quantityValue2.getValue().toPlainString();
                }
            } else if (singleObservationValue.getValue() instanceof CountValue) {
                CountValue countValue = (CountValue)singleObservationValue.getValue();
                if (countValue.getValue() != null) {
                    value = Integer.toString(countValue.getValue());
                }
            } else if (singleObservationValue.getValue() instanceof ProfileValue && (profileValue = (ProfileValue)singleObservationValue.getValue()).isSetValue() && ((ProfileLevel)profileValue.getValue().iterator().next()).getSimpleValue() instanceof QuantityValue && (quantityValue = (QuantityValue)((ProfileLevel)profileValue.getValue().iterator().next()).getSimpleValue()).isSetValue()) {
                value = Double.toString(quantityValue.getValue().doubleValue());
            }
            this.addValuesToMeasurementTVP(measurementTimeseries.addNewPoint().addNewMeasurementTVP(), time, value);
        } else if (observationValue instanceof MultiObservationValues) {
            MultiObservationValues mov = (MultiObservationValues)observationValue;
            TVPValue tvpValue = (TVPValue)mov.getValue();
            List timeValuePairs = tvpValue.getValue();
            unit = tvpValue.getUnit();
            for (TimeValuePair timeValuePair : timeValuePairs) {
                String time = this.getTimeString(timeValuePair.getTime());
                String value = null;
                if (timeValuePair.getValue() instanceof QuantityValue) {
                    QuantityValue quantityValue = (QuantityValue)timeValuePair.getValue();
                    if (quantityValue.isSetValue()) {
                        value = quantityValue.getValue().toPlainString();
                    }
                } else if (timeValuePair.getValue() instanceof ProfileValue) {
                    QuantityValue quantityValue;
                    ProfileValue profileValue = (ProfileValue)timeValuePair.getValue();
                    if (profileValue.isSetValue() && ((ProfileLevel)profileValue.getValue().iterator().next()).getSimpleValue() instanceof QuantityValue && (quantityValue = (QuantityValue)((ProfileLevel)profileValue.getValue().iterator().next()).getSimpleValue()).isSetValue()) {
                        value = Double.toString(quantityValue.getValue().doubleValue());
                    }
                } else if (timeValuePair.getValue() instanceof CountValue) {
                    CountValue countValue = (CountValue)timeValuePair.getValue();
                    if (countValue.isSetValue()) {
                        value = Integer.toString(countValue.getValue());
                    }
                } else {
                    throw new NoApplicableCodeException().withMessage("The types of values '%s' is not yet supported", new Object[]{mov.getValue().getClass().getSimpleName()});
                }
                this.addValuesToMeasurementTVP(measurementTimeseries.addNewPoint().addNewMeasurementTVP(), time, value);
            }
        }
        return unit;
    }

    private void addValuesToMeasurementTVP(MeasureTVPType measurementTVP, String time, String value) {
        measurementTVP.addNewTime().setStringValue(time);
        if (Strings.isNullOrEmpty((String)value)) {
            measurementTVP.addNewValue().setNil();
            measurementTVP.addNewMetadata().addNewTVPMeasurementMetadata().addNewNilReason().setNilReason((Object)"missing");
        } else {
            measurementTVP.addNewValue().setStringValue(value);
        }
    }

    private void addTimeseriesMetadata(MeasurementTimeseriesType mtt, String gmlId, TimeseriesMetadata timeseriesMetadata) {
        MeasurementTimeseriesMetadataType mtmt = (MeasurementTimeseriesMetadataType)mtt.addNewMetadata().addNewTimeseriesMetadata().substitute(WaterMLConstants.QN_MEASUREMENT_TIMESERIES_METADATA, MeasurementTimeseriesMetadataType.type);
        this.createMeasurementTimeseriesMetadataType(mtmt, gmlId);
        if (timeseriesMetadata != null && timeseriesMetadata.getClass().isAssignableFrom(MeasurementTimeseriesMetadata.class)) {
            mtmt.setCumulative(((MeasurementTimeseriesMetadata)timeseriesMetadata).isCumulative());
        }
    }

    private MeasurementTimeseriesMetadataType createMeasurementTimeseriesMetadataType(MeasurementTimeseriesMetadataType mtmt, String gmlId) {
        mtmt.addNewTemporalExtent().setHref("#" + gmlId);
        return mtmt;
    }
}

