/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.aqd.AqdConstants;
import org.n52.shetland.ogc.ows.service.OwsServiceCommunicationObject;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.DecoderRepository;
import org.n52.svalbard.decode.XmlNamespaceDecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.XmlHelper;

public class AqdDecoderv10
implements Decoder<OwsServiceCommunicationObject, XmlObject> {
    private static final Set<DecoderKey> DECODER_KEYS = CodingHelper.xmlDecoderKeysForOperation((String)"AQD", (String)"1.0.0", (Enum[])new Enum[]{AqdConstants.Operations.GetCapabilities, AqdConstants.Operations.GetObservation, AqdConstants.Operations.DescribeSensor});
    private DecoderRepository decoderRepository;

    @Inject
    public void setDecoderRepository(DecoderRepository decoderRepository) {
        this.decoderRepository = Objects.requireNonNull(decoderRepository);
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    public OwsServiceCommunicationObject decode(XmlObject objectToDecode) throws DecodingException {
        XmlNamespaceDecoderKey key = new XmlNamespaceDecoderKey(XmlHelper.getNamespace((XmlObject)objectToDecode), XmlObject.class);
        Decoder decoder = this.decoderRepository.getDecoder((DecoderKey)key, new DecoderKey[0]);
        return (OwsServiceCommunicationObject)decoder.decode((Object)objectToDecode);
    }
}

