/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.collect.Sets;
import java.util.Set;
import net.opengis.sosgda.x10.GetDataAvailabilityDocument;
import net.opengis.sosgda.x10.GetDataAvailabilityType;
import net.opengis.sosgda.x20.GetDataAvailabilityDocument;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.ogc.sos.gda.GetDataAvailabilityConstants;
import org.n52.shetland.ogc.sos.gda.GetDataAvailabilityRequest;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.AbstractSosRequestEncoder;
import org.n52.svalbard.encode.exception.EncodingException;

public class GetDataAvailabilityRequestEncoder
extends AbstractSosRequestEncoder<GetDataAvailabilityRequest> {
    public GetDataAvailabilityRequestEncoder() {
        super("GetDataAvailability", GetDataAvailabilityRequest.class);
    }

    @Override
    protected Set<SchemaLocation> getConcreteSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{GetDataAvailabilityConstants.GET_DATA_AVAILABILITY_SCHEMA_LOCATION});
    }

    @Override
    protected XmlObject create(GetDataAvailabilityRequest request) throws EncodingException {
        return request.getNamespace().equals("http://www.opengis.net/sosgda/2.0") ? this.createGDAv20(request) : this.createGDAv10(request);
    }

    private XmlObject createGDAv10(GetDataAvailabilityRequest request) {
        net.opengis.sosgda.x10.GetDataAvailabilityDocument document = GetDataAvailabilityDocument.Factory.newInstance();
        GetDataAvailabilityType gdat = document.addNewGetDataAvailability();
        gdat.setService(request.isSetService() ? request.getService() : "SOS");
        gdat.setVersion(request.isSetVersion() ? request.getVersion() : "1.0.0");
        request.getOfferings().forEach(arg_0 -> ((GetDataAvailabilityType)gdat).addOffering(arg_0));
        request.getProcedures().forEach(arg_0 -> ((GetDataAvailabilityType)gdat).addProcedure(arg_0));
        request.getFeaturesOfInterest().forEach(arg_0 -> ((GetDataAvailabilityType)gdat).addFeatureOfInterest(arg_0));
        request.getObservedProperties().forEach(arg_0 -> ((GetDataAvailabilityType)gdat).addObservedProperty(arg_0));
        return document;
    }

    private XmlObject createGDAv20(GetDataAvailabilityRequest request) {
        GetDataAvailabilityDocument document = GetDataAvailabilityDocument.Factory.newInstance();
        net.opengis.sosgda.x20.GetDataAvailabilityType gdat = document.addNewGetDataAvailability();
        gdat.setService(request.isSetService() ? request.getService() : "SOS");
        gdat.setVersion(request.isSetVersion() ? request.getVersion() : "2.0.0");
        request.getOfferings().forEach(arg_0 -> ((net.opengis.sosgda.x20.GetDataAvailabilityType)gdat).addOffering(arg_0));
        request.getProcedures().forEach(arg_0 -> ((net.opengis.sosgda.x20.GetDataAvailabilityType)gdat).addProcedure(arg_0));
        request.getFeaturesOfInterest().forEach(arg_0 -> ((net.opengis.sosgda.x20.GetDataAvailabilityType)gdat).addFeatureOfInterest(arg_0));
        request.getObservedProperties().forEach(arg_0 -> ((net.opengis.sosgda.x20.GetDataAvailabilityType)gdat).addObservedProperty(arg_0));
        return document;
    }
}

