/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.opengis.gml.x32.AbstractFeatureDocument;
import net.opengis.gml.x32.AbstractGMLType;
import net.opengis.gml.x32.FeaturePropertyType;
import net.opengis.sampling.x20.SFSamplingFeatureType;
import net.opengis.samplingSpatial.x20.SFSpatialSamplingFeatureDocument;
import net.opengis.samplingSpatial.x20.SFSpatialSamplingFeatureType;
import net.opengis.samplingSpatial.x20.ShapeType;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.n52.shetland.ogc.SupportedType;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gml.AbstractGML;
import org.n52.shetland.ogc.gml.AbstractMetaData;
import org.n52.shetland.ogc.om.NamedValue;
import org.n52.shetland.ogc.om.features.SfConstants;
import org.n52.shetland.ogc.om.features.samplingFeatures.AbstractSamplingFeature;
import org.n52.shetland.ogc.sos.FeatureType;
import org.n52.shetland.util.CollectionHelper;
import org.n52.shetland.util.OMHelper;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.ConformanceClass;
import org.n52.svalbard.encode.AbstractGmlEncoderv321;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.XmlEncoderFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class SamplingEncoderv20
extends AbstractGmlEncoderv321<XmlObject, AbstractFeature>
implements ConformanceClass {
    private static final Logger LOGGER = LoggerFactory.getLogger(SamplingEncoderv20.class);
    private static final Set<EncoderKey> ENCODER_KEYS = CollectionHelper.union((Set[])new Set[]{CodingHelper.encoderKeysForElements((String)"http://www.opengis.net/samplingSpatial/2.0", (Class[])new Class[]{AbstractFeature.class}), CodingHelper.encoderKeysForElements((String)"http://www.opengis.net/sampling/2.0", (Class[])new Class[]{AbstractFeature.class})});
    private static final Set<String> CONFORMANCE_CLASSES = Sets.newHashSet((Object[])new String[]{"http://www.opengis.net/spec/OMXML/2.0/conf/spatialSampling", "http://www.opengis.net/spec/OMXML/2.0/conf/samplingPoint", "http://www.opengis.net/spec/OMXML/2.0/conf/samplingCurve", "http://www.opengis.net/spec/OMXML/2.0/conf/samplingSurface"});
    private static final Set<SupportedType> SUPPORTED_TYPES = ImmutableSet.builder().add((Object)new FeatureType("http://www.opengis.net/def/nil/OGC/0/unknown")).add((Object)new FeatureType("http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingPoint")).add((Object)new FeatureType("http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingCurve")).add((Object)new FeatureType("http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingSurface")).build();

    public SamplingEncoderv20() {
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(ENCODER_KEYS));
    }

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEYS);
    }

    public Set<SupportedType> getSupportedTypes() {
        return Collections.unmodifiableSet(SUPPORTED_TYPES);
    }

    public Set<String> getConformanceClasses(String service, String version) {
        if ("SOS".equals(service) && "2.0.0".equals(version)) {
            return Collections.unmodifiableSet(CONFORMANCE_CLASSES);
        }
        return Collections.emptySet();
    }

    public void addNamespacePrefixToMap(Map<String, String> nameSpacePrefixMap) {
        nameSpacePrefixMap.put("http://www.opengis.net/samplingSpatial/2.0", "sams");
        nameSpacePrefixMap.put("http://www.opengis.net/sampling/2.0", "sf");
    }

    public Set<SchemaLocation> getSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{SfConstants.SF_SCHEMA_LOCATION, SfConstants.SAMS_SCHEMA_LOCATION});
    }

    public XmlObject encode(AbstractFeature abstractFeature, EncodingContext ctx) throws EncodingException {
        XmlObject tmp;
        Object encodedObject = !ctx.isEmpty() && ctx.has((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE) ? ((tmp = this.createFeature(abstractFeature)) instanceof SFSpatialSamplingFeatureDocument ? ((SFSpatialSamplingFeatureDocument)tmp).getSFSamplingFeature() : ((AbstractFeatureDocument)tmp).getAbstractFeature()) : this.createFeature(abstractFeature);
        return encodedObject;
    }

    protected XmlObject createFeature(AbstractFeature absFeature) throws EncodingException {
        if (absFeature instanceof AbstractSamplingFeature) {
            AbstractSamplingFeature sampFeat = (AbstractSamplingFeature)absFeature;
            SFSpatialSamplingFeatureDocument xbSampFeatDoc = SFSpatialSamplingFeatureDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
            if (sampFeat.isSetXml()) {
                try {
                    XmlObject feature = XmlObject.Factory.parse((String)sampFeat.getXml(), (XmlOptions)this.getXmlOptions());
                    if (XmlHelper.getNamespace((XmlObject)feature).equals("http://www.opengis.net/samplingSpatial/2.0")) {
                        XmlHelper.updateGmlIDs((Node)feature.getDomNode().getFirstChild(), (String)absFeature.getGmlId(), null);
                        if (feature instanceof SFSpatialSamplingFeatureType) {
                            xbSampFeatDoc.setSFSpatialSamplingFeature((SFSpatialSamplingFeatureType)feature);
                            this.encodeShape(xbSampFeatDoc.getSFSpatialSamplingFeature().getShape(), sampFeat);
                            this.addNameDescription((SFSamplingFeatureType)xbSampFeatDoc.getSFSpatialSamplingFeature(), sampFeat);
                            return xbSampFeatDoc;
                        }
                        this.encodeShape(((SFSpatialSamplingFeatureDocument)feature).getSFSpatialSamplingFeature().getShape(), sampFeat);
                        this.addNameDescription((SFSamplingFeatureType)((SFSpatialSamplingFeatureDocument)feature).getSFSpatialSamplingFeature(), sampFeat);
                        sampFeat.wasEncoded();
                        return feature;
                    }
                    return this.encodeObjectToXml(XmlHelper.getNamespace((XmlObject)feature), absFeature);
                }
                catch (XmlException xmle) {
                    throw new EncodingException("Error while encoding GetFeatureOfInterest response, invalid samplingFeature description!", (Throwable)xmle);
                }
            }
            SFSpatialSamplingFeatureType xbSampFeature = xbSampFeatDoc.addNewSFSpatialSamplingFeature();
            this.addId((AbstractGMLType)xbSampFeature, (AbstractFeature)sampFeat);
            this.addIdentifier((AbstractGMLType)xbSampFeature, (AbstractGML)sampFeat);
            this.addFeatureType((SFSamplingFeatureType)xbSampFeature, sampFeat);
            this.addNameDescription((SFSamplingFeatureType)xbSampFeature, sampFeat);
            this.setMetaDataProperty((SFSamplingFeatureType)xbSampFeature, sampFeat);
            this.addSampledFeatures((SFSamplingFeatureType)xbSampFeature, sampFeat);
            this.addParameter((SFSamplingFeatureType)xbSampFeature, sampFeat);
            this.encodeShape(xbSampFeature.addNewShape(), sampFeat);
            sampFeat.wasEncoded();
            return xbSampFeatDoc;
        }
        throw new UnsupportedEncoderInputException((Encoder)this, (Object)absFeature);
    }

    @Override
    protected XmlObject createFeature(FeaturePropertyType featurePropertyType, AbstractFeature abstractFeature, EncodingContext context) throws EncodingException {
        if (abstractFeature instanceof AbstractSamplingFeature) {
            AbstractSamplingFeature samplingFeature = (AbstractSamplingFeature)abstractFeature;
            String namespace = context.has((Enum)XmlEncoderFlags.ENCODE_NAMESPACE) && context.get((Enum)XmlEncoderFlags.ENCODE_NAMESPACE).isPresent() && context.get((Enum)XmlEncoderFlags.ENCODE_NAMESPACE).get() instanceof String ? (String)context.get((Enum)XmlEncoderFlags.ENCODE_NAMESPACE).get() : OMHelper.getNamespaceForFeatureType((String)samplingFeature.getFeatureType());
            XmlObject encodedXmlObject = this.encodeObjectToXml(namespace, samplingFeature);
            if (encodedXmlObject != null) {
                return encodedXmlObject;
            }
            if (samplingFeature.isSetXml()) {
                try {
                    return XmlObject.Factory.parse((String)samplingFeature.getXml());
                }
                catch (XmlException xmle) {
                    throw new EncodingException("Error while encoding featurePropertyType!", (Throwable)xmle);
                }
            }
            featurePropertyType.setHref(samplingFeature.getIdentifierCodeWithAuthority().getValue());
            if (samplingFeature.isSetName()) {
                featurePropertyType.setTitle(samplingFeature.getFirstName().getValue());
            }
            return featurePropertyType;
        }
        return featurePropertyType;
    }

    protected void addSampledFeatures(SFSamplingFeatureType sfsft, AbstractSamplingFeature sampFeat) throws EncodingException {
        if (sampFeat.isSetSampledFeatures()) {
            for (AbstractFeature sampledFeature : sampFeat.getSampledFeatures()) {
                XmlObject encodeObjectToXml = this.encodeObjectToXml("http://www.opengis.net/gml/3.2", sampledFeature, new EncodingContext().with((Enum)XmlBeansEncodingFlags.REFERENCED));
                sfsft.addNewSampledFeature().set(encodeObjectToXml);
            }
        } else {
            sfsft.addNewSampledFeature().setHref("http://www.opengis.net/def/nil/OGC/0/unknown");
        }
    }

    protected void addFeatureType(SFSamplingFeatureType sfsft, AbstractSamplingFeature sampFeat) {
        if (sampFeat.isSetFeatureType() && !"http://www.opengis.net/def/nil/OGC/0/unknown".equals(sampFeat.getFeatureType())) {
            sfsft.addNewType().setHref(sampFeat.getFeatureType());
        } else if (sampFeat.isSetGeometry()) {
            this.addFeatureTypeForGeometry(sfsft, sampFeat.getGeometry());
        }
    }

    private void addFeatureTypeForGeometry(SFSamplingFeatureType xbSampFeature, Geometry geometry) {
        xbSampFeature.addNewType().setHref(this.getFeatureType(geometry));
    }

    private String getFeatureType(Geometry geometry) {
        if (geometry instanceof Point || geometry instanceof MultiPoint) {
            return "http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingPoint";
        }
        if (geometry instanceof LineString || geometry instanceof MultiLineString) {
            return "http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingCurve";
        }
        if (geometry instanceof Polygon || geometry instanceof MultiPolygon) {
            return "http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingSurface";
        }
        return "http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingFeature";
    }

    private void encodeShape(ShapeType xbShape, AbstractSamplingFeature sampFeat) throws EncodingException {
        XmlObject xmlObject;
        Encoder<XmlObject, Geometry> encoder = this.getEncoder("http://www.opengis.net/gml/3.2", sampFeat.getGeometry());
        if (encoder != null) {
            xmlObject = (XmlObject)encoder.encode((Object)sampFeat.getGeometry(), EncodingContext.of((Enum)XmlBeansEncodingFlags.GMLID, (Object)sampFeat.getGmlId()));
            if (xbShape.isSetAbstractGeometry()) {
                xbShape.getAbstractGeometry().set(xmlObject);
            } else {
                xbShape.addNewAbstractGeometry().set(xmlObject);
            }
        } else {
            throw new EncodingException("Error while encoding geometry for feature, needed encoder is missing!", new Object[0]);
        }
        XmlHelper.substituteElement((XmlObject)xbShape.getAbstractGeometry(), (XmlObject)xmlObject);
    }

    protected void addParameter(SFSamplingFeatureType xbSampFeature, AbstractSamplingFeature sampFeat) throws EncodingException {
        for (NamedValue namedValuePair : sampFeat.getParameters()) {
            XmlObject encodeObjectToXml = this.encodeObjectToXml("http://www.opengis.net/om/2.0", namedValuePair);
            if (encodeObjectToXml == null) continue;
            xbSampFeature.addNewParameter().addNewNamedValue().set(encodeObjectToXml);
        }
    }

    protected void addNameDescription(SFSamplingFeatureType xbSamplingFeature, AbstractSamplingFeature samplingFeature) throws EncodingException {
        this.addName((AbstractGMLType)xbSamplingFeature, (AbstractGML)samplingFeature);
        this.addDescription((AbstractGMLType)xbSamplingFeature, (AbstractGML)samplingFeature);
    }

    protected void setMetaDataProperty(SFSamplingFeatureType sfssft, AbstractSamplingFeature sampFeat) throws EncodingException {
        if (sampFeat.isSetMetaDataProperty()) {
            for (AbstractMetaData abstractMetaData : sampFeat.getMetaDataProperty()) {
                XmlObject encodeObject = this.encodeObjectToXml("http://www.opengis.net/gml/3.2", abstractMetaData);
                XmlObject substituteElement = XmlHelper.substituteElement((XmlObject)sfssft.addNewMetaDataProperty().addNewAbstractMetaData(), (XmlObject)encodeObject);
                substituteElement.set(encodeObject);
            }
        }
    }
}

