/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.ogc.sensorML.AbstractSensorML;
import org.n52.shetland.ogc.sensorML.elements.SmlIdentifier;
import org.n52.svalbard.decode.AbstractXmlDecoder;
import org.n52.svalbard.decode.ProcedureDecoder;

public abstract class AbstractSensorMLDecoder
extends AbstractXmlDecoder<XmlObject, AbstractSensorML>
implements ProcedureDecoder<AbstractSensorML, XmlObject> {
    private static final Set<String> DEFINITION_VALUES = Sets.newHashSet((Object[])new String[]{"urn:ogc:def:identifier:OGC:uniqueID", "urn:ogc:def:identifier:OGC::identification"});

    protected boolean isIdentificationProcedureIdentifier(SmlIdentifier identifier) {
        return this.checkIdentificationNameForProcedureIdentifier(identifier.getName()) || this.checkIdentificationDefinitionForProcedureIdentifier(identifier.getDefinition());
    }

    private boolean checkIdentificationNameForProcedureIdentifier(String name) {
        return !Strings.isNullOrEmpty((String)name) && name.equals("uniqueID");
    }

    private boolean checkIdentificationDefinitionForProcedureIdentifier(String definition) {
        if (Strings.isNullOrEmpty((String)definition)) {
            return false;
        }
        return DEFINITION_VALUES.contains(definition) || this.checkDefinitionStartsWithAndContains(definition);
    }

    private boolean checkDefinitionStartsWithAndContains(String definition) {
        return definition.startsWith("urn:ogc:def:identifier:OGC:") && definition.contains("uniqueID");
    }
}

