/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import net.opengis.gml.x32.MeasureOrNilReasonListType;
import net.opengis.gml.x32.QuantityListDocument;
import net.opengis.om.x20.OMObservationType;
import net.opengis.watermlDr.x20.MeasurementTimeseriesCoverageType;
import net.opengis.watermlDr.x20.MeasurementTimeseriesDomainRangeDocument;
import net.opengis.watermlDr.x20.TimePositionListDocument;
import net.opengis.watermlDr.x20.TimePositionListType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.shetland.ogc.SupportedType;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gmlcov.GmlCoverageConstants;
import org.n52.shetland.ogc.om.AbstractObservationValue;
import org.n52.shetland.ogc.om.AbstractPhenomenon;
import org.n52.shetland.ogc.om.MultiObservationValues;
import org.n52.shetland.ogc.om.ObservationType;
import org.n52.shetland.ogc.om.ObservationValue;
import org.n52.shetland.ogc.om.OmObservableProperty;
import org.n52.shetland.ogc.om.OmObservation;
import org.n52.shetland.ogc.om.SingleObservationValue;
import org.n52.shetland.ogc.om.TimeValuePair;
import org.n52.shetland.ogc.om.series.tsml.TimeseriesMLConstants;
import org.n52.shetland.ogc.om.values.CountValue;
import org.n52.shetland.ogc.om.values.QuantityValue;
import org.n52.shetland.ogc.om.values.TVPValue;
import org.n52.shetland.ogc.sos.response.GetObservationResponse;
import org.n52.shetland.ogc.swe.SweAbstractDataComponent;
import org.n52.shetland.ogc.swe.SweDataRecord;
import org.n52.shetland.ogc.swe.SweField;
import org.n52.shetland.ogc.swe.simpleType.SweQuantity;
import org.n52.shetland.util.CollectionHelper;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.AbstractTsmlEncoderv10;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.StreamingEncoderFlags;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.write.TsmlTDREncoderv10XmlStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsmlTDREncoderv10
extends AbstractTsmlEncoderv10 {
    private static final Logger LOGGER = LoggerFactory.getLogger(TsmlTDREncoderv10.class);
    private static final Set<String> CONFORMANCE_CLASSES = ImmutableSet.of();
    private static final Set<EncoderKey> ENCODER_KEYS = TsmlTDREncoderv10.createEncoderKeys();
    private static final ImmutableSet<SupportedType> SUPPORTED_TYPES = ImmutableSet.builder().add((Object)new ObservationType("http://www.opengis.net/def/observationType/timeseriesML/1.0/MeasurementTimeseriesDomainRangeObservation")).build();
    private static final Map<String, Map<String, Set<String>>> SUPPORTED_RESPONSE_FORMATS = Collections.singletonMap("SOS", Collections.singletonMap("2.0.0", Collections.singleton("http://www.opengis.net/tsml/1.0")));
    private static final String TIMESERIES_ID_PREFIX = "timeseries_";
    private static final String DATA_RECORD_ID_PREFIX = "datarecord_";
    private static final String TIME_POSITION_LIST_ID_PREFIX = "timepositionList_";

    public TsmlTDREncoderv10() {
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(ENCODER_KEYS));
    }

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEYS);
    }

    public Set<SupportedType> getSupportedTypes() {
        return Collections.unmodifiableSet(SUPPORTED_TYPES);
    }

    public Map<String, Set<SupportedType>> getSupportedResponseFormatObservationTypes() {
        return Collections.singletonMap("http://www.opengis.net/tsml/1.0", this.getSupportedTypes());
    }

    public Set<String> getConformanceClasses(String service, String version) {
        if ("SOS".equals(service) && "2.0.0".equals(version)) {
            return Collections.unmodifiableSet(CONFORMANCE_CLASSES);
        }
        return Collections.emptySet();
    }

    @Override
    public void addNamespacePrefixToMap(Map<String, String> nameSpacePrefixMap) {
        super.addNamespacePrefixToMap(nameSpacePrefixMap);
        nameSpacePrefixMap.put("http://www.opengis.net/tsml/1.0", "tsml");
        nameSpacePrefixMap.put("http://www.opengis.net/gmlcov/1.0", "gmlcov");
    }

    public Set<String> getSupportedResponseFormats(String service, String version) {
        if (SUPPORTED_RESPONSE_FORMATS.get(service) != null && SUPPORTED_RESPONSE_FORMATS.get(service).get(version) != null) {
            return SUPPORTED_RESPONSE_FORMATS.get(service).get(version);
        }
        return Collections.emptySet();
    }

    public Set<SchemaLocation> getSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{TimeseriesMLConstants.TSML_10_SCHEMA_LOCATION, TimeseriesMLConstants.TSML_10_DR_SCHEMA_LOCATION, GmlCoverageConstants.GML_COVERAGE_10_SCHEMA_LOCATION});
    }

    public boolean supportsResultStreamingForMergedValues() {
        return false;
    }

    @Override
    public XmlObject encode(Object element, EncodingContext additionalValues) throws EncodingException {
        if (element instanceof ObservationValue) {
            return this.encodeResult((ObservationValue)element);
        }
        return super.encode(element, additionalValues);
    }

    @Override
    public void encode(Object objectToEncode, OutputStream outputStream, EncodingContext ctx) throws EncodingException {
        if (objectToEncode instanceof OmObservation) {
            try {
                new TsmlTDREncoderv10XmlStreamWriter(ctx.with((Enum)StreamingEncoderFlags.ENCODER, (Object)this), outputStream, (OmObservation)objectToEncode).write();
            }
            catch (XMLStreamException xmlse) {
                throw new EncodingException("Error while writing element to stream!", (Throwable)xmlse);
            }
        } else {
            super.encode(objectToEncode, ctx);
        }
    }

    @Override
    protected XmlObject createResult(OmObservation sosObservation) throws EncodingException {
        return this.createMeasurementDomainRange(sosObservation);
    }

    @Override
    protected XmlObject encodeResult(ObservationValue<?> observationValue) throws EncodingException {
        return this.createMeasurementDomainRange((AbstractObservationValue)observationValue);
    }

    @Override
    protected void addObservationType(OMObservationType xbObservation, String observationType) {
        if (!Strings.isNullOrEmpty((String)observationType)) {
            if (observationType.equals("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement") || observationType.equals("http://www.opengis.net/def/observationType/timeseriesML/1.0/MeasurementTimeseriesDomainRangeObservation")) {
                xbObservation.addNewType().setHref("http://www.opengis.net/def/observationType/timeseriesML/1.0/MeasurementTimeseriesDomainRangeObservation");
            } else if (observationType.equals("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_CategoryObservation") || observationType.equals("http://www.opengis.net/def/observationType/timeseriesML/1.0/CategoricalTimeseriesDomainRangeObservation")) {
                xbObservation.addNewType().setHref("http://www.opengis.net/def/observationType/timeseriesML/1.0/CategoricalTimeseriesDomainRangeObservation");
            }
        }
    }

    @Override
    protected OMObservationType createOmObservationType() {
        return OMObservationType.Factory.newInstance((XmlOptions)this.getXmlOptions());
    }

    private XmlObject createMeasurementDomainRange(OmObservation sosObservation) throws EncodingException {
        if (!sosObservation.getObservationConstellation().isSetObservationType() || sosObservation.getObservationConstellation().isSetObservationType() && this.isInvalidObservationType(sosObservation.getObservationConstellation().getObservationType())) {
            throw new UnsupportedEncoderInputException((Encoder)this, (Object)sosObservation.getObservationConstellation().isSetObservationType());
        }
        MeasurementTimeseriesDomainRangeDocument xbMearuementTimeseriesDomainRangeDoc = MeasurementTimeseriesDomainRangeDocument.Factory.newInstance();
        MeasurementTimeseriesCoverageType xbMeasurementTimeseriesDomainRange = xbMearuementTimeseriesDomainRangeDoc.addNewMeasurementTimeseriesDomainRange();
        xbMeasurementTimeseriesDomainRange.setId(TIMESERIES_ID_PREFIX + sosObservation.getObservationID());
        xbMeasurementTimeseriesDomainRange.addNewDomainSet().set((XmlObject)this.getTimePositionList(sosObservation));
        AbstractPhenomenon observableProperty = sosObservation.getObservationConstellation().getObservableProperty();
        String unit = null;
        QuantityListDocument quantityListDoc = QuantityListDocument.Factory.newInstance();
        MeasureOrNilReasonListType quantityList = quantityListDoc.addNewQuantityList();
        if (sosObservation.getValue() instanceof MultiObservationValues) {
            MultiObservationValues observationValue = (MultiObservationValues)sosObservation.getValue();
            TVPValue tvpValue = (TVPValue)observationValue.getValue();
            List timeValuePairs = tvpValue.getValue();
            if (CollectionHelper.isNotEmpty((Collection)timeValuePairs) && ((TimeValuePair)timeValuePairs.get(0)).getValue().isSetUnit()) {
                unit = ((TimeValuePair)timeValuePairs.get(0)).getValue().getUnit();
            }
            quantityList.setListValue(this.getValueList(timeValuePairs));
        }
        if (unit == null || unit.isEmpty()) {
            unit = "http://www.opengis.net/def/nil/OGC/0/unknown";
        }
        quantityList.setUom(unit);
        if (observableProperty instanceof OmObservableProperty && !((OmObservableProperty)observableProperty).isSetUnit()) {
            ((OmObservableProperty)observableProperty).setUnit(unit);
        }
        xbMeasurementTimeseriesDomainRange.addNewRangeSet().set((XmlObject)quantityListDoc);
        xbMeasurementTimeseriesDomainRange.addNewRangeType().set(this.createDataRecord(sosObservation));
        return xbMearuementTimeseriesDomainRangeDoc;
    }

    private XmlObject createMeasurementDomainRange(AbstractObservationValue<?> observationValue) throws EncodingException {
        if (!observationValue.isSetObservationType() || this.isInvalidObservationType(observationValue.getObservationType())) {
            return null;
        }
        MeasurementTimeseriesDomainRangeDocument xbMearuementTimeseriesDomainRangeDoc = MeasurementTimeseriesDomainRangeDocument.Factory.newInstance();
        MeasurementTimeseriesCoverageType xbMeasurementTimeseriesDomainRange = xbMearuementTimeseriesDomainRangeDoc.addNewMeasurementTimeseriesDomainRange();
        xbMeasurementTimeseriesDomainRange.setId(TIMESERIES_ID_PREFIX + observationValue.getObservationID());
        xbMeasurementTimeseriesDomainRange.addNewDomainSet().set((XmlObject)this.getTimePositionList(observationValue));
        String unit = null;
        QuantityListDocument quantityListDoc = QuantityListDocument.Factory.newInstance();
        MeasureOrNilReasonListType quantityList = quantityListDoc.addNewQuantityList();
        if (observationValue instanceof MultiObservationValues) {
            TVPValue tvpValue = (TVPValue)((MultiObservationValues)observationValue).getValue();
            List timeValuePairs = tvpValue.getValue();
            if (CollectionHelper.isNotEmpty((Collection)timeValuePairs) && ((TimeValuePair)timeValuePairs.get(0)).getValue().isSetUnit()) {
                unit = ((TimeValuePair)timeValuePairs.get(0)).getValue().getUnit();
            }
            quantityList.setListValue(this.getValueList(timeValuePairs));
        }
        if (unit == null || unit.isEmpty()) {
            unit = "http://www.opengis.net/def/nil/OGC/0/unknown";
        }
        quantityList.setUom(unit);
        xbMeasurementTimeseriesDomainRange.addNewRangeSet().set((XmlObject)quantityListDoc);
        xbMeasurementTimeseriesDomainRange.addNewRangeType().set(this.createDataRecord(observationValue, unit));
        return xbMearuementTimeseriesDomainRangeDoc;
    }

    private XmlObject createDataRecord(OmObservation sosObservation) throws EncodingException {
        AbstractPhenomenon observableProperty = sosObservation.getObservationConstellation().getObservableProperty();
        SweQuantity quantity = new SweQuantity();
        quantity.setDefinition(observableProperty.getIdentifier());
        quantity.setDescription(observableProperty.getDescription());
        if (observableProperty instanceof OmObservableProperty && ((OmObservableProperty)observableProperty).isSetUnit()) {
            quantity.setUom(((OmObservableProperty)observableProperty).getUnit());
        }
        return this.createDataRecord(quantity, sosObservation.getObservationID());
    }

    private XmlObject createDataRecord(AbstractObservationValue<?> observationValue, String unit) throws EncodingException {
        SweQuantity quantity = new SweQuantity();
        quantity.setDefinition(observationValue.getObservableProperty());
        quantity.setUom(unit);
        return this.createDataRecord(quantity, observationValue.getObservationID());
    }

    private XmlObject createDataRecord(SweQuantity quantity, String observationId) throws EncodingException {
        SweField field = new SweField("observed_value", (SweAbstractDataComponent)quantity);
        SweDataRecord dataRecord = new SweDataRecord();
        dataRecord.setIdentifier(DATA_RECORD_ID_PREFIX + observationId);
        dataRecord.addField(field);
        return this.encodeObjectToXml("http://www.opengis.net/swe/2.0", dataRecord, EncodingContext.of((Enum)XmlBeansEncodingFlags.FOR_OBSERVATION));
    }

    private TimePositionListDocument getTimePositionList(OmObservation sosObservation) throws EncodingException {
        TimePositionListDocument timePositionListDoc = TimePositionListDocument.Factory.newInstance();
        TimePositionListType timePositionList = timePositionListDoc.addNewTimePositionList();
        timePositionList.setId(TIME_POSITION_LIST_ID_PREFIX + sosObservation.getObservationID());
        if (sosObservation.getValue() instanceof SingleObservationValue) {
            timePositionList.setTimePositionList((List)Lists.newArrayList((Object[])new String[]{this.getTimeString(sosObservation.getValue().getPhenomenonTime())}));
        } else if (sosObservation.getValue() instanceof MultiObservationValues) {
            timePositionList.setTimePositionList(this.getTimeArray((MultiObservationValues)sosObservation.getValue()));
        }
        return timePositionListDoc;
    }

    private TimePositionListDocument getTimePositionList(AbstractObservationValue<?> observationValue) throws EncodingException {
        TimePositionListDocument timePositionListDoc = TimePositionListDocument.Factory.newInstance();
        TimePositionListType timePositionList = timePositionListDoc.addNewTimePositionList();
        timePositionList.setId(TIME_POSITION_LIST_ID_PREFIX + observationValue.getObservationID());
        timePositionList.setTimePositionList(this.getTimeArray((MultiObservationValues)observationValue));
        return timePositionListDoc;
    }

    private List<String> getTimeArray(MultiObservationValues<?> sosObservationValues) throws EncodingException {
        return ((TVPValue)sosObservationValues.getValue()).getValue().stream().map(TimeValuePair::getTime).map(this::getTimeString).collect(Collectors.toList());
    }

    private List<Object> getValueList(List<TimeValuePair> timeValuePairs) throws EncodingException {
        return timeValuePairs.stream().map(TimeValuePair::getValue).map(value -> {
            if (value != null && (value instanceof CountValue || value instanceof QuantityValue)) {
                return value.getValue();
            }
            return "";
        }).collect(Collectors.toList());
    }

    private boolean isInvalidObservationType(String observationType) {
        return !"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_CountObservation".equals(observationType) && !"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement".equals(observationType) && !"http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_SWEArrayObservation".equals(observationType);
    }

    private static Set<EncoderKey> createEncoderKeys() {
        return CollectionHelper.union((Set[])new Set[]{TsmlTDREncoderv10.getDefaultEncoderKeys(), CodingHelper.encoderKeysForElements((String)"http://www.opengis.net/tsml/1.0", (Class[])new Class[]{GetObservationResponse.class, OmObservation.class, AbstractFeature.class, SingleObservationValue.class, MultiObservationValues.class})});
    }
}

