/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import java.io.OutputStream;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.ogc.om.OmObservation;
import org.n52.shetland.ogc.sos.response.AbstractObservationResponse;
import org.n52.svalbard.encode.AbstractSosResponseEncoder;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.ObservationEncoder;
import org.n52.svalbard.encode.XmlEncoderKey;
import org.n52.svalbard.encode.exception.EncodingException;

public abstract class AbstractObservationResponseEncoder<T extends AbstractObservationResponse>
extends AbstractSosResponseEncoder<T> {
    public AbstractObservationResponseEncoder(String operation, Class<T> responseType) {
        super(operation, responseType);
    }

    private ObservationEncoder<XmlObject, OmObservation> findObservationEncoder(String responseFormat) throws EncodingException {
        Encoder encoder = this.getEncoder((EncoderKey)new XmlEncoderKey(responseFormat, OmObservation.class), new EncoderKey[0]);
        if (encoder == null) {
            return null;
        }
        if (encoder instanceof ObservationEncoder) {
            ObservationEncoder oe = (ObservationEncoder)encoder;
            return oe.isObservationAndMeasurmentV20Type() ? oe : null;
        }
        throw new EncodingException("Error while encoding response, encoder is not of type ObservationEncoder!", new Object[0]);
    }

    private Encoder<XmlObject, T> findResponseEncoder(String responseFormat) throws EncodingException {
        return this.getEncoder(responseFormat, this.getResponseType());
    }

    @Override
    protected XmlObject create(T response) throws EncodingException {
        String responseFormat = response.getResponseFormat();
        ObservationEncoder<XmlObject, OmObservation> encoder = this.findObservationEncoder(responseFormat);
        if (encoder != null) {
            return this.createResponse(encoder, response);
        }
        return (XmlObject)this.findResponseEncoder(responseFormat).encode(response);
    }

    @Override
    protected void create(T response, OutputStream outputStream, EncodingContext encodingValues) throws EncodingException {
        String responseFormat = response.getResponseFormat();
        ObservationEncoder<XmlObject, OmObservation> encoder = this.findObservationEncoder(responseFormat);
        if (encoder != null) {
            this.createResponse(encoder, response, outputStream, encodingValues);
        }
    }

    protected abstract XmlObject createResponse(ObservationEncoder<XmlObject, OmObservation> var1, T var2) throws EncodingException;

    protected void createResponse(ObservationEncoder<XmlObject, OmObservation> encoder, T response, OutputStream outputStream, EncodingContext encodingValues) throws EncodingException {
        super.create(response, outputStream, encodingValues);
    }
}

