/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.collect.Sets;
import java.io.OutputStream;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import net.opengis.sos.x20.GetObservationResponseDocument;
import net.opengis.sos.x20.GetObservationResponseType;
import net.opengis.swes.x20.ExtensibleResponseType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.shetland.ogc.om.ObservationStream;
import org.n52.shetland.ogc.om.OmObservation;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.sos.Sos2Constants;
import org.n52.shetland.ogc.sos.SosConstants;
import org.n52.shetland.ogc.sos.response.GetObservationResponse;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.AbstractObservationResponseEncoder;
import org.n52.svalbard.encode.EncoderFlags;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.ObservationEncoder;
import org.n52.svalbard.encode.StreamingEncoderFlags;
import org.n52.svalbard.encode.XmlEncoderFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.util.XmlHelper;
import org.n52.svalbard.write.GetObservationResponseXmlStreamWriter;
import org.w3c.dom.Node;

public class GetObservationResponseEncoder
extends AbstractObservationResponseEncoder<GetObservationResponse> {
    public GetObservationResponseEncoder() {
        super(SosConstants.Operations.GetObservation.name(), GetObservationResponse.class);
    }

    @Override
    public Set<SchemaLocation> getConcreteSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{Sos2Constants.SOS_GET_OBSERVATION_SCHEMA_LOCATION});
    }

    @Override
    protected XmlObject createResponse(ObservationEncoder<XmlObject, OmObservation> encoder, GetObservationResponse response) throws EncodingException {
        try {
            GetObservationResponseDocument doc = GetObservationResponseDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
            GetObservationResponseType xbResponse = doc.addNewGetObservationResponse();
            if (response.hasExtensions()) {
                this.createExtension((ExtensibleResponseType)xbResponse, response.getExtensions());
            }
            ObservationStream observationCollection = response.getObservationCollection();
            while (observationCollection.hasNext()) {
                xbResponse.addNewObservationData().addNewOMObservation().set((XmlObject)encoder.encode(observationCollection.next()));
            }
            XmlHelper.makeGmlIdsUnique((Node)doc.getDomNode());
            return doc;
        }
        catch (OwsExceptionReport ex) {
            throw new EncodingException((Throwable)ex);
        }
    }

    @Override
    protected void createResponse(ObservationEncoder<XmlObject, OmObservation> encoder, GetObservationResponse response, OutputStream outputStream, EncodingContext ctx) throws EncodingException {
        try {
            EncodingContext context = ctx.with((Enum)EncoderFlags.ENCODER_REPOSITORY, (Object)this.getEncoderRepository()).with((Enum)XmlEncoderFlags.XML_OPTIONS, this::getXmlOptions).with((Enum)StreamingEncoderFlags.ENCODER, (Object)this);
            new GetObservationResponseXmlStreamWriter(context, outputStream, response).write();
        }
        catch (XMLStreamException xmlse) {
            throw new EncodingException((Throwable)xmlse);
        }
    }
}

