/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.opengis.fes.x20.BBOXType;
import net.opengis.fes.x20.BinaryComparisonOpType;
import net.opengis.fes.x20.BinaryLogicOpType;
import net.opengis.fes.x20.BinaryTemporalOpType;
import net.opengis.fes.x20.ComparisonOpsType;
import net.opengis.fes.x20.FilterDocument;
import net.opengis.fes.x20.FilterType;
import net.opengis.fes.x20.LiteralType;
import net.opengis.fes.x20.LogicOpsType;
import net.opengis.fes.x20.PropertyIsBetweenType;
import net.opengis.fes.x20.PropertyIsLikeType;
import net.opengis.fes.x20.PropertyIsNilType;
import net.opengis.fes.x20.PropertyIsNullType;
import net.opengis.fes.x20.SpatialOpsType;
import net.opengis.fes.x20.TemporalOpsDocument;
import net.opengis.fes.x20.TemporalOpsType;
import net.opengis.fes.x20.UnaryLogicOpType;
import net.opengis.fes.x20.ValueReferenceDocument;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.locationtech.jts.geom.Geometry;
import org.n52.shetland.ogc.filter.BinaryLogicFilter;
import org.n52.shetland.ogc.filter.ComparisonFilter;
import org.n52.shetland.ogc.filter.Filter;
import org.n52.shetland.ogc.filter.FilterConstants;
import org.n52.shetland.ogc.filter.SpatialFilter;
import org.n52.shetland.ogc.filter.TemporalFilter;
import org.n52.shetland.ogc.filter.UnaryLogicFilter;
import org.n52.shetland.ogc.gml.GmlConstants;
import org.n52.shetland.ogc.gml.time.Time;
import org.n52.shetland.ogc.sos.Sos2Constants;
import org.n52.shetland.util.CollectionHelper;
import org.n52.shetland.util.ReferencedEnvelope;
import org.n52.svalbard.decode.AbstractXmlDecoder;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderXmlInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FesDecoderv20
extends AbstractXmlDecoder<XmlObject, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FesDecoderv20.class);
    private static final Set<DecoderKey> DECODER_KEYS = CodingHelper.decoderKeysForElements((String)"http://www.opengis.net/fes/2.0", (Class[])new Class[]{SpatialOpsType.class, TemporalOpsType.class, ComparisonOpsType.class, LogicOpsType.class, FilterType.class, FilterDocument.class, TemporalOpsDocument.class});

    public FesDecoderv20() {
        LOGGER.debug("Decoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(DECODER_KEYS));
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    public Object decode(XmlObject xmlObject) throws DecodingException {
        if (xmlObject instanceof SpatialOpsType) {
            return this.parseSpatialFilterType((SpatialOpsType)xmlObject);
        }
        if (xmlObject instanceof TemporalOpsType) {
            return this.parseTemporalFilterType((TemporalOpsType)xmlObject);
        }
        if (xmlObject instanceof TemporalOpsDocument) {
            return this.parseTemporalFilterType(((TemporalOpsDocument)xmlObject).getTemporalOps());
        }
        if (xmlObject instanceof ComparisonOpsType) {
            return this.parseComparisonFilterType((ComparisonOpsType)xmlObject);
        }
        if (xmlObject instanceof LogicOpsType) {
            return this.parseLogicFilterType((LogicOpsType)xmlObject);
        }
        if (xmlObject instanceof FilterType) {
            return this.parseFilterType((FilterType)xmlObject);
        }
        if (xmlObject instanceof FilterDocument) {
            return this.parseFilterType(((FilterDocument)xmlObject).getFilter());
        }
        throw new UnsupportedDecoderXmlInputException((Decoder<?, ?>)this, xmlObject);
    }

    private Filter<?> parseFilterType(FilterType filterType) throws DecodingException {
        if (filterType.isSetComparisonOps()) {
            return this.parseComparisonFilterType(filterType.getComparisonOps());
        }
        if (filterType.isSetSpatialOps()) {
            return this.parseSpatialFilterType(filterType.getSpatialOps());
        }
        if (filterType.isSetTemporalOps()) {
            return this.parseTemporalFilterType(filterType.getTemporalOps());
        }
        if (filterType.isSetLogicOps()) {
            return this.parseLogicFilterType(filterType.getLogicOps());
        }
        if (filterType.isSetFunction()) {
            throw new UnsupportedDecoderXmlInputException((Decoder<?, ?>)this, (XmlObject)filterType);
        }
        if (filterType.getIdArray() != null) {
            throw new UnsupportedDecoderXmlInputException((Decoder<?, ?>)this, (XmlObject)filterType);
        }
        throw new UnsupportedDecoderXmlInputException((Decoder<?, ?>)this, (XmlObject)filterType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SpatialFilter parseSpatialFilterType(SpatialOpsType xbSpatialOpsType) throws DecodingException {
        SpatialFilter spatialFilter = new SpatialFilter();
        try {
            XmlCursor geometryCursor;
            if (!(xbSpatialOpsType instanceof BBOXType)) throw new DecodingException((Enum)Sos2Constants.GetObservationParams.spatialFilter, "The requested spatial filter is not supported by this SOS!", new Object[0]);
            spatialFilter.setOperator(FilterConstants.SpatialOperator.BBOX);
            BBOXType xbBBOX = (BBOXType)xbSpatialOpsType;
            if (this.isValueReferenceExpression(xbBBOX.getExpression())) {
                spatialFilter.setValueReference(this.parseValueReference(xbBBOX.getExpression()));
            }
            if (!(geometryCursor = xbSpatialOpsType.newCursor()).toChild(GmlConstants.QN_ENVELOPE_32)) throw new DecodingException((Enum)Sos2Constants.GetObservationParams.spatialFilter, "The requested spatial filter operand is not supported by this SOS!", new Object[0]);
            Object sosGeometry = this.decodeXmlObject(XmlObject.Factory.parse((Node)geometryCursor.getDomNode()));
            if (sosGeometry instanceof Geometry) {
                spatialFilter.setGeometry((Geometry)sosGeometry);
            } else {
                if (!(sosGeometry instanceof ReferencedEnvelope)) throw new UnsupportedDecoderXmlInputException((Decoder<?, ?>)this, (XmlObject)xbSpatialOpsType);
                spatialFilter.setGeometry((ReferencedEnvelope)sosGeometry);
            }
            geometryCursor.dispose();
            return spatialFilter;
        }
        catch (XmlException xmle) {
            throw new DecodingException("Error while parsing spatial filter!", (Throwable)xmle);
        }
    }

    private TemporalFilter parseTemporalFilterType(TemporalOpsType xbTemporalOpsType) throws DecodingException {
        TemporalFilter temporalFilter;
        block32: {
            temporalFilter = new TemporalFilter();
            try {
                if (xbTemporalOpsType instanceof BinaryTemporalOpType) {
                    BinaryTemporalOpType btot = (BinaryTemporalOpType)xbTemporalOpsType;
                    if (btot.getValueReference() != null && !btot.getValueReference().isEmpty()) {
                        temporalFilter.setValueReference(btot.getValueReference().trim());
                    }
                    NodeList nodes = btot.getDomNode().getChildNodes();
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        if (nodes.item(i).getNamespaceURI() == null || nodes.item(i).getLocalName().equals("ValueReference")) continue;
                        Object timeObject = this.decodeXmlObject(XmlObject.Factory.parse((Node)nodes.item(i)));
                        if (timeObject instanceof Time) {
                            FilterConstants.TimeOperator operator;
                            Time time = (Time)timeObject;
                            String localName = XmlHelper.getLocalName((XmlObject)xbTemporalOpsType);
                            if (localName.equals(FilterConstants.TimeOperator2.After.name())) {
                                operator = FilterConstants.TimeOperator.TM_After;
                            } else if (localName.equals(FilterConstants.TimeOperator2.Before.name())) {
                                operator = FilterConstants.TimeOperator.TM_Before;
                            } else if (localName.equals(FilterConstants.TimeOperator2.Begins.name())) {
                                operator = FilterConstants.TimeOperator.TM_Begins;
                            } else if (localName.equals(FilterConstants.TimeOperator2.BegunBy.name())) {
                                operator = FilterConstants.TimeOperator.TM_BegunBy;
                            } else if (localName.equals(FilterConstants.TimeOperator2.TContains.name())) {
                                operator = FilterConstants.TimeOperator.TM_Contains;
                            } else if (localName.equals(FilterConstants.TimeOperator2.During.name())) {
                                operator = FilterConstants.TimeOperator.TM_During;
                            } else if (localName.equals(FilterConstants.TimeOperator2.EndedBy.name())) {
                                operator = FilterConstants.TimeOperator.TM_EndedBy;
                            } else if (localName.equals(FilterConstants.TimeOperator2.Ends.name())) {
                                operator = FilterConstants.TimeOperator.TM_Ends;
                            } else if (localName.equals(FilterConstants.TimeOperator2.TEquals.name())) {
                                operator = FilterConstants.TimeOperator.TM_Equals;
                            } else if (localName.equals(FilterConstants.TimeOperator2.Meets.name())) {
                                operator = FilterConstants.TimeOperator.TM_Meets;
                            } else if (localName.equals(FilterConstants.TimeOperator2.MetBy.name())) {
                                operator = FilterConstants.TimeOperator.TM_MetBy;
                            } else if (localName.equals(FilterConstants.TimeOperator2.TOverlaps.name())) {
                                operator = FilterConstants.TimeOperator.TM_Overlaps;
                            } else if (localName.equals(FilterConstants.TimeOperator2.OverlappedBy.name())) {
                                operator = FilterConstants.TimeOperator.TM_OverlappedBy;
                            } else {
                                throw FesDecoderv20.unsupportedTemporalOperator();
                            }
                            temporalFilter.setOperator(operator);
                            temporalFilter.setTime(time);
                            break block32;
                        }
                        throw new DecodingException((Enum)Sos2Constants.GetObservationParams.temporalFilter, "The requested temporal filter value is not supported by this SOS!", new Object[0]);
                    }
                    break block32;
                }
                throw FesDecoderv20.unsupportedTemporalOperator();
            }
            catch (XmlException xmle) {
                throw new DecodingException("Error while parsing temporal filter!", (Throwable)xmle);
            }
        }
        return temporalFilter;
    }

    private ComparisonFilter parseComparisonFilterType(ComparisonOpsType comparisonOpsType) throws DecodingException {
        if (comparisonOpsType instanceof BinaryComparisonOpType) {
            return this.parseBinaryComparisonFilter((BinaryComparisonOpType)comparisonOpsType);
        }
        if (comparisonOpsType instanceof PropertyIsLikeType) {
            return this.parsePropertyIsLikeFilter((PropertyIsLikeType)comparisonOpsType);
        }
        if (comparisonOpsType instanceof PropertyIsNullType) {
            return this.parsePropertyIsNullFilter((PropertyIsNullType)comparisonOpsType);
        }
        if (comparisonOpsType instanceof PropertyIsNilType) {
            return this.parsePropertyIsNilFilter((PropertyIsNilType)comparisonOpsType);
        }
        if (comparisonOpsType instanceof PropertyIsBetweenType) {
            return this.parsePropertyIsBetweenFilter((PropertyIsBetweenType)comparisonOpsType);
        }
        throw new UnsupportedDecoderXmlInputException((Decoder<?, ?>)this, (XmlObject)comparisonOpsType);
    }

    private ComparisonFilter parseBinaryComparisonFilter(BinaryComparisonOpType comparisonOpsType) throws DecodingException {
        ComparisonFilter comparisonFilter = new ComparisonFilter();
        String localName = XmlHelper.getLocalName((XmlObject)comparisonOpsType);
        if (FilterConstants.ComparisonOperator.PropertyIsEqualTo.name().equals(localName)) {
            comparisonFilter.setOperator(FilterConstants.ComparisonOperator.PropertyIsEqualTo);
        } else if (FilterConstants.ComparisonOperator.PropertyIsNotEqualTo.name().equals(localName)) {
            comparisonFilter.setOperator(FilterConstants.ComparisonOperator.PropertyIsNotEqualTo);
        } else if (FilterConstants.ComparisonOperator.PropertyIsLessThan.name().equals(localName)) {
            comparisonFilter.setOperator(FilterConstants.ComparisonOperator.PropertyIsLessThan);
        } else if (FilterConstants.ComparisonOperator.PropertyIsGreaterThan.name().equals(localName)) {
            comparisonFilter.setOperator(FilterConstants.ComparisonOperator.PropertyIsGreaterThan);
        } else if (FilterConstants.ComparisonOperator.PropertyIsLessThanOrEqualTo.name().equals(localName)) {
            comparisonFilter.setOperator(FilterConstants.ComparisonOperator.PropertyIsLessThanOrEqualTo);
        } else if (FilterConstants.ComparisonOperator.PropertyIsGreaterThanOrEqualTo.name().equals(localName)) {
            comparisonFilter.setOperator(FilterConstants.ComparisonOperator.PropertyIsGreaterThanOrEqualTo);
        } else {
            throw new UnsupportedDecoderXmlInputException((Decoder<?, ?>)this, (XmlObject)comparisonOpsType);
        }
        if (comparisonOpsType.isSetMatchCase()) {
            comparisonFilter.setMatchCase(comparisonOpsType.getMatchCase());
        }
        this.parseExpressions(comparisonOpsType.getExpressionArray(), comparisonFilter);
        return comparisonFilter;
    }

    private void parseExpressions(XmlObject[] expressionArray, ComparisonFilter comparisonFilter) throws DecodingException {
        for (XmlObject xmlObject : expressionArray) {
            if (this.isValueReferenceExpression(xmlObject)) {
                try {
                    comparisonFilter.setValueReference(this.parseValueReference(xmlObject));
                    continue;
                }
                catch (XmlException xmle) {
                    throw FesDecoderv20.valueReferenceParsingException(xmle);
                }
            }
            if (!(xmlObject instanceof LiteralType)) continue;
            comparisonFilter.setValue(this.parseLiteralValue((LiteralType)xmlObject));
        }
    }

    private String parseLiteralValue(LiteralType literalType) {
        return literalType.getDomNode().getFirstChild().getNodeValue();
    }

    private boolean isValueReferenceExpression(XmlObject xmlObject) {
        return "ValueReference".equals(XmlHelper.getLocalName((XmlObject)xmlObject));
    }

    private String parseValueReference(XmlObject xmlObject) throws XmlException {
        ValueReferenceDocument valueRefernece = ValueReferenceDocument.Factory.parse((Node)xmlObject.getDomNode());
        return valueRefernece.getValueReference().trim();
    }

    private ComparisonFilter parsePropertyIsLikeFilter(PropertyIsLikeType comparisonOpsType) throws DecodingException {
        ComparisonFilter comparisonFilter = new ComparisonFilter();
        comparisonFilter.setOperator(FilterConstants.ComparisonOperator.PropertyIsLike);
        comparisonFilter.setEscapeString(comparisonOpsType.getEscapeChar());
        comparisonFilter.setSingleChar(comparisonOpsType.getSingleChar());
        comparisonFilter.setWildCard(comparisonOpsType.getWildCard());
        this.parseExpressions(comparisonOpsType.getExpressionArray(), comparisonFilter);
        return comparisonFilter;
    }

    private ComparisonFilter parsePropertyIsNullFilter(PropertyIsNullType comparisonOpsType) throws DecodingException {
        throw new UnsupportedDecoderXmlInputException((Decoder<?, ?>)this, (XmlObject)comparisonOpsType);
    }

    private ComparisonFilter parsePropertyIsNilFilter(PropertyIsNilType comparisonOpsType) throws DecodingException {
        throw new UnsupportedDecoderXmlInputException((Decoder<?, ?>)this, (XmlObject)comparisonOpsType);
    }

    private ComparisonFilter parsePropertyIsBetweenFilter(PropertyIsBetweenType comparisonOpsType) throws DecodingException {
        ComparisonFilter comparisonFilter = new ComparisonFilter();
        comparisonFilter.setOperator(FilterConstants.ComparisonOperator.PropertyIsBetween);
        try {
            comparisonFilter.setValueReference(this.parseValueReference(comparisonOpsType.getExpression()));
        }
        catch (XmlException xmle) {
            throw FesDecoderv20.valueReferenceParsingException(xmle);
        }
        if (comparisonOpsType.getLowerBoundary().getExpression() instanceof LiteralType) {
            comparisonFilter.setValue(this.parseLiteralValue((LiteralType)comparisonOpsType.getLowerBoundary().getExpression()));
        }
        if (comparisonOpsType.getUpperBoundary().getExpression() instanceof LiteralType) {
            comparisonFilter.setValueUpper(this.parseLiteralValue((LiteralType)comparisonOpsType.getUpperBoundary().getExpression()));
        }
        return comparisonFilter;
    }

    private Filter<?> parseLogicFilterType(LogicOpsType logicOpsType) throws DecodingException {
        if (logicOpsType instanceof UnaryLogicOpType) {
            return this.parseUnaryLogicalFilter((UnaryLogicOpType)logicOpsType);
        }
        if (logicOpsType instanceof BinaryLogicOpType) {
            return this.parseBinaryLogicalFilter((BinaryLogicOpType)logicOpsType);
        }
        throw new UnsupportedDecoderXmlInputException((Decoder<?, ?>)this, (XmlObject)logicOpsType);
    }

    private UnaryLogicFilter parseUnaryLogicalFilter(UnaryLogicOpType unaryLogicOpType) throws DecodingException {
        if (unaryLogicOpType.isSetComparisonOps()) {
            return new UnaryLogicFilter((Filter)this.parseComparisonFilterType(unaryLogicOpType.getComparisonOps()));
        }
        if (unaryLogicOpType.isSetSpatialOps()) {
            return new UnaryLogicFilter((Filter)this.parseSpatialFilterType(unaryLogicOpType.getSpatialOps()));
        }
        if (unaryLogicOpType.isSetTemporalOps()) {
            return new UnaryLogicFilter((Filter)this.parseTemporalFilterType(unaryLogicOpType.getTemporalOps()));
        }
        if (unaryLogicOpType.isSetLogicOps()) {
            return new UnaryLogicFilter(this.parseLogicFilterType(unaryLogicOpType.getLogicOps()));
        }
        if (unaryLogicOpType.isSetFunction()) {
            throw new UnsupportedDecoderXmlInputException((Decoder<?, ?>)this, (XmlObject)unaryLogicOpType);
        }
        if (unaryLogicOpType.getIdArray() != null) {
            throw new UnsupportedDecoderXmlInputException((Decoder<?, ?>)this, (XmlObject)unaryLogicOpType);
        }
        throw new UnsupportedDecoderXmlInputException((Decoder<?, ?>)this, (XmlObject)unaryLogicOpType);
    }

    private BinaryLogicFilter parseBinaryLogicalFilter(BinaryLogicOpType binaryLogicOpType) throws DecodingException {
        BinaryLogicFilter binaryLogicFilter = null;
        String localName = XmlHelper.getLocalName((XmlObject)binaryLogicOpType);
        if (localName.equals(FilterConstants.BinaryLogicOperator.And.name())) {
            binaryLogicFilter = new BinaryLogicFilter(FilterConstants.BinaryLogicOperator.And);
        } else if (localName.equals(FilterConstants.BinaryLogicOperator.Or.name())) {
            binaryLogicFilter = new BinaryLogicFilter(FilterConstants.BinaryLogicOperator.Or);
        } else {
            throw new UnsupportedDecoderXmlInputException((Decoder<?, ?>)this, (XmlObject)binaryLogicOpType);
        }
        Set<Filter<?>> filters = this.getFilterPredicates(binaryLogicOpType);
        if (filters.size() < 2) {
            throw new DecodingException("The binary logic filter requires minimla two filter predicates!", new Object[0]);
        }
        binaryLogicFilter.addFilterPredicates(filters);
        return binaryLogicFilter;
    }

    private Set<Filter<?>> getFilterPredicates(BinaryLogicOpType binaryLogicOpType) throws DecodingException {
        HashSet filters = Sets.newHashSet();
        if (CollectionHelper.isNotNullOrEmpty((Object[])binaryLogicOpType.getComparisonOpsArray())) {
            filters.addAll(this.parseComparisonFilterArray(binaryLogicOpType.getComparisonOpsArray()));
        }
        if (CollectionHelper.isNotNullOrEmpty((Object[])binaryLogicOpType.getLogicOpsArray())) {
            filters.addAll(this.parseLogicFilterArray(binaryLogicOpType.getLogicOpsArray()));
        }
        if (CollectionHelper.isNotNullOrEmpty((Object[])binaryLogicOpType.getSpatialOpsArray())) {
            filters.addAll(this.parseSpatialFilterArray(binaryLogicOpType.getSpatialOpsArray()));
        }
        if (CollectionHelper.isNotNullOrEmpty((Object[])binaryLogicOpType.getTemporalOpsArray())) {
            filters.addAll(this.parseTemporalFilterArray(binaryLogicOpType.getTemporalOpsArray()));
        }
        if (CollectionHelper.isNotNullOrEmpty((Object[])binaryLogicOpType.getExtensionOpsArray())) {
            throw new UnsupportedDecoderXmlInputException((Decoder<?, ?>)this, (XmlObject)binaryLogicOpType);
        }
        if (CollectionHelper.isNotNullOrEmpty((Object[])binaryLogicOpType.getFunctionArray())) {
            throw new UnsupportedDecoderXmlInputException((Decoder<?, ?>)this, (XmlObject)binaryLogicOpType);
        }
        if (CollectionHelper.isNotNullOrEmpty((Object[])binaryLogicOpType.getIdArray())) {
            throw new UnsupportedDecoderXmlInputException((Decoder<?, ?>)this, (XmlObject)binaryLogicOpType);
        }
        return filters;
    }

    private Collection<? extends Filter<?>> parseComparisonFilterArray(ComparisonOpsType[] comparisonOpsArray) throws DecodingException {
        HashSet filters = Sets.newHashSet();
        for (ComparisonOpsType comparisonOpsType : comparisonOpsArray) {
            filters.add(this.parseComparisonFilterType(comparisonOpsType));
        }
        return filters;
    }

    private Collection<? extends Filter<?>> parseLogicFilterArray(LogicOpsType[] logicOpsArray) throws DecodingException {
        HashSet filters = Sets.newHashSet();
        for (LogicOpsType logicOpsType : logicOpsArray) {
            filters.add(this.parseLogicFilterType(logicOpsType));
        }
        return filters;
    }

    private Collection<? extends Filter<?>> parseSpatialFilterArray(SpatialOpsType[] spatialOpsArray) throws DecodingException {
        HashSet filters = Sets.newHashSet();
        for (SpatialOpsType spatialOpsType : spatialOpsArray) {
            filters.add(this.parseSpatialFilterType(spatialOpsType));
        }
        return filters;
    }

    private Collection<? extends Filter<?>> parseTemporalFilterArray(TemporalOpsType[] temporalOpsArray) throws DecodingException {
        HashSet filters = Sets.newHashSet();
        for (TemporalOpsType temporalOpsType : temporalOpsArray) {
            filters.add(this.parseTemporalFilterType(temporalOpsType));
        }
        return filters;
    }

    private static DecodingException valueReferenceParsingException(XmlException xmle) throws DecodingException {
        return new DecodingException("Error while parsing valueReference element!", (Throwable)xmle);
    }

    private static DecodingException unsupportedTemporalOperator() {
        return new DecodingException((Enum)Sos2Constants.GetObservationParams.temporalFilter, "The requested temporal filter operand is not supported by this SOS!", new Object[0]);
    }
}

