/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import java.util.Collections;
import java.util.Set;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.w3c.xlink.W3CHrefAttribute;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderXmlInputException;
import org.n52.svalbard.util.CodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3.x1999.xlink.HrefAttribute;

public class XlinkDecoderv1999
implements Decoder<Object, XmlObject> {
    private static final Logger LOGGER = LoggerFactory.getLogger(XlinkDecoderv1999.class);
    private static final Set<DecoderKey> DECODER_KEYS = CodingHelper.decoderKeysForElements((String)"http://www.w3.org/1999/xlink", (Class[])new Class[]{HrefAttribute.class});

    public XlinkDecoderv1999() {
        StringBuilder builder = new StringBuilder();
        for (DecoderKey decoderKeyType : DECODER_KEYS) {
            builder.append(decoderKeyType.toString());
            builder.append(", ");
        }
        builder.delete(builder.lastIndexOf(", "), builder.length());
        LOGGER.debug("Decoder for the following keys initialized successfully: " + builder.toString() + "!");
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    public Object decode(XmlObject xmlObject) throws DecodingException {
        if (xmlObject instanceof HrefAttribute) {
            return this.encodeHrefAttribute((HrefAttribute)xmlObject);
        }
        throw new UnsupportedDecoderXmlInputException(this, xmlObject);
    }

    private W3CHrefAttribute encodeHrefAttribute(HrefAttribute xmlObject) {
        W3CHrefAttribute href = new W3CHrefAttribute();
        if (xmlObject.isSetHref()) {
            href.setHref(xmlObject.getHref());
        }
        return href;
    }
}

