/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.opengis.gml.x32.VerticalDatumPropertyType;
import net.opengis.gml.x32.VerticalDatumType;
import net.opengis.om.x20.NamedValueType;
import net.opengis.om.x20.OMObservationDocument;
import net.opengis.om.x20.OMObservationType;
import net.opengis.samplingSpatial.x20.SFSpatialSamplingFeatureType;
import net.opengis.samplingSpatial.x20.ShapeType;
import net.opengis.waterml.x20.CollectionDocument;
import net.opengis.waterml.x20.CollectionType;
import net.opengis.waterml.x20.MonitoringPointDocument;
import net.opengis.waterml.x20.MonitoringPointType;
import net.opengis.waterml.x20.ObservationProcessDocument;
import net.opengis.waterml.x20.ObservationProcessType;
import org.apache.xmlbeans.GDuration;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.isotc211.x2005.gmd.CIResponsiblePartyPropertyType;
import org.isotc211.x2005.gmd.CIResponsiblePartyType;
import org.joda.time.DateTime;
import org.n52.janmayen.http.MediaType;
import org.n52.shetland.iso.gmd.CiResponsibleParty;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gml.CodeType;
import org.n52.shetland.ogc.gml.CodeWithAuthority;
import org.n52.shetland.ogc.gml.ReferenceType;
import org.n52.shetland.ogc.gml.VerticalDatum;
import org.n52.shetland.ogc.gml.time.Time;
import org.n52.shetland.ogc.gml.time.TimeInstant;
import org.n52.shetland.ogc.gml.time.TimePeriod;
import org.n52.shetland.ogc.om.NamedValue;
import org.n52.shetland.ogc.om.ObservationStream;
import org.n52.shetland.ogc.om.OmObservation;
import org.n52.shetland.ogc.om.features.FeatureCollection;
import org.n52.shetland.ogc.om.features.samplingFeatures.AbstractSamplingFeature;
import org.n52.shetland.ogc.om.series.wml.ObservationProcess;
import org.n52.shetland.ogc.om.series.wml.WaterMLConstants;
import org.n52.shetland.ogc.om.series.wml.WmlMonitoringPoint;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.sos.response.GetObservationResponse;
import org.n52.shetland.util.CollectionHelper;
import org.n52.shetland.util.DateTimeFormatException;
import org.n52.shetland.util.DateTimeHelper;
import org.n52.shetland.util.JavaHelper;
import org.n52.shetland.w3c.Nillable;
import org.n52.shetland.w3c.xlink.Actuate;
import org.n52.shetland.w3c.xlink.Reference;
import org.n52.shetland.w3c.xlink.Referenceable;
import org.n52.shetland.w3c.xlink.Show;
import org.n52.shetland.w3c.xlink.Type;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.encode.AbstractOmEncoderv20;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.ProcedureEncoder;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3.x1999.xlink.ActuateType;
import org.w3.x1999.xlink.ShowType;
import org.w3.x1999.xlink.TypeType;
import org.w3c.dom.Node;

public abstract class AbstractWmlEncoderv20
extends AbstractOmEncoderv20
implements ProcedureEncoder<XmlObject, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractWmlEncoderv20.class);
    private static final Map<String, ImmutableMap<String, Set<String>>> SUPPORTED_PROCEDURE_DESCRIPTION_FORMATS = ImmutableMap.of((Object)"SOS", (Object)ImmutableMap.builder().put((Object)"2.0.0", (Object)ImmutableSet.of((Object)"http://www.opengis.net/waterml/2.0/observationProcess")).build());
    private static final String PROCESS_ID_PREFIX = "process.";
    private static final String SF_ID_PREFIX = "sf_";
    private static final Set<EncoderKey> DEFAULT_ENCODER_KEYS = CollectionHelper.union((Set[])new Set[]{CodingHelper.encoderKeysForElements((String)"http://www.opengis.net/waterml/2.0", (Class[])new Class[]{AbstractFeature.class}), CodingHelper.encoderKeysForElements((String)"http://www.opengis.net/waterml/2.0/observationProcess", (Class[])new Class[]{ObservationProcess.class})});

    protected static Set<EncoderKey> getDefaultEncoderKeys() {
        return Collections.unmodifiableSet(DEFAULT_ENCODER_KEYS);
    }

    @Override
    protected boolean convertEncodedProcedure() {
        return true;
    }

    public boolean isObservationAndMeasurmentV20Type() {
        return true;
    }

    public boolean shouldObservationsWithSameXBeMerged() {
        return true;
    }

    public Set<String> getSupportedProcedureDescriptionFormats(String service, String version) {
        if (SUPPORTED_PROCEDURE_DESCRIPTION_FORMATS.containsKey(service) && SUPPORTED_PROCEDURE_DESCRIPTION_FORMATS.get(service).containsKey((Object)version)) {
            return (Set)SUPPORTED_PROCEDURE_DESCRIPTION_FORMATS.get(service).get((Object)version);
        }
        return Collections.emptySet();
    }

    @Override
    public MediaType getContentType() {
        return WaterMLConstants.WML_CONTENT_TYPE;
    }

    @Override
    public XmlObject encode(Object element, EncodingContext context) throws EncodingException {
        if (element instanceof ObservationProcess) {
            return this.createObservationProcess((ObservationProcess)element, context);
        }
        if (element instanceof OmObservation) {
            return super.encode(element, context);
        }
        if (element instanceof AbstractFeature) {
            return this.encodeAbstractFeature((AbstractFeature)element, context);
        }
        return super.encode(element, context);
    }

    private XmlObject encodeAbstractFeature(AbstractFeature abstractFeature, EncodingContext context) throws UnsupportedEncoderInputException, EncodingException {
        if (abstractFeature instanceof OmObservation) {
            return super.encode(abstractFeature, context);
        }
        return this.createMonitoringPoint(abstractFeature);
    }

    @Override
    public String getDefaultFeatureEncodingNamespace() {
        return "http://www.opengis.net/waterml/2.0";
    }

    @Override
    protected String getDefaultProcedureEncodingNamspace() {
        return "http://www.opengis.net/waterml/2.0/observationProcess";
    }

    @Override
    public void addNamespacePrefixToMap(Map<String, String> nameSpacePrefixMap) {
        super.addNamespacePrefixToMap(nameSpacePrefixMap);
        nameSpacePrefixMap.put("http://www.opengis.net/waterml/2.0", "wml2");
    }

    @Override
    protected void addAddtitionalInformation(OMObservationType omot, OmObservation observation) throws EncodingException {
    }

    protected XmlObject createWmlGetObservationResponse(GetObservationResponse getObservationResonse) throws EncodingException {
        HashMap gmlID4sfIdentifier = Maps.newHashMap();
        int sfIdCounter = 1;
        try {
            if (getObservationResonse.getObservationCollection() != null && !getObservationResonse.getObservationCollection().hasNext()) {
                ObservationStream observations = getObservationResonse.getObservationCollection();
                OmObservation observation = (OmObservation)observations.next();
                if (!observations.hasNext()) {
                    OMObservationDocument omObservationDoc = OMObservationDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
                    omObservationDoc.setOMObservation(this.encodeObservation(observation, gmlID4sfIdentifier, sfIdCounter));
                    ++sfIdCounter;
                    return omObservationDoc;
                }
                CollectionDocument xmlCollectionDoc = CollectionDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
                CollectionType wmlCollection = xmlCollectionDoc.addNewCollection();
                wmlCollection.addNewObservationMember().setOMObservation(this.encodeObservation(observation, gmlID4sfIdentifier, sfIdCounter));
                ++sfIdCounter;
                while (observations.hasNext()) {
                    wmlCollection.addNewObservationMember().setOMObservation(this.encodeObservation((OmObservation)observations.next(), gmlID4sfIdentifier, sfIdCounter));
                    ++sfIdCounter;
                }
                return xmlCollectionDoc;
            }
            throw new EncodingException("Combination does not exists!", new Object[0]);
        }
        catch (NoSuchElementException | OwsExceptionReport e) {
            throw new EncodingException(e);
        }
    }

    private OMObservationType encodeObservation(OmObservation observation, Map<CodeWithAuthority, String> gmlID4sfIdentifier, int sfIdCounter) throws EncodingException {
        EncodingContext foiContext;
        if (gmlID4sfIdentifier.containsKey(observation.getObservationConstellation().getFeatureOfInterest().getIdentifierCodeWithAuthority())) {
            String gmlId = gmlID4sfIdentifier.get(observation.getObservationConstellation().getFeatureOfInterest().getIdentifierCodeWithAuthority());
            foiContext = EncodingContext.of((Enum)XmlBeansEncodingFlags.EXIST_FOI_IN_DOC, (Object)true).with((Enum)XmlBeansEncodingFlags.GMLID, (Object)gmlId);
        } else {
            String gmlId = SF_ID_PREFIX + sfIdCounter;
            gmlID4sfIdentifier.put(observation.getObservationConstellation().getFeatureOfInterest().getIdentifierCodeWithAuthority(), gmlId);
            foiContext = EncodingContext.of((Enum)XmlBeansEncodingFlags.EXIST_FOI_IN_DOC, (Object)Boolean.toString(false)).with((Enum)XmlBeansEncodingFlags.GMLID, (Object)gmlId);
        }
        return (OMObservationType)this.encodeOmObservation(observation, foiContext);
    }

    protected XmlObject createMonitoringPoint(AbstractFeature absFeature) throws EncodingException {
        if (absFeature instanceof AbstractSamplingFeature) {
            Object xmlObject;
            AbstractSamplingFeature sampFeat = (AbstractSamplingFeature)absFeature;
            StringBuilder builder = new StringBuilder();
            builder.append("mp_");
            builder.append(JavaHelper.generateID((String)absFeature.getIdentifierCodeWithAuthority().getValue()));
            absFeature.setGmlId(builder.toString());
            MonitoringPointDocument monitoringPointDoc = MonitoringPointDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
            if (sampFeat.isSetXml()) {
                try {
                    XmlObject feature = XmlObject.Factory.parse((String)sampFeat.getXml());
                    if (XmlHelper.getNamespace((XmlObject)feature).equals("http://www.opengis.net/waterml/2.0")) {
                        if (feature instanceof MonitoringPointDocument) {
                            monitoringPointDoc = (MonitoringPointDocument)feature;
                        } else if (feature instanceof MonitoringPointType) {
                            monitoringPointDoc.setSFSpatialSamplingFeature((SFSpatialSamplingFeatureType)((MonitoringPointType)feature));
                        }
                        XmlHelper.updateGmlIDs((Node)monitoringPointDoc.getDomNode(), (String)absFeature.getGmlId(), null);
                        return monitoringPointDoc;
                    }
                }
                catch (XmlException xmle) {
                    throw new EncodingException("Error while encoding GetFeatureOfInterest response, invalid samplingFeature description!", (Throwable)xmle);
                }
            }
            MonitoringPointType mpt = monitoringPointDoc.addNewMonitoringPoint();
            mpt.setId(absFeature.getGmlId());
            if (sampFeat.isSetIdentifier() && (xmlObject = this.encodeGML(sampFeat.getIdentifierCodeWithAuthority())) != null) {
                mpt.addNewIdentifier().set((XmlObject)xmlObject);
            }
            if (sampFeat.isSetName()) {
                for (Object sosName : sampFeat.getName()) {
                    mpt.addNewName().set(this.encodeGML(sosName));
                }
            }
            if (sampFeat.isSetDescription()) {
                if (!mpt.isSetDescription()) {
                    mpt.addNewDescription();
                }
                mpt.getDescription().setStringValue(sampFeat.getDescription());
            }
            if (sampFeat.getSampledFeatures() != null && !sampFeat.getSampledFeatures().isEmpty()) {
                if (sampFeat.getSampledFeatures().size() == 1) {
                    XmlObject encodeObjectToXml = this.encodeObjectToXml("http://www.opengis.net/gml/3.2", sampFeat.getSampledFeatures().get(0));
                    mpt.addNewSampledFeature().set(encodeObjectToXml);
                } else {
                    FeatureCollection featureCollection = new FeatureCollection();
                    featureCollection.setGmlId("sampledFeatures_" + absFeature.getGmlId());
                    for (AbstractFeature sampledFeature : sampFeat.getSampledFeatures()) {
                        featureCollection.addMember(sampledFeature);
                    }
                    XmlObject encodeObjectToXml = this.encodeGML(featureCollection);
                    mpt.addNewSampledFeature().set(encodeObjectToXml);
                }
            } else {
                mpt.addNewSampledFeature().setHref("urn:ogc:def:nil:OGC:unknown");
            }
            if (sampFeat.isSetParameter()) {
                this.addParameter(mpt, sampFeat);
            }
            ShapeType xbShape = mpt.addNewShape();
            Encoder encoder = this.getEncoder(this.getEncoderKey("http://www.opengis.net/gml/3.2", sampFeat.getGeometry()), new EncoderKey[0]);
            if (encoder == null) {
                throw new EncodingException("Error while encoding geometry for feature, needed encoder is missing!", new Object[0]);
            }
            XmlObject xmlObject2 = (XmlObject)encoder.encode((Object)sampFeat.getGeometry(), new EncodingContext().with((Enum)XmlBeansEncodingFlags.GMLID, (Object)absFeature.getGmlId()));
            xbShape.addNewAbstractGeometry().set(xmlObject2);
            XmlHelper.substituteElement((XmlObject)xbShape.getAbstractGeometry(), (XmlObject)xmlObject2);
            if (absFeature instanceof WmlMonitoringPoint) {
                this.addMonitoringPointValues(mpt, (WmlMonitoringPoint)absFeature);
            }
            sampFeat.wasEncoded();
            return monitoringPointDoc;
        }
        throw new UnsupportedEncoderInputException((Encoder)this, (Object)absFeature);
    }

    protected ObservationProcessDocument createObservationProcess(ObservationProcess procedure, EncodingContext context) throws EncodingException {
        ObservationProcessDocument encodedObject = null;
        try {
            if (procedure.isSetXml()) {
                encodedObject = XmlObject.Factory.parse((String)procedure.getXml());
                this.checkAndAddIdentifier(procedure, encodedObject.getObservationProcess());
            } else {
                encodedObject = ObservationProcessDocument.Factory.newInstance();
                ObservationProcessType observationProcess = encodedObject.addNewObservationProcess();
                if (context.has((Enum)XmlBeansEncodingFlags.GMLID)) {
                    observationProcess.setId(PROCESS_ID_PREFIX + context.get((Enum)XmlBeansEncodingFlags.GMLID));
                } else {
                    observationProcess.setId(PROCESS_ID_PREFIX + JavaHelper.generateID((String)procedure.toString()));
                }
                if (procedure.isSetIdentifier()) {
                    observationProcess.addNewIdentifier().set(this.encodeGML(procedure.getIdentifierCodeWithAuthority()));
                }
                if (procedure.isSetName()) {
                    for (CodeType sosName : procedure.getName()) {
                        observationProcess.addNewName().set(this.encodeGML(sosName));
                    }
                }
                this.addProcessType(observationProcess, procedure);
                this.addOriginatingProcess(observationProcess, procedure);
                this.addAggregatingDuration(observationProcess, procedure);
                this.addVerticalDatum(observationProcess, procedure);
                this.addComment(observationProcess, procedure);
                this.addProcessReference(observationProcess, procedure);
                this.addInput(observationProcess, procedure);
                this.addParameter(observationProcess, procedure);
            }
        }
        catch (XmlException xmle) {
            throw new EncodingException((Throwable)xmle);
        }
        try {
            LOGGER.debug("Encoded object {} is valid: {}", (Object)encodedObject.schemaType().toString(), (Object)XmlHelper.validateDocument((XmlObject)encodedObject));
        }
        catch (DecodingException e) {
            throw new EncodingException((Throwable)e);
        }
        return encodedObject;
    }

    private void checkAndAddIdentifier(ObservationProcess op, ObservationProcessType opt) throws EncodingException {
        if (op.isSetIdentifier() && !opt.isSetIdentifier()) {
            CodeWithAuthority codeWithAuthority = op.getIdentifierCodeWithAuthority();
            Encoder encoder = this.getEncoder(this.getEncoderKey("http://www.opengis.net/gml/3.2", codeWithAuthority), new EncoderKey[0]);
            if (encoder != null) {
                XmlObject xmlObject = (XmlObject)encoder.encode((Object)codeWithAuthority);
                opt.addNewIdentifier().set(xmlObject);
            } else {
                throw new EncodingException("Error while encoding geometry value, needed encoder is missing!", new Object[0]);
            }
        }
    }

    private void addProcessType(ObservationProcessType observationProcess, ObservationProcess procedure) throws EncodingException {
        if (procedure.isSetProcessType() && procedure.getProcessType().isSetHref()) {
            XmlObject referenceType = this.encodeReferenceType(procedure.getProcessType());
            if (referenceType != null) {
                observationProcess.addNewProcessType().set(referenceType);
            }
        } else {
            throw new EncodingException("Missing processType definition", new Object[0]);
        }
    }

    private void addOriginatingProcess(ObservationProcessType observationProcess, ObservationProcess procedure) throws EncodingException {
        XmlObject referenceType;
        if (procedure.isSetOriginatingProcess() && (referenceType = this.encodeReferenceType(procedure.getOriginatingProcess())) != null) {
            observationProcess.addNewOriginatingProcess().set(referenceType);
        }
    }

    private void addAggregatingDuration(ObservationProcessType observationProcess, ObservationProcess procedure) {
        if (procedure.isSetAggregationDuration()) {
            observationProcess.setAggregationDuration(new GDuration((CharSequence)procedure.getAggregationDuration()));
        }
    }

    private void addVerticalDatum(ObservationProcessType observationProcess, ObservationProcess procedure) throws EncodingException {
        XmlObject referenceType;
        if (procedure.isSetVerticalDatum() && (referenceType = this.encodeReferenceType(procedure.getVerticalDatum())) != null) {
            observationProcess.addNewVerticalDatum().set(referenceType);
        }
    }

    private void addVerticalDatum(MonitoringPointType mpt, List<Referenceable<VerticalDatum>> verticalDatums) throws EncodingException {
        for (Referenceable<VerticalDatum> verticalDatum : verticalDatums) {
            VerticalDatumPropertyType vdpt = mpt.addNewVerticalDatum();
            if (verticalDatum.isReference()) {
                Reference reference = verticalDatum.getReference();
                reference.getActuate().map(Actuate::toString).map(ActuateType.Enum::forString).ifPresent(arg_0 -> ((VerticalDatumPropertyType)vdpt).setActuate(arg_0));
                reference.getArcrole().ifPresent(arg_0 -> ((VerticalDatumPropertyType)vdpt).setArcrole(arg_0));
                reference.getHref().map(URI::toString).ifPresent(arg_0 -> ((VerticalDatumPropertyType)vdpt).setHref(arg_0));
                reference.getRole().ifPresent(arg_0 -> ((VerticalDatumPropertyType)vdpt).setRole(arg_0));
                reference.getShow().map(Show::toString).map(ShowType.Enum::forString).ifPresent(arg_0 -> ((VerticalDatumPropertyType)vdpt).setShow(arg_0));
                reference.getTitle().ifPresent(arg_0 -> ((VerticalDatumPropertyType)vdpt).setTitle(arg_0));
                reference.getType().map(Type::toString).map(TypeType.Enum::forString).ifPresent(arg_0 -> ((VerticalDatumPropertyType)vdpt).setType(arg_0));
                continue;
            }
            if (!verticalDatum.isInstance()) continue;
            Nillable nillable = verticalDatum.getInstance();
            if (nillable.isPresent()) {
                XmlObject xml = this.encodeGML(nillable.get());
                if (xml != null && xml instanceof VerticalDatumType) {
                    vdpt.setVerticalDatum((VerticalDatumType)xml);
                    continue;
                }
                vdpt.setNil();
                vdpt.setNilReason(Nillable.missing().get());
                continue;
            }
            vdpt.setNil();
            if (nillable.hasReason()) {
                vdpt.setNilReason(nillable.getNilReason().get());
                continue;
            }
            vdpt.setNilReason(Nillable.missing().get());
        }
    }

    private void addComment(ObservationProcessType observationProcess, ObservationProcess procedure) {
        if (procedure.isSetComments()) {
            for (String comment : procedure.getComments()) {
                if (comment == null || comment.isEmpty()) continue;
                observationProcess.addComment(comment);
            }
        }
    }

    private void addProcessReference(ObservationProcessType observationProcess, ObservationProcess procedure) throws EncodingException {
        XmlObject referenceType;
        if (procedure.isSetProcessReference() && (referenceType = this.encodeReferenceType(procedure.getProcessReference())) != null) {
            observationProcess.addNewProcessReference().set(referenceType);
        }
    }

    private void addInput(ObservationProcessType observationProcess, ObservationProcess procedure) throws EncodingException {
        if (procedure.isSetInputs()) {
            for (ReferenceType sosReferenceType : procedure.getInputs()) {
                XmlObject referenceType = this.encodeReferenceType(sosReferenceType);
                if (referenceType == null) continue;
                observationProcess.addNewInput().set(referenceType);
            }
        }
    }

    private void addParameter(ObservationProcessType observationProcess, ObservationProcess procedure) throws EncodingException {
        if (procedure.isSetParameters()) {
            List parameters = procedure.getParameters();
            for (NamedValue sosNamedValue : parameters) {
                NamedValueType namedValue = this.createNamedValue(sosNamedValue);
                if (namedValue == null) continue;
                observationProcess.addNewParameter().addNewNamedValue().set((XmlObject)namedValue);
            }
        }
    }

    private void addParameter(MonitoringPointType monitoringPoint, AbstractSamplingFeature sampFeat) throws EncodingException {
        for (NamedValue namedValue : sampFeat.getParameters()) {
            NamedValueType encodeObjectToXml = this.createNamedValue(namedValue);
            if (encodeObjectToXml == null) continue;
            monitoringPoint.addNewParameter().addNewNamedValue().set((XmlObject)encodeObjectToXml);
        }
    }

    private XmlObject encodeReferenceType(ReferenceType sosReferenceType) throws EncodingException {
        Encoder encoder = this.getEncoder(this.getEncoderKey("http://www.opengis.net/gml/3.2", sosReferenceType), new EncoderKey[0]);
        if (encoder != null) {
            return (XmlObject)encoder.encode((Object)sosReferenceType);
        }
        throw new EncodingException("Error while encoding referenceType, needed encoder is missing!", new Object[0]);
    }

    protected String getTimeString(Time time) throws DateTimeFormatException {
        DateTime dateTime = this.getTime(time);
        return DateTimeHelper.formatDateTime2String((DateTime)dateTime, (Time.TimeFormat)time.getTimeFormat());
    }

    private DateTime getTime(Time time) {
        if (time instanceof TimeInstant) {
            return ((TimeInstant)time).getValue();
        }
        if (time instanceof TimePeriod) {
            TimePeriod timePeriod = (TimePeriod)time;
            if (timePeriod.getEnd() != null) {
                return timePeriod.getEnd();
            }
            return timePeriod.getStart();
        }
        return new DateTime().minusYears(1000);
    }

    private void addMonitoringPointValues(MonitoringPointType mpt, WmlMonitoringPoint monitoringPoint) throws EncodingException {
        if (monitoringPoint.hasRelatedParty()) {
            this.addRelatedParty(mpt, monitoringPoint.getRelatedParty());
        }
        if (monitoringPoint.hasMonitoringType()) {
            this.addMonitoringType(mpt, monitoringPoint.getMonitoringType());
        }
        if (monitoringPoint.hasDescriptionReference()) {
            this.addDescriptionReference(mpt, monitoringPoint.getDescriptionReference());
        }
        if (monitoringPoint.hasVerticalDatum()) {
            this.addVerticalDatum(mpt, monitoringPoint.getVerticalDatum());
        }
    }

    private void addRelatedParty(MonitoringPointType mpt, List<Referenceable<CiResponsibleParty>> relatedParties) throws EncodingException {
        for (Referenceable<CiResponsibleParty> relatedParty : relatedParties) {
            CIResponsiblePartyPropertyType citppt = mpt.addNewRelatedParty();
            if (relatedParty.isReference()) {
                Reference reference = relatedParty.getReference();
                reference.getActuate().map(Actuate::toString).map(ActuateType.Enum::forString).ifPresent(arg_0 -> ((CIResponsiblePartyPropertyType)citppt).setActuate(arg_0));
                reference.getArcrole().ifPresent(arg_0 -> ((CIResponsiblePartyPropertyType)citppt).setArcrole(arg_0));
                reference.getHref().map(URI::toString).ifPresent(arg_0 -> ((CIResponsiblePartyPropertyType)citppt).setHref(arg_0));
                reference.getRole().ifPresent(arg_0 -> ((CIResponsiblePartyPropertyType)citppt).setRole(arg_0));
                reference.getShow().map(Show::toString).map(ShowType.Enum::forString).ifPresent(arg_0 -> ((CIResponsiblePartyPropertyType)citppt).setShow(arg_0));
                reference.getTitle().ifPresent(arg_0 -> ((CIResponsiblePartyPropertyType)citppt).setTitle(arg_0));
                reference.getType().map(Type::toString).map(TypeType.Enum::forString).ifPresent(arg_0 -> ((CIResponsiblePartyPropertyType)citppt).setType(arg_0));
                continue;
            }
            if (!relatedParty.isInstance()) continue;
            Nillable nillable = relatedParty.getInstance();
            if (nillable.isPresent()) {
                XmlObject xml = this.encodeObjectToXml(((CiResponsibleParty)nillable.get()).getDefaultElementEncoding(), nillable.get());
                if (xml != null && xml instanceof CIResponsiblePartyType) {
                    citppt.setCIResponsibleParty((CIResponsiblePartyType)xml);
                    continue;
                }
                citppt.setNil();
                citppt.setNilReason(Nillable.missing().get());
                continue;
            }
            citppt.setNil();
            if (nillable.hasReason()) {
                citppt.setNilReason(nillable.getNilReason().get());
                continue;
            }
            citppt.setNilReason(Nillable.missing().get());
        }
    }

    private void addMonitoringType(MonitoringPointType mpt, List<ReferenceType> monitoringType) throws EncodingException {
        for (ReferenceType referenceType : monitoringType) {
            mpt.addNewMonitoringType().set(this.encodeGML(referenceType));
        }
    }

    private void addDescriptionReference(MonitoringPointType mpt, List<ReferenceType> descriptionReference) throws EncodingException {
        for (ReferenceType referenceType : descriptionReference) {
            mpt.addNewDescriptionReference2().set(this.encodeGML(referenceType));
        }
    }
}

