/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import net.opengis.om.x20.OMObservationType;
import org.n52.janmayen.http.MediaType;
import org.n52.shetland.ogc.SupportedType;
import org.n52.shetland.ogc.gwml.GWMLConstants;
import org.n52.shetland.ogc.om.MultiObservationValues;
import org.n52.shetland.ogc.om.NamedValue;
import org.n52.shetland.ogc.om.ObservationType;
import org.n52.shetland.ogc.om.OmConstants;
import org.n52.shetland.ogc.om.OmObservation;
import org.n52.shetland.ogc.om.SingleObservationValue;
import org.n52.shetland.util.CollectionHelper;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.EncoderFlags;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.OmEncoderv20;
import org.n52.svalbard.encode.XmlEncoderFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.write.GwmlV22XmlStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GwmlEncoderv22
extends OmEncoderv20 {
    private static final Logger LOGGER = LoggerFactory.getLogger(GwmlEncoderv22.class);
    private static final Set<EncoderKey> ENCODER_KEYS = CollectionHelper.union((Set[])new Set[]{CodingHelper.encoderKeysForElements((String)"http://www.opengis.net/gwml/2.2", (Class[])new Class[]{OmObservation.class, NamedValue.class, SingleObservationValue.class, MultiObservationValues.class}), CodingHelper.encoderKeysForElements((String)"http://www.opengis.net/gwml-well/2.2", (Class[])new Class[]{OmObservation.class, NamedValue.class, SingleObservationValue.class, MultiObservationValues.class})});
    private static final Set<SupportedType> SUPPORTED_TYPES = Sets.newHashSet((Object[])new SupportedType[]{new ObservationType("http://www.opengis.net/def/observationType/OGC-GWML/2.2/GW_GeologyLog"), new ObservationType("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_ProfileObservation")});
    private static final Map<String, Map<String, Set<String>>> SUPPORTED_RESPONSE_FORMATS = Collections.singletonMap("SOS", Collections.singletonMap("2.0.0", Collections.singleton("http://www.opengis.net/gwml/2.2")));

    public GwmlEncoderv22() {
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(ENCODER_KEYS));
    }

    @Override
    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEYS);
    }

    @Override
    public Set<SupportedType> getSupportedTypes() {
        return Collections.unmodifiableSet(SUPPORTED_TYPES);
    }

    @Override
    public Map<String, Set<SupportedType>> getSupportedResponseFormatObservationTypes() {
        return Collections.singletonMap("http://www.opengis.net/gwml/2.2", this.getSupportedTypes());
    }

    @Override
    public boolean isObservationAndMeasurmentV20Type() {
        return true;
    }

    @Override
    public Set<String> getSupportedResponseFormats(String service, String version) {
        if (SUPPORTED_RESPONSE_FORMATS.get(service) != null && SUPPORTED_RESPONSE_FORMATS.get(service).get(version) != null) {
            return SUPPORTED_RESPONSE_FORMATS.get(service).get(version);
        }
        return new HashSet<String>(0);
    }

    @Override
    public boolean shouldObservationsWithSameXBeMerged() {
        return false;
    }

    @Override
    public boolean supportsResultStreamingForMergedValues() {
        return false;
    }

    @Override
    public MediaType getContentType() {
        return OmConstants.CONTENT_TYPE_OM_2;
    }

    @Override
    public Set<SchemaLocation> getSchemaLocations() {
        HashSet schemaLocations = Sets.newHashSet((Object[])new SchemaLocation[]{GWMLConstants.GWML_22_SCHEMA_LOCATION, GWMLConstants.GWML_WELL_22_SCHEMA_LOCATION});
        schemaLocations.addAll(super.getSchemaLocations());
        return schemaLocations;
    }

    @Override
    protected OMObservationType createOmObservationType() {
        return super.createOmObservationType();
    }

    @Override
    public void encode(Object objectToEncode, OutputStream outputStream, EncodingContext context) throws EncodingException {
        if (objectToEncode instanceof OmObservation) {
            try {
                new GwmlV22XmlStreamWriter(EncodingContext.of((Enum)EncoderFlags.ENCODER_REPOSITORY, (Object)this.getEncoderRepository()).with((Enum)XmlEncoderFlags.XML_OPTIONS, this::getXmlOptions), outputStream, (OmObservation)objectToEncode).write();
            }
            catch (XMLStreamException xmlse) {
                throw new EncodingException("Error while writing element to stream!", (Throwable)xmlse);
            }
        } else {
            super.encode(objectToEncode, outputStream, context);
        }
    }
}

