/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.n52.janmayen.http.MediaType;
import org.n52.janmayen.http.MediaTypes;
import org.n52.shetland.inspire.InspireConstants;
import org.n52.shetland.inspire.InspireObject;
import org.n52.shetland.inspire.InspireSupportedCRS;
import org.n52.shetland.inspire.InspireSupportedLanguages;
import org.n52.shetland.inspire.InspireUniqueResourceIdentifier;
import org.n52.shetland.inspire.dls.FullInspireExtendedCapabilities;
import org.n52.shetland.inspire.dls.InspireExtendedCapabilities;
import org.n52.shetland.inspire.dls.MinimalInspireExtendedCapabilities;
import org.n52.shetland.ogc.swes.SwesExtension;
import org.n52.shetland.util.DateTimeFormatException;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.AbstractXmlEncoder;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderFlags;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.XmlEncoderFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.write.InspireXmlStreamWriter;

public class InspireXmlEncoder
extends AbstractXmlEncoder<XmlObject, Object> {
    private static final Set<EncoderKey> ENCODER_KEYS = Sets.union((Set)CodingHelper.encoderKeysForElements((String)"http://inspire.ec.europa.eu/schemas/inspire_dls/1.0", (Class[])new Class[]{InspireExtendedCapabilities.class}), (Set)CodingHelper.encoderKeysForElements((String)"http://inspire.ec.europa.eu/schemas/common/1.0", (Class[])new Class[]{SwesExtension.class, InspireSupportedLanguages.class, InspireSupportedCRS.class}));

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEYS);
    }

    @Override
    public XmlObject encode(Object objectToEncode) throws EncodingException {
        return this.encode(objectToEncode, EncodingContext.empty());
    }

    public XmlObject encode(Object objectToEncode, EncodingContext ctx) throws EncodingException {
        SwesExtension swesExtension;
        if (objectToEncode instanceof InspireObject) {
            return this.encodeObject((InspireObject)objectToEncode, ctx);
        }
        if (objectToEncode instanceof SwesExtension && (swesExtension = (SwesExtension)objectToEncode).getValue() instanceof InspireObject) {
            return this.encodeObject((InspireObject)swesExtension.getValue(), ctx);
        }
        throw new UnsupportedEncoderInputException((Encoder)this, objectToEncode);
    }

    private XmlObject encodeObject(InspireObject objectToEncode, EncodingContext ctx) throws EncodingException {
        try {
            this.checkIfSupported(objectToEncode);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            EncodingContext context = ctx.with((Enum)EncoderFlags.ENCODER_REPOSITORY, (Object)this.getEncoderRepository()).with((Enum)XmlEncoderFlags.XML_OPTIONS, this::getXmlOptions);
            new InspireXmlStreamWriter(context, (OutputStream)out, objectToEncode).write();
            String s = out.toString("UTF8");
            return XmlObject.Factory.parse((String)s);
        }
        catch (UnsupportedEncodingException | XMLStreamException | XmlException | DateTimeFormatException ex) {
            throw new EncodingException("Error encoding Inspire extended capabilities!", ex);
        }
    }

    private void checkIfSupported(InspireObject objectToEncode) throws EncodingException {
        if (!(objectToEncode instanceof InspireSupportedLanguages || objectToEncode instanceof InspireSupportedCRS || objectToEncode instanceof InspireUniqueResourceIdentifier || objectToEncode instanceof FullInspireExtendedCapabilities || objectToEncode instanceof MinimalInspireExtendedCapabilities)) {
            throw new UnsupportedEncoderInputException((Encoder)this, (Object)objectToEncode);
        }
    }

    public Set<SchemaLocation> getSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{InspireConstants.INSPIRE_COMMON_10_SCHEMA_LOCATION, InspireConstants.INSPIRE_DLS_10_SCHEMA_LOCATION});
    }

    public void addNamespacePrefixToMap(Map<String, String> nameSpacePrefixMap) {
        nameSpacePrefixMap.put("http://inspire.ec.europa.eu/schemas/common/1.0", "inspire_common");
        nameSpacePrefixMap.put("http://inspire.ec.europa.eu/schemas/inspire_dls/1.0", "inspire_dls");
    }

    @Override
    public MediaType getContentType() {
        return MediaTypes.TEXT_XML;
    }
}

