/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.xml.namespace.QName;
import net.opengis.gml.PointType;
import net.opengis.sensorML.x101.AbstractProcessType;
import net.opengis.sensorML.x101.CapabilitiesDocument;
import net.opengis.sensorML.x101.CharacteristicsDocument;
import net.opengis.sensorML.x101.ClassificationDocument;
import net.opengis.sensorML.x101.ComponentDocument;
import net.opengis.sensorML.x101.ComponentType;
import net.opengis.sensorML.x101.ComponentsDocument;
import net.opengis.sensorML.x101.ConnectionsDocument;
import net.opengis.sensorML.x101.ContactDocument;
import net.opengis.sensorML.x101.ContactInfoDocument;
import net.opengis.sensorML.x101.ContactListDocument;
import net.opengis.sensorML.x101.DocumentDocument;
import net.opengis.sensorML.x101.DocumentListDocument;
import net.opengis.sensorML.x101.DocumentationDocument;
import net.opengis.sensorML.x101.IdentificationDocument;
import net.opengis.sensorML.x101.InputsDocument;
import net.opengis.sensorML.x101.IoComponentPropertyType;
import net.opengis.sensorML.x101.LinkDocument;
import net.opengis.sensorML.x101.MethodPropertyType;
import net.opengis.sensorML.x101.OutputsDocument;
import net.opengis.sensorML.x101.PersonDocument;
import net.opengis.sensorML.x101.PositionDocument;
import net.opengis.sensorML.x101.ProcessMethodType;
import net.opengis.sensorML.x101.ProcessModelDocument;
import net.opengis.sensorML.x101.ProcessModelType;
import net.opengis.sensorML.x101.ResponsiblePartyDocument;
import net.opengis.sensorML.x101.SensorMLDocument;
import net.opengis.sensorML.x101.SmlLocation;
import net.opengis.sensorML.x101.SystemDocument;
import net.opengis.sensorML.x101.SystemType;
import net.opengis.sensorML.x101.TermDocument;
import net.opengis.swe.x101.AbstractDataComponentType;
import net.opengis.swe.x101.AnyScalarPropertyType;
import net.opengis.swe.x101.DataArrayDocument;
import net.opengis.swe.x101.DataArrayType;
import net.opengis.swe.x101.DataRecordType;
import net.opengis.swe.x101.PositionType;
import net.opengis.swe.x101.SimpleDataRecordType;
import net.opengis.swe.x101.VectorType;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.janmayen.http.MediaType;
import org.n52.shetland.ogc.SupportedType;
import org.n52.shetland.ogc.gml.CodeType;
import org.n52.shetland.ogc.gml.time.Time;
import org.n52.shetland.ogc.gml.time.TimeInstant;
import org.n52.shetland.ogc.gml.time.TimePeriod;
import org.n52.shetland.ogc.sensorML.AbstractProcess;
import org.n52.shetland.ogc.sensorML.AbstractSensorML;
import org.n52.shetland.ogc.sensorML.Component;
import org.n52.shetland.ogc.sensorML.ProcessMethod;
import org.n52.shetland.ogc.sensorML.ProcessModel;
import org.n52.shetland.ogc.sensorML.SensorML;
import org.n52.shetland.ogc.sensorML.SensorMLConstants;
import org.n52.shetland.ogc.sensorML.SmlContact;
import org.n52.shetland.ogc.sensorML.SmlContactList;
import org.n52.shetland.ogc.sensorML.SmlPerson;
import org.n52.shetland.ogc.sensorML.SmlResponsibleParty;
import org.n52.shetland.ogc.sensorML.System;
import org.n52.shetland.ogc.sensorML.elements.AbstractSmlDocumentation;
import org.n52.shetland.ogc.sensorML.elements.SmlCapabilities;
import org.n52.shetland.ogc.sensorML.elements.SmlCharacteristics;
import org.n52.shetland.ogc.sensorML.elements.SmlClassifier;
import org.n52.shetland.ogc.sensorML.elements.SmlComponent;
import org.n52.shetland.ogc.sensorML.elements.SmlConnection;
import org.n52.shetland.ogc.sensorML.elements.SmlDocumentation;
import org.n52.shetland.ogc.sensorML.elements.SmlDocumentationList;
import org.n52.shetland.ogc.sensorML.elements.SmlIdentifier;
import org.n52.shetland.ogc.sensorML.elements.SmlIo;
import org.n52.shetland.ogc.sensorML.elements.SmlLink;
import org.n52.shetland.ogc.sensorML.elements.SmlLocation;
import org.n52.shetland.ogc.sensorML.elements.SmlPosition;
import org.n52.shetland.ogc.sos.ProcedureDescriptionFormat;
import org.n52.shetland.ogc.swe.AbstractOptionalSweDataComponentVisitor;
import org.n52.shetland.ogc.swe.AbstractVoidSweDataComponentVisitor;
import org.n52.shetland.ogc.swe.SweAbstractDataComponent;
import org.n52.shetland.ogc.swe.SweConstants;
import org.n52.shetland.ogc.swe.SweCoordinate;
import org.n52.shetland.ogc.swe.SweDataArray;
import org.n52.shetland.ogc.swe.SweDataComponentVisitor;
import org.n52.shetland.ogc.swe.SweDataRecord;
import org.n52.shetland.ogc.swe.SweField;
import org.n52.shetland.ogc.swe.SweSimpleDataRecord;
import org.n52.shetland.ogc.swe.VoidSweDataComponentVisitor;
import org.n52.shetland.ogc.swe.simpleType.SweAbstractSimpleType;
import org.n52.shetland.ogc.swe.simpleType.SweBoolean;
import org.n52.shetland.ogc.swe.simpleType.SweCategory;
import org.n52.shetland.ogc.swe.simpleType.SweCount;
import org.n52.shetland.ogc.swe.simpleType.SweCountRange;
import org.n52.shetland.ogc.swe.simpleType.SweObservableProperty;
import org.n52.shetland.ogc.swe.simpleType.SweQuantity;
import org.n52.shetland.ogc.swe.simpleType.SweQuantityRange;
import org.n52.shetland.ogc.swe.simpleType.SweText;
import org.n52.shetland.ogc.swe.simpleType.SweTime;
import org.n52.shetland.ogc.swe.simpleType.SweTimeRange;
import org.n52.shetland.util.CollectionHelper;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.AbstractSensorMLEncoder;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.XmlEncoderKey;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class SensorMLEncoderv101
extends AbstractSensorMLEncoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SensorMLEncoderv101.class);
    private static final ImmutableSet<SupportedType> SUPPORTED_TYPES = ImmutableSet.builder().add((Object)new ProcedureDescriptionFormat("http://www.opengis.net/sensorML/1.0.1")).add((Object)new ProcedureDescriptionFormat(SensorMLConstants.SENSORML_CONTENT_TYPE.toString())).build();
    private static final Map<String, ImmutableMap<String, Set<String>>> SUPPORTED_PROCEDURE_DESCRIPTION_FORMATS = ImmutableMap.of((Object)"SOS", (Object)ImmutableMap.builder().put((Object)"2.0.0", (Object)ImmutableSet.of((Object)"http://www.opengis.net/sensorML/1.0.1")).put((Object)"1.0.0", (Object)ImmutableSet.of((Object)SensorMLConstants.SENSORML_OUTPUT_FORMAT_MIME_TYPE)).build());
    private static final Set<EncoderKey> ENCODER_KEYS = CollectionHelper.union((Set[])new Set[]{CodingHelper.encoderKeysForElements((String)"http://www.opengis.net/sensorML/1.0.1", (Class[])new Class[]{AbstractSensorML.class}), CodingHelper.encoderKeysForElements((String)SensorMLConstants.SENSORML_CONTENT_TYPE.toString(), (Class[])new Class[]{AbstractSensorML.class})});

    public SensorMLEncoderv101() {
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(ENCODER_KEYS));
    }

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEYS);
    }

    public Set<SupportedType> getSupportedTypes() {
        return Collections.unmodifiableSet(SUPPORTED_TYPES);
    }

    public void addNamespacePrefixToMap(Map<String, String> nameSpacePrefixMap) {
        nameSpacePrefixMap.put("http://www.opengis.net/sensorML/1.0.1", "sml");
    }

    @Override
    public MediaType getContentType() {
        return SensorMLConstants.SENSORML_CONTENT_TYPE;
    }

    public Set<SchemaLocation> getSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{SensorMLConstants.SML_101_SCHEMA_LOCATION});
    }

    public Set<String> getSupportedProcedureDescriptionFormats(String service, String version) {
        return (Set)SUPPORTED_PROCEDURE_DESCRIPTION_FORMATS.getOrDefault(service, (ImmutableMap<String, Set<String>>)ImmutableMap.of()).getOrDefault((Object)version, Collections.emptySet());
    }

    public XmlObject encode(Object response, EncodingContext additionalValues) throws EncodingException {
        XmlObject encodedObject = null;
        if (!(response instanceof AbstractSensorML)) {
            throw new UnsupportedEncoderInputException((Encoder)this, response);
        }
        encodedObject = this.createSensorDescription((AbstractSensorML)response);
        XmlHelper.makeGmlIdsUnique((Node)encodedObject.getDomNode());
        XmlHelper.validateDocument((XmlObject)encodedObject, EncodingException::new);
        return encodedObject;
    }

    private XmlObject createSensorDescription(AbstractSensorML sensorDesc) throws EncodingException {
        if (sensorDesc.isSetXml()) {
            return this.createSensorDescriptionFromString(sensorDesc);
        }
        return this.createSensorDescriptionFromObject(sensorDesc);
    }

    protected XmlObject createSensorDescriptionFromString(AbstractSensorML sensorDesc) throws EncodingException {
        try {
            XmlObject xmlObject = XmlObject.Factory.parse((String)sensorDesc.getXml());
            if (xmlObject instanceof SensorMLDocument) {
                SensorMLDocument sensorML = (SensorMLDocument)xmlObject;
                for (SensorMLDocument.SensorML.Member member : sensorML.getSensorML().getMemberArray()) {
                    if (sensorDesc instanceof SensorML) {
                        for (AbstractProcess absProcess : ((SensorML)sensorDesc).getMembers()) {
                            this.addAbstractProcessValues(member.getProcess(), absProcess);
                            if (member.getProcess() instanceof SystemType && absProcess instanceof System) {
                                this.addSystemValues((SystemType)member.getProcess(), (System)absProcess);
                                continue;
                            }
                            if (member.getProcess() instanceof ProcessModelType && absProcess instanceof ProcessModel) {
                                this.addProcessModelValues((ProcessModelType)member.getProcess(), (ProcessModel)absProcess);
                                continue;
                            }
                            if (!(member.getProcess() instanceof ComponentType) || !(absProcess instanceof Component)) continue;
                            this.addComponentValues((ComponentType)member.getProcess(), (Component)absProcess);
                        }
                        continue;
                    }
                    if (!(sensorDesc instanceof AbstractProcess)) continue;
                    this.addAbstractProcessValues(member.getProcess(), (AbstractProcess)sensorDesc);
                    if (member.getProcess() instanceof SystemType && sensorDesc instanceof System) {
                        this.addSystemValues((SystemType)member.getProcess(), (System)sensorDesc);
                        continue;
                    }
                    if (member.getProcess() instanceof ProcessModelType && sensorDesc instanceof ProcessModel) {
                        this.addProcessModelValues((ProcessModelType)member.getProcess(), (ProcessModel)sensorDesc);
                        continue;
                    }
                    if (!(member.getProcess() instanceof ComponentType) || !(sensorDesc instanceof Component)) continue;
                    this.addComponentValues((ComponentType)member.getProcess(), (Component)sensorDesc);
                }
            } else if (xmlObject instanceof AbstractProcessType) {
                AbstractProcessType abstractProcess = (AbstractProcessType)xmlObject;
                this.addAbstractProcessValues(abstractProcess, (AbstractProcess)sensorDesc);
                if (abstractProcess instanceof SystemType && sensorDesc instanceof System) {
                    this.addSystemValues((SystemType)abstractProcess, (System)sensorDesc);
                } else if (abstractProcess instanceof ProcessModelType && sensorDesc instanceof ProcessModel) {
                    this.addProcessModelValues((ProcessModelType)abstractProcess, (ProcessModel)sensorDesc);
                } else if (abstractProcess instanceof ComponentType && sensorDesc instanceof Component) {
                    this.addComponentValues((ComponentType)abstractProcess, (Component)sensorDesc);
                }
            }
            return xmlObject;
        }
        catch (XmlException xmle) {
            throw new EncodingException((Throwable)xmle);
        }
    }

    private XmlObject createSensorDescriptionFromObject(AbstractSensorML sensorDesc) throws EncodingException {
        if (sensorDesc instanceof SensorML) {
            return this.createSensorMLDescription((SensorML)sensorDesc);
        }
        if (sensorDesc instanceof AbstractProcess) {
            return this.createProcessDescription((AbstractProcess)sensorDesc);
        }
        throw SensorMLEncoderv101.unsupportedDescriptionType();
    }

    private XmlObject createProcessDescription(AbstractProcess sensorDesc) throws EncodingException {
        if (sensorDesc instanceof System) {
            System system = (System)sensorDesc;
            SystemDocument xbSystemDoc = SystemDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
            SystemType xbSystem = xbSystemDoc.addNewSystem();
            this.addAbstractProcessValues((AbstractProcessType)xbSystem, (AbstractProcess)system);
            this.addSystemValues(xbSystem, system);
            return xbSystem;
        }
        if (sensorDesc instanceof ProcessModel) {
            ProcessModel processModel = (ProcessModel)sensorDesc;
            ProcessModelDocument xbProcessModelDoc = ProcessModelDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
            ProcessModelType xbProcessModel = xbProcessModelDoc.addNewProcessModel();
            this.addAbstractProcessValues((AbstractProcessType)xbProcessModel, (AbstractProcess)processModel);
            this.addProcessModelValues(xbProcessModel, processModel);
            return xbProcessModel;
        }
        if (sensorDesc instanceof Component) {
            Component component = (Component)sensorDesc;
            ComponentDocument cd = ComponentDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
            ComponentType ct = cd.addNewComponent();
            this.addAbstractProcessValues((AbstractProcessType)ct, (AbstractProcess)component);
            return ct;
        }
        throw SensorMLEncoderv101.unsupportedDescriptionType();
    }

    protected SensorMLDocument createSensorMLDescription(SensorML smlSensorDesc) throws EncodingException {
        SensorMLDocument sensorMLDoc = SensorMLDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        SensorMLDocument.SensorML xbSensorML = sensorMLDoc.addNewSensorML();
        xbSensorML.setVersion("1.0.1");
        if (smlSensorDesc.isSetMembers()) {
            for (AbstractProcess sml : smlSensorDesc.getMembers()) {
                if (sml instanceof System) {
                    SystemType xbSystem = (SystemType)xbSensorML.addNewMember().addNewProcess().substitute(new QName("http://www.opengis.net/sensorML/1.0.1", "System"), SystemType.type);
                    System smlSystem = (System)sml;
                    this.addAbstractProcessValues((AbstractProcessType)xbSystem, (AbstractProcess)smlSystem);
                    this.addSystemValues(xbSystem, smlSystem);
                    continue;
                }
                if (sml instanceof ProcessModel) {
                    ProcessModelType xbProcessModel = (ProcessModelType)xbSensorML.addNewMember().addNewProcess().substitute(new QName("http://www.opengis.net/sensorML/1.0.1", "ProcessModel"), ProcessModelType.type);
                    ProcessModel smlProcessModel = (ProcessModel)sml;
                    this.addAbstractProcessValues((AbstractProcessType)xbProcessModel, (AbstractProcess)smlProcessModel);
                    this.addProcessModelValues(xbProcessModel, smlProcessModel);
                    continue;
                }
                if (!(sml instanceof Component)) continue;
                ComponentType xbCompontent = (ComponentType)xbSensorML.addNewMember().addNewProcess().substitute(new QName("http://www.opengis.net/sensorML/1.0.1", "Component"), ComponentType.type);
                Component smlComponent = (Component)sml;
                this.addAbstractProcessValues((AbstractProcessType)xbCompontent, (AbstractProcess)smlComponent);
                this.addComponentValues(xbCompontent, smlComponent);
            }
        }
        return sensorMLDoc;
    }

    private ContactListDocument.ContactList createContactList(List<SmlContact> contacts) {
        ContactListDocument.ContactList xbContacts = ContactListDocument.ContactList.Factory.newInstance();
        contacts.forEach(smlContact -> {
            if (smlContact.isSetHref()) {
                ContactListDocument.ContactList.Member member = xbContacts.addNewMember();
                member.setHref(smlContact.getHref());
                if (smlContact.isSetTitle()) {
                    member.setTitle(smlContact.getTitle());
                }
                if (smlContact.isSetRole()) {
                    member.setRole(smlContact.getRole());
                }
            } else if (smlContact instanceof SmlPerson) {
                ContactListDocument.ContactList.Member member = xbContacts.addNewMember();
                member.addNewPerson().set((XmlObject)this.createPerson((SmlPerson)smlContact));
                if (smlContact.isSetRole()) {
                    member.setRole(smlContact.getRole());
                }
            } else if (smlContact instanceof SmlResponsibleParty) {
                ContactListDocument.ContactList.Member member = xbContacts.addNewMember();
                member.addNewResponsibleParty().set(this.createResponsibleParty((SmlResponsibleParty)smlContact));
                if (smlContact.isSetRole()) {
                    member.setRole(smlContact.getRole());
                }
            } else if (smlContact instanceof SmlContactList) {
                SmlContactList contactList = (SmlContactList)smlContact;
                ContactListDocument.ContactList innerContactList = this.createContactList(contactList.getMembers());
                int innerContactLength = innerContactList.getMemberArray().length;
                for (int i = 0; i < innerContactLength; ++i) {
                    xbContacts.addNewMember().set((XmlObject)innerContactList.getMemberArray(i));
                }
            }
        });
        return xbContacts;
    }

    private XmlObject createResponsibleParty(SmlResponsibleParty smlRespParty) {
        ResponsiblePartyDocument.ResponsibleParty xbRespParty = ResponsiblePartyDocument.ResponsibleParty.Factory.newInstance();
        if (smlRespParty.isSetIndividualName()) {
            xbRespParty.setIndividualName(smlRespParty.getIndividualName());
        }
        if (smlRespParty.isSetOrganizationName()) {
            xbRespParty.setOrganizationName(smlRespParty.getOrganizationName());
        }
        if (smlRespParty.isSetPositionName()) {
            xbRespParty.setPositionName(smlRespParty.getPositionName());
        }
        if (smlRespParty.isSetContactInfo()) {
            xbRespParty.setContactInfo(this.createContactInfo(smlRespParty));
        }
        return xbRespParty;
    }

    private ContactInfoDocument.ContactInfo createContactInfo(SmlResponsibleParty smlRespParty) {
        ContactInfoDocument.ContactInfo xbContactInfo = ContactInfoDocument.ContactInfo.Factory.newInstance();
        if (smlRespParty.isSetHoursOfService()) {
            xbContactInfo.setHoursOfService(smlRespParty.getHoursOfService());
        }
        if (smlRespParty.isSetContactInstructions()) {
            xbContactInfo.setContactInstructions(smlRespParty.getContactInstructions());
        }
        if (smlRespParty.isSetOnlineResources()) {
            for (String onlineResouce : smlRespParty.getOnlineResources()) {
                xbContactInfo.addNewOnlineResource().setHref(onlineResouce);
            }
        }
        if (smlRespParty.isSetPhone()) {
            ContactInfoDocument.ContactInfo.Phone xbPhone = xbContactInfo.addNewPhone();
            if (smlRespParty.isSetPhoneFax()) {
                smlRespParty.getPhoneFax().forEach(arg_0 -> ((ContactInfoDocument.ContactInfo.Phone)xbPhone).addFacsimile(arg_0));
            }
            if (smlRespParty.isSetPhoneVoice()) {
                smlRespParty.getPhoneVoice().forEach(arg_0 -> ((ContactInfoDocument.ContactInfo.Phone)xbPhone).addVoice(arg_0));
            }
        }
        if (smlRespParty.isSetAddress()) {
            ContactInfoDocument.ContactInfo.Address xbAddress = xbContactInfo.addNewAddress();
            if (smlRespParty.isSetDeliveryPoint()) {
                smlRespParty.getDeliveryPoint().forEach(arg_0 -> ((ContactInfoDocument.ContactInfo.Address)xbAddress).addDeliveryPoint(arg_0));
            }
            if (smlRespParty.isSetCity()) {
                xbAddress.setCity(smlRespParty.getCity());
            }
            if (smlRespParty.isSetAdministrativeArea()) {
                xbAddress.setAdministrativeArea(smlRespParty.getAdministrativeArea());
            }
            if (smlRespParty.isSetPostalCode()) {
                xbAddress.setPostalCode(smlRespParty.getPostalCode());
            }
            if (smlRespParty.isSetCountry()) {
                xbAddress.setCountry(smlRespParty.getCountry());
            }
            if (smlRespParty.isSetEmail()) {
                xbAddress.setElectronicMailAddress(smlRespParty.getEmail());
            }
        }
        return xbContactInfo;
    }

    private PersonDocument.Person createPerson(SmlPerson smlPerson) {
        PersonDocument.Person xbPerson = PersonDocument.Person.Factory.newInstance();
        if (smlPerson.isSetAffiliation()) {
            xbPerson.setAffiliation(smlPerson.getAffiliation());
        }
        if (smlPerson.isSetEmail()) {
            xbPerson.setEmail(smlPerson.getEmail());
        }
        if (smlPerson.isSetName()) {
            xbPerson.setName(smlPerson.getName());
        }
        if (smlPerson.isSetPhoneNumber()) {
            xbPerson.setPhoneNumber(smlPerson.getPhoneNumber());
        }
        if (smlPerson.isSetSurname()) {
            xbPerson.setSurname(smlPerson.getSurname());
        }
        if (smlPerson.isSetUserID()) {
            xbPerson.setUserID(smlPerson.getUserID());
        }
        return xbPerson;
    }

    private void addAbstractProcessValues(AbstractProcessType abstractProcess, AbstractProcess sosAbstractProcess) throws EncodingException {
        ContactListDocument.ContactList contactList;
        if (sosAbstractProcess.isSetGmlID()) {
            abstractProcess.setId(sosAbstractProcess.getGmlId());
        }
        if (sosAbstractProcess.isSetCapabilities()) {
            CapabilitiesDocument.Capabilities[] existing = abstractProcess.getCapabilitiesArray();
            HashSet names = Sets.newHashSetWithExpectedSize((int)existing.length);
            for (CapabilitiesDocument.Capabilities element : existing) {
                if (element.getName() == null) continue;
                names.add(element.getName());
            }
            for (SmlCapabilities sosCapability : sosAbstractProcess.getCapabilities()) {
                CapabilitiesDocument.Capabilities c = this.createCapability(sosCapability);
                if (names.contains(c.getName())) {
                    this.removeCapability(abstractProcess, c);
                }
                abstractProcess.addNewCapabilities().set((XmlObject)c);
            }
        }
        if (sosAbstractProcess.isSetDescription() && !abstractProcess.isSetDescription()) {
            abstractProcess.addNewDescription().setStringValue(sosAbstractProcess.getDescription());
        }
        if (sosAbstractProcess.isSetName() && CollectionHelper.isNullOrEmpty((Object[])abstractProcess.getNameArray())) {
            this.addNamesToAbstractProcess(abstractProcess, sosAbstractProcess.getNames());
        }
        if (sosAbstractProcess.isSetIdentifications()) {
            abstractProcess.setIdentificationArray(this.createIdentification(sosAbstractProcess.getIdentifications()));
        }
        if (sosAbstractProcess.isSetClassifications()) {
            abstractProcess.setClassificationArray(this.createClassification(sosAbstractProcess.getClassifications()));
        }
        if (sosAbstractProcess.isSetCharacteristics()) {
            abstractProcess.setCharacteristicsArray(this.createCharacteristics(sosAbstractProcess.getCharacteristics()));
        }
        if (sosAbstractProcess.isSetDocumentation() && CollectionHelper.isNullOrEmpty((Object[])abstractProcess.getDocumentationArray())) {
            abstractProcess.setDocumentationArray(this.createDocumentationArray(sosAbstractProcess.getDocumentation()));
        }
        if (sosAbstractProcess.isSetContact() && CollectionHelper.isNullOrEmpty((Object[])abstractProcess.getContactArray()) && (contactList = this.createContactList(sosAbstractProcess.getContact())) != null && contactList.getMemberArray().length > 0) {
            abstractProcess.addNewContact().setContactList(contactList);
        }
        if (sosAbstractProcess.isSetKeywords()) {
            List keywords = sosAbstractProcess.getKeywords();
            int length = abstractProcess.getKeywordsArray().length;
            for (int i = 0; i < length; ++i) {
                abstractProcess.removeKeywords(i);
            }
            abstractProcess.addNewKeywords().addNewKeywordList().setKeywordArray(keywords.toArray(new String[keywords.size()]));
        }
        if (sosAbstractProcess.isSetValidTime()) {
            if (abstractProcess.isSetValidTime()) {
                XmlCursor newCursor = abstractProcess.getValidTime().newCursor();
                newCursor.removeXml();
                newCursor.dispose();
            }
            Time time = sosAbstractProcess.getMergedValidTime();
            XmlObject xbtime = this.encodeObjectToXml("http://www.opengis.net/gml", time);
            if (time instanceof TimeInstant) {
                abstractProcess.addNewValidTime().addNewTimeInstant().set(xbtime);
            } else if (time instanceof TimePeriod) {
                abstractProcess.addNewValidTime().addNewTimePeriod().set(xbtime);
            }
        }
    }

    private void addNamesToAbstractProcess(AbstractProcessType abstractProcess, List<CodeType> names) throws EncodingException {
        for (CodeType codeType : names) {
            abstractProcess.addNewName().set(this.encodeObjectToXml("http://www.opengis.net/gml", codeType));
        }
    }

    private ContactDocument.Contact[] mergeContacts(ContactDocument.Contact[] contacts, ContactListDocument.ContactList additionalContactsList) {
        HashSet mergedPersons = Sets.newHashSet();
        HashSet mergedResponsibleParties = Sets.newHashSet();
        for (ContactDocument.Contact contact : contacts) {
            if (this.isContactListSetAndContainingElements(contact)) {
                for (ContactListDocument.ContactList.Member member : contact.getContactList().getMemberArray()) {
                    if (member.isSetPerson()) {
                        mergedPersons.add(member.getPerson());
                        continue;
                    }
                    if (!member.isSetResponsibleParty()) continue;
                    mergedResponsibleParties.add(member.getResponsibleParty());
                }
                continue;
            }
            if (contact.isSetPerson()) {
                mergedPersons.add(contact.getPerson());
                continue;
            }
            if (!contact.isSetResponsibleParty()) continue;
            mergedResponsibleParties.add(contact.getResponsibleParty());
        }
        for (ContactDocument.Contact contact : additionalContactsList.getMemberArray()) {
            if (contact.isSetPerson() && !this.isContained(contact.getPerson(), mergedPersons)) {
                mergedPersons.add(contact.getPerson());
                continue;
            }
            if (!contact.isSetResponsibleParty() || this.isContained(contact.getResponsibleParty(), mergedResponsibleParties)) continue;
            mergedResponsibleParties.add(contact.getResponsibleParty());
        }
        ContactDocument.Contact newContact = ContactDocument.Contact.Factory.newInstance();
        ContactListDocument.ContactList newContactList = ContactListDocument.ContactList.Factory.newInstance();
        mergedResponsibleParties.forEach(responsibleParty -> newContactList.addNewMember().addNewResponsibleParty().set((XmlObject)responsibleParty));
        mergedPersons.forEach(person -> newContactList.addNewMember().addNewPerson().set((XmlObject)person));
        if (newContactList.sizeOfMemberArray() == 1) {
            if (newContactList.getMemberArray(0).isSetPerson()) {
                newContact.addNewPerson().set((XmlObject)newContactList.getMemberArray(0).getPerson());
            } else if (newContactList.getMemberArray(0).isSetResponsibleParty()) {
                newContact.addNewResponsibleParty().set((XmlObject)newContactList.getMemberArray(0).getResponsibleParty());
            }
        } else {
            newContact.addNewContactList().set((XmlObject)newContactList);
        }
        ContactDocument.Contact[] result = new ContactDocument.Contact[]{newContact};
        return result;
    }

    private boolean isContained(ResponsiblePartyDocument.ResponsibleParty rp, Set<ResponsiblePartyDocument.ResponsibleParty> mergedResponsibleParties) {
        XmlOptions xmlOptions = this.getXmlOptions();
        return mergedResponsibleParties.stream().anyMatch(rp2 -> this.isIdentical((XmlObject)rp, xmlOptions, (XmlObject)rp2));
    }

    private boolean isContained(PersonDocument.Person person, Set<PersonDocument.Person> mergedPersons) {
        XmlOptions xmlOptions = this.getXmlOptions();
        return mergedPersons.stream().anyMatch(p2 -> this.isIdentical((XmlObject)person, xmlOptions, (XmlObject)p2));
    }

    private boolean isContactListSetAndContainingElements(ContactDocument.Contact contact) {
        return contact.getContactList() != null && contact.getContactList().getMemberArray() != null && contact.getContactList().getMemberArray().length > 0;
    }

    private void removeCapability(AbstractProcessType abstractProcess, CapabilitiesDocument.Capabilities c) {
        for (int i = 0; i < abstractProcess.getCapabilitiesArray().length; ++i) {
            if (!abstractProcess.getCapabilitiesArray(i).getName().equals(c.getName())) continue;
            abstractProcess.removeCapabilities(i);
            return;
        }
    }

    private CapabilitiesDocument.Capabilities createCapability(SmlCapabilities capabilities) throws EncodingException {
        CapabilitiesDocument.Capabilities xbCapabilities = CapabilitiesDocument.Capabilities.Factory.newInstance((XmlOptions)this.getXmlOptions());
        if (capabilities.isSetName()) {
            xbCapabilities.setName(capabilities.getName());
        }
        if (capabilities.isSetAbstractDataRecord() && capabilities.getDataRecord().isSetFields()) {
            XmlObject encodedDataRecord = this.encodeObjectToXml("http://www.opengis.net/swe/1.0.1", capabilities.getDataRecord());
            XmlObject substituteElement = XmlHelper.substituteElement((XmlObject)xbCapabilities.addNewAbstractDataRecord(), (XmlObject)encodedDataRecord);
            substituteElement.set(encodedDataRecord);
        } else if (capabilities.isSetHref()) {
            xbCapabilities.setHref(capabilities.getHref());
            if (capabilities.isSetTitle()) {
                xbCapabilities.setTitle(capabilities.getTitle());
            }
        }
        return xbCapabilities;
    }

    private void addSystemValues(SystemType xbSystem, System system) throws EncodingException {
        if (system.isSetInputs() && !xbSystem.isSetInputs()) {
            xbSystem.setInputs(this.createInputs(system.getInputs()));
        }
        if (system.isSetPosition() && !xbSystem.isSetPosition()) {
            xbSystem.setPosition(this.createPosition(system.getPosition()));
        }
        if (system.isSetLocation() && !xbSystem.isSetSmlLocation()) {
            xbSystem.setSmlLocation(this.createLocation(system.getLocation()));
        }
        ArrayList smlComponents = Lists.newArrayList();
        if (system.isSetComponents()) {
            ComponentsDocument.Components components;
            if (system.isSetComponents()) {
                smlComponents.addAll(system.getComponents());
            }
            if (!smlComponents.isEmpty() && (components = this.createComponents(smlComponents)) != null && components.getComponentList() != null && components.getComponentList().sizeOfComponentArray() > 0) {
                xbSystem.setComponents(components);
            }
        }
        if (system.isSetOutputs() && !xbSystem.isSetOutputs()) {
            xbSystem.setOutputs(this.createOutputs(system.getOutputs()));
        }
        if (system.isSetConnections() && !xbSystem.isSetConnections()) {
            xbSystem.setConnections(this.createConnections(system.getConnections()));
        }
    }

    private void addComponentValues(ComponentType ct, Component component) throws EncodingException {
        if (component.isSetInputs()) {
            ct.setInputs(this.createInputs(component.getInputs()));
        }
        if (component.isSetPosition()) {
            ct.setPosition(this.createPosition(component.getPosition()));
        }
        if (component.isSetLocation()) {
            ct.setSmlLocation(this.createLocation(component.getLocation()));
        }
        if (component.isSetOutputs()) {
            ct.setOutputs(this.createOutputs(component.getOutputs()));
        }
    }

    private void addProcessModelValues(ProcessModelType processModel, ProcessModel sosProcessModel) throws EncodingException {
        if (sosProcessModel.isSetInputs()) {
            processModel.setInputs(this.createInputs(sosProcessModel.getInputs()));
        }
        if (sosProcessModel.isSetOutputs()) {
            processModel.setOutputs(this.createOutputs(sosProcessModel.getOutputs()));
        }
        processModel.setMethod(this.createMethod(sosProcessModel.getMethod()));
    }

    private MethodPropertyType createMethod(ProcessMethod method) throws EncodingException {
        MethodPropertyType xbMethod = MethodPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        if (method.isSetHref()) {
            xbMethod.setHref(method.getHref());
            if (method.isSetTitle()) {
                xbMethod.setTitle(method.getTitle());
            }
            if (method.isSetRole()) {
                xbMethod.setRole(method.getRole());
            }
        } else if (method.isSetRulesDefinition()) {
            ProcessMethodType xbProcessMethod = xbMethod.addNewProcessMethod();
            ProcessMethodType.Rules.RulesDefinition xbRulesDefinition = xbProcessMethod.addNewRules().addNewRulesDefinition();
            if (method.getRulesDefinition().isSetDescription()) {
                xbRulesDefinition.addNewDescription().setStringValue(method.getRulesDefinition().getDescription());
            }
        } else {
            throw new EncodingException("method", "The ProcessMethod should contain a href string or a RulesDefinition!", new Object[0]);
        }
        return xbMethod;
    }

    protected IdentificationDocument.Identification[] createIdentification(List<SmlIdentifier> identifications) {
        IdentificationDocument.Identification xbIdentification = IdentificationDocument.Identification.Factory.newInstance((XmlOptions)this.getXmlOptions());
        IdentificationDocument.Identification.IdentifierList xbIdentifierList = xbIdentification.addNewIdentifierList();
        identifications.forEach(sosSMLIdentifier -> {
            IdentificationDocument.Identification.IdentifierList.Identifier xbIdentifier = xbIdentifierList.addNewIdentifier();
            if (sosSMLIdentifier.getName() != null) {
                xbIdentifier.setName(sosSMLIdentifier.getName());
            }
            TermDocument.Term xbTerm = xbIdentifier.addNewTerm();
            xbTerm.setDefinition(sosSMLIdentifier.getDefinition());
            xbTerm.setValue(sosSMLIdentifier.getValue());
        });
        return new IdentificationDocument.Identification[]{xbIdentification};
    }

    private ClassificationDocument.Classification[] createClassification(List<SmlClassifier> classifications) {
        ClassificationDocument.Classification xbClassification = ClassificationDocument.Classification.Factory.newInstance((XmlOptions)this.getXmlOptions());
        ClassificationDocument.Classification.ClassifierList xbClassifierList = xbClassification.addNewClassifierList();
        classifications.forEach(sosSMLClassifier -> {
            ClassificationDocument.Classification.ClassifierList.Classifier xbClassifier = xbClassifierList.addNewClassifier();
            if (sosSMLClassifier.getName() != null) {
                xbClassifier.setName(sosSMLClassifier.getName());
            }
            TermDocument.Term xbTerm = xbClassifier.addNewTerm();
            xbTerm.setValue(sosSMLClassifier.getValue());
            if (sosSMLClassifier.isSetDefinition()) {
                xbTerm.setDefinition(sosSMLClassifier.getDefinition());
            }
            if (sosSMLClassifier.isSetCodeSpace()) {
                xbTerm.addNewCodeSpace().setHref(sosSMLClassifier.getCodeSpace());
            }
        });
        return new ClassificationDocument.Classification[]{xbClassification};
    }

    /*
     * Enabled aggressive block sorting
     */
    private CharacteristicsDocument.Characteristics[] createCharacteristics(List<SmlCharacteristics> smlCharacteristics) throws EncodingException {
        ArrayList characteristicsList = Lists.newArrayListWithExpectedSize((int)smlCharacteristics.size());
        Iterator<SmlCharacteristics> iterator = smlCharacteristics.iterator();
        while (true) {
            CharacteristicsDocument.Characteristics xbCharacteristics;
            block13: {
                SmlCharacteristics sosSMLCharacteristics;
                block12: {
                    if (!iterator.hasNext()) {
                        return characteristicsList.toArray(new CharacteristicsDocument.Characteristics[characteristicsList.size()]);
                    }
                    sosSMLCharacteristics = iterator.next();
                    xbCharacteristics = CharacteristicsDocument.Characteristics.Factory.newInstance((XmlOptions)this.getXmlOptions());
                    if (sosSMLCharacteristics.isSetName()) {
                        xbCharacteristics.setName(sosSMLCharacteristics.getName());
                    }
                    if (!sosSMLCharacteristics.isSetAbstractDataRecord()) break block12;
                    if (sosSMLCharacteristics.getDataRecord() instanceof SweSimpleDataRecord) {
                        SimpleDataRecordType xbSimpleDataRecord = (SimpleDataRecordType)xbCharacteristics.addNewAbstractDataRecord().substitute(SweConstants.QN_SIMPLEDATARECORD_SWE_101, SimpleDataRecordType.type);
                        if (sosSMLCharacteristics.isSetTypeDefinition()) {
                            xbSimpleDataRecord.setDefinition(sosSMLCharacteristics.getTypeDefinition());
                        }
                        if (sosSMLCharacteristics.getDataRecord().isSetFields()) {
                            for (SweField field : sosSMLCharacteristics.getDataRecord().getFields()) {
                                AnyScalarPropertyType xbField = xbSimpleDataRecord.addNewField();
                                xbField.setName(field.getName().getValue());
                                this.addSweSimpleTypeToField(xbField, field.getElement());
                            }
                        }
                        break block13;
                    } else {
                        if (sosSMLCharacteristics.getDataRecord() instanceof SweDataRecord) {
                            throw SensorMLEncoderv101.unsupportedCharacteristicsType(SweConstants.SweAggregateType.DataRecord);
                        }
                        throw SensorMLEncoderv101.unsupportedCharacteristicsType(sosSMLCharacteristics.getDataRecord().getClass().getName());
                    }
                }
                if (sosSMLCharacteristics.isSetHref()) {
                    if (sosSMLCharacteristics.isSetName()) {
                        xbCharacteristics.setName(sosSMLCharacteristics.getName());
                    }
                    xbCharacteristics.setHref(sosSMLCharacteristics.getHref());
                    if (sosSMLCharacteristics.isSetTitle()) {
                        xbCharacteristics.setTitle(sosSMLCharacteristics.getTitle());
                    }
                }
            }
            characteristicsList.add(xbCharacteristics);
        }
    }

    protected DocumentationDocument.Documentation[] createDocumentationArray(List<AbstractSmlDocumentation> sosDocumentation) {
        return (DocumentationDocument.Documentation[])sosDocumentation.stream().map(abstractSosSMLDocumentation -> {
            DocumentationDocument.Documentation documentation = DocumentationDocument.Documentation.Factory.newInstance();
            if (abstractSosSMLDocumentation instanceof SmlDocumentation) {
                documentation.setDocument(this.createDocument((SmlDocumentation)abstractSosSMLDocumentation));
            } else if (abstractSosSMLDocumentation instanceof SmlDocumentationList) {
                documentation.setDocumentList(this.createDocumentationList((SmlDocumentationList)abstractSosSMLDocumentation));
            }
            return documentation;
        }).toArray(DocumentationDocument.Documentation[]::new);
    }

    private DocumentDocument.Document createDocument(SmlDocumentation sosDocumentation) {
        DocumentDocument.Document document = DocumentDocument.Document.Factory.newInstance();
        if (sosDocumentation.isSetDescription()) {
            document.addNewDescription().setStringValue(sosDocumentation.getDescription());
        } else {
            document.addNewDescription().setStringValue("");
        }
        if (sosDocumentation.isSetDate()) {
            document.setDate((Object)sosDocumentation.getDate().getValue().toDate());
        }
        if (sosDocumentation.isSetContact()) {
            document.addNewContact().addNewResponsibleParty().setIndividualName(sosDocumentation.getContact());
        }
        if (sosDocumentation.isSetFormat()) {
            document.setFormat(sosDocumentation.getFormat());
        }
        if (sosDocumentation.isSetVersion()) {
            document.setVersion(sosDocumentation.getVersion());
        }
        return document;
    }

    private DocumentListDocument.DocumentList createDocumentationList(SmlDocumentationList sosDocumentationList) {
        DocumentListDocument.DocumentList documentList = DocumentListDocument.DocumentList.Factory.newInstance();
        if (sosDocumentationList.isSetDescription()) {
            documentList.addNewDescription().setStringValue(sosDocumentationList.getDescription());
        }
        if (sosDocumentationList.isSetMembers()) {
            sosDocumentationList.getMember().forEach(sosMember -> {
                DocumentListDocument.DocumentList.Member member = documentList.addNewMember();
                member.setName(sosMember.getName());
                member.setDocument(this.createDocument(sosMember.getDocumentation()));
            });
        }
        return documentList;
    }

    private PositionDocument.Position createPosition(SmlPosition position) throws EncodingException {
        PositionDocument.Position xbPosition = PositionDocument.Position.Factory.newInstance((XmlOptions)this.getXmlOptions());
        if (position.isSetName()) {
            xbPosition.setName(position.getName().getValue());
        } else {
            xbPosition.setName("position");
        }
        PositionType xbSwePosition = xbPosition.addNewPosition();
        xbSwePosition.setFixed(position.isFixed());
        xbSwePosition.setReferenceFrame(position.getReferenceFrame());
        VectorType xbVector = xbSwePosition.addNewLocation().addNewVector();
        for (SweCoordinate coordinate : position.getPosition()) {
            if (coordinate.getValue().getValue() == null || coordinate.getValue().isSetValue() && ((Number)coordinate.getValue().getValue()).equals(Double.NaN)) continue;
            xbVector.addNewCoordinate().set(this.encodeObjectToXml("http://www.opengis.net/swe/1.0.1", coordinate));
        }
        return xbPosition;
    }

    private SmlLocation.SmlLocation2 createLocation(SmlLocation location) throws EncodingException {
        XmlObject xbPoint;
        SmlLocation.SmlLocation2 xbLocation = SmlLocation.SmlLocation2.Factory.newInstance((XmlOptions)this.getXmlOptions());
        if (location.isSetPoint() && (xbPoint = this.encodeObjectToXml("http://www.opengis.net/gml", location.getPoint())) instanceof PointType) {
            xbLocation.setPoint((PointType)xbPoint);
        }
        return xbLocation;
    }

    private InputsDocument.Inputs createInputs(List<SmlIo> inputs) throws EncodingException {
        InputsDocument.Inputs xbInputs = InputsDocument.Inputs.Factory.newInstance((XmlOptions)this.getXmlOptions());
        InputsDocument.Inputs.InputList xbInputList = xbInputs.addNewInputList();
        int counter = 1;
        for (SmlIo sosSMLIo : inputs) {
            if (!sosSMLIo.isSetName()) {
                sosSMLIo.setIoName("input_" + counter++);
            }
            this.addIoComponentPropertyType(xbInputList.addNewInput(), sosSMLIo);
        }
        return xbInputs;
    }

    private OutputsDocument.Outputs createOutputs(List<SmlIo> sosOutputs) throws EncodingException {
        OutputsDocument.Outputs outputs = OutputsDocument.Outputs.Factory.newInstance((XmlOptions)this.getXmlOptions());
        OutputsDocument.Outputs.OutputList outputList = outputs.addNewOutputList();
        HashSet definitions = Sets.newHashSet();
        int counter = 1;
        HashSet outputNames = Sets.newHashSet();
        for (SmlIo sosSMLIo : sosOutputs) {
            if (!sosSMLIo.isSetValue().booleanValue() || definitions.contains(sosSMLIo.getIoValue().getDefinition())) continue;
            if (!sosSMLIo.isSetName() || outputNames.contains(sosSMLIo.getIoName())) {
                sosSMLIo.setIoName(this.getValidOutputName(counter++, outputNames));
            }
            outputNames.add(sosSMLIo.getIoName());
            this.addIoComponentPropertyType(outputList.addNewOutput(), sosSMLIo);
            definitions.add(sosSMLIo.getIoValue().getDefinition());
        }
        return outputs;
    }

    private ComponentsDocument.Components createComponents(List<SmlComponent> sosComponents) throws EncodingException {
        ComponentsDocument.Components components = ComponentsDocument.Components.Factory.newInstance((XmlOptions)this.getXmlOptions());
        ComponentsDocument.Components.ComponentList componentList = components.addNewComponentList();
        for (SmlComponent sosSMLComponent : sosComponents) {
            ComponentsDocument.Components.ComponentList.Component component = componentList.addNewComponent();
            if (sosSMLComponent.getName() != null) {
                component.setName(sosSMLComponent.getName());
            }
            if (sosSMLComponent.getHref() != null) {
                component.setHref(sosSMLComponent.getHref());
                if (sosSMLComponent.getTitle() == null) continue;
                component.setTitle(sosSMLComponent.getTitle());
                continue;
            }
            if (sosSMLComponent.getProcess() == null) continue;
            XmlObject xmlObject = null;
            if (sosSMLComponent.getProcess().isSetXml()) {
                try {
                    xmlObject = XmlObject.Factory.parse((String)sosSMLComponent.getProcess().getXml());
                }
                catch (XmlException xmle) {
                    throw new EncodingException("Error while encoding SensorML child procedure description from stored SensorML encoded sensor description with XMLBeans", (Throwable)xmle);
                }
            } else if (sosSMLComponent.getProcess() instanceof SensorML) {
                xmlObject = this.createSensorDescriptionFromObject((AbstractSensorML)((SensorML)sosSMLComponent.getProcess()).getMembers().iterator().next());
            } else if (sosSMLComponent.getProcess() instanceof AbstractProcess) {
                xmlObject = this.createSensorDescriptionFromObject(sosSMLComponent.getProcess());
            }
            if (xmlObject == null) continue;
            AbstractProcessType xbProcess = null;
            if (xmlObject instanceof SensorMLDocument) {
                int n = 0;
                SensorMLDocument smlDoc = (SensorMLDocument)xmlObject;
                SensorMLDocument.SensorML.Member[] memberArray = smlDoc.getSensorML().getMemberArray();
                int n2 = memberArray.length;
                if (n < n2) {
                    SensorMLDocument.SensorML.Member member = memberArray[n];
                    xbProcess = member.getProcess();
                }
            } else if (xmlObject instanceof AbstractProcessType) {
                xbProcess = (AbstractProcessType)xmlObject;
            }
            if (xbProcess == null) {
                throw new EncodingException("The sensor type is not supported by this SOS", new Object[0]);
            }
            SchemaType schemaType = xbProcess.schemaType();
            component.addNewProcess().substitute(this.getQnameForType(schemaType), schemaType).set((XmlObject)xbProcess);
        }
        return components;
    }

    private ConnectionsDocument.Connections createConnections(SmlConnection connections) {
        ConnectionsDocument.Connections c = ConnectionsDocument.Connections.Factory.newInstance();
        ConnectionsDocument.Connections.ConnectionList cl = c.addNewConnectionList();
        for (SmlLink link : connections.getConnections()) {
            LinkDocument.Link l = cl.addNewConnection().addNewLink();
            l.addNewDestination().setRef(link.getDestination());
            l.addNewSource().setRef(link.getSource());
        }
        return c;
    }

    private void addSweSimpleTypeToField(AnyScalarPropertyType xbField, SweAbstractDataComponent sosSweData) throws EncodingException {
        Encoder encoder = this.getEncoder((EncoderKey)new XmlEncoderKey("http://www.opengis.net/swe/1.0.1", SweDataArray.class), new EncoderKey[0]);
        if (encoder == null) {
            throw new EncodingException("The %s is not supported by this SOS for SWE fields!", sosSweData.getClass().getSimpleName(), new Object[0]);
        }
        XmlObject encoded = (XmlObject)encoder.encode((Object)sosSweData);
        if (!(sosSweData instanceof SweAbstractSimpleType)) {
            throw new EncodingException("The SosSweAbstractDataComponent '%s' is not supported by this SOS SensorML encoder!", new Object[]{sosSweData});
        }
        SweAbstractSimpleType sosSweSimpleType = (SweAbstractSimpleType)sosSweData;
        ((AbstractDataComponentType)((Optional)sosSweSimpleType.accept((SweDataComponentVisitor)new ScalarSweDataComponentAdder(xbField))).orElseThrow(() -> new EncodingException("The SWE simpleType '%s' is not supported by this SOS SensorML encoder!", sosSweSimpleType.getDataComponentType().name(), new Object[0]))).set(encoded);
    }

    private void addIoComponentPropertyType(IoComponentPropertyType ioComponentPropertyType, SmlIo sosSMLIO) throws EncodingException {
        ioComponentPropertyType.setName(sosSMLIO.getIoName());
        if (sosSMLIO.isSetHref()) {
            ioComponentPropertyType.setHref(sosSMLIO.getTitle());
            if (sosSMLIO.isSetTitle()) {
                ioComponentPropertyType.setTitle(sosSMLIO.getTitle());
            }
        } else {
            XmlObject xml = this.encodeObjectToXml("http://www.opengis.net/swe/1.0.1", sosSMLIO.getIoValue());
            Object encodeObjectToXml = xml instanceof DataArrayDocument ? ((DataArrayDocument)xml).getDataArray1() : xml;
            ((Optional)sosSMLIO.getIoValue().accept((SweDataComponentVisitor)new SweDataComponentAdder(ioComponentPropertyType))).map(arg_0 -> SensorMLEncoderv101.lambda$addIoComponentPropertyType$11((XmlObject)encodeObjectToXml, arg_0)).ifPresent(h -> sosSMLIO.getIoValue().accept((VoidSweDataComponentVisitor)new SweDataComponentSubstituter((AbstractDataComponentType)h)));
        }
    }

    private QName getQnameForType(SchemaType type) {
        if (type == SystemType.type) {
            return SensorMLConstants.SYSTEM_QNAME;
        }
        if (type == ProcessModelType.type) {
            return SensorMLConstants.PROCESS_MODEL_QNAME;
        }
        if (type == ComponentType.type) {
            return SensorMLConstants.COMPONENT_QNAME;
        }
        return SensorMLConstants.ABSTRACT_PROCESS_QNAME;
    }

    private static EncodingException unsupportedCharacteristicsType(Object type) {
        return new EncodingException("The SWE characteristics type '%s' is not supported by this SOS for SensorML characteristics!", new Object[]{type});
    }

    private static EncodingException unsupportedDescriptionType() {
        return new EncodingException("The sensor description type is not supported by this service!", new Object[0]);
    }

    private static /* synthetic */ AbstractDataComponentType lambda$addIoComponentPropertyType$11(XmlObject encodeObjectToXml, AbstractDataComponentType h) {
        return (AbstractDataComponentType)h.set(encodeObjectToXml);
    }

    private static class SweDataComponentSubstituter
    extends AbstractVoidSweDataComponentVisitor<RuntimeException> {
        private final AbstractDataComponentType dataComponentType;

        SweDataComponentSubstituter(AbstractDataComponentType dataComponentType) {
            this.dataComponentType = dataComponentType;
        }

        protected void _visit(SweDataArray component) {
            this.dataComponentType.substitute(SweConstants.QN_DATA_ARRAY_SWE_101, DataArrayType.type);
        }

        protected void _visit(SweSimpleDataRecord component) {
            this.dataComponentType.substitute(SweConstants.QN_SIMPLEDATARECORD_SWE_101, SimpleDataRecordType.type);
        }

        protected void _visit(SweDataRecord component) {
            this.dataComponentType.substitute(SweConstants.QN_DATA_RECORD_SWE_101, DataRecordType.type);
        }
    }

    private static class SweDataComponentAdder
    extends AbstractOptionalSweDataComponentVisitor<AbstractDataComponentType, RuntimeException> {
        private final IoComponentPropertyType parent;

        SweDataComponentAdder(IoComponentPropertyType parent) {
            this.parent = Objects.requireNonNull(parent);
        }

        public AbstractDataComponentType _visit(SweDataRecord component) {
            return this.parent.addNewAbstractDataRecord();
        }

        public AbstractDataComponentType _visit(SweDataArray component) {
            return this.parent.addNewAbstractDataArray1();
        }

        public AbstractDataComponentType _visit(SweCount component) {
            return this.parent.addNewCount();
        }

        public AbstractDataComponentType _visit(SweCountRange component) {
            return this.parent.addNewCountRange();
        }

        public AbstractDataComponentType _visit(SweBoolean component) {
            return this.parent.addNewBoolean();
        }

        public AbstractDataComponentType _visit(SweCategory component) {
            return this.parent.addNewCategory();
        }

        public AbstractDataComponentType _visit(SweObservableProperty component) {
            return this.parent.addNewObservableProperty();
        }

        public AbstractDataComponentType _visit(SweQuantity component) {
            return this.parent.addNewQuantity();
        }

        public AbstractDataComponentType _visit(SweQuantityRange component) {
            return this.parent.addNewQuantityRange();
        }

        public AbstractDataComponentType _visit(SweText component) {
            return this.parent.addNewText();
        }

        public AbstractDataComponentType _visit(SweTime component) {
            return this.parent.addNewTime();
        }

        public AbstractDataComponentType _visit(SweTimeRange component) {
            return this.parent.addNewTimeRange();
        }

        public AbstractDataComponentType _visit(SweSimpleDataRecord component) {
            return this.parent.addNewAbstractDataRecord();
        }
    }

    private static class ScalarSweDataComponentAdder
    extends AbstractOptionalSweDataComponentVisitor<AbstractDataComponentType, RuntimeException> {
        private final AnyScalarPropertyType parent;

        ScalarSweDataComponentAdder(AnyScalarPropertyType parent) {
            this.parent = Objects.requireNonNull(parent);
        }

        protected AbstractDataComponentType _visit(SweBoolean component) throws RuntimeException {
            return this.parent.addNewBoolean();
        }

        protected AbstractDataComponentType _visit(SweCategory component) throws RuntimeException {
            return this.parent.addNewCategory();
        }

        protected AbstractDataComponentType _visit(SweCount component) throws RuntimeException {
            return this.parent.addNewCount();
        }

        protected AbstractDataComponentType _visit(SweText component) throws RuntimeException {
            return this.parent.addNewText();
        }

        protected AbstractDataComponentType _visit(SweQuantity component) throws RuntimeException {
            return this.parent.addNewQuantity();
        }

        protected AbstractDataComponentType _visit(SweTime component) throws RuntimeException {
            return this.parent.addNewTime();
        }
    }
}

