/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.Set;
import org.apache.xmlbeans.XmlObject;
import org.isotc211.x2005.gco.CodeListValueType;
import org.n52.shetland.ogc.sensorML.Role;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderXmlInputException;
import org.n52.svalbard.util.CodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Iso19139GcoDecoder
implements Decoder<Object, XmlObject> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Iso19139GcoDecoder.class);
    private static final Set<DecoderKey> DECODER_KEYS = CodingHelper.decoderKeysForElements((String)"http://www.isotc211.org/2005/gco", (Class[])new Class[]{CodeListValueType.class});

    public Iso19139GcoDecoder() {
        LOGGER.debug("Decoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(DECODER_KEYS));
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    public Object decode(XmlObject element) throws DecodingException {
        if (element instanceof CodeListValueType) {
            return this.encodeCodeListValue((CodeListValueType)element);
        }
        throw new UnsupportedDecoderXmlInputException(this, element);
    }

    private Role encodeCodeListValue(CodeListValueType circ) {
        Role role = new Role(circ.getStringValue());
        role.setCodeList(circ.getCodeList());
        role.setCodeListValue(circ.getCodeListValue());
        return role;
    }
}

