/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.collect.Sets;
import eu.europa.ec.inspire.schemas.base.x33.IdentifierType;
import eu.europa.ec.inspire.schemas.ompr.x30.ProcessType;
import java.util.Collections;
import java.util.Set;
import org.n52.shetland.inspire.ompr.InspireOMPRConstants;
import org.n52.shetland.inspire.ompr.Process;
import org.n52.shetland.ogc.SupportedType;
import org.n52.shetland.ogc.gml.CodeWithAuthority;
import org.n52.shetland.ogc.sos.ProcedureDescriptionFormat;
import org.n52.svalbard.decode.AbstractXmlDecoder;
import org.n52.svalbard.decode.ProcedureDecoder;

public abstract class AbstractProcessDecoder<S>
extends AbstractXmlDecoder<S, Process>
implements ProcedureDecoder<Process, S> {
    private static final Set<SupportedType> SUPPORTED_TYPES = Sets.newHashSet((Object[])new SupportedType[]{new ProcedureDescriptionFormat("http://inspire.ec.europa.eu/schemas/ompr/3.0"), new ProcedureDescriptionFormat(InspireOMPRConstants.OMPR_30_OUTPUT_FORMAT_MIME_TYPE)});

    public Set<SupportedType> getSupportedTypes() {
        return Collections.unmodifiableSet(SUPPORTED_TYPES);
    }

    public Set<String> getSupportedProcedureDescriptionFormats(String service, String version) {
        return Collections.emptySet();
    }

    protected Process parseProcessType(ProcessType pt) {
        Process process = new Process();
        this.parseInspireId(pt, process);
        return process;
    }

    private void parseInspireId(ProcessType pt, Process process) {
        String namespace;
        IdentifierType identifier = pt.getInspireId().getIdentifier();
        String localId = identifier.getLocalId();
        CodeWithAuthority codeWithAuthority = localId.contains(namespace = identifier.getNamespace()) ? new CodeWithAuthority(localId, namespace) : new CodeWithAuthority(this.getIdentifier(localId, namespace), namespace);
        process.setIdentifier(codeWithAuthority);
    }

    private String getIdentifier(String localId, String namespace) {
        if (namespace.endsWith("=")) {
            return namespace + localId;
        }
        if (namespace.startsWith("urn")) {
            return namespace + ":" + localId;
        }
        if (namespace.startsWith("http")) {
            return namespace + "/" + localId;
        }
        return namespace + "-" + localId;
    }
}

