/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.opengis.gml.ReferenceType;
import net.opengis.ows.x11.CapabilitiesBaseType;
import net.opengis.sos.x10.CapabilitiesDocument;
import net.opengis.sos.x10.ContentsDocument;
import net.opengis.sos.x10.FilterCapabilitiesDocument;
import net.opengis.sos.x10.ObservationOfferingType;
import net.opengis.swe.x101.PhenomenonPropertyType;
import org.n52.shetland.ogc.filter.FilterCapabilities;
import org.n52.shetland.ogc.gml.time.Time;
import org.n52.shetland.ogc.ows.OwsCapabilities;
import org.n52.shetland.ogc.sos.SosCapabilities;
import org.n52.shetland.ogc.sos.SosObservationOffering;
import org.n52.shetland.util.ReferencedEnvelope;
import org.n52.svalbard.decode.AbstractCapabilitiesBaseTypeDecoder;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapabilitiesDecoder
extends AbstractCapabilitiesBaseTypeDecoder<CapabilitiesDocument.Capabilities, SosCapabilities> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CapabilitiesDecoder.class);
    private static final Set<DecoderKey> DECODER_KEYS = CodingHelper.decoderKeysForElements((String)"http://www.opengis.net/sos/1.0", (Class[])new Class[]{CapabilitiesDocument.Capabilities.class});

    public CapabilitiesDecoder() {
        LOGGER.debug("Decoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(DECODER_KEYS));
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
    public SosCapabilities decode(CapabilitiesDocument.Capabilities c) throws DecodingException {
        if (c != null) {
            OwsCapabilities owsCapabilities = this.parseCapabilitiesBaseType("SOS", (CapabilitiesBaseType)c);
            FilterCapabilities filterCapabilities = this.parseFilterCapabilities(c.getFilterCapabilities());
            Collection<SosObservationOffering> contents = this.parseContents(c.getContents());
            return new SosCapabilities(owsCapabilities, filterCapabilities, contents);
        }
        throw new UnsupportedDecoderInputException((Decoder)this, (Object)c);
    }

    private Collection<SosObservationOffering> parseContents(ContentsDocument.Contents contents) {
        if (contents == null) {
            return null;
        }
        return this.parseObservationOfferingList(contents.getObservationOfferingList());
    }

    private Collection<SosObservationOffering> parseObservationOfferingList(ContentsDocument.Contents.ObservationOfferingList obsOffList) {
        return Optional.ofNullable(obsOffList.getObservationOfferingArray()).map(Arrays::stream).orElseGet(Stream::empty).map(this::parseOffering).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private SosObservationOffering parseOffering(ObservationOfferingType obsOffType) {
        SosObservationOffering observationOffering = new SosObservationOffering();
        observationOffering.setOffering(obsOffType.getId());
        observationOffering.setProcedures(this.parseProcedure(obsOffType));
        observationOffering.setProcedureDescriptionFormat(this.parseProcedureDescriptionFormat(obsOffType));
        observationOffering.setObservableProperties(this.parseObservableProperties(obsOffType));
        observationOffering.setRelatedFeatures(this.parseRelatedFeatures(obsOffType));
        observationOffering.setObservedArea(this.parseObservedArea(obsOffType));
        observationOffering.setPhenomenonTime(this.parsePhenomenonTime(obsOffType));
        observationOffering.setResultTime(this.parseResultTime(obsOffType));
        observationOffering.setResponseFormats(this.parseResponseFormats(obsOffType));
        observationOffering.setObservationTypes(this.parseObservationTypes(obsOffType));
        observationOffering.setFeatureOfInterestTypes(this.parseFeatureOfInterestTypes(obsOffType));
        return observationOffering;
    }

    private FilterCapabilities parseFilterCapabilities(FilterCapabilitiesDocument.FilterCapabilities filterCapabilities) {
        LOGGER.warn("parseFilterCapabilities needs to be implemented");
        return null;
    }

    private Collection<String> parseProcedure(ObservationOfferingType obsOffType) {
        return Optional.ofNullable(obsOffType.getProcedureArray()).map(Arrays::stream).orElseGet(Stream::empty).map(ReferenceType::getHref).collect(Collectors.toSet());
    }

    private Collection<String> parseProcedureDescriptionFormat(ObservationOfferingType obsOffType) {
        LOGGER.warn("parseProcedureDescriptionFormat needs to be implemented");
        return Collections.emptySet();
    }

    private Collection<String> parseObservableProperties(ObservationOfferingType obsOffType) {
        return Optional.ofNullable(obsOffType.getObservedPropertyArray()).map(Arrays::stream).orElseGet(Stream::empty).map(PhenomenonPropertyType::getHref).collect(Collectors.toSet());
    }

    private Time parsePhenomenonTime(ObservationOfferingType obsOffType) {
        LOGGER.warn("parsePhenomenonTime needs to be implemented");
        return null;
    }

    private Time parseResultTime(ObservationOfferingType obsOffType) {
        LOGGER.warn("parseResultTime needs to be implemented");
        return null;
    }

    private Collection<String> parseResponseFormats(ObservationOfferingType obsOffType) {
        return Optional.ofNullable(obsOffType.getResponseFormatArray()).map(Arrays::stream).orElseGet(Stream::empty).collect(Collectors.toSet());
    }

    private Collection<String> parseObservationTypes(ObservationOfferingType obsOffType) {
        LOGGER.warn("parseObservationTypes needs to be implemented");
        return Collections.emptySet();
    }

    private Collection<String> parseFeatureOfInterestTypes(ObservationOfferingType obsOffType) {
        return Optional.ofNullable(obsOffType.getFeatureOfInterestArray()).map(Arrays::stream).orElseGet(Stream::empty).map(ReferenceType::getHref).collect(Collectors.toSet());
    }

    private Map<String, Set<String>> parseRelatedFeatures(ObservationOfferingType obsOffType) {
        LOGGER.warn("parseRelatedFeatures needs to be implemented");
        return Collections.emptyMap();
    }

    private ReferencedEnvelope parseObservedArea(ObservationOfferingType obsOffType) {
        LOGGER.warn("parseObservedArea needs to be implemented");
        return null;
    }
}

