/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.opengis.ows.x11.ExceptionReportDocument;
import net.opengis.ows.x11.ExceptionType;
import org.n52.janmayen.stream.Streams;
import org.n52.shetland.ogc.ows.exception.CodedException;
import org.n52.shetland.ogc.ows.exception.CompositeOwsException;
import org.n52.shetland.ogc.ows.exception.ExceptionCode;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.svalbard.decode.AbstractXmlDecoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.XmlNamespaceDecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;

public class OwsExceptionReportDecoder
extends AbstractXmlDecoder<ExceptionReportDocument, OwsExceptionReport> {
    private static final DecoderKey KEY = new XmlNamespaceDecoderKey("http://www.opengis.net/ows/1.1", ExceptionReportDocument.class);

    public Set<DecoderKey> getKeys() {
        return Collections.singleton(KEY);
    }

    public OwsExceptionReport decode(ExceptionReportDocument doc) throws DecodingException {
        return this.decode(doc.getExceptionReport());
    }

    private OwsExceptionReport decode(ExceptionReportDocument.ExceptionReport report) {
        String version = report.getVersion();
        Object[] exceptionTypes = report.getExceptionArray();
        List exceptions = Streams.stream((Object[])exceptionTypes).map(this::decode).collect(Collectors.toList());
        return new CompositeOwsException(exceptions).setVersion(version);
    }

    private CodedException decode(ExceptionType e) {
        String code = e.getExceptionCode();
        String locator = e.getLocator();
        String message = String.join((CharSequence)"\n", e.getExceptionTextArray());
        return new GenericCodedException(code).at(locator).withMessage(message, new Object[0]);
    }

    private static class GenericCodedException
    extends CodedException {
        private static final long serialVersionUID = 8443662702566120820L;

        GenericCodedException(String code) {
            super((ExceptionCode)new GenericExceptionCode(code));
        }
    }

    private static class GenericExceptionCode
    implements ExceptionCode {
        private final String code;

        GenericExceptionCode(String code) {
            this.code = code;
        }

        public String getSoapFaultReason() {
            return this.code;
        }

        public String toString() {
            return this.code;
        }

        public int hashCode() {
            return Objects.hashCode(this.code);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GenericExceptionCode other = (GenericExceptionCode)obj;
            return Objects.equals(this.getCode(), other.getCode());
        }

        public String getCode() {
            return this.code;
        }
    }
}

