/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.collect.Sets;
import java.util.Set;
import net.opengis.swes.x20.ExtensibleResponseType;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.ogc.ows.extension.Extension;
import org.n52.shetland.ogc.ows.extension.Extensions;
import org.n52.shetland.ogc.ows.service.OwsServiceResponse;
import org.n52.shetland.ogc.sos.Sos2Constants;
import org.n52.shetland.ogc.swe.SweAbstractDataComponent;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.AbstractResponseEncoder;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.exception.EncodingException;

public abstract class AbstractSosResponseEncoder<T extends OwsServiceResponse>
extends AbstractResponseEncoder<T> {
    public AbstractSosResponseEncoder(String operation, Class<T> responseType) {
        super("SOS", "2.0.0", operation, "http://www.opengis.net/sos/2.0", "sos", responseType);
    }

    public Set<SchemaLocation> getSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{Sos2Constants.SOS_SCHEMA_LOCATION});
    }

    protected XmlObject encodeGml(Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/gml/3.2", o);
    }

    protected XmlObject encodeGml(EncodingContext helperValues, Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/gml/3.2", o, helperValues);
    }

    protected XmlObject encodeOws(Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/ows/1.1", o);
    }

    protected XmlObject encodeOws(EncodingContext helperValues, Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/ows/1.1", o, helperValues);
    }

    protected XmlObject encodeFes(Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/fes/2.0", o);
    }

    protected XmlObject encodeFes(EncodingContext helperValues, Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/fes/2.0", o, helperValues);
    }

    protected XmlObject encodeSwe(Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/swe/2.0", o);
    }

    protected XmlObject encodeSwe(EncodingContext helperValues, Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/swe/2.0", o, helperValues);
    }

    protected void createExtension(ExtensibleResponseType xbResponse, Extensions extensions) throws EncodingException {
        EncodingContext ctx = new EncodingContext().with((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE, (Object)"true");
        for (Extension extension : extensions.getExtensions()) {
            if (!(extension.getValue() instanceof SweAbstractDataComponent)) continue;
            xbResponse.addNewExtension().set(this.encodeSwe(ctx, extension.getValue()));
        }
    }
}

