/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.collect.Sets;
import java.util.Set;
import net.opengis.sos.x10.GetCapabilitiesDocument;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.shetland.ogc.ows.OwsAcceptVersions;
import org.n52.shetland.ogc.ows.OwsSections;
import org.n52.shetland.ogc.ows.service.GetCapabilitiesRequest;
import org.n52.shetland.ogc.sos.Sos1Constants;
import org.n52.shetland.ogc.sos.SosConstants;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.AbstractSosV1RequestEncoder;
import org.n52.svalbard.encode.exception.EncodingException;

public class GetCapabilitiesV1RequestEncoder
extends AbstractSosV1RequestEncoder<GetCapabilitiesRequest> {
    public GetCapabilitiesV1RequestEncoder() {
        super(SosConstants.Operations.GetCapabilities.name(), GetCapabilitiesRequest.class);
    }

    @Override
    protected Set<SchemaLocation> getConcreteSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{Sos1Constants.GET_CAPABILITIES_SOS1_SCHEMA_LOCATION});
    }

    @Override
    protected XmlObject create(GetCapabilitiesRequest request) throws EncodingException {
        GetCapabilitiesDocument doc = GetCapabilitiesDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        GetCapabilitiesDocument.GetCapabilities gc = doc.addNewGetCapabilities();
        this.addService(gc, request);
        this.addAcceptVersions(gc, request);
        this.addSections(gc, request);
        return doc;
    }

    private void addService(GetCapabilitiesDocument.GetCapabilities gc, GetCapabilitiesRequest request) {
        if (request.isSetService()) {
            gc.setService(request.getService());
        } else {
            gc.setService("SOS");
        }
    }

    private void addAcceptVersions(GetCapabilitiesDocument.GetCapabilities gc, GetCapabilitiesRequest request) throws EncodingException {
        if (request.isSetAcceptVersions()) {
            gc.addNewAcceptVersions().set(this.encodeOws(new OwsAcceptVersions().setAcceptVersions(request.getAcceptVersions())));
        } else if (request.isSetVersion()) {
            gc.addNewAcceptVersions().addVersion(request.getVersion());
        } else {
            gc.addNewAcceptVersions().addVersion("1.0.0");
        }
    }

    private void addSections(GetCapabilitiesDocument.GetCapabilities gc, GetCapabilitiesRequest request) throws EncodingException {
        if (request.isSetSections()) {
            gc.addNewSections().set(this.encodeOws(new OwsSections().setSections(request.getSections())));
        }
    }
}

