/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import eu.europa.ec.inspire.schemas.base.x33.IdentifierPropertyType;
import java.util.Collections;
import java.util.Set;
import org.n52.shetland.inspire.base.Identifier;
import org.n52.svalbard.encode.AbstractIdentifierEncoder;
import org.n52.svalbard.encode.ClassToClassEncoderKey;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.XmlPropertyTypeEncoderKey;
import org.n52.svalbard.encode.exception.EncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentifierPropertyTypeEncoder
extends AbstractIdentifierEncoder<IdentifierPropertyType> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentifierPropertyTypeEncoder.class);
    private static final Set<EncoderKey> ENCODER_KEYS = Sets.newHashSet((Object[])new EncoderKey[]{new ClassToClassEncoderKey(Identifier.class, IdentifierPropertyType.class), new XmlPropertyTypeEncoderKey("http://inspire.ec.europa.eu/schemas/base/3.3", Identifier.class)});

    public IdentifierPropertyTypeEncoder() {
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(ENCODER_KEYS));
    }

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEYS);
    }

    public IdentifierPropertyType encode(Identifier identifier, EncodingContext context) throws EncodingException {
        IdentifierPropertyType ipt = IdentifierPropertyType.Factory.newInstance();
        ipt.setIdentifier(this.createIdentifierType(identifier));
        return ipt;
    }
}

