/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import java.util.List;
import net.opengis.sos.x20.InsertObservationDocument;
import net.opengis.sos.x20.InsertObservationType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.shetland.ogc.om.OmObservation;
import org.n52.shetland.ogc.ows.extension.Extension;
import org.n52.shetland.ogc.ows.extension.Extensions;
import org.n52.shetland.ogc.sos.SosConstants;
import org.n52.shetland.ogc.sos.request.InsertObservationRequest;
import org.n52.svalbard.encode.AbstractSwesRequestEncoder;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;

public class InsertObservationRequestEncoder
extends AbstractSwesRequestEncoder<InsertObservationRequest> {
    public InsertObservationRequestEncoder() {
        super(SosConstants.Operations.InsertObservation.name(), InsertObservationRequest.class);
    }

    @Override
    protected XmlObject create(InsertObservationRequest request) throws EncodingException {
        this.validateInput(request);
        InsertObservationDocument doc = InsertObservationDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        InsertObservationType insertObservation = doc.addNewInsertObservation();
        insertObservation.setService(request.getService());
        insertObservation.setVersion(request.getVersion());
        this.addExtensions(request.getExtensions(), insertObservation);
        this.addOfferings(request.getOfferings(), insertObservation);
        this.addObservations(request.getObservations(), insertObservation);
        return doc;
    }

    private void addObservations(List<OmObservation> observations, InsertObservationType insertObservation) throws EncodingException {
        InsertObservationType.Observation ob = insertObservation.addNewObservation();
        for (OmObservation o : observations) {
            ob.addNewOMObservation().set(this.encodeObjectToXmlDocument("http://www.opengis.net/om/2.0", o));
        }
    }

    private void addExtensions(Extensions extensions, InsertObservationType insertObservation) throws EncodingException {
        if (extensions == null || extensions.isEmpty()) {
            return;
        }
        for (Extension o : extensions.getExtensions()) {
            insertObservation.addNewExtension().set(this.encodeObjectToXml("http://www.opengis.net/swes/2.0", o));
        }
    }

    private void addOfferings(List<String> offerings, InsertObservationType insertObservation) {
        offerings.stream().forEach(o -> insertObservation.addNewOffering().setStringValue(o));
    }

    @Override
    protected void validateInput(InsertObservationRequest request) throws UnsupportedEncoderInputException {
        super.validateInput(request);
        if (!request.getVersion().equals("2.0.0")) {
            throw new UnsupportedEncoderInputException((Encoder)this, "SOS 1.0.0 insert observation request");
        }
        if (!request.isSetOfferings()) {
            throw new UnsupportedEncoderInputException((Encoder)this, "missing offering(s)");
        }
        if (!request.isSetObservation()) {
            throw new UnsupportedEncoderInputException((Encoder)this, "missing observation(s)");
        }
    }
}

