/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.opengis.ows.x11.AcceptVersionsType;
import net.opengis.ows.x11.AddressType;
import net.opengis.ows.x11.AllowedValuesDocument;
import net.opengis.ows.x11.CodeType;
import net.opengis.ows.x11.ContactType;
import net.opengis.ows.x11.DCPDocument;
import net.opengis.ows.x11.DomainMetadataType;
import net.opengis.ows.x11.DomainType;
import net.opengis.ows.x11.ExceptionDocument;
import net.opengis.ows.x11.ExceptionReportDocument;
import net.opengis.ows.x11.ExceptionType;
import net.opengis.ows.x11.HTTPDocument;
import net.opengis.ows.x11.KeywordsType;
import net.opengis.ows.x11.LanguageStringType;
import net.opengis.ows.x11.MetadataType;
import net.opengis.ows.x11.OnlineResourceType;
import net.opengis.ows.x11.OperationDocument;
import net.opengis.ows.x11.OperationsMetadataDocument;
import net.opengis.ows.x11.RangeType;
import net.opengis.ows.x11.RequestMethodType;
import net.opengis.ows.x11.ResponsiblePartySubsetType;
import net.opengis.ows.x11.SectionsType;
import net.opengis.ows.x11.ServiceIdentificationDocument;
import net.opengis.ows.x11.ServiceProviderDocument;
import net.opengis.ows.x11.TelephoneType;
import net.opengis.ows.x11.ValuesReferenceDocument;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.faroe.annotation.Configurable;
import org.n52.faroe.annotation.Setting;
import org.n52.janmayen.http.MediaTypes;
import org.n52.janmayen.i18n.LocaleHelper;
import org.n52.janmayen.i18n.LocalizedString;
import org.n52.janmayen.i18n.MultilingualString;
import org.n52.janmayen.stream.StreamingIterable;
import org.n52.shetland.ogc.ows.OWSConstants;
import org.n52.shetland.ogc.ows.OwsAcceptVersions;
import org.n52.shetland.ogc.ows.OwsAddress;
import org.n52.shetland.ogc.ows.OwsAllowedValues;
import org.n52.shetland.ogc.ows.OwsCode;
import org.n52.shetland.ogc.ows.OwsContact;
import org.n52.shetland.ogc.ows.OwsDCP;
import org.n52.shetland.ogc.ows.OwsDomain;
import org.n52.shetland.ogc.ows.OwsDomainMetadata;
import org.n52.shetland.ogc.ows.OwsHttp;
import org.n52.shetland.ogc.ows.OwsKeyword;
import org.n52.shetland.ogc.ows.OwsLanguageString;
import org.n52.shetland.ogc.ows.OwsMetadata;
import org.n52.shetland.ogc.ows.OwsOnlineResource;
import org.n52.shetland.ogc.ows.OwsOperation;
import org.n52.shetland.ogc.ows.OwsOperationMetadataExtension;
import org.n52.shetland.ogc.ows.OwsOperationsMetadata;
import org.n52.shetland.ogc.ows.OwsPhone;
import org.n52.shetland.ogc.ows.OwsPossibleValues;
import org.n52.shetland.ogc.ows.OwsRange;
import org.n52.shetland.ogc.ows.OwsResponsibleParty;
import org.n52.shetland.ogc.ows.OwsSections;
import org.n52.shetland.ogc.ows.OwsServiceIdentification;
import org.n52.shetland.ogc.ows.OwsServiceProvider;
import org.n52.shetland.ogc.ows.OwsValue;
import org.n52.shetland.ogc.ows.OwsValuesReference;
import org.n52.shetland.ogc.ows.exception.CodedException;
import org.n52.shetland.ogc.ows.exception.OwsExceptionCode;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.util.CollectionHelper;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.shetland.w3c.xlink.Actuate;
import org.n52.shetland.w3c.xlink.Show;
import org.n52.svalbard.encode.AbstractXmlEncoder;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.ExceptionEncoderKey;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.N52XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3.x1999.xlink.ActuateType;
import org.w3.x1999.xlink.ShowType;

@Configurable
public class OwsEncoderv110
extends AbstractXmlEncoder<XmlObject, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OwsEncoderv110.class);
    private static final Set<EncoderKey> ENCODER_KEYS = CollectionHelper.union((Set[])new Set[]{Sets.newHashSet((Object[])new EncoderKey[]{new ExceptionEncoderKey(MediaTypes.TEXT_XML), new ExceptionEncoderKey(MediaTypes.APPLICATION_XML)}), CodingHelper.encoderKeysForElements((String)"http://www.opengis.net/ows/1.1", (Class[])new Class[]{OwsServiceIdentification.class, OwsServiceProvider.class, OwsOperationsMetadata.class, OwsExceptionReport.class, OwsMetadata.class, OwsDomain.class, OwsSections.class})});
    private boolean includeStackTraceInExceptionReport;

    public OwsEncoderv110() {
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(ENCODER_KEYS));
    }

    @Setting(value="misc.includeStackTraceInExceptionReport")
    public void setIncludeStackTraceInExceptionReport(boolean includeStackTraceInExceptionReport) {
        this.includeStackTraceInExceptionReport = includeStackTraceInExceptionReport;
    }

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEYS);
    }

    public void addNamespacePrefixToMap(Map<String, String> nameSpacePrefixMap) {
        nameSpacePrefixMap.put("http://www.opengis.net/ows/1.1", "ows");
    }

    public Set<SchemaLocation> getSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{OWSConstants.OWS_110_SCHEMA_LOCATION});
    }

    public XmlObject encode(Object element, EncodingContext additionalValues) throws EncodingException {
        if (element instanceof OwsServiceIdentification) {
            return this.encodeServiceIdentification((OwsServiceIdentification)element);
        }
        if (element instanceof OwsServiceProvider) {
            return this.encodeServiceProvider((OwsServiceProvider)element);
        }
        if (element instanceof OwsOperationsMetadata) {
            return this.encodeOperationsMetadata((OwsOperationsMetadata)element);
        }
        if (element instanceof OwsExceptionReport) {
            if (this.isEncodeExceptionsOnly(additionalValues) && !((OwsExceptionReport)((Object)element)).getExceptions().isEmpty()) {
                return this.encodeOwsException((CodedException)((OwsExceptionReport)((Object)element)).getExceptions().get(0));
            }
            return this.encodeOwsExceptionReport((OwsExceptionReport)((Object)element));
        }
        if (element instanceof OwsMetadata) {
            MetadataType metadataType = MetadataType.Factory.newInstance((XmlOptions)this.getXmlOptions());
            this.encodeOwsMetadata((OwsMetadata)element, metadataType);
            return metadataType;
        }
        if (element instanceof OwsDomain) {
            DomainType domainType = DomainType.Factory.newInstance((XmlOptions)this.getXmlOptions());
            this.encodeOwsDomain((OwsDomain)element, domainType);
            return domainType;
        }
        if (element instanceof OwsAcceptVersions) {
            return this.encodeAcceptVersions((OwsAcceptVersions)element);
        }
        if (element instanceof OwsSections) {
            return this.encodeSections((OwsSections)element);
        }
        throw new UnsupportedEncoderInputException((Encoder)this, element);
    }

    protected boolean isEncodeExceptionsOnly(EncodingContext additionalValues) {
        return additionalValues != null && additionalValues.has((Enum)XmlBeansEncodingFlags.ENCODE_OWS_EXCEPTION_ONLY);
    }

    private XmlObject encodeServiceIdentification(OwsServiceIdentification serviceIdentification) throws EncodingException {
        ServiceIdentificationDocument.ServiceIdentification serviceIdent = ServiceIdentificationDocument.ServiceIdentification.Factory.newInstance();
        serviceIdentification.getAccessConstraints().forEach(arg_0 -> ((ServiceIdentificationDocument.ServiceIdentification)serviceIdent).addAccessConstraints(arg_0));
        if (!serviceIdentification.getFees().isEmpty()) {
            serviceIdent.setFees((String)serviceIdentification.getFees().iterator().next());
        }
        CodeType xbServiceType = serviceIdent.addNewServiceType();
        xbServiceType.setStringValue(serviceIdentification.getServiceType().getValue());
        if (serviceIdentification.getServiceType().getCodeSpace().isPresent()) {
            xbServiceType.setCodeSpace(((URI)serviceIdentification.getServiceType().getCodeSpace().get()).toString());
        }
        this.encodeMultilingualString(serviceIdentification.getTitle(), () -> ((ServiceIdentificationDocument.ServiceIdentification)serviceIdent).addNewTitle());
        this.encodeMultilingualString(serviceIdentification.getAbstract(), () -> ((ServiceIdentificationDocument.ServiceIdentification)serviceIdent).addNewAbstract());
        serviceIdentification.getServiceTypeVersion().stream().forEach(arg_0 -> ((ServiceIdentificationDocument.ServiceIdentification)serviceIdent).addServiceTypeVersion(arg_0));
        serviceIdentification.getProfiles().stream().map(URI::toString).forEach(arg_0 -> ((ServiceIdentificationDocument.ServiceIdentification)serviceIdent).addProfile(arg_0));
        serviceIdentification.getKeywords().stream().collect(Collectors.groupingBy(OwsKeyword::getType, Collectors.mapping(OwsKeyword::getKeyword, Collectors.toList()))).forEach((type, keywords) -> this.encodeOwsKeywords((Optional<OwsCode>)type, (List<OwsLanguageString>)keywords, serviceIdent.addNewKeywords()));
        return serviceIdent;
    }

    private void encodeMultilingualString(Optional<MultilingualString> string, Supplier<? extends LanguageStringType> supplier) {
        string.map(StreamingIterable::stream).orElseGet(Stream::empty).map(this::encodeOwsLanguageString).forEach(t -> ((LanguageStringType)supplier.get()).set((XmlObject)t));
    }

    private ServiceProviderDocument.ServiceProvider encodeServiceProvider(OwsServiceProvider osp) {
        ServiceProviderDocument.ServiceProvider serviceProvider = ServiceProviderDocument.ServiceProvider.Factory.newInstance();
        serviceProvider.setProviderName(osp.getProviderName());
        osp.getProviderSite().ifPresent(x -> this.encodeOnlineResource((OwsOnlineResource)x, serviceProvider.addNewProviderSite()));
        this.encodeOwsResponsibleParty(osp.getServiceContact(), serviceProvider.addNewServiceContact());
        return serviceProvider;
    }

    private OperationsMetadataDocument.OperationsMetadata encodeOperationsMetadata(OwsOperationsMetadata om) throws EncodingException {
        OperationsMetadataDocument.OperationsMetadata xom = OperationsMetadataDocument.OperationsMetadata.Factory.newInstance((XmlOptions)this.getXmlOptions());
        om.getOperations().forEach(x -> this.encodeOwsOperation((OwsOperation)x, xom.addNewOperation()));
        om.getConstraints().forEach(x -> this.encodeOwsDomain((OwsDomain)x, xom.addNewConstraint()));
        om.getParameters().forEach(x -> this.encodeOwsDomain((OwsDomain)x, xom.addNewParameter()));
        if (om.getExtension().isPresent()) {
            xom.setExtendedCapabilities(this.encodeOwsOperationsMetadataExtension((OwsOperationMetadataExtension)om.getExtension().get()));
        }
        return xom;
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
    private ExceptionDocument encodeOwsException(CodedException owsException) {
        ExceptionDocument exceptionDoc = ExceptionDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        ExceptionType exceptionType = exceptionDoc.addNewException();
        String exceptionCode = owsException.getCode() == null ? OwsExceptionCode.NoApplicableCode.toString() : owsException.getCode().toString();
        exceptionType.setExceptionCode(exceptionCode);
        if (owsException.getLocator() != null) {
            exceptionType.setLocator(owsException.getLocator());
        }
        StringBuilder exceptionText = new StringBuilder();
        if (owsException.getMessage() != null) {
            exceptionText.append(owsException.getMessage());
            exceptionText.append("\n");
        }
        if (owsException.getCause() != null) {
            exceptionText.append("[EXEPTION]: \n");
            String localizedMessage = owsException.getCause().getLocalizedMessage();
            String message = owsException.getCause().getMessage();
            if (localizedMessage != null && message != null) {
                if (!message.equals(localizedMessage)) {
                    exceptionText.append(message).append('\n');
                }
                exceptionText.append(localizedMessage).append('\n');
            } else if (localizedMessage != null) {
                exceptionText.append(localizedMessage).append('\n');
            } else if (message != null) {
                exceptionText.append(message).append('\n');
            }
            if (this.includeStackTraceInExceptionReport) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                owsException.getCause().printStackTrace(new PrintStream(os));
                exceptionText.append(os.toString());
            }
        }
        exceptionType.addExceptionText(exceptionText.toString());
        return exceptionDoc;
    }

    private ExceptionReportDocument encodeOwsExceptionReport(OwsExceptionReport owsExceptionReport) {
        ExceptionReportDocument erd = ExceptionReportDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        ExceptionReportDocument.ExceptionReport er = erd.addNewExceptionReport();
        er.setVersion(owsExceptionReport.getVersion());
        ArrayList exceptionTypes = new ArrayList(owsExceptionReport.getExceptions().size());
        owsExceptionReport.getExceptions().stream().map(this::encodeOwsException).map(ExceptionDocument::getException).forEach(exceptionTypes::add);
        er.setExceptionArray(exceptionTypes.toArray(new ExceptionType[exceptionTypes.size()]));
        N52XmlHelper.setSchemaLocationsToDocument((XmlObject)erd, Collections.singletonList(N52XmlHelper.getSchemaLocationForOWS110()));
        return erd;
    }

    private LanguageStringType encodeOwsLanguageString(LocalizedString ls) {
        LanguageStringType lst = LanguageStringType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        lst.setStringValue(ls.getText());
        lst.setLang(LocaleHelper.encode((Locale)ls.getLang()));
        return lst;
    }

    private void encodeOwsLanguageString(OwsLanguageString languageString, LanguageStringType xlanguageString) {
        xlanguageString.setStringValue(languageString.getValue());
        languageString.getLang().ifPresent(arg_0 -> ((LanguageStringType)xlanguageString).setLang(arg_0));
    }

    private AcceptVersionsType encodeAcceptVersions(OwsAcceptVersions acceptVersions) {
        AcceptVersionsType avt = AcceptVersionsType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        acceptVersions.getAcceptVersions().forEach(arg_0 -> ((AcceptVersionsType)avt).addVersion(arg_0));
        return avt;
    }

    private SectionsType encodeSections(OwsSections sections) {
        SectionsType st = SectionsType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        sections.getSections().forEach(arg_0 -> ((SectionsType)st).addSection(arg_0));
        return st;
    }

    private void encodeOnlineResource(OwsOnlineResource site, OnlineResourceType xsite) {
        site.getHref().map(URI::toString).ifPresent(arg_0 -> ((OnlineResourceType)xsite).setHref(arg_0));
        site.getTitle().ifPresent(arg_0 -> ((OnlineResourceType)xsite).setTitle(arg_0));
        site.getActuate().map(Actuate::toString).map(ActuateType.Enum::forString).ifPresent(arg_0 -> ((OnlineResourceType)xsite).setActuate(arg_0));
        site.getArcrole().map(URI::toString).ifPresent(arg_0 -> ((OnlineResourceType)xsite).setArcrole(arg_0));
        site.getRole().map(URI::toString).ifPresent(arg_0 -> ((OnlineResourceType)xsite).setRole(arg_0));
        site.getShow().map(Show::toString).map(ShowType.Enum::forString).ifPresent(arg_0 -> ((OnlineResourceType)xsite).setShow(arg_0));
    }

    private void encodeOwsDomain(OwsDomain domain, DomainType xdomain) {
        xdomain.setName(domain.getName());
        domain.getDefaultValue().ifPresent(value -> xdomain.addNewDefaultValue().setStringValue(value.getValue()));
        domain.getDataType().ifPresent(domainMetadata -> this.encodeOwsDomainMetadata((OwsDomainMetadata)domainMetadata, xdomain.addNewDataType()));
        domain.getMeaning().ifPresent(domainMetadata -> this.encodeOwsDomainMetadata((OwsDomainMetadata)domainMetadata, xdomain.addNewMeaning()));
        domain.getMetadata().forEach(metadata -> this.encodeOwsMetadata((OwsMetadata)metadata, xdomain.addNewMetadata()));
        domain.getMetadata().forEach(metadata -> this.encodeOwsMetadata((OwsMetadata)metadata, xdomain.addNewMetadata()));
        domain.getValuesUnit().ifPresent(x -> {
            if (x.isReferenceSystem()) {
                this.encodeOwsDomainMetadata((OwsDomainMetadata)x.asReferenceSystem(), xdomain.addNewReferenceSystem());
            } else if (x.isUOM()) {
                this.encodeOwsDomainMetadata((OwsDomainMetadata)x.asUOM(), xdomain.addNewUOM());
            }
        });
        this.encodeOwsPossibleValues(domain.getPossibleValues(), xdomain);
    }

    private void encodeOwsMetadata(OwsMetadata metadata, MetadataType xmetadata) {
        metadata.getHref().map(URI::toString).ifPresent(arg_0 -> ((MetadataType)xmetadata).setHref(arg_0));
        metadata.getTitle().ifPresent(arg_0 -> ((MetadataType)xmetadata).setTitle(arg_0));
        metadata.getActuate().map(Actuate::toString).map(ActuateType.Enum::forString).ifPresent(arg_0 -> ((MetadataType)xmetadata).setActuate(arg_0));
        metadata.getArcrole().map(URI::toString).ifPresent(arg_0 -> ((MetadataType)xmetadata).setArcrole(arg_0));
        metadata.getRole().map(URI::toString).ifPresent(arg_0 -> ((MetadataType)xmetadata).setRole(arg_0));
        metadata.getShow().map(Show::toString).map(ShowType.Enum::forString).ifPresent(arg_0 -> ((MetadataType)xmetadata).setShow(arg_0));
        metadata.getAbout().map(URI::toString).ifPresent(arg_0 -> ((MetadataType)xmetadata).setAbout(arg_0));
    }

    private void encodeOwsDomainMetadata(OwsDomainMetadata domainMetadata, DomainMetadataType xdomainMetadata) {
        domainMetadata.getReference().map(URI::toString).ifPresent(arg_0 -> ((DomainMetadataType)xdomainMetadata).setReference(arg_0));
        domainMetadata.getValue().ifPresent(arg_0 -> ((DomainMetadataType)xdomainMetadata).setStringValue(arg_0));
    }

    private void encodeOwsAddress(OwsAddress address, AddressType xaddress) {
        address.getAdministrativeArea().ifPresent(arg_0 -> ((AddressType)xaddress).setAdministrativeArea(arg_0));
        address.getCity().ifPresent(arg_0 -> ((AddressType)xaddress).setCity(arg_0));
        address.getCountry().ifPresent(arg_0 -> ((AddressType)xaddress).setCountry(arg_0));
        address.getPostalCode().ifPresent(arg_0 -> ((AddressType)xaddress).setPostalCode(arg_0));
        address.getDeliveryPoint().forEach(arg_0 -> ((AddressType)xaddress).addDeliveryPoint(arg_0));
        address.getElectronicMailAddress().forEach(arg_0 -> ((AddressType)xaddress).addElectronicMailAddress(arg_0));
    }

    private void encodeOwsPhone(OwsPhone phone, TelephoneType xphone) {
        phone.getVoice().forEach(arg_0 -> ((TelephoneType)xphone).addVoice(arg_0));
        phone.getFacsimile().forEach(arg_0 -> ((TelephoneType)xphone).addFacsimile(arg_0));
    }

    private void encodeOwsCode(OwsCode role, CodeType xrole) {
        role.getCodeSpace().map(URI::toString).ifPresent(arg_0 -> ((CodeType)xrole).setCodeSpace(arg_0));
        xrole.setStringValue(role.getValue());
    }

    private void encodeOwsOperation(OwsOperation operation, OperationDocument.Operation xoperation) {
        xoperation.setName(operation.getName());
        operation.getConstraints().forEach(x -> this.encodeOwsDomain((OwsDomain)x, xoperation.addNewConstraint()));
        operation.getMetadata().forEach(x -> this.encodeOwsMetadata((OwsMetadata)x, xoperation.addNewMetadata()));
        operation.getParameters().forEach(x -> this.encodeOwsDomain((OwsDomain)x, xoperation.addNewParameter()));
        operation.getDCP().forEach(x -> this.encodeOwsDCP((OwsDCP)x, xoperation.addNewDCP()));
    }

    private void encodeOwsContact(OwsContact contact, ContactType xcontact) {
        contact.getOnlineResource().ifPresent(site -> this.encodeOnlineResource((OwsOnlineResource)site, xcontact.addNewOnlineResource()));
        contact.getContactInstructions().ifPresent(arg_0 -> ((ContactType)xcontact).setContactInstructions(arg_0));
        contact.getHoursOfService().ifPresent(arg_0 -> ((ContactType)xcontact).setHoursOfService(arg_0));
        contact.getPhone().ifPresent(x -> this.encodeOwsPhone((OwsPhone)x, xcontact.addNewPhone()));
        contact.getAddress().ifPresent(x -> this.encodeOwsAddress((OwsAddress)x, xcontact.addNewAddress()));
    }

    private void encodeOwsResponsibleParty(OwsResponsibleParty responsibleParty, ResponsiblePartySubsetType xresponsibleParty) {
        responsibleParty.getIndividualName().ifPresent(arg_0 -> ((ResponsiblePartySubsetType)xresponsibleParty).setIndividualName(arg_0));
        responsibleParty.getPositionName().ifPresent(arg_0 -> ((ResponsiblePartySubsetType)xresponsibleParty).setPositionName(arg_0));
        responsibleParty.getContactInfo().ifPresent(x -> this.encodeOwsContact((OwsContact)x, xresponsibleParty.addNewContactInfo()));
        responsibleParty.getRole().ifPresent(x -> this.encodeOwsCode((OwsCode)x, xresponsibleParty.addNewRole()));
    }

    private void encodeOwsDCP(OwsDCP dcp, DCPDocument.DCP xdcp) {
        if (dcp.isHTTP()) {
            HTTPDocument.HTTP xhttp = xdcp.addNewHTTP();
            OwsHttp http = dcp.asHTTP();
            SortedSet requestMethods = http.getRequestMethods();
            requestMethods.forEach(method -> {
                RequestMethodType xmethod;
                switch (method.getHttpMethod()) {
                    case "GET": {
                        xmethod = xhttp.addNewGet();
                        break;
                    }
                    case "POST": {
                        xmethod = xhttp.addNewPost();
                        break;
                    }
                    default: {
                        return;
                    }
                }
                this.encodeOnlineResource((OwsOnlineResource)method, (OnlineResourceType)xmethod);
                method.getConstraints().forEach(x -> this.encodeOwsDomain((OwsDomain)x, xmethod.addNewConstraint()));
            });
        }
    }

    private void encodeOwsKeywords(Optional<OwsCode> type, List<OwsLanguageString> keywords, KeywordsType xkeywords) {
        type.ifPresent(x -> this.encodeOwsCode((OwsCode)x, xkeywords.addNewType()));
        keywords.forEach(x -> this.encodeOwsLanguageString((OwsLanguageString)x, xkeywords.addNewKeyword()));
    }

    private void encodeOwsPossibleValues(OwsPossibleValues possibleValues, DomainType xdomain) {
        if (possibleValues.isAnyValue()) {
            xdomain.addNewAnyValue();
        } else if (possibleValues.isNoValues()) {
            xdomain.addNewNoValues();
        } else if (possibleValues.isValuesReference()) {
            OwsValuesReference vr = possibleValues.asValuesReference();
            ValuesReferenceDocument.ValuesReference xvr = xdomain.addNewValuesReference();
            xvr.setReference(vr.getReference().toString());
            xvr.setStringValue(vr.getValue());
        } else if (possibleValues.isAllowedValues()) {
            OwsAllowedValues av = possibleValues.asAllowedValues();
            AllowedValuesDocument.AllowedValues xav = xdomain.addNewAllowedValues();
            av.getRestrictions().forEach(restriction -> {
                if (restriction.isRange()) {
                    OwsRange range = restriction.asRange();
                    RangeType xrange = xav.addNewRange();
                    range.getLowerBound().map(OwsValue::getValue).ifPresent(v -> xrange.addNewMinimumValue().setStringValue(v));
                    range.getUpperBound().map(OwsValue::getValue).ifPresent(v -> xrange.addNewMaximumValue().setStringValue(v));
                    range.getSpacing().map(OwsValue::getValue).ifPresent(v -> xrange.addNewSpacing().setStringValue(v));
                    xrange.setRangeClosure(Collections.singletonList(range.getType()));
                } else if (restriction.isValue()) {
                    xav.addNewValue().setStringValue(restriction.asValue().getValue());
                }
            });
        }
    }

    private XmlObject encodeOwsOperationsMetadataExtension(OwsOperationMetadataExtension extension) throws EncodingException {
        return this.encodeObjectToXml(extension.getNamespace(), extension);
    }
}

