/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.janmayen.exception.CompositeException;
import org.n52.janmayen.function.Functions;
import org.n52.shetland.ogc.ows.service.OwsServiceRequest;
import org.n52.shetland.util.CollectionHelper;
import org.n52.shetland.w3c.soap.SoapHeader;
import org.n52.shetland.w3c.soap.SoapRequest;
import org.n52.shetland.w3c.wsa.WsaActionHeader;
import org.n52.svalbard.decode.AbstractXmlDecoder;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.XmlNamespaceDecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.util.W3cHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public abstract class AbstractSoapDecoder
extends AbstractXmlDecoder<XmlObject, SoapRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSoapDecoder.class);
    private final Set<DecoderKey> decoderKeys;

    public AbstractSoapDecoder(String namespace) {
        this.decoderKeys = Collections.singleton(new XmlNamespaceDecoderKey(namespace, XmlObject.class));
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(this.decoderKeys);
    }

    public SoapRequest decode(XmlObject xmlObject) throws DecodingException {
        try {
            return this.createEnvelope(xmlObject);
        }
        catch (DecodingException de) {
            return this.createFault(de);
        }
    }

    protected abstract SoapRequest createEnvelope(XmlObject var1) throws DecodingException;

    protected abstract SoapRequest createFault(DecodingException var1);

    protected OwsServiceRequest getSOAPBodyContent(SOAPMessage message) throws DecodingException {
        try {
            Document bodyRequestDoc = message.getSOAPBody().extractContentAsDocument();
            String xmlString = W3cHelper.nodeToXmlString(bodyRequestDoc.getDocumentElement());
            return (OwsServiceRequest)this.decodeXmlElement(XmlObject.Factory.parse((String)xmlString, (XmlOptions)this.getXmlOptions()));
        }
        catch (IOException | SOAPException | XmlException e) {
            throw new DecodingException("Error while parsing SOAPMessage body content!", e);
        }
    }

    protected List<SoapHeader> getSoapHeader(SOAPHeader soapHeader) {
        HashMap headersByNamespace = new HashMap();
        Iterator headerElements = soapHeader.extractAllHeaderElements();
        while (headerElements.hasNext()) {
            SOAPHeaderElement element = (SOAPHeaderElement)headerElements.next();
            ((List)headersByNamespace.computeIfAbsent(element.getNamespaceURI(), Functions.forSupplier(LinkedList::new))).add(element);
        }
        ArrayList soapHeaders = Lists.newArrayList();
        for (Map.Entry key : headersByNamespace.entrySet()) {
            String namespace = (String)key.getKey();
            try {
                Decoder decoder = this.getDecoder((DecoderKey)new XmlNamespaceDecoderKey(namespace, SOAPHeaderElement.class), new DecoderKey[0]);
                if (decoder != null) {
                    Object object = decoder.decode(headersByNamespace.get(namespace));
                    if (object instanceof SoapHeader) {
                        soapHeaders.add((SoapHeader)object);
                        continue;
                    }
                    if (!(object instanceof List)) continue;
                    for (Object o : (List)object) {
                        if (!(o instanceof SoapHeader)) continue;
                        soapHeaders.add((SoapHeader)o);
                    }
                    continue;
                }
                LOGGER.warn("The SOAP-Header elements for namespace '{}' are not supported by this server!", (Object)namespace);
            }
            catch (DecodingException owse) {
                LOGGER.debug("Requested SOAPHeader element is not supported", (Throwable)owse);
            }
        }
        return soapHeaders;
    }

    protected String checkSoapAction(String soapAction, List<SoapHeader> soapHeaders) {
        if (soapAction != null && !soapAction.isEmpty()) {
            return soapAction;
        }
        if (CollectionHelper.isNotEmpty(soapHeaders)) {
            for (SoapHeader soapHeader : soapHeaders) {
                if (!"http://www.w3.org/2005/08/addressing".equals(soapHeader.getNamespace()) || !(soapHeader instanceof WsaActionHeader)) continue;
                return ((WsaActionHeader)soapHeader).getValue();
            }
        }
        return null;
    }

    protected String getFaultReasons(DecodingException de) {
        if (de.getCause() instanceof CompositeException) {
            return Joiner.on((String)"\n").join((Iterable)((CompositeException)de.getCause()).getExceptions().stream().map(e -> e.getMessage()).collect(Collectors.toList()));
        }
        return de.getMessage();
    }
}

