/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.opengis.gml.x32.AbstractCurveType;
import net.opengis.gml.x32.AbstractFeatureType;
import net.opengis.gml.x32.AbstractGMLType;
import net.opengis.gml.x32.AbstractGeometryType;
import net.opengis.gml.x32.AbstractRingPropertyType;
import net.opengis.gml.x32.AbstractRingType;
import net.opengis.gml.x32.AbstractSurfaceType;
import net.opengis.gml.x32.CodeWithAuthorityType;
import net.opengis.gml.x32.CompositeSurfaceType;
import net.opengis.gml.x32.CoordinatesType;
import net.opengis.gml.x32.CurvePropertyType;
import net.opengis.gml.x32.DirectPositionListType;
import net.opengis.gml.x32.DirectPositionType;
import net.opengis.gml.x32.EnvelopeDocument;
import net.opengis.gml.x32.EnvelopeType;
import net.opengis.gml.x32.FeatureCollectionDocument;
import net.opengis.gml.x32.FeatureCollectionType;
import net.opengis.gml.x32.FeaturePropertyType;
import net.opengis.gml.x32.GeometryPropertyType;
import net.opengis.gml.x32.LineStringType;
import net.opengis.gml.x32.LinearRingType;
import net.opengis.gml.x32.MeasureType;
import net.opengis.gml.x32.MultiCurveDocument;
import net.opengis.gml.x32.MultiCurveType;
import net.opengis.gml.x32.PointDocument;
import net.opengis.gml.x32.PointType;
import net.opengis.gml.x32.PolygonType;
import net.opengis.gml.x32.ReferenceType;
import net.opengis.gml.x32.SurfacePropertyType;
import net.opengis.gml.x32.TimeInstantDocument;
import net.opengis.gml.x32.TimeInstantType;
import net.opengis.gml.x32.TimePeriodDocument;
import net.opengis.gml.x32.TimePeriodType;
import net.opengis.gml.x32.TimePositionType;
import net.opengis.gml.x32.VerticalDatumPropertyType;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;
import org.n52.janmayen.NcName;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gml.AbstractGML;
import org.n52.shetland.ogc.gml.AbstractGeometry;
import org.n52.shetland.ogc.gml.CodeType;
import org.n52.shetland.ogc.gml.CodeWithAuthority;
import org.n52.shetland.ogc.gml.GmlMeasureType;
import org.n52.shetland.ogc.gml.time.IndeterminateValue;
import org.n52.shetland.ogc.gml.time.TimeInstant;
import org.n52.shetland.ogc.gml.time.TimePeriod;
import org.n52.shetland.ogc.om.features.FeatureCollection;
import org.n52.shetland.ogc.om.features.samplingFeatures.AbstractSamplingFeature;
import org.n52.shetland.ogc.om.features.samplingFeatures.SamplingFeature;
import org.n52.shetland.ogc.sos.Sos2Constants;
import org.n52.shetland.util.CRSHelper;
import org.n52.shetland.util.CollectionHelper;
import org.n52.shetland.util.DateTimeHelper;
import org.n52.shetland.util.DateTimeParseException;
import org.n52.shetland.util.JTSHelper;
import org.n52.shetland.util.ReferencedEnvelope;
import org.n52.svalbard.decode.AbstractGmlDecoderv321;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderInputException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderXmlInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GmlDecoderv321
extends AbstractGmlDecoderv321<XmlObject, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GmlDecoderv321.class);
    private static final Set<DecoderKey> DECODER_KEYS = CollectionHelper.union((Set[])new Set[]{CodingHelper.decoderKeysForElements((String)"http://www.opengis.net/gml/3.2", (Class[])new Class[]{EnvelopeDocument.class, EnvelopeType.class, TimeInstantType.class, TimePeriodType.class, TimeInstantDocument.class, TimePeriodDocument.class, ReferenceType.class, MeasureType.class, PointType.class, PointDocument.class, LineStringType.class, MultiCurveDocument.class, MultiCurveType.class, PolygonType.class, CompositeSurfaceType.class, CodeWithAuthorityType.class, net.opengis.gml.x32.CodeType.class, FeaturePropertyType.class, GeometryPropertyType.class, VerticalDatumPropertyType.class, FeatureCollectionDocument.class, FeatureCollectionType.class}), CodingHelper.decoderKeysForElements((String)MeasureType.type.toString(), (Class[])new Class[]{MeasureType.class})});
    private static final String CS = ",";
    private static final String DECIMAL = ".";
    private static final String TS = " ";
    private static final int DEFAULT_SRID = 4326;

    public GmlDecoderv321() {
        LOGGER.debug("Decoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(DECODER_KEYS));
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    public Object decode(XmlObject xmlObject) throws DecodingException {
        if (xmlObject instanceof FeaturePropertyType) {
            return this.parseFeaturePropertyType((FeaturePropertyType)xmlObject);
        }
        if (xmlObject instanceof EnvelopeDocument) {
            return this.parseEnvelope(((EnvelopeDocument)xmlObject).getEnvelope());
        }
        if (xmlObject instanceof EnvelopeType) {
            return this.parseEnvelope((EnvelopeType)xmlObject);
        }
        if (xmlObject instanceof TimeInstantType) {
            return this.parseTimeInstant((TimeInstantType)xmlObject);
        }
        if (xmlObject instanceof TimePeriodType) {
            return this.parseTimePeriod((TimePeriodType)xmlObject);
        }
        if (xmlObject instanceof TimeInstantDocument) {
            return this.parseTimeInstant(((TimeInstantDocument)xmlObject).getTimeInstant());
        }
        if (xmlObject instanceof TimePeriodDocument) {
            return this.parseTimePeriod(((TimePeriodDocument)xmlObject).getTimePeriod());
        }
        if (xmlObject instanceof ReferenceType) {
            return this.parseReferenceType((ReferenceType)xmlObject);
        }
        if (xmlObject instanceof MeasureType) {
            return this.parseMeasureType((MeasureType)xmlObject);
        }
        if (xmlObject instanceof PointType) {
            return this.parsePointType((PointType)xmlObject);
        }
        if (xmlObject instanceof PointDocument) {
            return this.parsePointType(((PointDocument)xmlObject).getPoint());
        }
        if (xmlObject instanceof LineStringType) {
            return this.parseLineStringType((LineStringType)xmlObject);
        }
        if (xmlObject instanceof PolygonType) {
            return this.parsePolygonType((PolygonType)xmlObject);
        }
        if (xmlObject instanceof CompositeSurfaceType) {
            return this.parseCompositeSurfaceType((CompositeSurfaceType)xmlObject);
        }
        if (xmlObject instanceof CodeWithAuthorityType) {
            return this.parseCodeWithAuthorityTye((CodeWithAuthorityType)xmlObject);
        }
        if (xmlObject instanceof net.opengis.gml.x32.CodeType) {
            return this.parseCodeType((net.opengis.gml.x32.CodeType)xmlObject);
        }
        if (xmlObject instanceof GeometryPropertyType) {
            return this.parseGeometryPropertyType((GeometryPropertyType)xmlObject);
        }
        if (xmlObject instanceof VerticalDatumPropertyType) {
            return this.parseVerticalDatumPropertyType((VerticalDatumPropertyType)xmlObject);
        }
        if (xmlObject instanceof FeatureCollectionDocument) {
            return this.parseFeatureCollectionDocument((FeatureCollectionDocument)xmlObject);
        }
        if (xmlObject instanceof FeatureCollectionType) {
            return this.parseFeatureCollectionType((FeatureCollectionType)xmlObject);
        }
        if (xmlObject instanceof MultiCurveDocument) {
            return this.parseMultiCurveDocument((MultiCurveDocument)xmlObject);
        }
        if (xmlObject instanceof MultiCurveType) {
            return this.parseMultiCurveType((MultiCurveType)xmlObject);
        }
        throw new UnsupportedDecoderXmlInputException((Decoder<?, ?>)this, xmlObject);
    }

    private Object parseFeaturePropertyType(FeaturePropertyType featurePropertyType) throws DecodingException {
        SamplingFeature feature = null;
        if (featurePropertyType.getHref() != null) {
            if (featurePropertyType.getHref().startsWith("#")) {
                feature = new SamplingFeature(null, featurePropertyType.getHref().replace("#", ""));
            } else {
                feature = new SamplingFeature(new CodeWithAuthority(featurePropertyType.getHref()));
                if (featurePropertyType.getTitle() != null && !featurePropertyType.getTitle().isEmpty()) {
                    feature.addName(new CodeType(featurePropertyType.getTitle()));
                }
            }
            feature.setGmlId("ssf_" + NcName.makeValid((String)featurePropertyType.getHref()));
        } else {
            AbstractFeatureType abstractFeature = null;
            if (featurePropertyType.getAbstractFeature() != null) {
                abstractFeature = featurePropertyType.getAbstractFeature();
            } else if (featurePropertyType.getDomNode().hasChildNodes()) {
                try {
                    abstractFeature = XmlObject.Factory.parse((Node)XmlHelper.getNodeFromNodeList((NodeList)featurePropertyType.getDomNode().getChildNodes()));
                }
                catch (XmlException xmle) {
                    throw new DecodingException("Error while parsing feature request!", (Throwable)xmle);
                }
            }
            if (abstractFeature != null) {
                Object decodedObject = this.decodeXmlObject((XmlObject)abstractFeature);
                if (decodedObject instanceof AbstractSamplingFeature) {
                    feature = (AbstractSamplingFeature)decodedObject;
                } else {
                    throw GmlDecoderv321.unsupportedFeaturePropertyType();
                }
            }
        }
        if (feature == null) {
            throw GmlDecoderv321.unsupportedFeaturePropertyType();
        }
        return feature;
    }

    private FeatureCollection parseFeatureCollectionDocument(FeatureCollectionDocument featureCollectionDocument) throws DecodingException {
        return this.parseFeatureCollectionType(featureCollectionDocument.getFeatureCollection());
    }

    private FeatureCollection parseFeatureCollectionType(FeatureCollectionType featureCollectionType) throws DecodingException {
        FeatureCollection feaColl = new FeatureCollection();
        for (FeaturePropertyType feaPropType : featureCollectionType.getFeatureMemberArray()) {
            Object decoded = this.decodeXmlElement((XmlObject)feaPropType);
            feaColl.addMember((AbstractFeature)decoded);
        }
        return feaColl;
    }

    private ReferencedEnvelope parseEnvelope(EnvelopeType envelopeType) throws DecodingException {
        int srid = CRSHelper.parseSrsName((String)envelopeType.getSrsName());
        String lowerCorner = envelopeType.getLowerCorner().getStringValue();
        String upperCorner = envelopeType.getUpperCorner().getStringValue();
        return new ReferencedEnvelope(JTSHelper.createEnvelopeFromLowerUpperCorner((String)lowerCorner, (String)upperCorner), srid);
    }

    private Object parseTimeInstant(TimeInstantType xbTimeIntant) throws DecodingException {
        TimeInstant ti = this.parseTimePosition(xbTimeIntant.getTimePosition());
        ti.setGmlId(xbTimeIntant.getId());
        return ti;
    }

    private Object parseTimePeriod(TimePeriodType xbTimePeriod) throws DecodingException {
        TimePositionType xbBeginTPT = xbTimePeriod.getBeginPosition();
        TimeInstant begin = null;
        if (xbBeginTPT == null) {
            throw new DecodingException("gml:TimePeriod must contain gml:beginPosition Element with valid ISO:8601 String!", new Object[0]);
        }
        begin = this.parseTimePosition(xbBeginTPT);
        TimePositionType xbEndTPT = xbTimePeriod.getEndPosition();
        TimeInstant end = null;
        if (xbEndTPT == null) {
            throw new DecodingException("gml:TimePeriod must contain gml:endPosition Element with valid ISO:8601 String!", new Object[0]);
        }
        end = this.parseTimePosition(xbEndTPT);
        TimePeriod timePeriod = new TimePeriod(begin, end);
        timePeriod.setGmlId(xbTimePeriod.getId());
        return timePeriod;
    }

    private TimeInstant parseTimePosition(TimePositionType xbTimePosition) throws DecodingException {
        TimeInstant ti = new TimeInstant();
        String timeString = xbTimePosition.getStringValue();
        if (timeString != null && !timeString.isEmpty()) {
            try {
                ti.setValue(DateTimeHelper.parseIsoString2DateTime((String)timeString));
                ti.setRequestedTimeLength(DateTimeHelper.getTimeLengthBeforeTimeZone((String)timeString));
            }
            catch (DateTimeParseException ex) {
                ti.setIndeterminateValue(new IndeterminateValue(timeString, new String[0]));
            }
        }
        if (xbTimePosition.isSetIndeterminatePosition()) {
            ti.setIndeterminateValue(new IndeterminateValue(xbTimePosition.getIndeterminatePosition().toString(), new String[0]));
        }
        return ti;
    }

    private GmlMeasureType parseMeasureType(MeasureType measureType) {
        GmlMeasureType sosMeasureType = new GmlMeasureType(Double.valueOf(measureType.getDoubleValue()));
        sosMeasureType.setUnit(measureType.getUom());
        return sosMeasureType;
    }

    private AbstractGeometry parseGeometryPropertyType(GeometryPropertyType geometryPropertyType) throws DecodingException {
        return this.parseAbstractGeometryType(geometryPropertyType.getAbstractGeometry());
    }

    private AbstractGeometry parseAbstractGeometryType(AbstractGeometryType agt) throws DecodingException {
        AbstractGeometry abstractGeometry = new AbstractGeometry(agt.getId());
        this.parseAbstractGMLType((AbstractGMLType)agt, (AbstractGML)abstractGeometry);
        abstractGeometry.setGeometry((Geometry)this.decode((XmlObject)agt));
        return abstractGeometry;
    }

    private Geometry parsePointType(PointType xbPointType) throws DecodingException {
        String geomWKT = null;
        int srid = -1;
        if (xbPointType.getSrsName() != null) {
            srid = CRSHelper.parseSrsName((String)xbPointType.getSrsName());
        }
        if (xbPointType.getPos() != null) {
            DirectPositionType xbPos = xbPointType.getPos();
            if (srid == -1 && xbPos.getSrsName() != null) {
                srid = CRSHelper.parseSrsName((String)xbPos.getSrsName());
            }
            String directPosition = this.getString4Pos(xbPos);
            geomWKT = "POINT(" + directPosition + ")";
        } else if (xbPointType.getCoordinates() != null) {
            CoordinatesType xbCoords = xbPointType.getCoordinates();
            String directPosition = this.getString4Coordinates(xbCoords);
            geomWKT = "POINT" + directPosition;
        } else {
            throw new DecodingException("For geometry type 'gml:Point' only element 'gml:pos' and 'gml:coordinates' are allowed in the feature of interest parameter!", new Object[0]);
        }
        srid = this.setDefaultForUnsetSrid(srid);
        try {
            return JTSHelper.createGeometryFromWKT((String)geomWKT, (int)srid);
        }
        catch (ParseException ex) {
            throw new DecodingException((Throwable)ex);
        }
    }

    private Geometry parseLineStringType(LineStringType xbLineStringType) throws DecodingException {
        String geomWKT;
        DirectPositionType[] xbPositions;
        int srid = -1;
        if (xbLineStringType.getSrsName() != null) {
            srid = CRSHelper.parseSrsName((String)xbLineStringType.getSrsName());
        }
        if ((xbPositions = xbLineStringType.getPosArray()) != null && xbPositions.length > 0) {
            if (srid == -1 && xbPositions[0].getSrsName() != null && !xbPositions[0].getSrsName().isEmpty()) {
                srid = CRSHelper.parseSrsName((String)xbPositions[0].getSrsName());
            }
            geomWKT = "LINESTRING" + this.getString4PosArray(xbLineStringType.getPosArray(), false) + "";
        } else if (xbLineStringType.getPosList() != null) {
            StringBuilder builder = new StringBuilder();
            builder.append("LINESTRING(");
            DirectPositionListType posList = xbLineStringType.getPosList();
            int dim = posList.getSrsDimension() == null ? 2 : posList.getSrsDimension().intValue();
            if (posList.getListValue().size() % dim != 0) {
                throw new DecodingException("posList does not contain a multiple of %d coordinates", new Object[]{dim});
            }
            Iterator iterator = posList.getListValue().iterator();
            if (iterator.hasNext()) {
                int i;
                builder.append(iterator.next());
                for (i = 1; i < dim; ++i) {
                    builder.append(' ').append(iterator.next());
                }
                while (iterator.hasNext()) {
                    builder.append(", ");
                    builder.append(iterator.next());
                    for (i = 1; i < dim; ++i) {
                        builder.append(' ').append(iterator.next());
                    }
                }
            }
            builder.append(")");
            geomWKT = builder.toString();
        } else {
            geomWKT = null;
        }
        srid = this.setDefaultForUnsetSrid(srid);
        if (geomWKT != null) {
            try {
                return JTSHelper.createGeometryFromWKT(geomWKT, (int)srid);
            }
            catch (ParseException ex) {
                throw new DecodingException((Throwable)ex);
            }
        }
        return JTSHelper.getGeometryFactoryForSRID((int)srid).createGeometryCollection(null);
    }

    private Geometry parsePolygonType(PolygonType xbPolygonType) throws DecodingException {
        AbstractRingPropertyType[] xbInterior;
        int srid = -1;
        if (xbPolygonType.getSrsName() != null) {
            srid = CRSHelper.parseSrsName((String)xbPolygonType.getSrsName());
        }
        String exteriorCoordString = null;
        StringBuilder geomWKT = new StringBuilder();
        StringBuilder interiorCoordString = new StringBuilder();
        AbstractRingPropertyType xbExterior = xbPolygonType.getExterior();
        if (xbExterior != null) {
            AbstractRingType xbExteriorRing = xbExterior.getAbstractRing();
            if (xbExteriorRing instanceof LinearRingType) {
                AbstractRingPropertyType[] xbLinearRing = (AbstractRingPropertyType[])xbExteriorRing;
                exteriorCoordString = this.getCoordString4LinearRing((LinearRingType)xbLinearRing);
            } else {
                throw new DecodingException("The Polygon must contain the following elements <gml:exterior><gml:LinearRing><gml:posList>!", new Object[0]);
            }
        }
        if ((xbInterior = xbPolygonType.getInteriorArray()) != null && xbInterior.length != 0) {
            for (AbstractRingPropertyType xbInteriorRing : xbInterior) {
                if (!(xbInteriorRing.getAbstractRing() instanceof LinearRingType)) continue;
                interiorCoordString.append(", ").append(this.getCoordString4LinearRing((LinearRingType)xbInteriorRing.getAbstractRing()));
            }
        }
        geomWKT.append("POLYGON(");
        geomWKT.append(exteriorCoordString);
        geomWKT.append((CharSequence)interiorCoordString);
        geomWKT.append(")");
        srid = this.setDefaultForUnsetSrid(srid);
        try {
            return JTSHelper.createGeometryFromWKT((String)geomWKT.toString(), (int)srid);
        }
        catch (ParseException ex) {
            throw new DecodingException((Throwable)ex);
        }
    }

    private Geometry parseMultiCurveDocument(MultiCurveDocument multiCurveDocument) throws DecodingException {
        return this.parseMultiCurveType(multiCurveDocument.getMultiCurve());
    }

    private Geometry parseMultiCurveType(MultiCurveType multiCurveType) throws DecodingException {
        ArrayList<Geometry> curves = new ArrayList<Geometry>(multiCurveType.getCurveMemberArray().length);
        for (CurvePropertyType curvePropertyType : multiCurveType.getCurveMemberArray()) {
            if (curvePropertyType.getAbstractCurve() == null) continue;
            curves.add(this.parseAbstractCurveType(curvePropertyType.getAbstractCurve()));
        }
        return JTSHelper.getGeometryFactoryForSRID((int)this.getSRID((AbstractGeometryType)multiCurveType)).buildGeometry(curves);
    }

    private int getSRID(AbstractGeometryType abstractGeometryType) {
        String srsName = abstractGeometryType.getSrsName();
        int srid = CRSHelper.parseSrsName((String)srsName);
        return srid <= 0 ? 4326 : srid;
    }

    private Geometry parseAbstractCurveType(AbstractCurveType abstractCurveType) throws DecodingException {
        if (abstractCurveType instanceof LineStringType) {
            return this.parseLineStringType((LineStringType)abstractCurveType);
        }
        throw new UnsupportedDecoderInputException((Decoder)this, (Object)abstractCurveType);
    }

    private Geometry parseCompositeSurfaceType(CompositeSurfaceType xbCompositeSurface) throws DecodingException {
        SurfacePropertyType[] xbCurfaceProperties = xbCompositeSurface.getSurfaceMemberArray();
        int srid = -1;
        ArrayList<Polygon> polygons = new ArrayList<Polygon>(xbCurfaceProperties.length);
        if (xbCompositeSurface.getSrsName() != null) {
            srid = CRSHelper.parseSrsName((String)xbCompositeSurface.getSrsName());
        }
        for (SurfacePropertyType xbSurfaceProperty : xbCurfaceProperties) {
            AbstractSurfaceType xbAbstractSurface = xbSurfaceProperty.getAbstractSurface();
            if (srid == -1 && xbAbstractSurface.getSrsName() != null) {
                srid = CRSHelper.parseSrsName((String)xbAbstractSurface.getSrsName());
            }
            if (!(xbAbstractSurface instanceof PolygonType)) {
                throw new DecodingException("The FeatureType %s is not supportted! Only PolygonType", new Object[]{xbAbstractSurface});
            }
            polygons.add((Polygon)this.parsePolygonType((PolygonType)xbAbstractSurface));
        }
        if (polygons.isEmpty()) {
            throw new DecodingException("The FeatureType: %s does not contain any member!", new Object[]{xbCompositeSurface});
        }
        srid = this.setDefaultForUnsetSrid(srid);
        GeometryFactory factory = new GeometryFactory();
        MultiPolygon geom = factory.createMultiPolygon(polygons.toArray(new Polygon[polygons.size()]));
        geom.setSRID(srid);
        return geom;
    }

    private org.n52.shetland.ogc.gml.ReferenceType parseVerticalDatumPropertyType(VerticalDatumPropertyType vdpt) {
        if (vdpt.isSetHref() && !vdpt.getHref().isEmpty()) {
            org.n52.shetland.ogc.gml.ReferenceType referenceType = new org.n52.shetland.ogc.gml.ReferenceType(vdpt.getHref());
            if (vdpt.isSetTitle() && !vdpt.getTitle().isEmpty()) {
                referenceType.setTitle(vdpt.getTitle());
            }
            return referenceType;
        }
        return new org.n52.shetland.ogc.gml.ReferenceType("UNKNOWN");
    }

    private String getCoordString4LinearRing(LinearRingType xbLinearRing) throws DecodingException {
        String result = "";
        DirectPositionListType xbPosList = xbLinearRing.getPosList();
        CoordinatesType xbCoordinates = xbLinearRing.getCoordinates();
        DirectPositionType[] xbPosArray = xbLinearRing.getPosArray();
        if (xbPosList != null && !xbPosList.getStringValue().isEmpty()) {
            result = this.getString4PosList(xbPosList);
        } else if (xbCoordinates != null && !xbCoordinates.getStringValue().isEmpty()) {
            result = this.getString4Coordinates(xbCoordinates);
        } else if (xbPosArray != null && xbPosArray.length > 0) {
            result = this.getString4PosArray(xbPosArray, true);
        } else {
            throw new DecodingException("The Polygon must contain the following elements <gml:exterior><gml:LinearRing><gml:posList>, <gml:exterior><gml:LinearRing><gml:coordinates> or <gml:exterior><gml:LinearRing><gml:pos>{<gml:pos>}!", new Object[0]);
        }
        return result;
    }

    private String getString4Pos(DirectPositionType xbPos) {
        return xbPos.getStringValue();
    }

    private String getString4PosArray(DirectPositionType[] xbPosArray, boolean polygon) {
        StringBuilder coordinateString = new StringBuilder();
        coordinateString.append("(");
        for (DirectPositionType directPositionType : xbPosArray) {
            coordinateString.append(directPositionType.getStringValue());
            coordinateString.append(", ");
        }
        if (polygon) {
            coordinateString.append(xbPosArray[0].getStringValue());
        } else {
            coordinateString.delete(coordinateString.length() - 2, coordinateString.length());
        }
        coordinateString.append(")");
        return coordinateString.toString();
    }

    private String getString4PosList(DirectPositionListType xbPosList) throws DecodingException {
        StringBuilder coordinateString = new StringBuilder("(");
        List values = xbPosList.getListValue();
        if (values.size() % 2 != 0) {
            throw new DecodingException("The Polygons posList must contain pairs of coordinates!", new Object[0]);
        }
        for (int i = 0; i < values.size(); ++i) {
            coordinateString.append(values.get(i));
            if (i % 2 != 0) {
                coordinateString.append(", ");
                continue;
            }
            coordinateString.append(TS);
        }
        int length = coordinateString.length();
        coordinateString.delete(length - 2, length);
        coordinateString.append(")");
        return coordinateString.toString();
    }

    private String getString4Coordinates(CoordinatesType xbCoordinates) {
        String coordinateString = "(" + xbCoordinates.getStringValue() + ")";
        if (!xbCoordinates.getCs().equals(CS)) {
            coordinateString = coordinateString.replace(xbCoordinates.getCs(), CS);
        }
        if (!xbCoordinates.getDecimal().equals(DECIMAL)) {
            coordinateString = coordinateString.replace(xbCoordinates.getDecimal(), DECIMAL);
        }
        if (!xbCoordinates.getTs().equals(TS)) {
            coordinateString = coordinateString.replace(xbCoordinates.getTs(), TS);
        }
        return coordinateString;
    }

    private int setDefaultForUnsetSrid(int srid) throws DecodingException {
        if (srid == 0 || srid == -1) {
            LOGGER.warn("No SrsName is specified for geometry, instead the default 4326 is taken!");
            return 4326;
        }
        return srid;
    }

    private static DecodingException unsupportedFeaturePropertyType() {
        return new DecodingException((Enum)Sos2Constants.InsertObservationParams.observation, "The requested featurePropertyType type is not supported by this service!", new Object[0]);
    }
}

