/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import java.util.Map;
import net.opengis.gml.x32.DiscreteCoverageType;
import net.opengis.gml.x32.DomainSetType;
import net.opengis.gml.x32.MultiPointDomainDocument;
import org.apache.xmlbeans.XmlObject;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.n52.shetland.ogc.om.values.DiscreteCoverage;
import org.n52.shetland.ogc.om.values.MultiPointCoverage;
import org.n52.shetland.util.IdGenerator;
import org.n52.svalbard.encode.AbstractCoverageEncoder;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.exception.EncodingException;

public abstract class AbstractMultiPointCoverageTypeEncoder<T>
extends AbstractCoverageEncoder<T, MultiPointCoverage> {
    protected DiscreteCoverageType encodeMultiPointCoverageType(DiscreteCoverageType dct, MultiPointCoverage multiPointCoverage) throws EncodingException {
        dct.setId(multiPointCoverage.getGmlId());
        MultiPointCoverage.PointValueLists pointValues = multiPointCoverage.getPointValue();
        this.encodeMultiPointDomain(dct, pointValues);
        this.encodeRangeSet(dct, (DiscreteCoverage<?>)multiPointCoverage);
        return dct;
    }

    private void encodeMultiPointDomain(DiscreteCoverageType dct, MultiPointCoverage.PointValueLists pointValues) throws EncodingException {
        MultiPointDomainDocument mpdd = MultiPointDomainDocument.Factory.newInstance();
        DomainSetType mpdst = mpdd.addNewMultiPointDomain();
        GeometryFactory factory = ((Point)pointValues.getPoints().get(0)).getFactory();
        MultiPoint multiPoint = factory.createMultiPoint(pointValues.getPoints().toArray(new Point[0]));
        EncodingContext ec = EncodingContext.of((Enum)XmlBeansEncodingFlags.GMLID, (Object)IdGenerator.generate((String)multiPoint.toString())).with((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE, (Object)true);
        XmlObject encodedGeometry = this.encodeGML(multiPoint, ec);
        mpdst.addNewAbstractGeometry().set(encodedGeometry);
        this.substitute((XmlObject)mpdst.getAbstractGeometry(), encodedGeometry);
        dct.setDomainSet(mpdst);
    }

    public void addNamespacePrefixToMap(Map<String, String> nameSpacePrefixMap) {
        super.addNamespacePrefixToMap(nameSpacePrefixMap);
        nameSpacePrefixMap.put("http://www.opengis.net/gml/3.2", "gml");
    }

    protected XmlObject encodeGML(Object o, EncodingContext ec) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/gml/3.2", o, ec);
    }
}

