/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import java.io.IOException;
import java.util.Set;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.custommonkey.xmlunit.Diff;
import org.n52.janmayen.NcName;
import org.n52.svalbard.encode.AbstractXmlEncoder;
import org.n52.svalbard.encode.ProcedureEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public abstract class AbstractSensorMLEncoder
extends AbstractXmlEncoder<XmlObject, Object>
implements ProcedureEncoder<XmlObject, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSensorMLEncoder.class);
    private static final String OUTPUT_PREFIX = "output#";

    protected boolean isIdentical(XmlObject xmlObject, XmlOptions xmlOptions, XmlObject anotherXmlObject) {
        try {
            return new Diff(xmlObject.xmlText(xmlOptions), anotherXmlObject.xmlText(xmlOptions)).similar();
        }
        catch (IOException | SAXException e) {
            LOGGER.error("Exception thrown: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    protected String getValidOutputName(int counter, Set<String> outputNames) {
        String outputName = OUTPUT_PREFIX + counter;
        while (outputNames.contains(outputName)) {
            outputName = OUTPUT_PREFIX + (counter + 1);
        }
        return NcName.makeValid((String)outputName);
    }
}

