/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.collect.Sets;
import java.util.Set;
import net.opengis.sos.x10.DescribeSensorDocument;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.shetland.ogc.sos.SosConstants;
import org.n52.shetland.ogc.sos.request.DescribeSensorRequest;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.AbstractSosV1RequestEncoder;
import org.n52.svalbard.encode.exception.EncodingException;

public class DescribeSensorV1RequestEncoder
extends AbstractSosV1RequestEncoder<DescribeSensorRequest> {
    public DescribeSensorV1RequestEncoder() {
        super(SosConstants.Operations.DescribeSensor.name(), DescribeSensorRequest.class);
    }

    @Override
    protected Set<SchemaLocation> getConcreteSchemaLocations() {
        return Sets.newHashSet();
    }

    @Override
    protected XmlObject create(DescribeSensorRequest request) throws EncodingException {
        DescribeSensorDocument doc = DescribeSensorDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        DescribeSensorDocument.DescribeSensor descSens = doc.addNewDescribeSensor();
        this.addVersion(descSens, request);
        this.addService(descSens, request);
        this.addProcedure(descSens, request);
        this.addOutputFormat(descSens, request);
        return doc;
    }

    private void addVersion(DescribeSensorDocument.DescribeSensor descSens, DescribeSensorRequest request) {
        if (request.getVersion() != null) {
            descSens.setVersion(request.getVersion());
        } else {
            descSens.setVersion("1.0.0");
        }
    }

    private void addService(DescribeSensorDocument.DescribeSensor descSens, DescribeSensorRequest request) {
        if (request.getService() != null) {
            descSens.setService(request.getService());
        } else {
            descSens.setService("SOS");
        }
    }

    private void addProcedure(DescribeSensorDocument.DescribeSensor descSens, DescribeSensorRequest request) {
        descSens.setProcedure(request.getProcedure());
    }

    private void addOutputFormat(DescribeSensorDocument.DescribeSensor descSens, DescribeSensorRequest request) {
        descSens.setOutputFormat(request.getProcedureDescriptionFormat());
    }
}

