/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import net.opengis.gml.x32.PointPropertyType;
import net.opengis.gml.x32.PointType;
import org.apache.xmlbeans.XmlObject;
import org.locationtech.jts.geom.Point;
import org.n52.svalbard.encode.AbstractXmlEncoder;
import org.n52.svalbard.encode.ClassToClassEncoderKey;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.XmlPropertyTypeEncoderKey;
import org.n52.svalbard.encode.exception.EncodingException;

public class PointPropertyTypeEncoder
extends AbstractXmlEncoder<PointPropertyType, Point> {
    private static final Set<EncoderKey> ENCODER_KEYS = Sets.newHashSet((Object[])new EncoderKey[]{new ClassToClassEncoderKey(PointPropertyType.class, Point.class), new XmlPropertyTypeEncoderKey("http://www.opengis.net/gml/3.2", Point.class)});

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEYS);
    }

    @Override
    public PointPropertyType encode(Point point) throws EncodingException {
        return this.encode(point, EncodingContext.empty());
    }

    public PointPropertyType encode(Point point, EncodingContext ec) throws EncodingException {
        PointPropertyType ppt = PointPropertyType.Factory.newInstance();
        ppt.setPoint(this.encodePointType(point, ec));
        return ppt;
    }

    private PointType encodePointType(Point point, EncodingContext ec) throws EncodingException {
        return (PointType)this.encodeGML(point, ec);
    }

    protected XmlObject encodeGML(Object o, EncodingContext ec) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/gml/3.2", o, ec);
    }
}

