/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.opengis.gml.FeaturePropertyType;
import net.opengis.sampling.x10.SamplingCurveDocument;
import net.opengis.sampling.x10.SamplingCurveType;
import net.opengis.sampling.x10.SamplingFeatureCollectionDocument;
import net.opengis.sampling.x10.SamplingFeatureCollectionType;
import net.opengis.sampling.x10.SamplingFeaturePropertyType;
import net.opengis.sampling.x10.SamplingFeatureType;
import net.opengis.sampling.x10.SamplingPointDocument;
import net.opengis.sampling.x10.SamplingPointType;
import net.opengis.sampling.x10.SamplingSurfaceDocument;
import net.opengis.sampling.x10.SamplingSurfaceType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.joda.time.DateTime;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.n52.shetland.ogc.SupportedType;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gml.AbstractMetaData;
import org.n52.shetland.ogc.gml.CodeType;
import org.n52.shetland.ogc.om.features.FeatureCollection;
import org.n52.shetland.ogc.om.features.SfConstants;
import org.n52.shetland.ogc.om.features.samplingFeatures.AbstractSamplingFeature;
import org.n52.shetland.ogc.sos.FeatureType;
import org.n52.shetland.util.CollectionHelper;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.encode.AbstractXmlEncoder;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamplingEncoderv100
extends AbstractXmlEncoder<XmlObject, AbstractFeature> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SamplingEncoderv100.class);
    private static final Set<EncoderKey> ENCODER_KEYS = CollectionHelper.union((Set[])new Set[]{CodingHelper.encoderKeysForElements((String)"http://www.opengis.net/sampling/1.0", (Class[])new Class[]{AbstractFeature.class})});
    private static final Set<SupportedType> SUPPORTED_TYPES = ImmutableSet.of((Object)new FeatureType("http://www.opengis.net/def/nil/OGC/0/unknown"), (Object)new FeatureType("SamplingPoint"), (Object)new FeatureType("SamplingSurface"), (Object)new FeatureType("SamplingCurve"));

    public SamplingEncoderv100() {
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(ENCODER_KEYS));
    }

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEYS);
    }

    public Set<SupportedType> getSupportedTypes() {
        return Collections.unmodifiableSet(SUPPORTED_TYPES);
    }

    public void addNamespacePrefixToMap(Map<String, String> nameSpacePrefixMap) {
        nameSpacePrefixMap.put("http://www.opengis.net/sampling/1.0", "sa");
    }

    public Set<SchemaLocation> getSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{SfConstants.SA_SCHEMA_LOCATION});
    }

    public XmlObject encode(AbstractFeature abstractFeature, EncodingContext context) throws EncodingException {
        XmlObject encodedObject = this.createFeature(abstractFeature);
        if (LOGGER.isDebugEnabled()) {
            try {
                LOGGER.debug("Encoded object {} is valid: {}", (Object)encodedObject.schemaType().toString(), (Object)XmlHelper.validateDocument((XmlObject)encodedObject));
            }
            catch (DecodingException e) {
                throw new EncodingException((Throwable)e);
            }
        }
        return encodedObject;
    }

    private XmlObject createFeature(AbstractFeature absFeature) throws EncodingException {
        if (absFeature instanceof AbstractSamplingFeature) {
            AbstractSamplingFeature sampFeat = (AbstractSamplingFeature)absFeature;
            if (sampFeat.getFeatureType().equals("sa:SamplingPoint") || sampFeat.getFeatureType().equals("http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingPoint") || sampFeat.getGeometry() instanceof Point) {
                SamplingPointDocument xbSamplingPointDoc = SamplingPointDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
                SamplingPointType xbSamplingPoint = xbSamplingPointDoc.addNewSamplingPoint();
                this.addValuesToFeature((SamplingFeatureType)xbSamplingPoint, sampFeat);
                XmlObject xbGeomety = this.getEncodedGeometry(sampFeat.getGeometry(), absFeature.getGmlId());
                xbSamplingPoint.addNewPosition().addNewPoint().set(xbGeomety);
                sampFeat.wasEncoded();
                return xbSamplingPointDoc;
            }
            if (sampFeat.getFeatureType().equals("sa:SamplingCurve") || sampFeat.getFeatureType().equals("http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingCurve") || sampFeat.getGeometry() instanceof LineString) {
                SamplingCurveDocument xbSamplingCurveDoc = SamplingCurveDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
                SamplingCurveType xbSamplingCurve = xbSamplingCurveDoc.addNewSamplingCurve();
                this.addValuesToFeature((SamplingFeatureType)xbSamplingCurve, sampFeat);
                XmlObject xbGeomety = this.getEncodedGeometry(sampFeat.getGeometry(), absFeature.getGmlId());
                xbSamplingCurve.addNewShape().addNewCurve().set(xbGeomety);
                sampFeat.wasEncoded();
                return xbSamplingCurveDoc;
            }
            if (sampFeat.getFeatureType().equals("sa:SamplingSurface") || sampFeat.getFeatureType().equals("http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingSurface") || sampFeat.getGeometry() instanceof Polygon) {
                SamplingSurfaceDocument xbSamplingSurfaceDoc = SamplingSurfaceDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
                SamplingSurfaceType xbSamplingSurface = xbSamplingSurfaceDoc.addNewSamplingSurface();
                this.addValuesToFeature((SamplingFeatureType)xbSamplingSurface, sampFeat);
                XmlObject xbGeomety = this.getEncodedGeometry(sampFeat.getGeometry(), absFeature.getGmlId());
                xbSamplingSurface.addNewShape().addNewSurface().set(xbGeomety);
                sampFeat.wasEncoded();
                return xbSamplingSurfaceDoc;
            }
        } else if (absFeature instanceof FeatureCollection) {
            this.createFeatureCollection((FeatureCollection)absFeature);
        }
        throw new UnsupportedEncoderInputException((Encoder)this, (Object)absFeature);
    }

    private XmlObject getEncodedGeometry(Geometry geometry, String gmlId) throws UnsupportedEncoderInputException, EncodingException {
        Encoder encoder = this.getEncoder(this.getEncoderKey("http://www.opengis.net/gml", geometry), new EncoderKey[0]);
        if (encoder != null) {
            return (XmlObject)encoder.encode((Object)geometry, EncodingContext.of((Enum)XmlBeansEncodingFlags.GMLID, (Object)gmlId));
        }
        throw new EncodingException("Error while encoding geometry for feature, needed encoder is missing!", new Object[0]);
    }

    private void addValuesToFeature(SamplingFeatureType xbSamplingFeature, AbstractSamplingFeature sampFeat) throws EncodingException {
        xbSamplingFeature.setId(sampFeat.getGmlId());
        if (sampFeat.isSetIdentifier()) {
            sampFeat.getIdentifierCodeWithAuthority().setCodeSpace("uniquID");
            xbSamplingFeature.addNewName().set(this.encodeObjectToXml("http://www.opengis.net/gml", sampFeat.getIdentifierCodeWithAuthority()));
        }
        if (sampFeat.isSetName()) {
            for (CodeType sosName : sampFeat.getName()) {
                xbSamplingFeature.addNewName().set(this.encodeObjectToXml("http://www.opengis.net/gml", sosName));
            }
        }
        if (sampFeat.getSampledFeatures() != null && !sampFeat.getSampledFeatures().isEmpty()) {
            for (AbstractFeature sampledFeature : sampFeat.getSampledFeatures()) {
                FeaturePropertyType sp = xbSamplingFeature.addNewSampledFeature();
                sp.setHref(sampledFeature.getIdentifier());
                if (!sampFeat.isSetName() || !sampFeat.getFirstName().isSetValue()) continue;
                sp.setTitle(sampFeat.getFirstName().getValue());
            }
        } else {
            xbSamplingFeature.addNewSampledFeature().setHref("urn:ogc:def:nil:OGC:unknown");
        }
        this.setMetaDataProperty(xbSamplingFeature, sampFeat);
    }

    private void setMetaDataProperty(SamplingFeatureType sft, AbstractSamplingFeature sampFeat) throws EncodingException {
        if (sampFeat.isSetMetaDataProperty()) {
            for (AbstractMetaData abstractMetaData : sampFeat.getMetaDataProperty()) {
                XmlObject encodeObject = this.encodeObjectToXml("http://www.opengis.net/gml", abstractMetaData);
                sft.addNewMetaDataProperty().set(encodeObject);
            }
        }
    }

    private XmlObject createFeatureCollection(FeatureCollection sosFeatureCollection) throws EncodingException {
        SamplingFeatureCollectionDocument xbSampFeatCollDoc = SamplingFeatureCollectionDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        SamplingFeatureCollectionType xbSampFeatColl = xbSampFeatCollDoc.addNewSamplingFeatureCollection();
        xbSampFeatColl.setId("sfc_" + Long.toString(new DateTime().getMillis()));
        for (AbstractFeature sosAbstractFeature : sosFeatureCollection.getMembers().values()) {
            SamplingFeaturePropertyType xbFeatMember = xbSampFeatColl.addNewMember();
            xbFeatMember.set(this.createFeature(sosAbstractFeature));
        }
        return xbSampFeatCollDoc;
    }
}

