/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import net.opengis.gml.StringOrRefType;
import net.opengis.swe.x101.AbstractDataComponentType;
import net.opengis.swe.x101.AbstractEncodingType;
import net.opengis.swe.x101.AllowedTimesDocument;
import net.opengis.swe.x101.AllowedTimesPropertyType;
import net.opengis.swe.x101.AllowedTokensDocument;
import net.opengis.swe.x101.AllowedTokensPropertyType;
import net.opengis.swe.x101.AllowedValuesDocument;
import net.opengis.swe.x101.AllowedValuesPropertyType;
import net.opengis.swe.x101.AnyScalarPropertyType;
import net.opengis.swe.x101.BlockEncodingPropertyType;
import net.opengis.swe.x101.BooleanDocument;
import net.opengis.swe.x101.CategoryDocument;
import net.opengis.swe.x101.CountDocument;
import net.opengis.swe.x101.CountRangeDocument;
import net.opengis.swe.x101.DataArrayDocument;
import net.opengis.swe.x101.DataArrayType;
import net.opengis.swe.x101.DataComponentPropertyType;
import net.opengis.swe.x101.DataRecordDocument;
import net.opengis.swe.x101.DataRecordType;
import net.opengis.swe.x101.EnvelopeType;
import net.opengis.swe.x101.ObservablePropertyDocument;
import net.opengis.swe.x101.QualityPropertyType;
import net.opengis.swe.x101.QuantityDocument;
import net.opengis.swe.x101.QuantityRangeDocument;
import net.opengis.swe.x101.SimpleDataRecordType;
import net.opengis.swe.x101.TextBlockDocument;
import net.opengis.swe.x101.TextDocument;
import net.opengis.swe.x101.TimeDocument;
import net.opengis.swe.x101.TimeGeometricPrimitivePropertyType;
import net.opengis.swe.x101.TimeRangeDocument;
import net.opengis.swe.x101.UomPropertyType;
import net.opengis.swe.x101.VectorPropertyType;
import net.opengis.swe.x101.VectorType;
import org.apache.xmlbeans.GDateBuilder;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlDateTime;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlString;
import org.joda.time.DateTime;
import org.n52.shetland.ogc.UoM;
import org.n52.shetland.ogc.gml.time.TimePeriod;
import org.n52.shetland.ogc.swe.RangeValue;
import org.n52.shetland.ogc.swe.SweAbstractDataComponent;
import org.n52.shetland.ogc.swe.SweConstants;
import org.n52.shetland.ogc.swe.SweCoordinate;
import org.n52.shetland.ogc.swe.SweDataArray;
import org.n52.shetland.ogc.swe.SweDataRecord;
import org.n52.shetland.ogc.swe.SweEnvelope;
import org.n52.shetland.ogc.swe.SweField;
import org.n52.shetland.ogc.swe.SweSimpleDataRecord;
import org.n52.shetland.ogc.swe.SweVector;
import org.n52.shetland.ogc.swe.encoding.SweAbstractEncoding;
import org.n52.shetland.ogc.swe.encoding.SweTextEncoding;
import org.n52.shetland.ogc.swe.simpleType.SweAbstractSimpleType;
import org.n52.shetland.ogc.swe.simpleType.SweAllowedTimes;
import org.n52.shetland.ogc.swe.simpleType.SweAllowedTokens;
import org.n52.shetland.ogc.swe.simpleType.SweAllowedValues;
import org.n52.shetland.ogc.swe.simpleType.SweBoolean;
import org.n52.shetland.ogc.swe.simpleType.SweCategory;
import org.n52.shetland.ogc.swe.simpleType.SweCount;
import org.n52.shetland.ogc.swe.simpleType.SweCountRange;
import org.n52.shetland.ogc.swe.simpleType.SweObservableProperty;
import org.n52.shetland.ogc.swe.simpleType.SweQuality;
import org.n52.shetland.ogc.swe.simpleType.SweQuantity;
import org.n52.shetland.ogc.swe.simpleType.SweQuantityRange;
import org.n52.shetland.ogc.swe.simpleType.SweText;
import org.n52.shetland.ogc.swe.simpleType.SweTime;
import org.n52.shetland.ogc.swe.simpleType.SweTimeRange;
import org.n52.shetland.util.DateTimeHelper;
import org.n52.shetland.w3c.Nillable;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.shetland.w3c.xlink.Actuate;
import org.n52.shetland.w3c.xlink.Reference;
import org.n52.shetland.w3c.xlink.Referenceable;
import org.n52.shetland.w3c.xlink.Show;
import org.n52.shetland.w3c.xlink.Type;
import org.n52.svalbard.encode.AbstractXmlEncoder;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.NotYetSupportedEncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3.x1999.xlink.ActuateType;
import org.w3.x1999.xlink.ShowType;
import org.w3.x1999.xlink.TypeType;

public class SweCommonEncoderv101
extends AbstractXmlEncoder<XmlObject, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SweCommonEncoderv101.class);
    private static final String URN = "urn:";
    private static final String HTTP = "http://";
    private static final Set<EncoderKey> ENCODER_KEYS = CodingHelper.encoderKeysForElements((String)"http://www.opengis.net/swe/1.0.1", (Class[])new Class[]{SweBoolean.class, SweCategory.class, SweCount.class, SweObservableProperty.class, SweQuantity.class, SweQuantityRange.class, SweText.class, SweTime.class, SweTimeRange.class, SweEnvelope.class, SweCoordinate.class, SweDataArray.class, SweDataRecord.class, SweSimpleDataRecord.class, TimePeriod.class});

    public SweCommonEncoderv101() {
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(ENCODER_KEYS));
    }

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEYS);
    }

    public void addNamespacePrefixToMap(Map<String, String> nameSpacePrefixMap) {
        nameSpacePrefixMap.put("http://www.opengis.net/swe/1.0.1", "swe");
    }

    public Set<SchemaLocation> getSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{SweConstants.SWE_101_SCHEMA_LOCATION});
    }

    public XmlObject encode(Object element, EncodingContext context) throws EncodingException {
        AbstractDataComponentType encodedObject = null;
        if (element instanceof SweAbstractSimpleType) {
            encodedObject = this.createSimpleType((SweAbstractSimpleType)element, context);
        } else if (element instanceof SweCoordinate) {
            encodedObject = this.createCoordinate((SweCoordinate)element);
        } else if (element instanceof SweDataArray) {
            encodedObject = this.createDataArray((SweDataArray)element);
        } else if (element instanceof SweDataRecord) {
            DataRecordType drt = this.createDataRecord((SweDataRecord)element);
            if (context.has((Enum)XmlBeansEncodingFlags.DOCUMENT)) {
                DataRecordDocument drd = DataRecordDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
                drd.setDataRecord(drt);
                encodedObject = drd;
            } else {
                encodedObject = drt;
            }
        } else if (element instanceof SweEnvelope) {
            encodedObject = this.createEnvelope((SweEnvelope)element);
        } else if (element instanceof SweSimpleDataRecord) {
            encodedObject = this.createSimpleDataRecord((SweSimpleDataRecord)element);
        } else if (element instanceof TimePeriod) {
            encodedObject = this.createTimeGeometricPrimitivePropertyType((TimePeriod)element);
        } else {
            throw new UnsupportedEncoderInputException((Encoder)this, element);
        }
        XmlHelper.validateDocument((XmlObject)encodedObject, EncodingException::new);
        return encodedObject;
    }

    private AbstractDataComponentType createSimpleType(SweAbstractSimpleType<?> sosSimpleType) throws EncodingException {
        return this.createSimpleType(sosSimpleType, null);
    }

    private AbstractDataComponentType createSimpleType(SweAbstractSimpleType<?> sosSimpleType, EncodingContext additionalValues) throws EncodingException {
        BooleanDocument.Boolean abstractDataComponentType = null;
        if (sosSimpleType instanceof SweBoolean) {
            abstractDataComponentType = this.createBoolean((SweBoolean)sosSimpleType);
        } else if (sosSimpleType instanceof SweCategory) {
            abstractDataComponentType = this.createCategory((SweCategory)sosSimpleType);
        } else if (sosSimpleType instanceof SweCount) {
            abstractDataComponentType = this.createCount((SweCount)sosSimpleType);
        } else if (sosSimpleType instanceof SweCountRange) {
            abstractDataComponentType = this.createCountRange((SweCountRange)sosSimpleType);
        } else if (sosSimpleType instanceof SweObservableProperty) {
            abstractDataComponentType = this.createObservableProperty((SweObservableProperty)sosSimpleType);
        } else if (sosSimpleType instanceof SweQuantity) {
            abstractDataComponentType = this.createQuantity((SweQuantity)sosSimpleType);
        } else if (sosSimpleType instanceof SweQuantityRange) {
            abstractDataComponentType = this.createQuantityRange((SweQuantityRange)sosSimpleType);
        } else if (sosSimpleType instanceof SweText) {
            abstractDataComponentType = this.createText((SweText)sosSimpleType);
        } else if (sosSimpleType instanceof SweTimeRange) {
            abstractDataComponentType = this.createTimeRange((SweTimeRange)sosSimpleType);
        } else if (sosSimpleType instanceof SweTime) {
            abstractDataComponentType = this.createTime((SweTime)sosSimpleType);
        } else {
            throw new NotYetSupportedEncodingException(SweAbstractSimpleType.class.getSimpleName(), sosSimpleType);
        }
        this.addAbstractDataComponentValues((AbstractDataComponentType)abstractDataComponentType, (SweAbstractDataComponent)sosSimpleType);
        return abstractDataComponentType;
    }

    private SimpleDataRecordType createSimpleDataRecord(SweSimpleDataRecord simpleDataRecord) throws EncodingException {
        SimpleDataRecordType xbSimpleDataRecord = SimpleDataRecordType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        if (simpleDataRecord.isSetDefinition()) {
            xbSimpleDataRecord.setDefinition(simpleDataRecord.getDefinition());
        }
        if (simpleDataRecord.isSetDescription()) {
            StringOrRefType xbSoR = StringOrRefType.Factory.newInstance();
            xbSoR.setStringValue(simpleDataRecord.getDefinition());
            xbSimpleDataRecord.setDescription(xbSoR);
        }
        if (simpleDataRecord.isSetFields()) {
            AnyScalarPropertyType[] xbFields = new AnyScalarPropertyType[simpleDataRecord.getFields().size()];
            int xbFieldIndex = 0;
            for (SweField sweField : simpleDataRecord.getFields()) {
                AnyScalarPropertyType xbField;
                xbFields[xbFieldIndex] = xbField = this.createFieldForSimpleDataRecord(sweField);
                ++xbFieldIndex;
            }
            xbSimpleDataRecord.setFieldArray(xbFields);
        }
        return xbSimpleDataRecord;
    }

    private AnyScalarPropertyType createFieldForSimpleDataRecord(SweField sweField) throws EncodingException {
        SweAbstractDataComponent element = sweField.getElement();
        AnyScalarPropertyType xbField = AnyScalarPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        if (sweField.isSetName()) {
            xbField.setName(sweField.getName().getValue());
        }
        if (element != null) {
            if (element instanceof SweBoolean) {
                BooleanDocument.Boolean xbDCD = xbField.addNewBoolean();
                xbDCD.set((XmlObject)this.createSimpleType((SweAbstractSimpleType<?>)((SweBoolean)element)));
            } else if (element instanceof SweCategory) {
                CategoryDocument.Category xbDCD = xbField.addNewCategory();
                xbDCD.set((XmlObject)this.createSimpleType((SweAbstractSimpleType<?>)((SweCategory)element)));
            } else if (element instanceof SweCount) {
                CountDocument.Count xbDCD = xbField.addNewCount();
                xbDCD.set((XmlObject)this.createSimpleType((SweAbstractSimpleType<?>)((SweCount)element)));
            } else if (element instanceof SweQuantity) {
                QuantityDocument.Quantity xbDCD = xbField.addNewQuantity();
                xbDCD.set((XmlObject)this.createSimpleType((SweAbstractSimpleType<?>)((SweQuantity)element)));
            } else if (element instanceof SweText) {
                TextDocument.Text xbDCD = xbField.addNewText();
                xbDCD.set((XmlObject)this.createSimpleType((SweAbstractSimpleType<?>)((SweText)element)));
            } else if (element instanceof SweTime) {
                TimeDocument.Time xbDCD = xbField.addNewTime();
                xbDCD.set((XmlObject)this.createSimpleType((SweAbstractSimpleType<?>)((SweTime)element)));
            } else {
                throw new EncodingException("The element type '%s' of the received %s is not supported by this encoder '%s'.", new Object[]{element.getClass().getName(), sweField.getClass().getName(), ((Object)((Object)this)).getClass().getName()});
            }
        }
        return xbField;
    }

    private DataComponentPropertyType createField(SweField sweField) throws EncodingException {
        SweAbstractDataComponent element = sweField.getElement();
        DataComponentPropertyType xbField = DataComponentPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        if (sweField.isSetName()) {
            xbField.setName(sweField.getName().getValue());
        }
        if (element instanceof SweBoolean) {
            xbField.addNewBoolean().set((XmlObject)this.createSimpleType((SweAbstractSimpleType<?>)((SweBoolean)element)));
        } else if (element instanceof SweCategory) {
            xbField.addNewCategory().set((XmlObject)this.createSimpleType((SweAbstractSimpleType<?>)((SweCategory)element)));
        } else if (element instanceof SweCount) {
            xbField.addNewCount().set((XmlObject)this.createSimpleType((SweAbstractSimpleType<?>)((SweCount)element)));
        } else if (element instanceof SweCountRange) {
            xbField.addNewCount().set((XmlObject)this.createSimpleType((SweAbstractSimpleType<?>)((SweCountRange)element)));
        } else if (element instanceof SweQuantity) {
            xbField.addNewQuantity().set((XmlObject)this.createSimpleType((SweAbstractSimpleType<?>)((SweQuantity)element)));
        } else if (element instanceof SweQuantityRange) {
            xbField.addNewQuantity().set((XmlObject)this.createSimpleType((SweAbstractSimpleType<?>)((SweQuantityRange)element)));
        } else if (element instanceof SweText) {
            xbField.addNewText().set((XmlObject)this.createSimpleType((SweAbstractSimpleType<?>)((SweText)element)));
        } else if (element instanceof SweTimeRange) {
            xbField.addNewTimeRange().set((XmlObject)this.createSimpleType((SweAbstractSimpleType<?>)((SweTimeRange)element)));
        } else if (element instanceof SweTime) {
            xbField.addNewTime().set((XmlObject)this.createSimpleType((SweAbstractSimpleType<?>)((SweTime)element)));
        } else if (element instanceof SweEnvelope) {
            EnvelopeType xbEnvelope = (EnvelopeType)xbField.addNewAbstractDataRecord().substitute(SweConstants.QN_ENVELOPE_SWE_101, EnvelopeType.type);
            xbEnvelope.set((XmlObject)this.createEnvelope((SweEnvelope)element));
        } else if (element instanceof SweDataRecord) {
            DataRecordType xbEnvelope = (DataRecordType)xbField.addNewAbstractDataRecord().substitute(SweConstants.QN_DATA_RECORD_SWE_101, DataRecordType.type);
            xbEnvelope.set((XmlObject)this.createDataRecord((SweDataRecord)element));
        } else if (element instanceof SweDataArray) {
            DataArrayType xbEnvelope = (DataArrayType)xbField.addNewAbstractDataRecord().substitute(SweConstants.QN_DATA_RECORD_SWE_101, DataArrayType.type);
            xbEnvelope.set((XmlObject)this.createDataArray((SweDataArray)element).getDataArray1());
        } else {
            throw new EncodingException("The element type '%s' of the received '%s' is not supported by this encoder '%s'.", new Object[]{element != null ? element.getClass().getName() : null, sweField.getClass().getName(), ((Object)((Object)this)).getClass().getName()});
        }
        return xbField;
    }

    private BooleanDocument.Boolean createBoolean(SweBoolean bool) throws EncodingException {
        BooleanDocument.Boolean xbBoolean = BooleanDocument.Boolean.Factory.newInstance((XmlOptions)this.getXmlOptions());
        if (bool.isSetValue()) {
            xbBoolean.setValue(bool.getValue().booleanValue());
        }
        if (bool.isSetQuality()) {
            xbBoolean.setQuality(this.createQuality(bool.getQuality())[0]);
        }
        return xbBoolean;
    }

    private QualityPropertyType[] createQuality(Collection<SweQuality> quality) {
        if (!quality.isEmpty()) {
            ArrayList xbQualities = Lists.newArrayListWithCapacity((int)quality.size());
            for (SweQuality sweQuality : quality) {
                QualityPropertyType xbQuality = QualityPropertyType.Factory.newInstance();
                if (sweQuality instanceof SweText) {
                    xbQuality.addNewText().set((XmlObject)this.createText((SweText)sweQuality));
                } else if (sweQuality instanceof SweCategory) {
                    xbQuality.addNewCategory().set((XmlObject)this.createCategory((SweCategory)sweQuality));
                } else if (sweQuality instanceof SweQuantity) {
                    xbQuality.addNewQuantity().set((XmlObject)this.createQuantity((SweQuantity)sweQuality));
                } else if (sweQuality instanceof SweQuantityRange) {
                    xbQuality.addNewQuantityRange().set((XmlObject)this.createQuantityRange((SweQuantityRange)sweQuality));
                }
                xbQualities.add(xbQuality);
            }
            return xbQualities.toArray(new QualityPropertyType[xbQualities.size()]);
        }
        return new QualityPropertyType[]{QualityPropertyType.Factory.newInstance()};
    }

    private CategoryDocument.Category createCategory(SweCategory component) {
        CategoryDocument.Category xml = CategoryDocument.Category.Factory.newInstance((XmlOptions)this.getXmlOptions());
        if (component.isSetValue()) {
            xml.setValue(component.getValue());
        }
        if (component.isSetCodeSpace()) {
            xml.addNewCodeSpace().setHref(component.getCodeSpace());
        }
        if (component.isSetQuality()) {
            xml.setQuality(this.createQuality(component.getQuality())[0]);
        }
        if (component.isSetContstraint()) {
            this.createConstraint(xml.getConstraint(), (Referenceable<SweAllowedTokens>)component.getConstraint());
        }
        return xml;
    }

    private CountDocument.Count createCount(SweCount component) throws EncodingException {
        CountDocument.Count xml = CountDocument.Count.Factory.newInstance((XmlOptions)this.getXmlOptions());
        if (component.isSetValue()) {
            xml.setValue(new BigInteger(Integer.toString(component.getValue())));
        }
        if (component.isSetQuality()) {
            xml.setQualityArray(this.createQuality(component.getQuality()));
        }
        if (component.isSetContstraint()) {
            this.createConstraint(xml.getConstraint(), (Referenceable<SweAllowedValues>)component.getConstraint());
        }
        return xml;
    }

    private CountRangeDocument.CountRange createCountRange(SweCountRange component) throws EncodingException {
        CountRangeDocument.CountRange xml = CountRangeDocument.CountRange.Factory.newInstance((XmlOptions)this.getXmlOptions());
        if (component.isSetValue()) {
            xml.setValue(component.getValue().getRangeAsList());
        }
        if (component.isSetQuality()) {
            xml.setQualityArray(this.createQuality(component.getQuality()));
        }
        if (component.isSetContstraint()) {
            this.createConstraint(xml.getConstraint(), (Referenceable<SweAllowedValues>)component.getConstraint());
        }
        return xml;
    }

    private ObservablePropertyDocument.ObservableProperty createObservableProperty(SweObservableProperty observableProperty) throws EncodingException {
        ObservablePropertyDocument.ObservableProperty xbObservableProperty = ObservablePropertyDocument.ObservableProperty.Factory.newInstance((XmlOptions)this.getXmlOptions());
        return xbObservableProperty;
    }

    protected QuantityDocument.Quantity createQuantity(SweQuantity component) {
        QuantityDocument.Quantity xml = QuantityDocument.Quantity.Factory.newInstance((XmlOptions)this.getXmlOptions());
        if (component.isSetAxisID()) {
            xml.setAxisID(component.getAxisID());
        }
        if (component.isSetValue()) {
            xml.setValue(component.getValue().doubleValue());
        }
        if (component.isSetUom()) {
            xml.addNewUom().set((XmlObject)this.createUom(component.getUomObject()));
        }
        if (component.isSetQuality()) {
            xml.setQualityArray(this.createQuality(component.getQuality()));
        }
        if (component.isSetContstraint()) {
            this.createConstraint(xml.getConstraint(), (Referenceable<SweAllowedValues>)component.getConstraint());
        }
        return xml;
    }

    protected QuantityRangeDocument.QuantityRange createQuantityRange(SweQuantityRange component) {
        QuantityRangeDocument.QuantityRange xml = QuantityRangeDocument.QuantityRange.Factory.newInstance((XmlOptions)this.getXmlOptions());
        if (component.isSetAxisID()) {
            xml.setAxisID(component.getDescription());
        }
        if (component.isSetValue()) {
            xml.setValue(component.getValue().getRangeAsList());
        }
        if (component.isSetUom()) {
            xml.addNewUom().set((XmlObject)this.createUom(component.getUomObject()));
        }
        if (component.isSetQuality()) {
            xml.setQualityArray(this.createQuality(component.getQuality()));
        }
        if (component.isSetContstraint()) {
            this.createConstraint(xml.getConstraint(), (Referenceable<SweAllowedValues>)component.getConstraint());
        }
        return xml;
    }

    private TextDocument.Text createText(SweText component) {
        TextDocument.Text xml = TextDocument.Text.Factory.newInstance((XmlOptions)this.getXmlOptions());
        if (component.isSetValue()) {
            xml.setValue(component.getValue());
        }
        return xml;
    }

    private TimeDocument.Time createTime(SweTime component) throws EncodingException {
        TimeDocument.Time xml = TimeDocument.Time.Factory.newInstance((XmlOptions)this.getXmlOptions());
        if (component.isSetValue()) {
            XmlDateTime xbDateTime = this.createDateTime(component.getValue());
            xml.setValue((Object)xbDateTime);
        }
        if (component.isSetUom()) {
            if (component.getUom().startsWith(URN) || component.getUom().startsWith(HTTP)) {
                xml.addNewUom().setHref(component.getUom());
            } else {
                xml.addNewUom().setCode(component.getUom());
            }
        }
        if (component.isSetQuality()) {
            xml.setQuality(this.createQuality(component.getQuality())[0]);
        }
        if (component.isSetContstraint()) {
            this.createConstraint(xml.getConstraint(), (Referenceable<SweAllowedTimes>)component.getConstraint());
        }
        return xml;
    }

    private AllowedValuesPropertyType createConstraint(AllowedValuesPropertyType avpt, Referenceable<SweAllowedValues> constraint) {
        if (constraint.isInstance()) {
            this.createAllowedValues(avpt.addNewAllowedValues(), (Nillable<SweAllowedValues>)constraint.getInstance());
        } else if (constraint.isReference()) {
            Reference reference = constraint.getReference();
            reference.getActuate().map(Actuate::toString).map(ActuateType.Enum::forString).ifPresent(arg_0 -> ((AllowedValuesPropertyType)avpt).setActuate(arg_0));
            reference.getArcrole().ifPresent(arg_0 -> ((AllowedValuesPropertyType)avpt).setArcrole(arg_0));
            reference.getHref().map(URI::toString).ifPresent(arg_0 -> ((AllowedValuesPropertyType)avpt).setHref(arg_0));
            reference.getRole().ifPresent(arg_0 -> ((AllowedValuesPropertyType)avpt).setRole(arg_0));
            reference.getShow().map(Show::toString).map(ShowType.Enum::forString).ifPresent(arg_0 -> ((AllowedValuesPropertyType)avpt).setShow(arg_0));
            reference.getTitle().ifPresent(arg_0 -> ((AllowedValuesPropertyType)avpt).setTitle(arg_0));
            reference.getType().map(Type::toString).map(TypeType.Enum::forString).ifPresent(arg_0 -> ((AllowedValuesPropertyType)avpt).setType(arg_0));
        }
        return avpt;
    }

    private AllowedTokensPropertyType createConstraint(AllowedTokensPropertyType atpt, Referenceable<SweAllowedTokens> constraint) {
        if (constraint.isInstance()) {
            this.createAllowedTokens(atpt.addNewAllowedTokens(), (Nillable<SweAllowedTokens>)constraint.getInstance());
        } else if (constraint.isReference()) {
            Reference reference = constraint.getReference();
            reference.getActuate().map(Actuate::toString).map(ActuateType.Enum::forString).ifPresent(arg_0 -> ((AllowedTokensPropertyType)atpt).setActuate(arg_0));
            reference.getArcrole().ifPresent(arg_0 -> ((AllowedTokensPropertyType)atpt).setArcrole(arg_0));
            reference.getHref().map(URI::toString).ifPresent(arg_0 -> ((AllowedTokensPropertyType)atpt).setHref(arg_0));
            reference.getRole().ifPresent(arg_0 -> ((AllowedTokensPropertyType)atpt).setRole(arg_0));
            reference.getShow().map(Show::toString).map(ShowType.Enum::forString).ifPresent(arg_0 -> ((AllowedTokensPropertyType)atpt).setShow(arg_0));
            reference.getTitle().ifPresent(arg_0 -> ((AllowedTokensPropertyType)atpt).setTitle(arg_0));
            reference.getType().map(Type::toString).map(TypeType.Enum::forString).ifPresent(arg_0 -> ((AllowedTokensPropertyType)atpt).setType(arg_0));
        }
        return atpt;
    }

    private AllowedTimesPropertyType createConstraint(AllowedTimesPropertyType atpt, Referenceable<SweAllowedTimes> constraint) {
        if (constraint.isInstance()) {
            this.createAllowedTimes(atpt.addNewAllowedTimes(), (Nillable<SweAllowedTimes>)constraint.getInstance());
        } else if (constraint.isReference()) {
            Reference reference = constraint.getReference();
            reference.getActuate().map(Actuate::toString).map(ActuateType.Enum::forString).ifPresent(arg_0 -> ((AllowedTimesPropertyType)atpt).setActuate(arg_0));
            reference.getArcrole().ifPresent(arg_0 -> ((AllowedTimesPropertyType)atpt).setArcrole(arg_0));
            reference.getHref().map(URI::toString).ifPresent(arg_0 -> ((AllowedTimesPropertyType)atpt).setHref(arg_0));
            reference.getRole().ifPresent(arg_0 -> ((AllowedTimesPropertyType)atpt).setRole(arg_0));
            reference.getShow().map(Show::toString).map(ShowType.Enum::forString).ifPresent(arg_0 -> ((AllowedTimesPropertyType)atpt).setShow(arg_0));
            reference.getTitle().ifPresent(arg_0 -> ((AllowedTimesPropertyType)atpt).setTitle(arg_0));
            reference.getType().map(Type::toString).map(TypeType.Enum::forString).ifPresent(arg_0 -> ((AllowedTimesPropertyType)atpt).setType(arg_0));
        }
        return atpt;
    }

    private AllowedValuesDocument.AllowedValues createAllowedValues(AllowedValuesDocument.AllowedValues avt, Nillable<SweAllowedValues> instance) {
        if (instance.isPresent()) {
            if (((SweAllowedValues)instance.get()).isSetGmlID()) {
                avt.setId(((SweAllowedValues)instance.get()).getGmlId());
            }
            if (((SweAllowedValues)instance.get()).isSetValue()) {
                for (Double value : ((SweAllowedValues)instance.get()).getValue()) {
                    avt.addValueList((List)Lists.newArrayList((Object[])new Double[]{value}));
                }
            }
            if (((SweAllowedValues)instance.get()).isSetInterval()) {
                for (RangeValue interval : ((SweAllowedValues)instance.get()).getInterval()) {
                    avt.addInterval(interval.getRangeAsList());
                }
            }
        }
        return avt;
    }

    private AllowedTokensDocument.AllowedTokens createAllowedTokens(AllowedTokensDocument.AllowedTokens att, Nillable<SweAllowedTokens> instance) {
        if (instance.isPresent()) {
            if (((SweAllowedTokens)instance.get()).isSetGmlID()) {
                att.setId(((SweAllowedTokens)instance.get()).getGmlId());
            }
            if (((SweAllowedTokens)instance.get()).isSetValue()) {
                for (String value : ((SweAllowedTokens)instance.get()).getValue()) {
                    att.addValueList((List)Lists.newArrayList((Object[])new String[]{value}));
                }
            }
        }
        return att;
    }

    private AllowedTimesDocument.AllowedTimes createAllowedTimes(AllowedTimesDocument.AllowedTimes att, Nillable<SweAllowedTimes> instance) {
        if (instance.isPresent()) {
            if (((SweAllowedTimes)instance.get()).isSetGmlID()) {
                att.setId(((SweAllowedTimes)instance.get()).getGmlId());
            }
            if (((SweAllowedTimes)instance.get()).isSetValue()) {
                for (DateTime value : ((SweAllowedTimes)instance.get()).getValue()) {
                    att.addNewValueList().setListValue((List)Lists.newArrayList((Object[])new String[]{DateTimeHelper.formatDateTime2IsoString((DateTime)value)}));
                }
            }
            if (((SweAllowedTimes)instance.get()).isSetInterval()) {
                for (RangeValue interval : ((SweAllowedTimes)instance.get()).getInterval()) {
                    ArrayList list = Lists.newArrayListWithCapacity((int)2);
                    list.add(DateTimeHelper.formatDateTime2IsoString((DateTime)((DateTime)interval.getRangeStart())));
                    if (interval.isSetEndValue()) {
                        list.add(DateTimeHelper.formatDateTime2IsoString((DateTime)((DateTime)interval.getRangeEnd())));
                    }
                    att.addInterval((List)list);
                }
            }
        }
        return att;
    }

    private XmlDateTime createDateTime(DateTime sosDateTime) {
        XmlDateTime xbDateTime = XmlDateTime.Factory.newInstance((XmlOptions)this.getXmlOptions());
        GDateBuilder gdb = new GDateBuilder(sosDateTime.toDate());
        gdb.normalize();
        xbDateTime.setGDateValue(gdb.toGDate());
        return xbDateTime;
    }

    private EnvelopeType createEnvelope(SweEnvelope sosSweEnvelope) throws EncodingException {
        EnvelopeType envelopeType = EnvelopeType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        this.addAbstractDataComponentValues((AbstractDataComponentType)envelopeType, (SweAbstractDataComponent)sosSweEnvelope);
        if (sosSweEnvelope.isReferenceFrameSet()) {
            envelopeType.setReferenceFrame(sosSweEnvelope.getReferenceFrame());
        }
        if (sosSweEnvelope.isLowerCornerSet()) {
            envelopeType.setLowerCorner(this.createVectorProperty(sosSweEnvelope.getLowerCorner()));
        }
        if (sosSweEnvelope.isUpperCornerSet()) {
            envelopeType.setUpperCorner(this.createVectorProperty(sosSweEnvelope.getUpperCorner()));
        }
        if (sosSweEnvelope.isTimeSet()) {
            envelopeType.addNewTime().setTimeRange(this.createTimeRange(sosSweEnvelope.getTime()));
        }
        return envelopeType;
    }

    private VectorPropertyType createVectorProperty(SweVector sosSweVector) throws EncodingException {
        VectorPropertyType vectorPropertyType = VectorPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        vectorPropertyType.setVector(this.createVector(sosSweVector.getCoordinates()));
        return vectorPropertyType;
    }

    private VectorType createVector(List<? extends SweCoordinate<?>> coordinates) throws EncodingException {
        VectorType vectorType = VectorType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        vectorType.setCoordinateArray(this.createCoordinates(coordinates));
        return vectorType;
    }

    private TimeRangeDocument.TimeRange createTimeRange(SweTimeRange timeRange) throws EncodingException {
        TimeRangeDocument.TimeRange xbTimeRange = TimeRangeDocument.TimeRange.Factory.newInstance((XmlOptions)this.getXmlOptions());
        this.addAbstractDataComponentValues((AbstractDataComponentType)xbTimeRange, (SweAbstractDataComponent)timeRange);
        if (timeRange.isSetValue()) {
            xbTimeRange.setValue(timeRange.getValue().getRangeAsStringList());
        }
        if (timeRange.isSetUom()) {
            xbTimeRange.addNewUom().setCode(timeRange.getUom());
        }
        if (timeRange.isSetQuality()) {
            xbTimeRange.setQuality(this.createQuality(timeRange.getQuality())[0]);
        }
        return xbTimeRange;
    }

    private void addAbstractDataComponentValues(AbstractDataComponentType xbComponent, SweAbstractDataComponent component) throws EncodingException {
        if (component.isSetDefinition()) {
            xbComponent.setDefinition(component.getDefinition());
        }
        if (component.isSetDescription()) {
            xbComponent.addNewDescription().setStringValue(component.getDescription());
        }
        if (component.isSetName()) {
            xbComponent.addNewName().set(this.encodeObjectToXml("http://www.opengis.net/gml", component.getName()));
        }
    }

    private VectorType.Coordinate createCoordinate(SweCoordinate<?> coordinate) {
        VectorType.Coordinate xbCoordinate = VectorType.Coordinate.Factory.newInstance((XmlOptions)this.getXmlOptions());
        xbCoordinate.setName(coordinate.getName());
        xbCoordinate.setQuantity(this.createQuantity((SweQuantity)coordinate.getValue()));
        return xbCoordinate;
    }

    private VectorType.Coordinate[] createCoordinates(List<? extends SweCoordinate<?>> coordinates) {
        if (coordinates != null) {
            return (VectorType.Coordinate[])coordinates.stream().map(this::createCoordinate).toArray(VectorType.Coordinate[]::new);
        }
        return null;
    }

    private DataRecordType createDataRecord(SweDataRecord sosDataRecord) throws EncodingException {
        List sosFields = sosDataRecord.getFields();
        DataRecordType xbDataRecord = DataRecordType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        if (sosDataRecord.isSetDefinition()) {
            xbDataRecord.setDefinition(sosDataRecord.getDefinition());
        }
        if (sosDataRecord.isSetFields()) {
            DataComponentPropertyType[] xbFields = new DataComponentPropertyType[sosFields.size()];
            int xbFieldIndex = 0;
            for (SweField sosSweField : sosFields) {
                DataComponentPropertyType xbField;
                xbFields[xbFieldIndex] = xbField = this.createField(sosSweField);
                ++xbFieldIndex;
            }
            xbDataRecord.setFieldArray(xbFields);
        }
        return xbDataRecord;
    }

    private DataArrayDocument createDataArray(SweDataArray sosDataArray) throws EncodingException {
        if (sosDataArray != null) {
            if (sosDataArray.isSetElementTyp()) {
                DataArrayDocument xbDataArrayDoc = DataArrayDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
                DataArrayType xbDataArray = xbDataArrayDoc.addNewDataArray1();
                if (sosDataArray.isSetElementCount()) {
                    xbDataArray.addNewElementCount().addNewCount().set((XmlObject)this.createCount(sosDataArray.getElementCount()));
                }
                if (sosDataArray.isSetElementTyp()) {
                    DataComponentPropertyType xbElementType = xbDataArray.addNewElementType();
                    xbElementType.setName("Components");
                    if (sosDataArray.getElementType() instanceof SweBoolean) {
                        xbElementType.addNewBoolean().set((XmlObject)this.createSimpleType((SweAbstractSimpleType<?>)((SweBoolean)sosDataArray.getElementType())));
                    } else if (sosDataArray.getElementType() instanceof SweCategory) {
                        xbElementType.addNewCategory().set((XmlObject)this.createSimpleType((SweAbstractSimpleType<?>)((SweCategory)sosDataArray.getElementType())));
                    } else if (sosDataArray.getElementType() instanceof SweCount) {
                        xbElementType.addNewCount().set((XmlObject)this.createSimpleType((SweAbstractSimpleType<?>)((SweCount)sosDataArray.getElementType())));
                    } else if (sosDataArray.getElementType() instanceof SweQuantity) {
                        xbElementType.addNewQuantity().set((XmlObject)this.createSimpleType((SweAbstractSimpleType<?>)((SweQuantity)sosDataArray.getElementType())));
                    } else if (sosDataArray.getElementType() instanceof SweText) {
                        xbElementType.addNewText().set((XmlObject)this.createSimpleType((SweAbstractSimpleType<?>)((SweText)sosDataArray.getElementType())));
                    } else if (sosDataArray.getElementType() instanceof SweTimeRange) {
                        xbElementType.addNewTimeRange().set((XmlObject)this.createSimpleType((SweAbstractSimpleType<?>)((SweTimeRange)sosDataArray.getElementType())));
                    } else if (sosDataArray.getElementType() instanceof SweTime) {
                        xbElementType.addNewTime().set((XmlObject)this.createSimpleType((SweAbstractSimpleType<?>)((SweTime)sosDataArray.getElementType())));
                    } else if (sosDataArray.getElementType() instanceof SweEnvelope) {
                        xbElementType.addNewAbstractDataRecord().set((XmlObject)this.createEnvelope((SweEnvelope)sosDataArray.getElementType()));
                        xbElementType.getAbstractDataRecord().substitute(SweConstants.QN_ENVELOPE_SWE_101, EnvelopeType.type);
                    } else if (sosDataArray.getElementType() instanceof SweDataRecord) {
                        xbElementType.addNewAbstractDataRecord().set((XmlObject)this.createDataRecord((SweDataRecord)sosDataArray.getElementType()));
                        xbElementType.getAbstractDataRecord().substitute(SweConstants.QN_DATA_RECORD_SWE_101, DataRecordType.type);
                    } else if (sosDataArray.getElementType() instanceof SweSimpleDataRecord) {
                        xbElementType.addNewAbstractDataRecord().set((XmlObject)this.createSimpleDataRecord((SweSimpleDataRecord)sosDataArray.getElementType()));
                        xbElementType.getAbstractDataRecord().substitute(SweConstants.QN_SIMPLEDATARECORD_SWE_101, SimpleDataRecordType.type);
                    } else if (sosDataArray.getElementType() instanceof SweDataArray) {
                        xbElementType.addNewAbstractDataArray1().set((XmlObject)this.createDataArray((SweDataArray)sosDataArray.getElementType()).getDataArray1());
                        xbElementType.getAbstractDataArray1().substitute(SweConstants.QN_DATA_RECORD_SWE_101, DataArrayType.type);
                    } else {
                        throw new UnsupportedEncoderInputException((Encoder)this, (Object)sosDataArray.getElementType());
                    }
                }
                if (sosDataArray.isSetEncoding()) {
                    BlockEncodingPropertyType xbEncoding = xbDataArray.addNewEncoding();
                    xbEncoding.set((XmlObject)this.createBlockEncoding(sosDataArray.getEncoding()));
                }
                if (sosDataArray.isSetValues()) {
                    xbDataArray.addNewValues().set((XmlObject)this.createValues(sosDataArray.getValues(), sosDataArray.getEncoding()));
                }
                return xbDataArrayDoc;
            }
            if (sosDataArray.isSetXml()) {
                try {
                    XmlObject xmlObject = XmlObject.Factory.parse((String)sosDataArray.getXml().trim());
                    if (xmlObject instanceof DataArrayDocument) {
                        return (DataArrayDocument)xmlObject;
                    }
                    DataArrayDocument xbDataArrayDoc = DataArrayDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
                    xbDataArrayDoc.setDataArray1(DataArrayType.Factory.parse((String)sosDataArray.getXml().trim()));
                    return xbDataArrayDoc;
                }
                catch (XmlException e) {
                    throw new EncodingException("Error while encoding SweDataArray!", (Throwable)e);
                }
            }
        }
        return null;
    }

    private XmlString createValues(List<List<String>> values, SweAbstractEncoding encoding) {
        return this.createValues((SweTextEncoding)encoding, values);
    }

    private XmlString createValues(SweTextEncoding textEncoding, List<List<String>> values) {
        String tokenSeparator = textEncoding.getTokenSeparator();
        String blockSeparator = textEncoding.getBlockSeparator();
        String valueString = values.stream().map(block -> String.join((CharSequence)tokenSeparator, block)).collect(Collectors.joining(blockSeparator));
        XmlString xbValueString = XmlString.Factory.newInstance();
        xbValueString.setStringValue(valueString);
        return xbValueString;
    }

    private BlockEncodingPropertyType createBlockEncoding(SweAbstractEncoding sosSweAbstractEncoding) throws EncodingException {
        try {
            if (sosSweAbstractEncoding instanceof SweTextEncoding) {
                return this.createTextEncoding((SweTextEncoding)sosSweAbstractEncoding);
            }
            if (sosSweAbstractEncoding.getXml() != null && !sosSweAbstractEncoding.getXml().isEmpty()) {
                XmlObject xmlObject = XmlObject.Factory.parse((String)sosSweAbstractEncoding.getXml());
                if (xmlObject instanceof AbstractEncodingType) {
                    return (BlockEncodingPropertyType)xmlObject;
                }
                throw new EncodingException("AbstractEncoding can not be encoded!", new Object[0]);
            }
        }
        catch (XmlException e) {
            throw new EncodingException("Error while encoding AbstractEncoding!", (Throwable)e);
        }
        return null;
    }

    private BlockEncodingPropertyType createTextEncoding(SweTextEncoding sosTextEncoding) {
        BlockEncodingPropertyType xbTextEncodingType = BlockEncodingPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        TextBlockDocument.TextBlock xbTextEncoding = xbTextEncodingType.addNewTextBlock();
        if (sosTextEncoding.getBlockSeparator() != null) {
            xbTextEncoding.setBlockSeparator(sosTextEncoding.getBlockSeparator());
        }
        if (sosTextEncoding.getDecimalSeparator() != null) {
            xbTextEncoding.setDecimalSeparator(sosTextEncoding.getDecimalSeparator());
        }
        if (sosTextEncoding.getTokenSeparator() != null) {
            xbTextEncoding.setTokenSeparator(sosTextEncoding.getTokenSeparator());
        }
        return xbTextEncodingType;
    }

    private XmlObject createTimeGeometricPrimitivePropertyType(TimePeriod timePeriod) throws EncodingException {
        XmlCursor timeCursor;
        boolean hasTimePrimitive;
        TimeGeometricPrimitivePropertyType xbTimeGeometricPrimitiveProperty = TimeGeometricPrimitivePropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        if (timePeriod.isSetStart() && timePeriod.isSetEnd()) {
            xbTimeGeometricPrimitiveProperty.addNewTimeGeometricPrimitive().set(this.encodeObjectToXml("http://www.opengis.net/gml", timePeriod));
        }
        if (hasTimePrimitive = (timeCursor = xbTimeGeometricPrimitiveProperty.newCursor()).toChild(new QName("http://www.opengis.net/gml", "_TimeGeometricPrimitive"))) {
            timeCursor.setName(new QName("http://www.opengis.net/gml", "TimePeriod"));
        }
        timeCursor.dispose();
        return xbTimeGeometricPrimitiveProperty;
    }

    private UomPropertyType createUom(UoM uom) {
        UomPropertyType upt = UomPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        if (!uom.isSetLink() && (uom.getUom().startsWith(URN) || uom.getUom().startsWith(HTTP))) {
            upt.setHref(uom.getUom());
        } else {
            upt.setCode(uom.getUom());
        }
        if (uom.isSetName()) {
            upt.setTitle(uom.getName());
        }
        if (uom.isSetLink()) {
            upt.setHref(uom.getLink());
        }
        return upt;
    }
}

