/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.collect.Lists;
import eu.europa.ec.inspire.schemas.base2.x20.ContactType;
import eu.europa.ec.inspire.schemas.base2.x20.RelatedPartyType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import net.opengis.gml.x32.ReferenceType;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.inspire.ad.AddressRepresentation;
import org.n52.shetland.inspire.base2.Contact;
import org.n52.shetland.inspire.base2.RelatedParty;
import org.n52.shetland.iso.gmd.PT_FreeText;
import org.n52.shetland.w3c.Nillable;
import org.n52.shetland.w3c.xlink.Reference;
import org.n52.svalbard.decode.AbstractXmlDecoder;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderInputException;
import org.n52.svalbard.read.NillableReferenceReader;
import org.n52.svalbard.util.CodingHelper;

public class RelatedPartyTypeDecoder
extends AbstractXmlDecoder<XmlObject, RelatedParty> {
    private static final Set<DecoderKey> DECODER_KEYS = CodingHelper.decoderKeysForElements((String)"http://inspire.ec.europa.eu/schemas/ompr/3.0", (Class[])new Class[]{RelatedPartyType.class});

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    public RelatedParty decode(XmlObject xmlObject) throws DecodingException {
        if (xmlObject instanceof RelatedPartyType) {
            RelatedPartyType rpt = (RelatedPartyType)xmlObject;
            RelatedParty relatedParty = new RelatedParty();
            relatedParty.setContact(this.parseContact(rpt));
            relatedParty.setIndividualName((PT_FreeText)this.decodeXmlElement((XmlObject)rpt.getIndividualName()));
            relatedParty.setOrganisationName((PT_FreeText)this.decodeXmlElement((XmlObject)rpt.getOrganisationName()));
            relatedParty.setPositionName((PT_FreeText)this.decodeXmlElement((XmlObject)rpt.getPositionName()));
            relatedParty.setRoles(this.parseRole(rpt));
            return relatedParty;
        }
        throw new UnsupportedDecoderInputException((Decoder)this, (Object)xmlObject);
    }

    private Contact parseContact(RelatedPartyType rpt) throws DecodingException {
        ContactType ct = rpt.getContact().getContact();
        Contact contact = new Contact();
        contact.setAddress(this.parseAddress(ct));
        contact.setContactInstructions(this.parseContactInstructions(ct));
        contact.setElectronicMailAddress(this.parseElectronicMailAddress(ct));
        contact.setTelephoneFacsimile(this.parseTelephoneFacsimile(ct));
        contact.setTelephoneVoice(this.parseTelephoneVoice(ct));
        contact.setWebsite(this.parseWebsite(ct));
        return contact;
    }

    private Nillable<AddressRepresentation> parseAddress(ContactType ct) {
        return Nillable.nil();
    }

    private Nillable<PT_FreeText> parseContactInstructions(ContactType ct) throws DecodingException {
        if (ct.isNilContactInstructions()) {
            if (ct.getContactInstructions().isSetNilReason()) {
                return Nillable.nil((String)ct.getContactInstructions().getNilReason().toString());
            }
            return Nillable.nil();
        }
        return Nillable.of((Object)((PT_FreeText)this.decodeXmlElement((XmlObject)ct.getContactInstructions())));
    }

    private Nillable<String> parseElectronicMailAddress(ContactType ct) {
        if (ct.isNilElectronicMailAddress()) {
            if (ct.getElectronicMailAddress().isSetNilReason()) {
                return Nillable.nil((String)ct.getElectronicMailAddress().getNilReason().toString());
            }
            return Nillable.nil();
        }
        return Nillable.of((Object)ct.getElectronicMailAddress().getStringValue());
    }

    private Nillable<List<Nillable<String>>> parseTelephoneFacsimile(ContactType ct) {
        ArrayList list = Lists.newArrayList();
        for (ContactType.TelephoneFacsimile tf : ct.getTelephoneFacsimileArray()) {
            if (tf.isNil() && tf.isSetNilReason()) {
                return Nillable.nil((String)tf.getNilReason().toString());
            }
            list.add(Nillable.of((Object)tf.getStringValue()));
        }
        return Nillable.of((Object)list);
    }

    private Nillable<List<Nillable<String>>> parseTelephoneVoice(ContactType ct) {
        ArrayList list = Lists.newArrayList();
        for (ContactType.TelephoneVoice tv : ct.getTelephoneVoiceArray()) {
            if (tv.isNil() && tv.isSetNilReason()) {
                return Nillable.nil((String)tv.getNilReason().toString());
            }
            list.add(Nillable.of((Object)tv.getStringValue()));
        }
        return Nillable.of((Object)list);
    }

    private Nillable<String> parseWebsite(ContactType ct) {
        if (ct.isNilWebsite()) {
            if (ct.getWebsite().isSetNilReason()) {
                return Nillable.nil((String)ct.getWebsite().getNilReason().toString());
            }
            return Nillable.nil();
        }
        return Nillable.present((Object)ct.getWebsite().getStringValue());
    }

    private List<Nillable<Reference>> parseRole(RelatedPartyType rpt) throws DecodingException {
        try {
            ArrayList list = Lists.newArrayList();
            for (ReferenceType rt : rpt.getRoleArray()) {
                list.add(new NillableReferenceReader().read(rt.newInputStream()));
            }
            return list;
        }
        catch (XMLStreamException e) {
            throw new DecodingException((Throwable)e);
        }
    }
}

