/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPConstants;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.ogc.ows.exception.NoApplicableCodeException;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.ows.service.OwsServiceCommunicationObject;
import org.n52.shetland.ogc.ows.service.OwsServiceRequest;
import org.n52.shetland.ogc.ows.service.OwsServiceResponse;
import org.n52.shetland.ogc.swe.SweConstants;
import org.n52.shetland.w3c.W3CConstants;
import org.n52.shetland.w3c.soap.AbstractSoap;
import org.n52.shetland.w3c.soap.SoapFault;
import org.n52.shetland.w3c.soap.SoapHelper;
import org.n52.shetland.w3c.soap.SoapRequest;
import org.n52.shetland.w3c.soap.SoapResponse;
import org.n52.svalbard.decode.AbstractSoapDecoder;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.encode.SchemaRepository;
import org.n52.svalbard.util.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3.x2003.x05.soapEnvelope.Body;
import org.w3.x2003.x05.soapEnvelope.EnvelopeDocument;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Soap12Decoder
extends AbstractSoapDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(Soap12Decoder.class);
    private SchemaRepository schemaRepository;

    public Soap12Decoder() {
        super("http://www.w3.org/2003/05/soap-envelope");
        LOGGER.debug("Decoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(this.getKeys()));
    }

    @Inject
    public void setSchemaRepository(SchemaRepository schemaRepository) {
        this.schemaRepository = schemaRepository;
    }

    @Override
    protected AbstractSoap<?> createEnvelope(XmlObject doc) throws DecodingException {
        AbstractSoap soap = null;
        String soapAction = "";
        try {
            SOAPMessage message;
            OwsServiceCommunicationObject bodyContent = this.getBodyContent((EnvelopeDocument)doc);
            soap = bodyContent instanceof OwsServiceRequest ? new SoapRequest("http://www.w3.org/2003/05/soap-envelope", "SOAP 1.2 Protocol").setBodyContent((OwsServiceCommunicationObject)((OwsServiceRequest)bodyContent)) : new SoapResponse("http://www.w3.org/2003/05/soap-envelope", "SOAP 1.2 Protocol").setBodyContent((OwsServiceCommunicationObject)((OwsServiceResponse)bodyContent));
            try {
                message = SoapHelper.getSoapMessageForProtocol((String)"SOAP 1.2 Protocol", (InputStream)doc.newInputStream());
            }
            catch (IOException | SOAPException ioe) {
                throw new NoApplicableCodeException().causedBy(ioe).withMessage("Error while parsing SOAPMessage from request string!", new Object[0]);
            }
            try {
                if (message.getSOAPHeader() != null) {
                    soap.setSoapHeader(this.getSoapHeader(message.getSOAPHeader()));
                }
                soap.setAction(this.checkSoapAction(soapAction, soap.getSoapHeader()));
            }
            catch (SOAPException soape) {
                throw new NoApplicableCodeException().causedBy((Throwable)soape).withMessage("Error while parsing SOAPMessage!", new Object[0]);
            }
        }
        catch (OwsExceptionReport owse) {
            throw new DecodingException((Throwable)owse);
        }
        return soap;
    }

    @Override
    protected AbstractSoap<?> createFault(DecodingException de) {
        SoapFault fault = new SoapFault();
        fault.setFaultCode(SOAPConstants.SOAP_SENDER_FAULT);
        fault.setLocale(Locale.ENGLISH);
        fault.setFaultReason(this.getFaultReasons(de));
        SoapRequest r = new SoapRequest("http://www.w3.org/2003/05/soap-envelope", "SOAP 1.2 Protocol");
        r.setSoapFault(fault);
        return r;
    }

    private OwsServiceCommunicationObject getBodyContent(EnvelopeDocument doc) throws DecodingException {
        Body body = doc.getEnvelope().getBody();
        try {
            Node domNode = body.getDomNode();
            if (domNode.hasChildNodes()) {
                NodeList childNodes = domNode.getChildNodes();
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node node = childNodes.item(i);
                    if (node.getNodeType() != 1) continue;
                    XmlObject content = XmlObject.Factory.parse((Node)node);
                    Map namespaces = XmlHelper.getNamespaces((XmlObject)doc.getEnvelope());
                    this.fixNamespaceForXsiType(content, namespaces);
                    XmlHelper.fixNamespaceForXsiType((XmlObject)content, (QName)SweConstants.QN_DATA_ARRAY_PROPERTY_TYPE_SWE_200);
                    return (OwsServiceCommunicationObject)this.decodeXmlElement(content);
                }
            }
            return (OwsServiceCommunicationObject)this.decodeXmlElement((XmlObject)body);
        }
        catch (XmlException xmle) {
            throw new DecodingException("Error while parsing SOAP body element!", (Throwable)xmle);
        }
    }

    private void fixNamespaceForXsiType(XmlObject content, Map<?, ?> namespaces) {
        XmlCursor cursor = content.newCursor();
        while (cursor.hasNextToken()) {
            String[] toks;
            String xsiType;
            if (!cursor.toNextToken().isStart() || (xsiType = cursor.getAttributeText(W3CConstants.QN_XSI_TYPE)) == null || (toks = xsiType.split(":")).length <= 1) continue;
            String prefix = toks[0];
            String localName = toks[1];
            String namespace = (String)namespaces.get(prefix);
            if (Strings.isNullOrEmpty((String)namespace)) {
                namespace = this.schemaRepository.getNamespaceFor(prefix);
            }
            if (Strings.isNullOrEmpty((String)namespace)) continue;
            cursor.setAttributeText(W3CConstants.QN_XSI_TYPE, Joiner.on((String)":").join((Object)XmlHelper.getPrefixForNamespace((XmlObject)content, (String)((String)namespaces.get(prefix))), (Object)localName, new Object[0]));
        }
        cursor.dispose();
    }
}

