/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.isotc211.x2005.gco.CodeListValueType;
import org.n52.shetland.iso.GcoConstants;
import org.n52.shetland.iso.gco.AbstractRole;
import org.n52.shetland.ogc.sensorML.Role;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.AbstractIso19139GcoEncoder;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Iso19139GcoEncoder
extends AbstractIso19139GcoEncoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(Iso19139GcoEncoder.class);
    private static final Set<EncoderKey> ENCODER_KEYS = CodingHelper.encoderKeysForElements((String)"http://www.isotc211.org/2005/gco", (Class[])new Class[]{Role.class, org.n52.shetland.iso.gco.Role.class, AbstractRole.class});

    public Iso19139GcoEncoder() {
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(ENCODER_KEYS));
    }

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEYS);
    }

    public void addNamespacePrefixToMap(Map<String, String> nameSpacePrefixMap) {
        nameSpacePrefixMap.put("http://www.isotc211.org/2005/gco", "gco");
    }

    public Set<SchemaLocation> getSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{GcoConstants.GCO_SCHEMA_LOCATION});
    }

    public XmlObject encode(Object element, EncodingContext additionalValues) throws EncodingException, UnsupportedEncoderInputException {
        XmlObject encodedObject = null;
        if (!(element instanceof AbstractRole)) {
            throw new UnsupportedEncoderInputException((Encoder)this, element);
        }
        encodedObject = this.encodeRole((AbstractRole)element);
        XmlHelper.validateDocument((XmlObject)encodedObject, EncodingException::new);
        return encodedObject;
    }

    private XmlObject encodeRole(AbstractRole role) {
        CodeListValueType circ = CodeListValueType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        circ.setStringValue(role.getValue());
        circ.setCodeList(role.getCodeList());
        circ.setCodeListValue(role.getCodeListValue());
        return circ;
    }
}

