/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.opengis.fes.x20.FilterCapabilitiesDocument;
import net.opengis.gml.x32.EnvelopeType;
import net.opengis.ows.x11.CapabilitiesBaseType;
import net.opengis.sos.x20.CapabilitiesType;
import net.opengis.sos.x20.ContentsType;
import net.opengis.sos.x20.ObservationOfferingPropertyType;
import net.opengis.sos.x20.ObservationOfferingType;
import net.opengis.swes.x20.AbstractContentsType;
import net.opengis.swes.x20.AbstractOfferingType;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.ogc.filter.FilterCapabilities;
import org.n52.shetland.ogc.gml.CodeType;
import org.n52.shetland.ogc.gml.time.Time;
import org.n52.shetland.ogc.ows.OwsCapabilities;
import org.n52.shetland.ogc.ows.extension.Extension;
import org.n52.shetland.ogc.ows.extension.Extensions;
import org.n52.shetland.ogc.sos.SosCapabilities;
import org.n52.shetland.ogc.sos.SosObservationOffering;
import org.n52.shetland.ogc.sos.SosOffering;
import org.n52.shetland.util.ReferencedEnvelope;
import org.n52.svalbard.decode.AbstractCapabilitiesBaseTypeDecoder;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CapabilitiesTypeDecoder
extends AbstractCapabilitiesBaseTypeDecoder<CapabilitiesType, SosCapabilities> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CapabilitiesTypeDecoder.class);
    private static final Set<DecoderKey> DECODER_KEYS = CodingHelper.decoderKeysForElements((String)"http://www.opengis.net/sos/2.0", (Class[])new Class[]{CapabilitiesType.class});

    public CapabilitiesTypeDecoder() {
        LOGGER.debug("Decoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(DECODER_KEYS));
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
    public SosCapabilities decode(CapabilitiesType ct) throws DecodingException {
        if (ct != null) {
            OwsCapabilities owsCapabilities = this.parseCapabilitiesBaseType("SOS", (CapabilitiesBaseType)ct);
            FilterCapabilities filterCapabilities = this.parseFilterCapabilities(ct.getFilterCapabilities());
            Collection<SosObservationOffering> contents = this.parseContents(ct.getContents());
            return new SosCapabilities(owsCapabilities, filterCapabilities, contents);
        }
        throw new UnsupportedDecoderInputException((Decoder)this, (Object)ct);
    }

    private Collection<SosObservationOffering> parseContents(CapabilitiesType.Contents contents) {
        if (contents == null) {
            return null;
        }
        return this.parseContents(contents.getContents());
    }

    private Collection<SosObservationOffering> parseContents(ContentsType contents) {
        return Optional.ofNullable(contents.getOfferingArray()).map(Arrays::stream).orElseGet(Stream::empty).map(this::parseOffering).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private SosObservationOffering parseOffering(AbstractContentsType.Offering offering) {
        SosObservationOffering observationOffering = new SosObservationOffering();
        if (offering.getDomNode().hasChildNodes()) {
            Node node = XmlHelper.getNodeFromNodeList((NodeList)offering.getDomNode().getChildNodes());
            try {
                ObservationOfferingPropertyType offeringType = ObservationOfferingPropertyType.Factory.parse((Node)node);
                ObservationOfferingType obsOffPropType = offeringType.getObservationOffering();
                observationOffering.setOffering(this.parseOffering(obsOffPropType));
                observationOffering.setProcedures(this.parseProcedure(obsOffPropType));
                observationOffering.setProcedureDescriptionFormat(this.parseProcedureDescriptionFormat(obsOffPropType));
                observationOffering.setObservableProperties(this.parseObservableProperties(obsOffPropType));
                observationOffering.setRelatedFeatures(this.parseRelatedFeatures(obsOffPropType));
                observationOffering.setObservedArea(this.parseObservedArea(obsOffPropType));
                observationOffering.setPhenomenonTime(this.parsePhenomenonTime(obsOffPropType));
                observationOffering.setResultTime(this.parseResultTime(obsOffPropType));
                observationOffering.setResponseFormats(this.parseResponseFormats(obsOffPropType));
                observationOffering.setObservationTypes(this.parseObservationTypes(obsOffPropType));
                observationOffering.setFeatureOfInterestTypes(this.parseFeatureOfInterestTypes(obsOffPropType));
                observationOffering.setExtensions(this.parseOfferingExtension(obsOffPropType));
            }
            catch (XmlException | DecodingException ex) {
                LOGGER.error(ex.getLocalizedMessage(), ex);
            }
        }
        return observationOffering;
    }

    private SosOffering parseOffering(ObservationOfferingType obsOffPropType) throws DecodingException {
        String offeringId = obsOffPropType.getIdentifier() != null ? obsOffPropType.getIdentifier() : obsOffPropType.getId();
        if (obsOffPropType.getNameArray() != null && obsOffPropType.getNameArray().length > 0) {
            CodeType codeType = (CodeType)this.decodeXmlElement((XmlObject)obsOffPropType.getNameArray(0));
            return new SosOffering(offeringId, codeType);
        }
        return new SosOffering(offeringId, "");
    }

    private FilterCapabilities parseFilterCapabilities(CapabilitiesType.FilterCapabilities filterCapabilities) {
        if (filterCapabilities == null) {
            return null;
        }
        return this.parseFilterCapabilities(filterCapabilities.getFilterCapabilities());
    }

    private FilterCapabilities parseFilterCapabilities(FilterCapabilitiesDocument.FilterCapabilities filterCapabilities) {
        return null;
    }

    private Collection<String> parseProcedure(ObservationOfferingType obsOff) {
        return Optional.ofNullable(obsOff.getProcedure()).map(Collections::singleton).get();
    }

    private Collection<String> parseProcedureDescriptionFormat(ObservationOfferingType obsOff) {
        return Optional.ofNullable(obsOff.getProcedureDescriptionFormatArray()).map(Arrays::stream).orElseGet(Stream::empty).collect(Collectors.toSet());
    }

    private Collection<String> parseObservableProperties(ObservationOfferingType obsOff) {
        return Optional.ofNullable(obsOff.getObservablePropertyArray()).map(Arrays::stream).orElseGet(Stream::empty).collect(Collectors.toSet());
    }

    private Time parsePhenomenonTime(ObservationOfferingType obsOff) {
        return Optional.ofNullable(obsOff.getPhenomenonTime()).map(phenTime -> {
            try {
                return (Time)this.decodeXmlElement((XmlObject)phenTime.getTimePeriod());
            }
            catch (DecodingException ex) {
                LOGGER.error(ex.getLocalizedMessage(), (Throwable)ex);
                return null;
            }
        }).orElse(null);
    }

    private Extensions parseOfferingExtension(ObservationOfferingType obsOff) throws DecodingException {
        Extensions extensions = new Extensions();
        for (XmlObject xmlObject : obsOff.getExtensionArray()) {
            try {
                Extension extension = (Extension)this.decodeXmlElement(xmlObject);
                extensions.addExtension(extension);
            }
            catch (DecodingException ex) {
                LOGGER.warn(ex.getLocalizedMessage());
            }
        }
        return extensions;
    }

    private ReferencedEnvelope parseObservedArea(ObservationOfferingType obsOff) {
        return Optional.ofNullable(obsOff.getObservedArea()).map(obsArea -> {
            try {
                EnvelopeType envelope = obsArea.getEnvelope();
                Object decodeXmlElement = this.decodeXmlElement((XmlObject)envelope);
                return (ReferencedEnvelope)decodeXmlElement;
            }
            catch (DecodingException ex) {
                LOGGER.error(ex.getLocalizedMessage(), (Throwable)ex);
                return null;
            }
        }).orElse(null);
    }

    private Map<String, Set<String>> parseRelatedFeatures(ObservationOfferingType obsOff) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(obsOff.getRelatedFeatureArray().length);
        for (AbstractOfferingType.RelatedFeature releatedFeature : obsOff.getRelatedFeatureArray()) {
            String feature = releatedFeature.getFeatureRelationship().getTarget().getHref();
            String role = releatedFeature.getFeatureRelationship().getRole();
            Set roles = map.computeIfAbsent(feature, key -> new HashSet(1));
            if (role == null) continue;
            roles.add(role);
        }
        return map;
    }

    private Time parseResultTime(ObservationOfferingType obsOff) {
        return Optional.ofNullable(obsOff.getResultTime()).map(resultTime -> {
            try {
                return (Time)this.decodeXmlElement((XmlObject)resultTime.getTimePeriod());
            }
            catch (DecodingException ex) {
                LOGGER.error(ex.getLocalizedMessage(), (Throwable)ex);
                return null;
            }
        }).orElse(null);
    }

    private Collection<String> parseResponseFormats(ObservationOfferingType obsOff) {
        return Optional.ofNullable(obsOff.getResponseFormatArray()).map(Arrays::stream).orElseGet(Stream::empty).collect(Collectors.toSet());
    }

    private Collection<String> parseObservationTypes(ObservationOfferingType obsOff) {
        return Optional.ofNullable(obsOff.getObservationTypeArray()).map(Arrays::stream).orElseGet(Stream::empty).collect(Collectors.toSet());
    }

    private Collection<String> parseFeatureOfInterestTypes(ObservationOfferingType obsOff) {
        return Optional.ofNullable(obsOff.getFeatureOfInterestTypeArray()).map(Arrays::stream).orElseGet(Stream::empty).collect(Collectors.toSet());
    }
}

