/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.ogc.ows.exception.NoApplicableCodeException;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.ows.service.OwsServiceCommunicationObject;
import org.n52.shetland.w3c.soap.SoapFault;
import org.n52.shetland.w3c.soap.SoapHelper;
import org.n52.shetland.w3c.soap.SoapRequest;
import org.n52.svalbard.decode.AbstractSoapDecoder;
import org.n52.svalbard.decode.exception.DecodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Soap11Decoder
extends AbstractSoapDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(Soap11Decoder.class);
    private static final String SOAP_ACTION = "SOAPAction:";
    private static final QName QN_CLIENT = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Client");

    public Soap11Decoder() {
        super("http://schemas.xmlsoap.org/soap/envelope/");
        LOGGER.debug("Decoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(this.getKeys()));
    }

    protected SoapRequest createEnvelope(XmlObject doc) throws DecodingException {
        SoapRequest soapRequest = new SoapRequest("http://schemas.xmlsoap.org/soap/envelope/", "SOAP 1.1 Protocol");
        String soapAction = "";
        try {
            SOAPMessage soapMessageRequest;
            try {
                soapMessageRequest = SoapHelper.getSoapMessageForProtocol((String)"SOAP 1.1 Protocol", (InputStream)doc.newInputStream());
            }
            catch (IOException | SOAPException ioe) {
                throw new NoApplicableCodeException().causedBy(ioe).withMessage("Error while parsing SOAPMessage from request string!", new Object[0]);
            }
            if (soapAction.isEmpty() || !soapAction.startsWith(SOAP_ACTION)) {
                SoapFault fault = new SoapFault();
                fault.setFaultCode(QN_CLIENT);
                fault.setFaultReason("The SOAPAction parameter in the HTTP-Header is missing or not valid!");
                fault.setLocale(Locale.ENGLISH);
                soapRequest.setSoapFault(fault);
                soapRequest.setSoapFault(fault);
            } else {
                soapAction = soapAction.replace("\"", "").replace(" ", "").replace(SOAP_ACTION, "").trim();
            }
            try {
                if (soapMessageRequest.getSOAPHeader() != null) {
                    soapRequest.setSoapHeader(this.getSoapHeader(soapMessageRequest.getSOAPHeader()));
                }
                soapRequest.setAction(this.checkSoapAction(soapAction, soapRequest.getSoapHeader()));
                soapRequest.setSoapBodyContent((OwsServiceCommunicationObject)this.getSOAPBodyContent(soapMessageRequest));
            }
            catch (SOAPException | DecodingException soape) {
                throw new NoApplicableCodeException().causedBy(soape).withMessage("Error while parsing SOAPMessage!", new Object[0]);
            }
        }
        catch (OwsExceptionReport owse) {
            throw new DecodingException((Throwable)owse);
        }
        return soapRequest;
    }

    protected SoapRequest createFault(DecodingException de) {
        SoapFault fault = new SoapFault();
        fault.setFaultCode(QN_CLIENT);
        fault.setLocale(Locale.ENGLISH);
        fault.setFaultReason(this.getFaultReasons(de));
        SoapRequest r = new SoapRequest("http://schemas.xmlsoap.org/soap/envelope/", "SOAP 1.1 Protocol");
        r.setSoapFault(fault);
        return r;
    }
}

