/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Joiner;
import java.util.List;
import java.util.stream.Collectors;
import net.opengis.gml.x32.BooleanListDocument;
import net.opengis.gml.x32.CoordinatesType;
import net.opengis.gml.x32.CountListDocument;
import net.opengis.gml.x32.DataBlockType;
import net.opengis.gml.x32.DiscreteCoverageType;
import net.opengis.gml.x32.MeasureOrNilReasonListType;
import net.opengis.gml.x32.QuantityListDocument;
import net.opengis.gml.x32.RangeSetType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.shetland.ogc.om.values.BooleanValue;
import org.n52.shetland.ogc.om.values.CategoryValue;
import org.n52.shetland.ogc.om.values.CountValue;
import org.n52.shetland.ogc.om.values.DiscreteCoverage;
import org.n52.shetland.ogc.om.values.QuantityValue;
import org.n52.shetland.ogc.om.values.TextValue;
import org.n52.shetland.ogc.om.values.Value;
import org.n52.svalbard.encode.AbstractXmlEncoder;
import org.n52.svalbard.encode.exception.EncodingException;

public abstract class AbstractCoverageEncoder<T, S>
extends AbstractXmlEncoder<T, S> {
    protected RangeSetType encodeRangeSet(DiscreteCoverageType dct, DiscreteCoverage<?> discreteCoverage) throws EncodingException {
        RangeSetType rst = dct.addNewRangeSet();
        this.encodeValueList(rst, discreteCoverage);
        return dct.getRangeSet();
    }

    protected void encodeValueList(RangeSetType rst, DiscreteCoverage<?> discreteCoverage) throws EncodingException {
        List<?> list = this.getList(discreteCoverage);
        Value value = (Value)discreteCoverage.getRangeSet().iterator().next();
        if (value instanceof BooleanValue) {
            BooleanListDocument bld = BooleanListDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
            bld.setBooleanList(list);
            rst.set((XmlObject)bld);
        } else if (value instanceof CategoryValue || value instanceof TextValue) {
            DataBlockType dbt = rst.addNewDataBlock();
            dbt.addNewRangeParameters().setHref(discreteCoverage.getRangeParameters());
            CoordinatesType ct = dbt.addNewTupleList();
            ct.setCs(",");
            ct.setStringValue(Joiner.on((String)",").join(list));
        } else if (value instanceof CountValue) {
            CountListDocument cld = CountListDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
            cld.setCountList(list);
            rst.set((XmlObject)cld);
        } else if (value instanceof QuantityValue) {
            QuantityListDocument qld = QuantityListDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
            MeasureOrNilReasonListType monrlt = qld.addNewQuantityList();
            if (discreteCoverage.isSetUnit()) {
                monrlt.setUom(discreteCoverage.getUnit());
            } else if (value.isSetUnit()) {
                monrlt.setUom(value.getUnit());
            }
            monrlt.setListValue(list);
            rst.set((XmlObject)qld);
        }
    }

    private List<?> getList(DiscreteCoverage<?> discreteCoverage) {
        return discreteCoverage.getRangeSet().stream().map(Value::getValue).collect(Collectors.toList());
    }
}

