/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import net.opengis.gml.x32.FeaturePropertyType;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gwml.GWMLConstants;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.AbstractGmlEncoderv321;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.exception.EncodingException;

public abstract class AbstractGroundWaterMLEncoder<T, S>
extends AbstractGmlEncoderv321<T, S> {
    public void addNamespacePrefixToMap(Map<String, String> nameSpacePrefixMap) {
        nameSpacePrefixMap.put("http://www.opengis.net/gwml/2.2", "gwml2");
        nameSpacePrefixMap.put("http://www.opengis.net/gwml-well/2.2", "gwml2w");
    }

    public Set<SchemaLocation> getSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{GWMLConstants.GWML_22_SCHEMA_LOCATION, GWMLConstants.GWML_WELL_22_SCHEMA_LOCATION});
    }

    protected XmlObject encodeGML(Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/gml/3.2", o);
    }

    protected XmlObject encodeGML(Object o, EncodingContext ec) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/gml/3.2", o, ec);
    }

    protected XmlObject encodeSweCommon(Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/swe/2.0", o);
    }

    protected XmlObject encodeSweCommon(Object o, EncodingContext ec) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/swe/2.0", o, ec);
    }

    protected XmlObject encodeGWML(Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/gwml/2.2", o);
    }

    protected XmlObject encodeGWML(Object o, EncodingContext ec) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/gwml/2.2", o, ec);
    }

    protected XmlObject encodeGWMLProperty(Object o) throws EncodingException {
        return this.encodeObjectToXmlPropertyType("http://www.opengis.net/gwml/2.2", o);
    }

    protected XmlObject encodeGWMLProperty(Object o, EncodingContext ec) throws EncodingException {
        return this.encodeObjectToXmlPropertyType("http://www.opengis.net/gwml/2.2", o, ec);
    }

    protected XmlObject encodeGWMLDocument(Object o) throws EncodingException {
        return this.encodeObjectToXmlDocument("http://www.opengis.net/gwml/2.2", o);
    }

    @Override
    protected XmlObject createFeature(FeaturePropertyType featurePropertyType, AbstractFeature abstractFeature, EncodingContext context) throws EncodingException {
        if (context.has((Enum)XmlBeansEncodingFlags.ENCODE) && !context.getBoolean((Enum)XmlBeansEncodingFlags.ENCODE)) {
            featurePropertyType.setHref(abstractFeature.getIdentifierCodeWithAuthority().getValue());
            if (abstractFeature.isSetName()) {
                featurePropertyType.setTitle(abstractFeature.getFirstName().getValue());
            }
            return featurePropertyType;
        }
        return this.encodeGWMLDocument(abstractFeature);
    }
}

