/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.collect.Sets;
import java.util.Set;
import net.opengis.swes.x20.DescribeSensorResponseDocument;
import net.opengis.swes.x20.DescribeSensorResponseType;
import net.opengis.swes.x20.ExtensibleResponseType;
import net.opengis.swes.x20.SensorDescriptionType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.shetland.ogc.gml.time.Time;
import org.n52.shetland.ogc.sos.SosConstants;
import org.n52.shetland.ogc.sos.SosProcedureDescription;
import org.n52.shetland.ogc.sos.SosProcedureDescriptionUnknownType;
import org.n52.shetland.ogc.sos.response.DescribeSensorResponse;
import org.n52.shetland.ogc.swes.SwesConstants;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.encode.AbstractSwesResponseEncoder;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.util.GmlHelper;
import org.n52.svalbard.util.XmlHelper;
import org.w3c.dom.Node;

public class DescribeSensorResponseEncoder
extends AbstractSwesResponseEncoder<DescribeSensorResponse> {
    public DescribeSensorResponseEncoder() {
        super(SosConstants.Operations.DescribeSensor.name(), DescribeSensorResponse.class);
    }

    @Override
    protected XmlObject create(DescribeSensorResponse response) throws EncodingException {
        DescribeSensorResponseDocument doc = DescribeSensorResponseDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        DescribeSensorResponseType dsr = doc.addNewDescribeSensorResponse();
        if (response.hasExtensions()) {
            this.createExtension((ExtensibleResponseType)dsr, response.getExtensions());
        }
        dsr.setProcedureDescriptionFormat(response.getOutputFormat());
        for (SosProcedureDescription sosProcedureDescription : response.getProcedureDescriptions()) {
            SensorDescriptionType sensorDescription = dsr.addNewDescription().addNewSensorDescription();
            sensorDescription.addNewData().set(this.getSensorDescription(response, sosProcedureDescription));
            if (!sosProcedureDescription.isSetValidTime()) continue;
            XmlObject xoValidTime = this.encodeObjectToXml("http://www.opengis.net/gml/3.2", sosProcedureDescription.getValidTime());
            XmlObject substitution = sensorDescription.addNewValidTime().addNewAbstractTimeGeometricPrimitive().substitute(GmlHelper.getGml321QnameForITime((Time)sosProcedureDescription.getValidTime()), xoValidTime.schemaType());
            substitution.set(xoValidTime);
        }
        if (response.getProcedureDescriptions().size() > 1) {
            XmlHelper.makeGmlIdsUnique((Node)doc.getDomNode());
        }
        return doc;
    }

    private XmlObject getSensorDescription(DescribeSensorResponse response, SosProcedureDescription<?> abstractFeature) throws EncodingException {
        if (abstractFeature instanceof SosProcedureDescriptionUnknownType && abstractFeature.isSetXml()) {
            try {
                return XmlHelper.parseXmlString((String)abstractFeature.getXml());
            }
            catch (DecodingException de) {
                throw new EncodingException("An xml error occured when parsing the request!", (Throwable)de);
            }
        }
        return this.encodeObjectToXml(response.getOutputFormat(), abstractFeature.getProcedureDescription());
    }

    @Override
    public Set<SchemaLocation> getConcreteSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{SwesConstants.SWES_20_DESCRIBE_SENSOR_SCHEMA_LOCATION});
    }
}

