/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.Set;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.shetland.w3c.W3CConstants;
import org.n52.shetland.w3c.xlink.W3CHrefAttribute;
import org.n52.svalbard.encode.AbstractXmlEncoder;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3.x1999.xlink.HrefAttribute;

public class XlinkEncoderv1999
extends AbstractXmlEncoder<XmlObject, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(XlinkEncoderv1999.class);
    private static final Set<EncoderKey> ENCODER_KEYS = CodingHelper.encoderKeysForElements((String)"http://www.w3.org/1999/xlink", (Class[])new Class[]{W3CHrefAttribute.class});

    public XlinkEncoderv1999() {
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(ENCODER_KEYS));
    }

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEYS);
    }

    public XmlObject encode(Object element, EncodingContext additionalValues) throws EncodingException {
        XmlObject encodedObject = null;
        if (!(element instanceof W3CHrefAttribute)) {
            throw new UnsupportedEncoderInputException((Encoder)this, element);
        }
        encodedObject = this.encodeHrefAttribute((W3CHrefAttribute)element);
        return encodedObject;
    }

    private XmlObject encodeHrefAttribute(W3CHrefAttribute hrefAttribute) {
        HrefAttribute xmlHrefAttribute = HrefAttribute.Factory.newInstance((XmlOptions)this.getXmlOptions());
        xmlHrefAttribute.setHref(hrefAttribute.getHref());
        return xmlHrefAttribute;
    }

    public Set<SchemaLocation> getSchemaLocations() {
        return Collections.singleton(W3CConstants.XLINK_SCHEMA_LOCATION);
    }
}

