/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import javax.inject.Inject;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.janmayen.Producer;
import org.n52.svalbard.decode.AbstractDelegatingDecoder;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.XmlNamespaceDecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.NoDecoderForKeyException;
import org.n52.svalbard.decode.exception.XmlDecodingException;
import org.w3c.dom.Node;

public abstract class AbstractXmlDecoder<T, S>
extends AbstractDelegatingDecoder<S, T> {
    private Producer<XmlOptions> xmlOptions;

    public XmlOptions getXmlOptions() {
        return (XmlOptions)this.xmlOptions.get();
    }

    @Inject
    public void setXmlOptions(Producer<XmlOptions> xmlOptions) {
        this.xmlOptions = xmlOptions;
    }

    public <T> T decodeXmlElement(XmlObject x) throws DecodingException {
        return this.decodeXmlObject(x);
    }

    public DecoderKey getDecoderKey(XmlObject doc) {
        Node domNode = doc.getDomNode();
        String namespaceURI = domNode.getNamespaceURI();
        if (namespaceURI == null && domNode.getFirstChild() != null) {
            namespaceURI = domNode.getFirstChild().getNamespaceURI();
        }
        if (namespaceURI == null && domNode.getFirstChild() != null && domNode.getFirstChild().getNextSibling() != null) {
            namespaceURI = domNode.getFirstChild().getNextSibling().getNamespaceURI();
        }
        return new XmlNamespaceDecoderKey(namespaceURI, doc.getClass());
    }

    public <T> T decodeXmlObject(XmlObject xbObject) throws DecodingException {
        DecoderKey key = this.getDecoderKey(xbObject);
        Decoder decoder = this.getDecoderRepository().getDecoder(key, new DecoderKey[0]);
        if (decoder == null) {
            XmlNamespaceDecoderKey schemaTypeKey = new XmlNamespaceDecoderKey(xbObject.schemaType().getName().getNamespaceURI(), xbObject.getClass());
            decoder = this.getDecoderRepository().getDecoder((DecoderKey)schemaTypeKey, new DecoderKey[0]);
        }
        if (decoder == null) {
            throw new NoDecoderForKeyException(key);
        }
        return (T)decoder.decode((Object)xbObject);
    }

    public Object decodeXmlObject(String xmlString) throws DecodingException {
        try {
            return this.decodeXmlObject(XmlObject.Factory.parse((String)xmlString));
        }
        catch (XmlException e) {
            throw new XmlDecodingException("XML string", xmlString, e);
        }
    }
}

